<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
global $post;
global $woocommerce;
global $foodking_opt;
$rating         = wc_get_rating_html($product->get_average_rating());
$ratingcount    = $product->get_review_count();
$ratingaverage  = $product->get_average_rating();
$price          = $product->get_price_html();

// Calculate the discount percentage
$regular_price  = $product->get_regular_price();
$sale_price     = $product->get_sale_price();
$discount_percentage = '';
if ($sale_price && $regular_price) {
    $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
}

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$product_sidebar    = isset( $foodking_opt['product_sidebar']) ? $foodking_opt['product_sidebar'] : '';

if ( !empty($_GET['foodking_shop_style']) ) {
    $foodking_shop_style = $_GET['foodking_shop_style'];
}else {
    $foodking_shop_style = '';
}

if ( $product_sidebar == 'right-sidebar' ) { 
    $divclass = "col-xl-4 col-lg-6 col-md-6";
}elseif($product_sidebar == 'left-sidebar' ){
    $divclass = "col-xl-4 col-lg-6 col-md-6";
}elseif( $foodking_shop_style == 'shop_right_sidebar'){
    $divclass = "col-xl-4 col-lg-6 col-md-6";
}elseif( $foodking_shop_style == 'shop_left_sidebar'){
    $divclass = "col-xl-4 col-lg-6 col-md-6";
}elseif( $foodking_shop_style == 'shop_list'){
    $divclass = "col-xl-4 col-lg-6 col-md-6";
}else {
    $divclass = "col-xl-3 col-lg-4 col-md-6";
}

?>
    <?php if( $foodking_shop_style == 'shop_list'): ?>
        <div class="col-xl-12 col-lg-12">
            <div class="shop-list-items">
                <div class="shop-image">
                    <?php the_post_thumbnail( 'foodking_product_card' ); ?>
                </div>
                <div class="shop-content">
                    <div class="star pb-4">
                        <?php if($product->is_on_sale()) : ?>
                            <span class="discount"><?php esc_html_e('-', 'foodking'); ?><?php echo esc_html($discount_percentage); ?><?php esc_html_e('%', 'foodking'); ?></span>
                        <?php elseif($discount_percentage): ?>
                            <span class="discount"><?php echo esc_html($sale); ?></span>
                        <?php endif; ?>

                        <?php echo wp_kses_post( $rating ); ?>
                    </div>
                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <p>
                        <?php echo esc_html( get_the_excerpt()); ?>
                    </p>
                    <h5>  <?php woocommerce_template_loop_price(); ?></h5>

                    <div class="shop-list-btn">
                        <a href="<?php the_permalink(); ?>" class="theme-btn">
                        <span class="button-content-wrapper d-flex align-items-center">
                        <span class="button-icon"><i class="flaticon-delivery"></i></span>
                        <span class="button-text"><?php esc_html_e('order now','foodking'); ?></span>
                        </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="<?php echo esc_attr( $divclass ); ?>">
            <div class="catagory-product-card-2 shadow-style text-center">
                <?php if ( class_exists( 'YITH_WCWL' ) ) { ?>
                    <div class="icon">
                        <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist]')); ?>
                    </div>
                <?php } ?>
                <div class="catagory-product-image">
                    <a href="<?php the_permalink(); ?>" class="d-block">
                        <?php the_post_thumbnail( 'foodking_product_card' ); ?>
                    </a>
                </div>
                <?php if($product->is_on_sale()): ?>
                    <span class="sale"><?php esc_html_e( 'SALE', 'foodking' ); ?></span>
                <?php endif; ?>
                <div class="catagory-product-content">
                    <div class="catagory-button">
                        <?php woocommerce_template_loop_add_to_cart(); ?>
                    </div>
                    <div class="info-price d-flex align-items-center justify-content-center">
                        <?php if($product->is_on_sale()) : ?>
                            <p class="minus-count"><?php esc_html_e('-', 'foodking'); ?><?php echo esc_html($discount_percentage); ?><?php esc_html_e('%', 'foodking'); ?></p>
                        <?php elseif($discount_percentage): ?>
                            <p class="minus-count"><?php echo esc_html($sale); ?></p>
                        <?php endif; ?>
                        <?php woocommerce_template_loop_price(); ?>
                    </div>
                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                    <div class="star text-center">
                        <?php echo wp_kses_post( $rating ); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

