<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */


defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

global $foodking_opt;

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

do_action( 'woocommerce_before_main_content' );

$post_page_id       = get_option( 'woocommerce_shop_page_id' );
$product_sidebar    = isset( $foodking_opt['product_sidebar']) ? $foodking_opt['product_sidebar'] : '';

/**
 * Page Control
*/
if( isset($foodking_opt['blog_title']) ) {
    $hide_breadcrumb    	= $foodking_opt['hide_breadcrumb'];
    $hide_blog_banner       = $foodking_opt['hide_blog_banner'];
    $hide_page_title    	= $foodking_opt['hide_page_title'];
    $shop_banner_bg         = $foodking_opt['shop_banner_bg']['url'];
} else {
    $hide_breadcrumb    	= false;
    $hide_blog_banner       = false;
    $hide_page_title    	= false; 
    $shop_banner_bg         = false;
}

// Blog page link
if ( get_option( 'page_for_posts' ) ) {
    $blog_link = get_permalink( get_option( 'page_for_posts' ));
}else{
    $blog_link = home_url( '/' );
}

$foodking_blog_layout = !empty($foodking_opt['foodking_blog_layout']) ? $foodking_opt['foodking_blog_layout'] : 'container';
if( isset($foodking_opt['page_title_tag']) ):
    $tag = $foodking_opt['page_title_tag'];
else:
    $tag = 'h1';
endif;

$foodking_shop_style = isset($_GET['foodking_shop_style']) ? sanitize_text_field($_GET['foodking_shop_style']) : '';

    if( $hide_blog_banner == false ): 
        ?>
		<div class="breadcrumb-wrapper bg-cover" <?php if($shop_banner_bg): ?>style="background-image:url(<?php echo esc_url($shop_banner_bg); ?>);" <?php else: ?>style="background-image:url(<?php echo esc_url(get_template_directory_uri() .'/assets/img/breadcrumb.jpg') ?>);" <?php endif; ?>>
			<div class="container"> 
				<div class="page-heading center">
                    <?php if( $hide_page_title == false ): ?>
                        <?php if( isset($tag) ): ?>
                                <<?php echo esc_attr( $tag ); ?>><?php woocommerce_page_title(); ?></<?php echo esc_attr( $tag ); ?>>
                            <?php else: ?>
                                <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('Shop', 'foodking'); ?></<?php echo esc_attr( $tag ); ?>>
                        <?php endif; ?>
                    <?php endif; ?>

					<?php if( $hide_breadcrumb == false ): ?>
						<?php
							if ( function_exists('yoast_breadcrumb') ) {
								yoast_breadcrumb( '<p class="foodking-seo-breadcrumbs" id="breadcrumbs">','</p>' );
							} else { ?>
								<ul class="breadcrumb-items">
									<li class="d-inline-block position-relative"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'foodking' ); ?></a></li>
										<li class="d-inline-block position-relative active"><?php woocommerce_page_title(); ?></li>
									<?php ?>                        
									
								</ul>
							<?php
							}
					endif; ?>
				</div>
			</div>
		</div>
    <?php endif; ?>

    <div class="sidebar_<?php echo esc_attr($foodking_shop_style); ?>">
        <?php if( $foodking_shop_style == 'shop_left_sidebar'): ?>
            <div class="special-products-area section-padding">
                <div class="container">
                    <div class="row">
                    <?php
                        if ( is_active_sidebar( 'shop' ) ) { ?>

                            <div class="col-xl-3 col-lg-4">
                                <?php do_action( 'woocommerce_sidebar' ); ?>
                            </div>

                            <div class="col-xl-9 col-lg-8">
                        <?php } else { ?>
                            <div class="col-lg-12 col-md-12">
                        <?php } ?>
                            <?php if ( woocommerce_product_loop() ) { ?>

                                <div class="woocommerce-topbar">
                                    <?php  do_action( 'woocommerce_before_shop_loop' ); ?>

                                    <div class="form-clt">
                                        <div class="icon">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_right_sidebar' ) );?>"><i class="fas fa-th"></i></a>
                                        </div>
                                        <div class="icon-2">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_list' ) );?>"><i class="fas fa-list"></i></a>
                                        </div>
                                    </div>

                                </div>

                                <?Php
                                woocommerce_product_loop_start();

                                if ( wc_get_loop_prop( 'total' ) ) {
                                    while ( have_posts() ) {
                                        the_post();

                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         *
                                         * @hooked WC_Structured_Data::generate_product_data() - 10
                                         */
                                        do_action( 'woocommerce_shop_loop' );

                                        wc_get_template_part( 'content', 'product' );
                                    }
                                }

                                woocommerce_product_loop_end();

                                /**
                                 * Hook: woocommerce_after_shop_loop.
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                                do_action( 'woocommerce_after_shop_loop' );
                            } else {
                                /**
                                 * Hook: woocommerce_no_products_found.
                                 *
                                 * @hooked wc_no_products_found - 10
                                 */
                                do_action( 'woocommerce_no_products_found' );
                            } ?>
                        </div> <!-- end clo-8 -->

                        <?php
                        if ( isset( $_GET['shop'] ) ) {
                            if ( $foodking_shop_cat_sidebar == 'right' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } else {
                            if ( $product_sidebar == 'right-sidebar' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
        <?php elseif( $foodking_shop_style == 'shop_right_sidebar'): ?>
            <div class="special-products-area section-padding">
                <div class="container">
                    <div class="row">
                    <?php
                        if ( is_active_sidebar( 'shop' ) ) { ?>
                            <div class="col-xl-9 col-lg-8">
                        <?php } else { ?>
                            <div class="col-lg-12 col-md-12">
                        <?php } ?>
                            <?php if ( woocommerce_product_loop() ) { ?>

                                <div class="woocommerce-topbar">
                                    <?php  do_action( 'woocommerce_before_shop_loop' ); ?>

                                    <div class="form-clt">
                                        <div class="icon">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_right_sidebar' ) );?>"><i class="fas fa-th"></i></a>
                                        </div>
                                        <div class="icon-2">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_list' ) );?>"><i class="fas fa-list"></i></a>
                                        </div>
                                    </div>

                                </div>

                                <?Php
                                woocommerce_product_loop_start();

                                if ( wc_get_loop_prop( 'total' ) ) {
                                    while ( have_posts() ) {
                                        the_post();

                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         *
                                         * @hooked WC_Structured_Data::generate_product_data() - 10
                                         */
                                        do_action( 'woocommerce_shop_loop' );

                                        wc_get_template_part( 'content', 'product' );
                                    }
                                }

                                woocommerce_product_loop_end();

                                /**
                                 * Hook: woocommerce_after_shop_loop.
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                                do_action( 'woocommerce_after_shop_loop' );
                            } else {
                                /**
                                 * Hook: woocommerce_no_products_found.
                                 *
                                 * @hooked wc_no_products_found - 10
                                 */
                                do_action( 'woocommerce_no_products_found' );
                            } ?>
                        </div> <!-- end clo-8 -->

                        <?php if ( is_active_sidebar( 'shop' ) ) { ?>
                        <div class="col-xl-3 col-lg-4">
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                        </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
        <?php elseif( $foodking_shop_style == 'shop_list'): ?>
            <div class="special-products-area section-padding section-bg">
                <div class="container">
                    <div class="row">
                    <?php
                        if ( is_active_sidebar( 'shop' ) ) { ?>

                            <div class="col-xl-3 col-lg-4">
                                <?php do_action( 'woocommerce_sidebar' ); ?>
                            </div>

                            <div class="col-xl-9 col-lg-8">
                        <?php } else { ?>
                            <div class="col-lg-12 col-md-12">
                        <?php } ?>
                            <?php if ( woocommerce_product_loop() ) { ?>

                                <div class="woocommerce-topbar">
                                    <?php  do_action( 'woocommerce_before_shop_loop' ); ?>

                                    <div class="form-clt">
                                        <div class="icon">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_right_sidebar' ) );?>"><i class="fas fa-th"></i></a>
                                        </div>
                                        <div class="icon-2">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_list' ) );?>"><i class="fas fa-list"></i></a>
                                        </div>
                                    </div>

                                </div>

                                <?Php
                                woocommerce_product_loop_start();

                                if ( wc_get_loop_prop( 'total' ) ) {
                                    while ( have_posts() ) {
                                        the_post();

                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         *
                                         * @hooked WC_Structured_Data::generate_product_data() - 10
                                         */
                                        do_action( 'woocommerce_shop_loop' );

                                        wc_get_template_part( 'content', 'product' );
                                    }
                                }

                                woocommerce_product_loop_end();

                                /**
                                 * Hook: woocommerce_after_shop_loop.
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                                do_action( 'woocommerce_after_shop_loop' );
                            } else {
                                /**
                                 * Hook: woocommerce_no_products_found.
                                 *
                                 * @hooked wc_no_products_found - 10
                                 */
                                do_action( 'woocommerce_no_products_found' );
                            } ?>
                        </div> <!-- end clo-8 -->

                        <?php
                        if ( isset( $_GET['shop'] ) ) {
                            if ( $foodking_shop_cat_sidebar == 'right' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } else {
                            if ( $product_sidebar == 'right-sidebar' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="special-products-area section-padding">
                <div class="container">
                    <div class="row">
                    <?php
                        if ( is_active_sidebar( 'shop' ) ) {
                            if ( isset( $_GET['shop'] ) ) {
                                $foodking_shop_cat_sidebar = $_GET['shop'];

                                if ( $foodking_shop_cat_sidebar == 'none' ): ?>
                                    <div class="col-lg-12 col-md-12">
                                <?php elseif ( $foodking_shop_cat_sidebar == 'left' ): ?>
                                    <div class="col-xl-3 col-lg-4">
                                        <?php do_action( 'woocommerce_sidebar' ); ?>
                                    </div>

                                    <div class="col-xl-9 col-lg-8">
                                <?php elseif ( $foodking_shop_cat_sidebar == 'right' ): ?>
                                    <div class="col-xl-9 col-lg-8">
                                <?php endif;

                            } else {
                                if( $product_sidebar == 'left-sidebar' ): ?>
                                    <div class="col-xl-3 col-lg-4">
                                        <?php do_action( 'woocommerce_sidebar' ); ?>
                                    </div>

                                    <div class="col-xl-9 col-lg-8">
                                <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                                    <div class="col-xl-9 col-lg-8">
                                <?php elseif ( $product_sidebar == 'foodking_product_no_sidebar' ): ?>
                                    <div class="col-lg-12 col-md-12">
                                <?php else: ?>
                                    <div class="col-xl-3 col-lg-4">
                                        <?php do_action( 'woocommerce_sidebar' ); ?>
                                    </div>
                                    <div class="col-xl-9 col-lg-8">
                                <?php endif;
                            }
                        } else { ?>
                            <div class="col-lg-12 col-md-12">
                        <?php } ?>
                            <?php if ( woocommerce_product_loop() ) { ?>

                                <div class="woocommerce-topbar">
                                    <?php  do_action( 'woocommerce_before_shop_loop' ); ?>

                                    <div class="form-clt">
                                        <div class="icon">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_right_sidebar' ) );?>"><i class="fas fa-th"></i></a>
                                        </div>
                                        <div class="icon-2">
                                            <a href="<?php echo esc_url( home_url( '/shop/?foodking_shop_style=shop_list' ) );?>"><i class="fas fa-list"></i></a>
                                        </div>
                                    </div>

                                </div>

                                <?Php
                                woocommerce_product_loop_start();

                                if ( wc_get_loop_prop( 'total' ) ) {
                                    while ( have_posts() ) {
                                        the_post();

                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         *
                                         * @hooked WC_Structured_Data::generate_product_data() - 10
                                         */
                                        do_action( 'woocommerce_shop_loop' );

                                        wc_get_template_part( 'content', 'product' );
                                    }
                                }

                                woocommerce_product_loop_end();

                                /**
                                 * Hook: woocommerce_after_shop_loop.
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                                do_action( 'woocommerce_after_shop_loop' );
                            } else {
                                /**
                                 * Hook: woocommerce_no_products_found.
                                 *
                                 * @hooked wc_no_products_found - 10
                                 */
                                do_action( 'woocommerce_no_products_found' );
                            } ?>
                        </div> <!-- end clo-8 -->

                        <?php
                        if ( isset( $_GET['shop'] ) ) {
                            if ( $foodking_shop_cat_sidebar == 'right' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } else {
                            if ( $product_sidebar == 'right-sidebar' ) { ?>
                                <div class="col-xl-3 col-lg-4">
                                    <?php do_action( 'woocommerce_sidebar' ); ?>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */

get_footer( 'shop' ); ?>