<?php
/**
 * Header Content
 * @package WordPress
 * @subpackage foodking
*/

if ( ! function_exists( 'foodking_nav_area' ) ) {
	function foodking_nav_area() {
        global $foodking_opt;
        $logo                       = isset($foodking_opt['main_logo']['url']) ? $foodking_opt['main_logo']['url'] : '';
        $logo2                      = isset($foodking_opt['main_logo2']['url']) ? $foodking_opt['main_logo2']['url'] : '';
        $mobile_logo                = isset($foodking_opt['sidebar_logo']['url']) ? $foodking_opt['sidebar_logo']['url'] : '';
        $side_menu_icon1            = isset($foodking_opt['side_menu_icon1']['url']) ? $foodking_opt['side_menu_icon1']['url'] : '';
        $side_menu_icon2            = isset($foodking_opt['side_menu_icon2']['url']) ? $foodking_opt['side_menu_icon2']['url'] : '';
        $top_bar_number             = isset($foodking_opt['top_bar_number']) ? $foodking_opt['top_bar_number'] : '';
		$info_field_1               = isset($foodking_opt['info_field_1']) ? $foodking_opt['info_field_1'] : '';
		$icon_field		            = isset($foodking_opt['icon_field']) ? $foodking_opt['icon_field'] : '';
		$info_field_2               = isset($foodking_opt['info_field_2']) ? $foodking_opt['info_field_2'] : '';
        $enable_search              = isset($foodking_opt['enable_search_bar']) ? $foodking_opt['enable_search_bar'] : '';
        $search_placeholder         = isset($foodking_opt['search_placeholder_text']) ? $foodking_opt['search_placeholder_text'] : '';
        $header_btn	                = isset($foodking_opt['header_btn']) ? $foodking_opt['header_btn'] : '';
        $header_btn_link	        = isset($foodking_opt['header_btn_link']) ? $foodking_opt['header_btn_link'] : '';

        $header_sidebar_desc        = isset($foodking_opt['header_sidebar_desc']) ? $foodking_opt['header_sidebar_desc'] : '';
        $gallery_img_1              = isset($foodking_opt['gallery_img_1']['url']) ? $foodking_opt['gallery_img_1']['url'] : '';
        $gallery_img_2              = isset($foodking_opt['gallery_img_2']['url']) ? $foodking_opt['gallery_img_2']['url'] : '';
        $gallery_img_3              = isset($foodking_opt['gallery_img_3']['url']) ? $foodking_opt['gallery_img_3']['url'] : '';
        $gallery_img_4              = isset($foodking_opt['gallery_img_4']['url']) ? $foodking_opt['gallery_img_4']['url'] : '';
        $gallery_img_5              = isset($foodking_opt['gallery_img_5']['url']) ? $foodking_opt['gallery_img_5']['url'] : '';
        $gallery_img_6              = isset($foodking_opt['gallery_img_6']['url']) ? $foodking_opt['gallery_img_6']['url'] : '';
        $sidebar_title              = isset($foodking_opt['sidebar_title']) ? $foodking_opt['sidebar_title'] : '';
        $contact_field_1_link       = isset($foodking_opt['contact_field_1_link']) ? $foodking_opt['contact_field_1_link'] : '';
        $contact_field_3_link       = isset($foodking_opt['contact_field_3_link']) ? $foodking_opt['contact_field_3_link'] : '';
        $contact_icon_field_1       = isset($foodking_opt['contact_icon_field_1']) ? $foodking_opt['contact_icon_field_1'] : '';
        $contact_field_1            = isset($foodking_opt['contact_field_1']) ? $foodking_opt['contact_field_1'] : '';
        $contact_icon_field_2       = isset($foodking_opt['contact_icon_field_2']) ? $foodking_opt['contact_icon_field_2'] : '';
        $contact_field_2            = isset($foodking_opt['contact_field_2']) ? $foodking_opt['contact_field_2'] : '';
        $header_sidebar_email_link  = isset($foodking_opt['header_sidebar_email_link']) ? $foodking_opt['header_sidebar_email_link'] : '';
        $contact_icon_field_3       = isset($foodking_opt['contact_icon_field_3']) ? $foodking_opt['contact_icon_field_3'] : '';
        $contact_field_3            = isset($foodking_opt['contact_field_3']) ? $foodking_opt['contact_field_3'] : '';
        $contact_icon_field_4       = isset($foodking_opt['contact_icon_field_4']) ? $foodking_opt['contact_icon_field_4'] : '';
        $contact_field_4            = isset($foodking_opt['contact_field_4']) ? $foodking_opt['contact_field_4'] : '';
        $header_sidebar_phone_link  = isset($foodking_opt['header_sidebar_phone_link']) ? $foodking_opt['header_sidebar_phone_link'] : '';
        $order_btn                  = isset($foodking_opt['order_btn']) ? $foodking_opt['order_btn'] : '';
        $order_btn_link             = isset($foodking_opt['order_btn_link']) ? $foodking_opt['order_btn_link'] : '';

        $hide_adminbar 				= 'foodking-hide-adminbar';
        $nav_style = function_exists( 'get_field' ) ? get_field( 'header_style' ) : '';
        ?>
        <!-- Offcanvas Area Start -->
        <div class="fix-area">
            <div class="offcanvas__info">
                <div class="offcanvas__wrapper">
                    <div class="offcanvas__content">
                        <div class="offcanvas__top mb-5 d-flex justify-content-between align-items-center">
                            <div class="offcanvas__logo">
                                <a href="<?php echo esc_url( home_url( '/' ) );?>">
                                    <?php if( $mobile_logo != '' ): ?>
                                        <img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                        <?php else: ?>
                                            <h2><?php bloginfo( 'name' ); ?></h2>
                                    <?php endif; ?>
                                </a>
                            </div>
                            <div class="offcanvas__close">
                                <button>
                                <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                            <div class="responsive-navbar d-none">
                                <?php
                                    $primary_nav_arg = [
                                        'menu'            => 'primary-menu',
                                        'theme_location'  => 'primary-menu',
                                        'container'       => null,
                                        'menu_class'      => 'navbar-nav',
                                        'depth'           => 3,
                                    ];

                                    if(has_nav_menu('primary-menu')){
                                        wp_nav_menu($primary_nav_arg);
                                    }
                                ?>
                            </div>
                        <p class="text d-none d-lg-block">
                            <?php echo wp_kses($header_sidebar_desc, 'foodking_kses_allowed_html');?>
                        </p>
                        <div class="offcanvas-gallery-area d-none d-lg-block">
                            <div class="offcanvas-gallery-items">
                                <a href="<?php echo esc_url($gallery_img_1);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_1): ?>
                                        <img src="<?php echo esc_url($gallery_img_1);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                                <a href="<?php echo esc_url($gallery_img_2);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_2): ?>
                                        <img src="<?php echo esc_url($gallery_img_2);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                                <a href="<?php echo esc_url($gallery_img_3);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_3): ?>
                                        <img src="<?php echo esc_url($gallery_img_3);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                            </div>
                            <div class="offcanvas-gallery-items">
                                <a href="<?php echo esc_url($gallery_img_4);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_4): ?>
                                        <img src="<?php echo esc_url($gallery_img_4);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                                <a href="<?php echo esc_url($gallery_img_5);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_5): ?>
                                        <img src="<?php echo esc_url($gallery_img_5);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                                <a href="<?php echo esc_url($gallery_img_6);?>" class="offcanvas-image img-popup">
                                    <?php if($gallery_img_6): ?>
                                        <img src="<?php echo esc_url($gallery_img_6);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
                                    <?php endif;?>
                                </a>
                            </div>
                        </div>
                        <div class="offcanvas__contact">
                            <h4><?php echo esc_html($sidebar_title);?></h4>
                            <ul>
                                <?php if($contact_field_1): ?>
                                    <li class="d-flex align-items-center">
                                        <div class="offcanvas__contact-icon">
                                            <i class="<?php echo esc_html($contact_icon_field_1);?>"></i>
                                        </div>
                                        <div class="offcanvas__contact-text">
                                            <a target="_blank" href="<?php echo esc_url($contact_field_1_link);?>"><?php echo esc_html($contact_field_1);?></a>
                                        </div>
                                    </li>
                                <?php endif;?>

                                <?php if($contact_field_2): ?>
                                    <li class="d-flex align-items-center">
                                        <div class="offcanvas__contact-icon mr-15">
                                            <i class="<?php echo esc_html($contact_icon_field_2);?>"></i>
                                        </div>
                                        <div class="offcanvas__contact-text">
                                            <a href="<?php echo esc_url($header_sidebar_email_link);?>"><span class="mailto:info@enofik.com"><?php echo esc_html($contact_field_2);?></span></a>
                                        </div>
                                    </li>
                                <?php endif;?>

                                <?php if($contact_field_3): ?>
                                    <li class="d-flex align-items-center">
                                        <div class="offcanvas__contact-icon mr-15">
                                            <i class="<?php echo esc_html($contact_icon_field_3);?>"></i>
                                        </div>
                                        <div class="offcanvas__contact-text">
                                            <a target="_blank" href="<?php echo esc_url($contact_field_3_link);?>"><?php echo esc_html($contact_field_3);?></a>
                                        </div>
                                    </li>
                                <?php endif;?>

                                <?php if($contact_field_4): ?>
                                    <li class="d-flex align-items-center">
                                        <div class="offcanvas__contact-icon mr-15">
                                            <i class="<?php echo esc_html($contact_icon_field_4);?>"></i>
                                        </div>
                                        <div class="offcanvas__contact-text">
                                            <a href="<?php echo esc_url($header_sidebar_phone_link);?>"><?php echo esc_html($contact_field_4);?></a>
                                        </div>
                                    </li>
                                <?php endif;?>
                            </ul>
                            <?php if($order_btn): ?>
                                <div class="header-button mt-4">
                                    <a href="<?php echo esc_url($order_btn_link);?>" class="theme-btn">
                                    <span class="button-content-wrapper d-flex align-items-center justify-content-center">
                                    <span class="button-icon"><i class="flaticon-delivery"></i></span>
                                    <span class="button-text"><?php echo esc_html($order_btn);?></span>
                                    </span>
                                    </a>
                                </div>
                            <?php endif;?>
                            <ul class="social-icon d-flex align-items-center">
                                <?php foodking_social_link(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="offcanvas__overlay"></div>

        <?php if($nav_style== 2): ?>    
            <header>
                <div id="header-sticky" class="header-2 <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">
                    <div class="container-fluid">
                        <div class="mega-menu-wrapper">
                            <div class="header-main">
                                <div class="header-left">
                                    <div class="logo">
                                        <a href="<?php echo esc_url( home_url( '/' ) );?>" class="header-logo">
                                            <?php if( $logo != '' ): ?>
                                                <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                                <?php else: ?>
                                                <h2><?php bloginfo( 'name' ); ?></h2>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                    <div class="logo-2">
                                        <a href="<?php echo esc_url( home_url( '/' ) );?>" class="header-logo">
                                            <?php if( $logo2 != '' ): ?>
                                                <img src="<?php echo esc_url( $logo2 ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                                <?php else: ?>
                                                <h2><?php bloginfo( 'name' ); ?></h2>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="header-right d-flex justify-content-end align-items-center">
                                    <div class="mean__menu-wrapper d-none d-lg-block">
                                        <div class="main-menu">
                                            <nav id="mobile-menu">
                                                <?php
                                                    // Display the WordPress menu
                                                    wp_nav_menu(array(
                                                        'theme_location' => 'primary-menu',
                                                        'container' => 'menu-primary-menu',
                                                        'container_class' => 'primary-menu-container',
                                                        'menu_class' => 'primary-menu',
                                                        'depth' => 3,
                                                        'fallback_cb' => true // Disable fallback menu
                                                    ));
                                                    ?>
                                                </nav>
                                            <!-- for wp -->
                                        </div>
                                    </div>
                                    <?php if($enable_search): ?>
                                        <a href="#0" class="search-trigger search-icon"><i class="fal fa-search"></i></a>
                                    <?php endif; ?>
                                    <div class="menu-cart">
                                        <?php if ( class_exists( 'WooCommerce' ) ) :
                                            if ( is_page( 'cart' ) || is_cart() ) {} 
                                            else { ?>
                                            <a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="cart-icon">
                                                <i class="far fa-shopping-basket" aria-hidden="true"></i>
                                                <span><?php echo count( WC()->cart->get_cart() ) ?></span>
                                            </a>
                                    <?php } ?>
                                    <?php endif; ?>
                                    </div>
                                    <div class="header-button">
                                        <?php if($order_btn): ?>
                                            <a href="<?php echo esc_url($order_btn_link); ?>" class="theme-btn bg-transparent">
                                                <span class="button-content-wrapper d-flex align-items-center">
                                                <span class="button-icon"><i class="flaticon-delivery"></i></span>
                                                <span class="button-text"><?php echo esc_html($order_btn); ?></span>
                                                </span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="header__hamburger d-xl-block my-auto">
                                        <div class="sidebar__toggle">
                                            <?php if($side_menu_icon1): ?>
                                                <img src="<?php echo esc_url($side_menu_icon1);?>" alt="bar-icon" class="bar-1">
                                            <?php endif; ?>
                                            <?php if($side_menu_icon2): ?>
                                                <img src="<?php echo esc_url($side_menu_icon2);?>" alt="bar-icon" class="bar-2">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header> 
            <!-- Search Area Start -->
            <div class="search-wrap">
                <div class="search-inner">
                    <i class="fas fa-times search-close" id="search-close"></i>
                    <div class="search-cell">
                        <?php if($enable_search): ?>
                            <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>"  class="search-wrp">
                                <div class="search-field-holder">
                                    <input type="search" class="main-search-input" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr($search_placeholder); ?>" aria-label="Search">
                                </div>
                            </form>
                        <?php endif;?>
                    </div>
                </div>
            </div>
        <?php else: ?>

            <!-- Header Area Start -->
            <header class="section-bg">
                <?php if($info_field_1) : ?>
                    <div class="header-top">
                        <div class="container">
                            <div class="header-top-wrapper">
                                <ul>
                                    <li><span><?php echo esc_html($top_bar_number); ?></span> <?php echo esc_html($info_field_1); ?></li>
                                    <li><i class="<?php echo esc_attr($icon_field); ?> color-main"></i><?php echo esc_html($info_field_2); ?></li>
                                </ul>
                                <div class="top-right">
                                    <?php if($enable_search): ?>
                                        <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>"  class="search-wrp">
                                            <button><i class="fa fa-search"></i></button>
                                            <input type="search" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr($search_placeholder); ?>" aria-label="Search">
                                        </form>
                                    <?php endif;?>

                                    <ul class="social-icon d-flex align-items-center">
                                        <?php foodking_social_link(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif;?>

                <div id="header-sticky" class="header-1">
                    <div class="container">
                        <div class="mega-menu-wrapper">
                            <div class="header-main">
                                <div class="logo">
                                    <a href="<?php echo esc_url( home_url( '/' ) );?>" class="header-logo">
                                        <?php if( $logo != '' ): ?>
                                            <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                            <?php else: ?>
                                            <h2><?php bloginfo( 'name' ); ?></h2>
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <div class="header-left">
                                    <div class="mean__menu-wrapper d-none d-lg-block">
                                        <div class="main-menu">
                                            <nav id="mobile-menu">
                                                <?php
                                                // Display the WordPress menu
                                                wp_nav_menu(array(
                                                    'theme_location' => 'primary-menu',
                                                    'container' => 'menu-primary-menu',
                                                    'container_class' => 'primary-menu-container',
                                                    'menu_class' => 'primary-menu',
                                                    'depth' => 3,
                                                    'fallback_cb' => true // Disable fallback menu
                                                ));
                                                ?>
                                            </nav>
                                            <!-- for wp -->
                                        </div>
                                    </div>
                                </div>
                                <div class="header-right d-flex justify-content-end align-items-center">
                                    <div class="menu-cart">
                                        <?php if ( class_exists( 'WooCommerce' ) ) :
                                                if ( is_page( 'cart' ) || is_cart() ) {} 
                                                else { ?>
                                                <a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="cart-icon">
                                                    <i class="far fa-shopping-basket" aria-hidden="true"></i>
                                                    <span><?php echo count( WC()->cart->get_cart() ) ?></span>
                                                </a>
                                        <?php } ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="header-button">
                                        <?php if($header_btn): ?>
                                            <a href="<?php echo esc_url($header_btn_link); ?>" class="theme-btn bg-red-2"><?php echo esc_html($header_btn); ?></a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="header__hamburger d-xl-block my-auto">
                                        <div class="sidebar__toggle">
                                            <div class="header-bar">
                                                <span></span>
                                                <span></span>
                                                <span></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
        <?php endif; ?>	
        <?php
	}
}