<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package foodking
 */
global $foodking_opt;

$single_blog_page_title					= isset($foodking_opt['single_blog_page_title']) ? $foodking_opt['single_blog_page_title'] : '';
$single_blog_header_banner				= isset($foodking_opt['single_blog_header_banner']['url']) ? $foodking_opt['single_blog_header_banner']['url'] : '';
$foodking_single_blog_layout			= isset($foodking_opt['foodking_single_blog_layout']) ? $foodking_opt['foodking_single_blog_layout'] : 'container';
$foodking_single_blog_sidebar    		= isset($foodking_opt['foodking_single_blog_sidebar']) ? $foodking_opt['foodking_single_blog_sidebar'] : 'foodking_with_single_sidebar';
$foodking_single_blog_sidebar_position	= isset($foodking_opt['foodking_single_blog_sidebar_position']) ? $foodking_opt['foodking_single_blog_sidebar_position'] : 'right';
$cta_banner_bg							= isset($foodking_opt['cta_banner_bg']['url']) ? $foodking_opt['cta_banner_bg']['url'] : '';
$cta_sec_img							= isset($foodking_opt['cta_sec_img']['url']) ? $foodking_opt['cta_sec_img']['url'] : '';
$cta_shape_img_1						= isset($foodking_opt['cta_shape_img_1']['url']) ? $foodking_opt['cta_shape_img_1']['url'] : '';
$cta_shape_img_2						= isset($foodking_opt['cta_shape_img_2']['url']) ? $foodking_opt['cta_shape_img_2']['url'] : '';
$cta_subtitle							= isset($foodking_opt['cta_subtitle']) ? $foodking_opt['cta_subtitle'] : '';
$cta_title_1							= isset($foodking_opt['cta_title_1']) ? $foodking_opt['cta_title_1'] : '';
$cta_title_2							= isset($foodking_opt['cta_title_2']) ? $foodking_opt['cta_title_2'] : '';
$cta_title_3							= isset($foodking_opt['cta_title_3']) ? $foodking_opt['cta_title_3'] : '';
$cta_btn								= isset($foodking_opt['cta_btn']) ? $foodking_opt['cta_btn'] : '';
$cta_btn_link							= isset($foodking_opt['cta_btn_link']) ? $foodking_opt['cta_btn_link'] : '';

// Blog Sidebar Positioning
if(isset($foodking_opt['foodking_single_blog_sidebar'])) {
	if( $foodking_opt['foodking_single_blog_sidebar'] == 'foodking_without_single_sidebar_center' ):
		$foodking_single_sidebar_class = 'col-lg-12 col-md-12';
	elseif( $foodking_opt['foodking_single_blog_sidebar'] == 'foodking_without_single_sidebar' ):
		$foodking_single_sidebar_class = 'col-lg-12 col-md-12';
	else:
		if( is_active_sidebar( 'sidebar-1' ) ):
			$foodking_single_sidebar_class = 'col-lg-8 col-md-12';
		else:
			$foodking_single_sidebar_class = 'col-lg-8 col-md-12';
		endif;
	endif;
	$sidebar_hide = $foodking_opt['foodking_single_blog_sidebar'];
} else {
	if( is_active_sidebar( 'sidebar-1' ) ):
		$foodking_single_sidebar_class = 'col-lg-8 col-md-12';
		$sidebar_hide = 'foodking_with_single_sidebar';
	else:
		$foodking_single_sidebar_class = 'col-lg-8 col-md-12';
		$sidebar_hide = 'foodking_without_single_sidebar';
	endif;
}
get_header();
?>

	<!--<< Breadcrumb Section Start >>-->
	<div class="breadcrumb-wrapper bg-cover <?php if(!$single_blog_header_banner): ?>no-image<?php endif; ?>" <?php if($single_blog_header_banner): ?> style="background-image: url(<?php echo esc_url($single_blog_header_banner); ?>)"<?php endif; ?>>
		<div class="container">
			<div class="page-heading center">
				<h1><?php echo esc_html($single_blog_page_title); ?></h1>
				<ul class="breadcrumb-items">
					<?php foodking_breadcrumb_trail(); ?>
				</ul>
			</div>
		</div>
	</div>

	<!--<< Blog Wrapper Here >>-->
	<section class=" blog-details-area news-wrapper section-padding section-bg">
		<div class="<?php echo esc_attr($foodking_single_blog_layout); ?>">
			<div class="news-area">
				<div class="row">

					<!--Right Sidebar Layout-->
					<?php if( $sidebar_hide == 'foodking_with_single_sidebar' ): ?>
						<?php if($foodking_single_blog_sidebar_position == 'left'): ?>
							<div class="col-12 col-lg-4">
								<?php get_sidebar(); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr($foodking_single_sidebar_class); ?>">
						<?php
						while ( have_posts() ) : the_post();
							$author_link = get_author_posts_url(get_the_author_meta('ID'));
							?>
							<div class="blog-details border-wrap mt-0">
								<div class=" blog-details-content mt-0">
									<div class="post-content pt-0">
										<h1 class="mt-0"><?php the_title(); ?></h1>
										<div class="post-meta mt-3">
											<span><i class="fa fa-user"></i><?php echo esc_html(get_the_author()); ?></span>
											<span><i class="fa fa-comments"></i><?php echo get_comments_number();?> <?php esc_html_e('نظرات', 'foodking'); ?></span>
											<span><i class="fa fa-calendar-alt"></i><?php echo esc_html(get_the_date('d M Y')); ?></span>
										</div>
										<?php the_content();?>
									</div>
								</div>
								<div class="row tag-share-wrap">
									<div class="col-lg-8 col-12">
										<h4><?php esc_html_e('برچسب های مرتبط','foodking');?></h4>
										<div class="tagcloud">
											<?php
											$post_tags = get_the_tags();
											if ($post_tags) {
												foreach ($post_tags as $tag) {
													echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
												}
											} else { ?>
												<p><?php esc_html_e('No tags found.','foodking');?></p>
											<?php } ?>
										</div>
									</div>

									<!-- Blog Post Share in Social Media -->
									<div class="col-lg-4 col-12 mt-3 mt-lg-0 text-lg-end">
										<?php foodking_social_share(); ?>
									</div>

								</div>
								
								<?php
									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>

							</div>
							<?php
						endwhile;?>
					</div>
					
					<!--Right Sidebar Layout-->
					<?php if( $sidebar_hide == 'foodking_with_single_sidebar' ): ?>
						<?php if($foodking_single_blog_sidebar_position == 'right'): ?>
							<div class="col-12 col-lg-4">
								<?php get_sidebar(); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>

				</div>
			</div>
		</div>
	</section>

	<?php if($cta_banner_bg): ?>
		<!-- Main Cta Banner Section Start -->
		<section class="main-cta-banner-2 section-padding bg-cover" style="background-image: url(<?php echo esc_url($cta_banner_bg); ?>)">
			<div class="tomato-shape-left float-bob-y">
				<?php if($cta_shape_img_1):?>
					<img src="<?php echo esc_url($cta_shape_img_1);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="chili-shape-right float-bob-y">
				<?php if($cta_shape_img_2):?>
					<img src="<?php echo esc_url($cta_shape_img_2);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="container">
				<div class="main-cta-banner-wrapper-2 d-flex align-items-center justify-content-between">
					<div class="section-title mb-0">
						<span class="theme-color-3"><?php echo esc_html($cta_subtitle);?></span>
						<h2 class="text-white">
							<?php echo esc_html($cta_title_1);?> <br>
							<span class="theme-color-3"><?php echo esc_html($cta_title_2);?></span> <?php echo esc_html($cta_title_3);?>
						</h2>
					</div>
					<?php if($cta_btn): ?>
						<a href="<?php echo esc_url($cta_btn_link); ?>" class="theme-btn bg-white">
							<span class="button-content-wrapper d-flex align-items-center">
							<span class="button-icon"><i class="fas fa-shipping-fast"></i></span>
							<span class="button-text"><?php echo esc_html($cta_btn); ?></span>
							</span>
						</a>
					<?php endif;?>
					<div class="delivery-man">
						<?php if($cta_sec_img):?>
							<img src="<?php echo esc_url($cta_sec_img);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
						<?php endif;?>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

<?php
get_sidebar();
get_footer();
