<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'foodking_custom_style' ) ) {
    function foodking_custom_style(){
        
        $custom_style = '';
        global $foodking_opt;
        
        $primary_color          = isset($foodking_opt['primary_color']) ? $foodking_opt['primary_color'] : '#00813D';
        $secondary_color        = isset($foodking_opt['secondary_color']) ? $foodking_opt['secondary_color'] : '#D12525';
        $main_color             = isset($foodking_opt['main_color']) ? $foodking_opt['main_color'] : '#FFB936';
        $text_color             = isset($foodking_opt['text_color']) ? $foodking_opt['text_color'] : '#5C5C5B';
        $white_color            = isset($foodking_opt['white_color']) ? $foodking_opt['white_color'] : '#fff';
        $black_color            = isset($foodking_opt['black_color']) ? $foodking_opt['black_color'] : '#212121';
        $bg_color               = isset($foodking_opt['bg_color']) ? $foodking_opt['bg_color'] : '#f4f1ea';
        $top_header_bg_color    = isset($foodking_opt['top_header_bg_color']) ? $foodking_opt['top_header_bg_color'] : '#f4f1ea';
        $fontFamily             = isset($foodking_opt['primary_typography']);


        $custom_style .= '
        :root {
            --primaryColor:     '.esc_attr($primary_color).'; 
            --secondaryColor:   '.esc_attr($secondary_color).';
            --mainColor:        '.esc_attr($main_color).';
            --textColor:        '.esc_attr($text_color).';
            --whiteColor:       '.esc_attr($white_color).';
            --blackColor:       '.esc_attr($black_color).';
            --backgroundColor:  '.esc_attr($bg_color).';
            --fontFamily:       '.esc_attr($fontFamily).';
        }
        .header-top {
            background-color: '.esc_attr($top_header_bg_color).';
        }

        ';

        // Custom Css
        if( isset($foodking_opt['css_code'] ) && !empty($foodking_opt['css_code']) ):
            $custom_style .= $foodking_opt['css_code'];
        endif;

        wp_add_inline_style('foodking-blog', $custom_style);

        // Custom Js
        $custom_script ='';
        if( isset($foodking_opt['js_code'] )){
            $custom_script .= $foodking_opt['js_code'];
        }

        // Hide Sticky Header
        if(isset($foodking_opt['enable_sticky_header']) && $foodking_opt['enable_sticky_header'] == true){ $custom_script .='
            (function($){
                "use strict";
                jQuery(document).on("ready", function () {
            
                    //>> Sticky Header Js Start <<//
                    $(window).scroll(function() {
                        if ($(this).scrollTop() > 250) {
                            $("#header-sticky").addClass("custom-sticky");
                        } else {
                            $("#header-sticky").removeClass("custom-sticky");
                        }
                    });

                });
            }(jQuery));';
        }

        wp_add_inline_script( 'foodking-main', $custom_script );

    }
}
add_action( 'wp_enqueue_scripts', 'foodking_custom_style' );