<?php
/**
 * Start Custom Widgets
 */

/*
Custom Search Widget
A custom widget for search functionality.
==========================================
*/

// Register Custom Search Widget
function custom_search_widget_register() {
    register_widget('Custom_Search_Widget');
}
add_action('widgets_init', 'custom_search_widget_register');

// Custom Search Widget Class
class Custom_Search_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'custom_search_widget',
            'جستجو سفارشی فودکینگ',
            array('description' => 'ابزارک جستجو سفارشی برای قالب')
        );
    }

    // Output of the widget
    public function widget($args, $instance) {
        echo $args['before_widget'];
        echo '<div class="single-sidebar-widgets">';
        echo '<div class="wid-title">';
        echo '<h4>جستجو</h4>';
        echo '</div>';
        echo '<div class="search_widget">';
        echo '<form role="search" method="get" class="search-form" action="' . esc_url(home_url('/')) . '">';
        echo '<input type="text" placeholder=" ...جستجو کنید" name="s">';
        echo '<button type="submit"><i class="fa fa-search"></i></button>';
        echo '</form>';
        echo '</div>';
        echo '</div>';
        echo $args['after_widget'];
    }
}

/*
Custom Sidebar Popular Post Widget
A custom widget to display popular post dynamically.
====================================================
*/
// Create Custom Popular Post Widget
class Custom_Popular_Posts_Widget extends WP_Widget {

    // Widget setup
    public function __construct() {
        parent::__construct(
            'custom_popular_posts_widget', // Base ID
            'پست های محبوب سفارشی فودکینگ', // Widget name
            array( 'description' => 'ویجت سفارشی برای نمایش پست های محبوب در نوار کناری' ) // Widget description
        );
    }

    // Display widget content
    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        echo '<div class="single-sidebar-widgets">';
        echo '<div class="wid-title">';
        echo '<h4>مطالب محبوب </h4>';
        echo '</div>';
        echo '<div class="popular-posts">';
        
        // Your popular post query goes here
        $popular_posts = new WP_Query(array(
            'post_type'      => 'post',
            'posts_per_page' => 3, // Number of popular posts to display
            'orderby'        => 'comment_count', // Order by number of comments
            'order'          => 'DESC',
        ));

        if ($popular_posts->have_posts()) {
            while ($popular_posts->have_posts()) {
                $popular_posts->the_post();
                echo '<div class="single-post-item">';
                echo '<div class="thumb bg-cover" style="background-image: url(' . get_the_post_thumbnail_url() . ');"></div>';
                echo '<div class="post-content">';
                echo '<h5><a href="' . get_permalink() . '">' . get_the_title() . '</a></h5>';
                echo '<div class="post-date">';
                echo '<i class="far fa-calendar-alt"></i>' . get_the_date('jS F Y');
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
        } else {
            // If no popular posts found
            echo 'No popular posts found.';
        }
        
        // Restore original post data
        wp_reset_postdata();
        
        echo '</div>'; // Close .popular-posts
        echo '</div>'; // Close .single-sidebar-widget
        echo $args['after_widget'];
    }

}

// Register Custom Popular Post Widget
function register_custom_popular_posts_widget() {
    register_widget( 'Custom_Popular_Posts_Widget' );
}

add_action( 'widgets_init', 'register_custom_popular_posts_widget' );


/*
Custom Sidebar Categories Widget
A custom widget to display categories dynamically.
====================================================
*/

class Custom_Sidebar_Categories_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'custom_sidebar_categories_widget',
            'دسته بندی سفارشی فودکینگ',
            array('description' => 'دسته ها را در نوار کناری نمایش می دهد.')
        );
    }

    // Display widget content
    public function widget($args, $instance) {
        echo $args['before_widget'];
        echo '<div class="single-sidebar-widgets">';
        echo '<div class="wid-title">';
        echo '<h4>' . esc_html($instance['title']) . '</h4>';
        echo '</div>';
        echo '<div class="cus_widget_categories">';
        echo '<ul>';

        $categories = get_categories(array(
            'orderby' => 'name',
            'order' => 'ASC'
        ));

        foreach ($categories as $category) {
            echo '<li>';
            echo '<a href="' . esc_url(get_category_link($category->term_id)) . '">';
            // Output category icon if available
            $category_icon = get_field('category_icon', 'category_' . $category->term_id);
            if ($category_icon) {
                echo '<i class="' . esc_attr($category_icon) . '"></i>';
            }
            echo esc_html($category->name) . ' <span>(' . esc_html($category->count) . ')</span></a>';
            echo '</li>';
        }

        echo '</ul>';
        echo '</div>';
        echo '</div>';
        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Categories';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}
function register_custom_sidebar_categories_widget() {
    register_widget('Custom_Sidebar_Categories_Widget');
}
add_action('widgets_init', 'register_custom_sidebar_categories_widget');

/*
Custom Sidebar Social Profile Widget
A custom widget to display social media profile dynamically.
============================================================
*/
// Register the custom widget
function register_never_miss_news_widget() {
    register_widget('Never_Miss_News_Widget');
}
add_action('widgets_init', 'register_never_miss_news_widget');

// Define the widget class
class Never_Miss_News_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'never_miss_news_widget',
            'ابزارک اخبار سفارشی فودکینگ',
            array('description' => 'پیوندهای اجتماعی را برای اخبار گم نشدنی نمایش می دهد.')
        );
    }

    // Output of the widget
    public function widget($args, $instance) {
        echo $args['before_widget'];
        echo '<div class="single-sidebar-widgets">';
        echo '<div class="wid-title">';
        echo '<h4>' . esc_html__('اشتراک گذاری', 'text-domain') . '</h4>';
        echo '</div>';
        echo '<div class="social-link">';
        
        // Output social links
        $social_links = array(
            'facebook' => 'fab fa-facebook-f',
            'twitter' => 'fab fa-twitter',
            'instagram' => 'fab fa-instagram',
            'linkedin' => 'fab fa-linkedin-in',
            'youtube' => 'fab fa-youtube'
        );
        
        foreach ($social_links as $social => $icon_class) {
            if (!empty($instance[$social])) {
                echo '<a href="' . esc_url($instance[$social]) . '"><i class="' . esc_attr($icon_class) . '"></i></a>';
            }
        }
        
        echo '</div>';
        echo '</div>';
        echo $args['after_widget'];
    }

    // Output of the widget form
    public function form($instance) {
        $social_links = array(
            'facebook' => 'Facebook',
            'twitter' => 'Twitter',
            'instagram' => 'Instagram',
            'linkedin' => 'LinkedIn',
            'youtube' => 'YouTube'
        );
        
        foreach ($social_links as $social => $label) {
            $field_id = $this->get_field_id($social);
            $field_name = $this->get_field_name($social);
            $field_value = !empty($instance[$social]) ? esc_attr($instance[$social]) : '';
            
            echo '<p>';
            echo '<label for="' . $field_id . '">' . $label . ' URL:</label>';
            echo '<input class="widefat" id="' . $field_id . '" name="' . $field_name . '" type="text" value="' . $field_value . '">';
            echo '</p>';
        }
    }

    // Update the widget settings
    public function update($new_instance, $old_instance) {
        $instance = array();
        
        foreach ($new_instance as $social => $value) {
            $instance[$social] = !empty($value) ? esc_url($value) : '';
        }
        
        return $instance;
    }
}


/*
Custom Sidebar Popular Tags Widget
A custom widget to display popular tags dynamically.
====================================================
*/
class Popular_Tags_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'popular_tags_widget',
            'محبوب ترین برچسب های سقارشی فودکینگ',
            array('description' => 'برچسب های محبوب را در نوار کناری نمایش می دهد.')
        );
    }

    // Output of the widget
    public function widget($args, $instance) {
        echo $args['before_widget'];
        echo '<div class="single-sidebar-widgets">';
        echo '<div class="wid-title">';
        echo '<h4>' . esc_html__('برچسب های محبوب', 'text-domain') . '</h4>';
        echo '</div>';
        echo '<div class="tagcloud">';
        
        // Output popular tags
        $tags = get_tags(array(
            'orderby' => 'count',
            'order' => 'DESC',
            'number' => 8 // Change this number to control the number of tags displayed
        ));
        
        foreach ($tags as $tag) {
            echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
        }
        
        echo '</div>';
        echo '</div>';
        echo $args['after_widget'];
    }
}

// Register the custom widget
function register_popular_tags_widget() {
    register_widget('Popular_Tags_Widget');
}
add_action('widgets_init', 'register_popular_tags_widget');







