<?php
/**
 * Render the Reusable Content Blocks Settings page.
 *
 * @package reusablec-block
 *
 * @return void
 */

add_action('admin_menu', 'rcb_register_options_page'); //init plugin options menu

//register plugin options menu
function rcb_register_options_page() {
	add_submenu_page( 'edit.php?post_type=foodking_blocks', 'Reusable Content Blocks Settings', 'تنظیمات', 'manage_options', 'reusablecb-options', 'rcb_options_page_callback' ); 
}

add_action( 'admin_init', 'rcb_register_settings' );
function rcb_register_settings() {

    register_setting( 'rcb-settings-group', 'rcb_hide_unpub' );
	register_setting( 'rcb-settings-group', 'rcb_enable_widget' );
	register_setting( 'rcb-settings-group', 'rcb_css_metakeys' );
}

//plugin options page function
function rcb_options_page_callback() {
	?>
	<div class="wrap">
	<h2><?php echo esc_html__( 'تنظیمات بلوک محتوای قابل استفاده مجدد', 'foodking-toolkit' ); ?></h2>	
    <form method="post" action="options.php">
	
    <?php settings_fields( 'rcb-settings-group' ); ?>
    <?php do_settings_sections( 'rcb-settings-group' ); ?>
   
    <table class="form-table">
       
        <tr valign="top">
        <th scope="row"><?php echo esc_html__( 'بلوک های منتشر نشده را مخفی کنید:', 'foodking-toolkit' ); ?></th>
        <td><input type="checkbox" name="rcb_hide_unpub" value="enable" <?php checked( get_option('rcb_hide_unpub'), 'enable', true ); ?>/></td>
        <td></td>
        </tr>
        <tr valign="top">
        <th scope="row"><?php echo esc_html__( 'پشتیبانی از ویجت را فعال کنید:', 'foodking-toolkit' ); ?></th>
        <td><input type="checkbox" name="rcb_enable_widget" value="enable" <?php checked( get_option('rcb_enable_widget'), 'enable', true ); ?>/></td>
        <td><?php _e( 'اگر تم شما از کدهای کوتاه در قسمت‌های ابزارک پشتیبانی می‌کند، می‌توانید از کدهای کوتاه قابل استفاده مجدد در ابزارک‌های نوشتاری/HTML استفاده کنید.', 'foodking-toolkit' ); ?>
        </td>
        </tr>
        
        <tr valign="top">
        <th scope="row"><?php echo esc_html__( 'cssسفارشی:', 'foodking-toolkit' ); ?></th>
        <td><textarea name="rcb_css_metakeys" rows="5" cols="40"><?php echo get_option('rcb_css_metakeys'); ?></textarea></td>
        <td><?php echo sprintf( __( '(اختیاری) برخی از سازندگان صفحه CSS های سفارشی عنصر را به عنوان کلیدهای متا ذخیره می کنند و هنگام مشاهده صفحه ، آن را ارائه می دهند.اگر عناصر مربوط به تم یا صفحه سازنده خود افزودنی های اضافه شده سبک هنگام قرار دادن با کد کوتاه ، کلیدهای متا خود را در اینجا به یک خط اضافه کنید.', 'foodking-toolkit' ) );  ?>
        </td>
        </tr>
    </table>
    <?php submit_button();  ?>
    </form>
<?php  }