<?php
/**
 * Foodking Elementor Support
 */

// Main Elementor foodking Extension Class
final class Elementor_Foodking_Extension {

    const VERSION = '1.0.0';
    const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
    const MINIMUM_PHP_VERSION = '7.0';

    // Instance
    private static $_instance = null;

    public static function instance() {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;

    }

    // Constructor
    public function __construct() {
        add_action( 'plugins_loaded', [ $this, 'init' ] );
    }

    // init
    public function init() {
        load_plugin_textdomain( 'foodking-toolkit' );

        // Check if Elementor installed and activated
        if ( ! did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
            return;
        }

        // Check for required Elementor version
        if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
            return;
        }

        // Check for required PHP version
        if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
            return;
        }

        // Add Plugin actions
        add_action( 'elementor/widgets/register', [ $this, 'init_widgets' ] );

        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );

    }

    public function register_new_category($manager){
        $manager->add_category('foodking-elements',[
            'title'=>esc_html__('المان های فودکینگ','foodking-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
        ?>
        <style media="screen">

            #elementor-panel-category-foodking-elements .elementor-element{
                position: relative;
            }
            #elementor-panel-category-foodking-elements .elementor-element::before {
                position: absolute;
                content: 'F K';
                background: linear-gradient(90deg, #faa927, #d12525);
                top: 0%;
                left: 0;
                border-radius: 5px;
                font-family:"IRANYekanWeb(FaNum)"!important;
                padding: 5px;
                color: #fff;
                font-weight: 200;
                border: 0;
                overflow: hidden;
                font-size: 15px;
            }
            #elementor-panel-category-general .elementor-element .title,.elementor-panel-category-title{
                font-family:"IRANYekanWeb(FaNum)"!important;
            }
            #elementor-panel-category-general .elementor-element .title{
                font-size: 12px !important;
            }
            .elementor-panel .elementor-element .title-wrapper {
                font-family:"IRANYekanWeb(FaNum)"!important;
            }
            .elementor-loader-wrapper .elementor-loading-title{
                font-family: "IRANYekanWeb(FaNum)"!important;
            }
            .elementor-loading-title {
                color: var(--e-a-color-txt);
                text-align: center;
                text-transform: uppercase;
                 letter-spacing: unset!important;
                text-indent: 7px;
                font-size: 14px!important;
                width: 100%;
            }
            .elementor-label-inline>.elementor-control-content>.elementor-control-field>.elementor-control-title {
                flex-shrink: 0;
                max-width: 60%;
                font-family: "IRANYekanWeb(FaNum)"!important;
            }
        </style>
        <?php
    }


    //Admin notice
    public function admin_notice_missing_main_plugin() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
            /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'foodking-toolkit' ),
            '<strong>' . esc_html__( 'Foodking Toolkit', 'foodking-toolkit' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'foodking-toolkit' ) . '</strong>'
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }
    public function admin_notice_minimum_elementor_version() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
            /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'foodking-toolkit' ),
            '<strong>' . esc_html__( 'Foodking Toolkit', 'foodking-toolkit' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'foodking-toolkit' ) . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }
    public function admin_notice_minimum_php_version() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
            /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'foodking-toolkit' ),
            '<strong>' . esc_html__( 'Foodking Toolkit', 'foodking-toolkit' ) . '</strong>',
            '<strong>' . esc_html__( 'PHP', 'foodking-toolkit' ) . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }

    // Toolkit Widgetsّ
    public function init_widgets() {
        
        // Include Widget files
        require_once( __DIR__ . '/icons.php' );
        require_once( __DIR__ . '/el-widgets/about-one.php' );
        require_once( __DIR__ . '/el-widgets/about-two.php' );
        require_once( __DIR__ . '/el-widgets/about-three.php' );
        require_once( __DIR__ . '/el-widgets/about-four.php' );
        require_once( __DIR__ . '/el-widgets/about-five.php' );
        require_once( __DIR__ . '/el-widgets/brand.php' );
        require_once( __DIR__ . '/el-widgets/booking.php' );
        require_once( __DIR__ . '/el-widgets/booking-two.php' );
        require_once( __DIR__ . '/el-widgets/blog-one.php' );
        require_once( __DIR__ . '/el-widgets/blog-two.php' );
        require_once( __DIR__ . '/el-widgets/choose-us.php' );
        require_once( __DIR__ . '/el-widgets/choose-us-two.php' );
        require_once( __DIR__ . '/el-widgets/choose-us-three.php' );
        require_once( __DIR__ . '/el-widgets/cta-banner-one.php' );
        require_once( __DIR__ . '/el-widgets/cta-banner-two.php' );
        require_once( __DIR__ . '/el-widgets/contact-info.php' );
        require_once( __DIR__ . '/el-widgets/contact.php' );
        require_once( __DIR__ . '/el-widgets/chef.php' );
        require_once( __DIR__ . '/el-widgets/chef-two.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-one.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-two.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-three.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-four.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-five.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-six.php' );
        require_once( __DIR__ . '/el-widgets/food-banner-seven.php' );
        require_once( __DIR__ . '/el-widgets/footer-widgets.php' );
        require_once( __DIR__ . '/el-widgets/food-comboo.php' );
        require_once( __DIR__ . '/el-widgets/food-menu.php' );
        require_once( __DIR__ . '/el-widgets/food-processing.php' );
        require_once( __DIR__ . '/el-widgets/food-processing-two.php' );
        require_once( __DIR__ . '/el-widgets/faq.php' );
        require_once( __DIR__ . '/el-widgets/grilled-banner.php' );
        require_once( __DIR__ . '/el-widgets/gallery-one.php' );
        require_once( __DIR__ . '/el-widgets/gallery.php' );
        require_once( __DIR__ . '/el-widgets/hero-one.php' );
        require_once( __DIR__ . '/el-widgets/hero-two.php' );
        require_once( __DIR__ . '/el-widgets/hero-three.php' );
        require_once( __DIR__ . '/el-widgets/instagram-banner.php' );
        require_once( __DIR__ . '/el-widgets/instagram-banner-two.php' );
        require_once( __DIR__ . '/el-widgets/kfc-banner.php' );
        require_once( __DIR__ . '/el-widgets/marque.php' );
        require_once( __DIR__ . '/el-widgets/marque-two.php' );
        require_once( __DIR__ . '/el-widgets/marque-three.php' );
        require_once( __DIR__ . '/el-widgets/newsletter.php' );
        require_once( __DIR__ . '/el-widgets/reservation-one.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-one.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-two.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-three.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-four.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-five.php' );
        require_once( __DIR__ . '/el-widgets/testimonial-six.php' );
        require_once( __DIR__ . '/el-widgets/today-nest-sale.php' );
        require_once( __DIR__ . '/el-widgets/today-nest-sale-two.php' );
        require_once( __DIR__ . '/el-widgets/video-banner.php' );
        require_once( __DIR__ . '/el-widgets/video-banner-two.php' );
        require_once( __DIR__ . '/el-widgets/video-banner-three.php' );
        require_once( __DIR__ . '/el-widgets/chef-details-widget.php' );
        require_once( __DIR__ . '/el-widgets/reservation-details-widget.php' );
        require_once( __DIR__ . '/el-widgets/product-category.php' );
        require_once( __DIR__ . '/el-widgets/products.php' );
        require_once( __DIR__ . '/el-widgets/products-two.php' );
        require_once( __DIR__ . '/el-widgets/offer.php' );
        require_once( __DIR__ . '/el-widgets/product-sidebar-cat.php' );
        require_once( __DIR__ . '/el-widgets/breadcrumb.php' );

    }
}
Elementor_Foodking_Extension::instance();