<?php

namespace Elementor;
class Foodking_Today_Nest_Sale_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_today_nest_sale_two';
	}
    public function get_title() {
		return esc_html__( 'Today Nest Sale Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-device-desktop';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'today_nest_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'slider_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Slider Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Image for Slide', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
            $this->add_control(
                'bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Content Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Deal Of The Day', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'TODAY’S the hamburger’ DAY', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'special price', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_price', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Subtitle Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$55', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Savor the perfect symphony of flavors It’s the perfect dining experience where Experience quick and efficient with our signature hamburger, a culinary', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'today_nest_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h4',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h2',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Sub Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Sub Title Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content h3',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .today-best-sale-wrapper .best-sale-content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
    <!-- Today Nest Sale Banner Start -->
    <section class="today-best-sale fix">
        <div class="today-best-sale-wrapper">
            <div class="row g-0">
                <div class="col-xl-8 col-lg-7">
                    <div class="swiper today-best-sale-image-slider">
                        <div class="array-button">
                            <button class="array-next"><i class="far fa-long-arrow-right"></i></button>
                            <button class="array-prev"><i class="far fa-long-arrow-left"></i></button>
                        </div>
                        <div class="swiper-wrapper">
                            <?php foreach($settings['lists'] as $item):?>
                                <div class="swiper-slide">
                                    <?php if($item['slider_image']['url']):?>
                                        <div class="today-best-sale-image bg-cover" style="background-image: url(<?php echo esc_url($item['slider_image']['url']);?>);"></div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="best-sale-content style-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']);?>);">
                        <div class="burger-shape">
                            <?php if($settings['shape_image_1']['url']):?>
                                <img src="<?php echo esc_url($settings['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?>
                        </div>
                        <div class="fry-shape">
                            <?php if($settings['shape_image_2']['url']):?>
                                <img src="<?php echo esc_url($settings['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?>
                        </div>
                        <h4 class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></h4>
                        <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['title']);?></h2>
                        <h3 class="wow fadeInUp" data-wow-delay=".5s">
                            <span><?php echo esc_html($settings['subtitle']);?></span> <?php echo esc_html($settings['subtitle_price']);?>
                        </h3>
                        <p class="wow fadeInUp" data-wow-delay=".7s"><?php echo wp_kses_post($settings['content']);?></p>
                        <div class="button-area wow fadeInUp" data-wow-delay=".9s">
                            <?php if($settings['btn_text']): ?>
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn bg-transparent">
                                <span class="button-content-wrapper d-flex align-items-center">
                                <span class="button-icon">
                                    <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                        <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                    <?php else: ?>
                                        <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php endif; ?>
                                </span>
                                <span class="button-text"><?php echo esc_html($settings['btn_text']);?></span>
                                </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Today_Nest_Sale_Two_Widget );