<?php

namespace Elementor;
class Foodking_Testimonial_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_testimonial_two';
	}
    public function get_title() {
		return esc_html__( 'Testimonial Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-commenting-o';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'testimonial' ];
	}

    protected function register_controls() {
        // Elementor Section Control
		$this->start_controls_section(
			'testimonial_controls',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Section Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'section_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Section Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'feedback_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Feedback Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'feedback_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Feedback Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Feedback', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'client_name', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Piter Bowman', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'client_designation', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Designation', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Business CEO & co founder', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'testimonial_comment',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Client Says', 'foodking-toolkit' ),
                    'default' => esc_html__( '“Thank you for dinner last night. It was amazing!! I have
                    say it’s the best meal I have had in quite some time.
                    will definitely be seeing more eating next year.”', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'icon_1',
                [
                    'label' => esc_html__( 'Ratings Icons #1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_2',
                [
                    'label' => esc_html__( 'Ratings Icons #2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_3',
                [
                    'label' => esc_html__( 'Ratings Icons #3', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_4',
                [
                    'label' => esc_html__( 'Ratings Icons #4', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_5',
                [
                    'label' => esc_html__( 'Ratings Icons #5', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Testimonial', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .testimonial-section-2',
                ]
            );

            $this->add_control(
                'ratings_color',
                [
                    'label' => esc_html__( 'Ratings Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .star span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Ratings Typography', 'foodking-toolkit' ),
                    'name' => 'ratings_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .star span',
                ]
            );

            $this->add_control(
                'testimony_content_color',
                [
                    'label' => esc_html__( 'Comment Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Comment Typography', 'foodking-toolkit' ),
                    'name' => 'testimony_content_typography',
                    'selector' => '{{WRAPPER}} .testimonial-content h3',
                ]
            );

            $this->add_control(
                'commenter_color',
                [
                    'label' => esc_html__( 'Person Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Name Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h4',
                ]
            );

            $this->add_control(
                'commenter_designation_color',
                [
                    'label' => esc_html__( 'Person Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Designation Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_designation_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h5',
                ]
            );

        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        
    <!-- Testimonial Section Start -->
    <section class="testimonial-section-2">
        <div class="container">
            <div class="testimonial-wrapper-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['section_bg_image']['url']);?>);">
                <div class="row align-items-center">
                    <div class="col-xl-4 col-lg-4">
                        <div class="testimonial-image bg-cover" style="background-image: url(<?php echo esc_url($settings['section_image']['url']);?>);">
                            <?php if($settings['feedback_image']['url']):?>
                                <div class="feedback d-flex align-items-center">
                                    <img src="<?php echo esc_url($settings['feedback_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <h4><?php echo esc_HTML($settings['feedback_title']);?></h4>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xl-8 col-lg-8 mt-5 mt-lg-0">
                        <div class="swiper testimonial-content-slider-2">
                            <div class="swiper-wrapper">
                                <?php foreach($settings['lists'] as $item):?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-content center">
                                            <div class="client-info">
                                                <h4><?php echo esc_html($item['client_name']);?></h4>
                                                <h5><?php echo esc_html($item['client_designation']);?></h5>
                                            </div>
                                            <h3>
                                                <?php echo esc_html($item['testimonial_comment']); ?>
                                            </h3>
                                            <div class="star">
                                                <span class="<?php echo esc_attr( $item['icon_1'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_2'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_3'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_4'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_5'] ); ?>"></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach;?>
                            </div>
                            <div class="swiper-dot style-2">
                                <div class="dot-2"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Testimonial_Two_Widget );