<?php

namespace Elementor;
class Foodking_Testimonial_Four_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_testimonial_four';
	}
    public function get_title() {
		return esc_html__( 'Testimonial Four', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-commenting-o';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'testimonial' ];
	}

    protected function register_controls() {
        // Elementor Section Control
		$this->start_controls_section(
			'testimonial_controls',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'cover_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Cover Image', 'foodking-toolkit' ),
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'quote_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Quote Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'feedback_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Praise Text', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Quality Food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'icon_1',
                [
                    'label' => esc_html__( 'Ratings Icons #1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_2',
                [
                    'label' => esc_html__( 'Ratings Icons #2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_3',
                [
                    'label' => esc_html__( 'Ratings Icons #3', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_4',
                [
                    'label' => esc_html__( 'Ratings Icons #4', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_5',
                [
                    'label' => esc_html__( 'Ratings Icons #5', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'testimonial_comment',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Client Says', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Nestled within a fresh, toasted bun, each bite unveils a perfect harmony of textures, complemented by layers of crisp lettuce, ripe tomatoes, and the crunch pickles Our secret sauce proprietary blend savory', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'avatar',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Avatar Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'client_name', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Richard D. Baker/ ', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'client_designation', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Designation', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CEO & founder', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Testimonial', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .testimonial-section',
                ]
            );

            $this->add_control(
                'ratings_color',
                [
                    'label' => esc_html__( 'Ratings Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .info-icon .star span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Ratings Typography', 'foodking-toolkit' ),
                    'name' => 'ratings_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .info-icon .star span',
                ]
            );

            $this->add_control(
                'testimony_praise_color',
                [
                    'label' => esc_html__( 'Praise Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .info-icon h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Praise Text Typography', 'foodking-toolkit' ),
                    'name' => 'testimony_praise_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .info-icon h4',
                ]
            );

            $this->add_control(
                'testimony_content_color',
                [
                    'label' => esc_html__( 'Comment Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Comment Typography', 'foodking-toolkit' ),
                    'name' => 'testimony_content_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content h3',
                ]
            );

            $this->add_control(
                'commenter_color',
                [
                    'label' => esc_html__( 'Person Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .client-info .title h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Name Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .client-info .title h4',
                ]
            );

            $this->add_control(
                'commenter_designation_color',
                [
                    'label' => esc_html__( 'Person Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .client-info .title h4 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Designation Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_designation_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-4 .testimonial-content .client-info .title h4 span',
                ]
            );

        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        
    <!-- Testimonial Section Start -->
    <section class="testimonial-section fix section-padding">
        <div class="container">
            <div class="testimonial-wrapper-4">
                <div class="row align-items-center justify-content-between">
                    <div class="col-xl-7 col-lg-7">
                        <div class="swiper testimonial-content-slider-3">
                            <div class="swiper-wrapper">
                                <?php foreach($settings['lists'] as $item):?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-content">
                                            <div class="info-icon d-flex align-items-center">
                                                <?php if($item['quote_image']['url']):?>
                                                    <img src="<?php echo esc_url($item['quote_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                <?php endif;?>
                                                <h4><?php echo esc_html($item['feedback_title']);?></h4>
                                                <div class="star">
                                                    <span class="<?php echo esc_attr( $item['icon_1'] ); ?>"></span>
                                                    <span class="<?php echo esc_attr( $item['icon_2'] ); ?>"></span>
                                                    <span class="<?php echo esc_attr( $item['icon_3'] ); ?>"></span>
                                                    <span class="<?php echo esc_attr( $item['icon_4'] ); ?>"></span>
                                                    <span class="<?php echo esc_attr( $item['icon_5'] ); ?>"></span>
                                                </div>
                                            </div>
                                            <h3><?php echo wp_kses_post($item['testimonial_comment']);?></h3>
                                            <?php if($item['avatar']['url']):?>
                                                <div class="client-info d-flex align-items-center">
                                                    <div class="client-image bg-cover" style="background-image: url(<?php echo esc_url($item['avatar']['url']);?>);"></div>
                                                    <div class="title">
                                                        <h4><?php echo esc_html($item['client_name']);?><span><?php echo esc_html($item['client_designation']);?></span></h4>
                                                    </div>
                                                </div>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                <?php endforeach;?>
                            </div>
                        </div>
                    </div>
                    <?php if($settings['cover_image']['url']):?>
                        <div class="col-xl-4 col-lg-4 mt-5 mt-lg-0">
                            <div class="testimonial-image bg-cover" style="background-image: url(<?php echo esc_url($settings['cover_image']['url']);?>);"></div>
                        </div>
                    <?php endif;?>
                </div>
                <div class="swiper-dot-2">
                    <div class="dot-2"></div>
                </div>
            </div>
        </div>
    </section>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Testimonial_Four_Widget );