<?php

namespace Elementor;
class Foodking_Testimonial_Five_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_testimonial_five';
	}
    public function get_title() {
		return esc_html__( 'Testimonial Five', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-commenting-o';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'testimonial' ];
	}

    protected function register_controls() {
        // Elementor Section Control
		$this->start_controls_section(
			'testimonial_controls',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'avatar',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Cover Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'testimonial_comment',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Client Says', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Bring to the table win-win strategies to ensure proactive domination. At the end of the day going forward normal that has evolved from
                    operational X is on the', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'client_name', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Janes Cooper', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'client_designation', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Designation', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Developer', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Testimonial', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-card-items' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'quote_color',
                [
                    'label' => esc_html__( 'Quote Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-card-items::before' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Quote Icon Typography', 'foodking-toolkit' ),
                    'name' => 'quote_typography',
                    'selector' => '{{WRAPPER}} .testimonial-card-items::before',
                ]
            );
            $this->add_control(
                'testimony_content_color',
                [
                    'label' => esc_html__( 'Comment Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Comment Typography', 'foodking-toolkit' ),
                    'name' => 'testimony_content_typography',
                    'selector' => '{{WRAPPER}} .testimonial-content p',
                ]
            );
            $this->add_control(
                'commenter_color',
                [
                    'label' => esc_html__( 'Person Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-card-items .testimonial-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Name Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_typography',
                    'selector' => '{{WRAPPER}} .testimonial-card-items .testimonial-content h4',
                ]
            );

            $this->add_control(
                'commenter_designation_color',
                [
                    'label' => esc_html__( 'Person Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Designation Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_designation_typography',
                    'selector' => '{{WRAPPER}} .testimonial-content span',
                ]
            );

        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        
    <!--<< Testimonial Section Start >>-->
    <section class="testimonial-section-4 fix section-bg section-padding">
        <div class="container">
            <div class="row g-4">
                <?php foreach($settings['lists'] as $item):?>
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="testimonial-card-items">
                            <?php if($item['avatar']['url']):?>
                                <div class="testimonial-image bg-cover" style="background-image: url(<?php echo esc_url($item['avatar']['url']);?>);"></div>
                            <?php endif;?>
                            <div class="testimonial-content">
                                <p><?php echo wp_kses_post($item['testimonial_comment']);?></p>
                                <h4><?php echo esc_html($item['client_name']);?></h4>
                                <span><?php echo esc_html($item['client_designation']);?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach;?>
            </div>
        </div>
    </section>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Testimonial_Five_Widget );