<?php

namespace Elementor;
class Foodking_Reservation_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_reservation_one';
	}
    public function get_title() {
		return esc_html__( 'Reservation', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-select';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'reservation_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Reservation Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'reservation_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'create an reservation', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'shortcode',
                [
                    'label' => esc_html__( 'Reservation Contact Form 7 PLugin Short code', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'reservation_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .booking-section',
                ]
            );
            $this->add_control(
                'bg_color',
                [
                    'label' => esc_html__( 'Reservation Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .booking-contact' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .booking-contact h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .booking-contact h3',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn.bg-yellow' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn.bg-yellow' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_hober_color',
                [
                    'label' => esc_html__( 'Button Hover Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn.bg-yellow:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_warning_color',
                [
                    'label' => esc_html__( 'Button Warning Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .booking-items .wpcf7-response-output' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Text Typography', 'foodking-toolkit' ),
                    'name' => 'tbtn_typography',
                    'selector' => '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn.bg-yellow',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Booking Section Start -->
    <section class="booking-section fix section-bg section-padding mt-0">
        <div class="container">
            <div class="booking-wrapper">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="booking-contact mb-0 style-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['section_shape_image']['url']);?>);">
                            <h3 class="text-center mb-4 text-white wow fadeInUp"><?php echo esc_html($settings['reservation_title']);?></h3>
                            <div class="booking-items">
                                <?php echo do_shortcode( $settings['shortcode'] ); ?><!-- Contact Form 7 Short Code -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Reservation_One_Widget );