<?php

/**
 * Products Area Widget
 */

namespace Elementor;

class Foodking_Products extends Widget_Base
{

    public function get_name()
    {
        return 'Products';
    }

    public function get_title()
    {
        return __('Products', 'foodking-toolkit');
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return ['foodking-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'products_section',
            [
                'label' => __('Products Area', 'foodking-toolkit'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('crispy, every bite taste', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Popular Food Items', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'متن دکمه', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('VIEW MORE', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => foodking_toolkit_get_page_product_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Product Order By', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'foodking-toolkit' ),
                        'ASC'       => __( 'ASC', 'foodking-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 8,
                ]
            );


        $this->end_controls_section();

        $this->start_controls_section(
            'product_style',
            [
                'label' => __('Style', 'foodking-toolkit'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'width',
            [
                'label' => esc_html__( 'عرض تصویر', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .catagory-product-card-2 .catagory-product-image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title span',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );

            $this->add_control(
                'card_title_color',
                [
                    'label' => esc_html__('Card Title Color', 'foodking-toolkit'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card-2 .catagory-product-content h4 a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_title_typography',
                    'label' => __('Card Title Typography', 'foodking-toolkit'),
                    'selector' => '{{WRAPPER}} .catagory-product-card-2 .catagory-product-content h4',
                ]
            );

            $this->add_control(
                'card_h_bg_color',
                [
                    'label' => esc_html__('Card Hover Bg Color', 'foodking-toolkit'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card-2:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );


        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this->add_inline_editing_attributes('title', 'none');
        $this->add_inline_editing_attributes('content', 'none');

        // Title tag
		$title_tag = !empty($settings['sec_title_tag']) ? $settings['sec_title_tag'] : 'h2';

        // Product Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'product',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'product_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $products_array = new \WP_Query( $args );
        ?>

        <!-- Food Catagory Section Start -->
        <section class="food-category-section fix section-padding section-bg">
            <div class="container">
                <div class="section-title text-center">
                    <?php if( $settings['top_title']): ?>
                        <span class="wow fadeInUp"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?> 
                    <?php if( $settings['title']): ?>
                        <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row">
                    <?php
                        while ($products_array->have_posts()) : $products_array->the_post();
                        $product        = wc_get_product( get_the_ID() );
                        $price          = $product->get_price_html();
                        $average_rating = $product->get_average_rating();
                        $rating_count = $product->get_rating_count();

                        // Calculate the discount percentage
                        $regular_price  = $product->get_regular_price();
                        $sale_price     = $product->get_sale_price();
                        $discount_percentage = '';
                        if ($sale_price && $regular_price) {
                            $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                        }

                        $product_id = get_the_ID();
                    ?>
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="catagory-product-card-2 text-center">
                            <div class="icon">
                                <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                            </div>
                            <div class="catagory-product-image">
                                <a href="<?php the_permalink() ?>"><img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'foodking_product_thumb' ); ?>" alt="Image" class="transition"></a>
                            </div>
                            <div class="catagory-product-content">
                                <div class="catagory-button">
                                    <?php // woocommerce_template_loop_add_to_cart(); ?>

                                    <a href="<?php echo get_home_url(); ?>/cart/?add-to-cart=<?php echo $product_id ; ?>" class="theme-btn-2"><?php echo esc_html__("افزودن به سبد", "foodking-toolkit" ); ?></a>
                                </div>
                                <div class="info-price d-flex align-items-center justify-content-center">
                                    <?php if($product->is_on_sale()) : ?>
                                        <p class="minus-count"><?php esc_html_e('-', 'foodking'); ?><?php echo esc_html($discount_percentage); ?><?php esc_html_e('%', 'foodking'); ?></p>
                                    <?php elseif($discount_percentage): ?>
                                        <p class="minus-count"><?php echo esc_html($sale); ?></p>
                                    <?php endif; ?>
                                    <?php echo $price; ?>
                                </div>
                                <h4>
                                    <a href="<?php the_permalink() ?>"><?php the_title() ?></a>
                                </h4>
                                <div class="star">
                                   <?php
                                        echo '<div class="average-rating-stars">';
                                        echo '<div class="star-rating">';

                                        // Output filled stars
                                        for ( $i = 1; $i <= floor( $average_rating ); $i++ ) {
                                            echo '<span class="dashicons dashicons-star-filled"></span>';
                                        }

                                        // Output half star if applicable
                                        if ( $average_rating - floor( $average_rating ) >= 0.5 ) {
                                            echo '<span class="dashicons dashicons-star-half"></span>';
                                        }

                                        // Output empty stars
                                        for ( $i = ceil( $average_rating ); $i < 5; $i++ ) {
                                            echo '<span class="dashicons dashicons-star-empty"></span>';
                                        }
                                        echo '</div>'; // Close star-rating
                                        echo '</div>'; // Close average-rating-stars
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
                <?php if( $settings['btn_url']): ?> 
                    <div class="catagory-button text-center pt-4 wow fadeInUp" data-wow-delay=".3s">
                        <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="theme-btn">
                        <span class="button-content-wrapper d-flex align-items-center">
                        <span class="button-icon"><i class="flaticon-delivery"></i></span>
                        <span class="button-text"><?php echo wp_kses_post( $settings['btn_text'] ); ?></span>
                        </span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foodking_Products);