<?php

/**
 * Products Area Widget
 */

namespace Elementor;

class Foodking_Products_Two extends Widget_Base
{

    public function get_name()
    {
        return 'Products_Two';
    }

    public function get_title()
    {
        return __('Products Two', 'foodking-toolkit');
    }

    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_categories()
    {
        return ['foodking-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'products_section',
            [
                'label' => __('Products Area', 'foodking-toolkit'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shape1',
            [
                'label' => esc_html__( 'Shape One', 'foodking-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape2',
            [
                'label' => esc_html__( 'Shape Two', 'foodking-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape3',
            [
                'label' => esc_html__( 'Shape Three', 'foodking-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('BEST SELLING DISHES', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('EXPLORE OUR PRODUCTS', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => foodking_toolkit_get_page_product_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Product Order By', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'foodking-toolkit' ),
                        'ASC'       => __( 'ASC', 'foodking-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 8,
                ]
            );
        $this->add_control(
            'widget_title',
            [
                'label' => esc_html__( 'عنوان قیمت', 'foodking-toolkit' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'قیمت', 'foodking-toolkit' ),
                'placeholder' => esc_html__( 'عنوان مورد منظر خود را وارد کنید.', 'foodking-toolkit' ),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'product_style',
            [
                'label' => __('Style', 'foodking-toolkit'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title span',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );

            $this->add_control(
                'card_title_color',
                [
                    'label' => esc_html__('Card Title Color', 'foodking-toolkit'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-product-items-2 .product-content h4 a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_title_typography',
                    'label' => __('Card Title Typography', 'foodking-toolkit'),
                    'selector' => '{{WRAPPER}} .single-product-items-2 .product-content h4',
                ]
            );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'card_btn_typography',
                'label' => __('تایپوگرافی دکمه سبد خرید', 'foodking-toolkit'),
                'selector' => '{{WRAPPER}} .btn_add_tt a',
            ]
        );

            $this->add_control(
                'card_h_bg_color',
                [
                    'label' => esc_html__('رنگ کارت محصول', 'foodking-toolkit'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-product-items-2' => 'background-color: {{VALUE}}',
                    ],
                ]
            );


        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this->add_inline_editing_attributes('title', 'none');
        $this->add_inline_editing_attributes('content', 'none');

        // Title tag
		$title_tag = !empty($settings['sec_title_tag']) ? $settings['sec_title_tag'] : 'h2';

        // Product Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'product',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'product_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $products_array = new \WP_Query( $args );
        ?>

        <!-- Food Catagory Section Start -->
        <section class="food-category-section fix section-padding pb-0 section-bg">
            <?php if( $settings['shape1']['url'] != '' ): ?>
                <div class="pizza-shape">
                    <img src="<?php echo esc_url( $settings['shape1']['url'] ) ?>" alt="image">
                </div>
            <?php endif; ?>
            <?php if( $settings['shape2']['url'] != '' ): ?>
                <div class="frame-shape">
                    <img src="<?php echo esc_url( $settings['shape2']['url'] ) ?>" alt="image">
                </div>
            <?php endif; ?>
            <?php if( $settings['shape3']['url'] != '' ): ?>
                <div class="frame-shape-2">
                    <img src="<?php echo esc_url( $settings['shape3']['url'] ) ?>" alt="image">
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="section-title text-center">
                    <?php if( $settings['top_title']): ?>
                        <span class="wow fadeInUp"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?> 
                    <?php if( $settings['title']): ?>
                        <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row">
                    <?php
                        while ($products_array->have_posts()) : $products_array->the_post();
                        $product        = wc_get_product( get_the_ID() );
                        $price          = $product->get_price_html();
                        $average_rating = $product->get_average_rating();
                        $rating_count = $product->get_rating_count();

                        // Calculate the discount percentage
                        $regular_price  = $product->get_regular_price();
                        $sale_price     = $product->get_sale_price();
                        $discount_percentage = '';
                        if ($sale_price && $regular_price) {
                            $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                        }
                    ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="single-product-items-2 text-center">
                            <div class="product-content">
                                <h4>
                                    <a href="<?php the_permalink() ?>"><?php the_title() ?></a>
                                </h4>
                                <div class="star">
                                    <?php
                                        echo '<div class="average-rating-stars">';
                                        echo '<div class="star-rating">';

                                        // Output filled stars
                                        for ( $i = 1; $i <= floor( $average_rating ); $i++ ) {
                                            echo '<span class="dashicons dashicons-star-filled"></span>';
                                        }

                                        // Output half star if applicable
                                        if ( $average_rating - floor( $average_rating ) >= 0.5 ) {
                                            echo '<span class="dashicons dashicons-star-half"></span>';
                                        }

                                        // Output empty stars
                                        for ( $i = ceil( $average_rating ); $i < 5; $i++ ) {
                                            echo '<span class="dashicons dashicons-star-empty"></span>';
                                        }
                                        echo '</div>'; // Close star-rating
                                        echo '</div>'; // Close average-rating-stars
                                    ?>
                                </div>
                                <h5><?php echo $settings['widget_title']; ?> <?php echo $price; ?></h5>
                            </div>
                            <div class="product-image">
                            <a href="<?php the_permalink() ?>"><img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'foodking_product_thumb' ); ?>" alt="Image"></a>
                                <ul class="product-icon d-flex justify-content-center align-items-center">
                                    <li>
                                    <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                    </li>
                                    <li class="btn_add_tt">
                                        <?php woocommerce_template_loop_add_to_cart(); ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <?php endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        </section>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foodking_Products_Two);