<?php
/**
 * Offer Widget
 */

namespace Elementor;
class Foodking_Offer extends Widget_Base {

	public function get_name() {
        return 'Foodking_Offer';
    }

	public function get_title() {
        return __( 'Offer', 'foodking-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'foodking-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Foodking_Offer_Area',
			[
				'label' => __( 'Offer Controls', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

            $list_items = new Repeater();

            $list_items->add_control(
                'offer_icon',
                [
                    'label' => __( 'Offer Image', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
                'box_shape',
                [
                    'label' => __( 'Box Shape Image', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
				'top_title',
				[
					'label'       => __( 'Top Title', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'offer',
				[
					'label'       => __( 'Offer', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'offer_title',
				[
					'label'       => __( 'Offer Title', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_text',
				[
					'label'       => __( 'Button Text', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url',
				[
					'label'       => __( 'Button Url', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'offer_item',
                [
                    'label' => esc_html__('Add Offer Item', 'foodking-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'offer_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .food-catagory-wrapper .catagory-product-card-3 .food-content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .food-catagory-wrapper .catagory-product-card-3 .food-content h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Button Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .link-btn.color-red' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Button Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .link-btn.color-red',
                ]
            );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $offer_item = $settings['offer_item'];
        ?>

        <!-- Food Catagory Section Start -->
        <section class="food-category-section fix">
            <div class="food-catagory-wrapper">
                <?php foreach($offer_item as $item_offer): ?>
                    <div class="catagory-product-card-3 center wow fadeInUp" data-wow-delay=".2s">
                        <div class="food-image">
                            <?php if( $item_offer['offer_icon']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $item_offer['offer_icon']['url'] ) ?>" alt="image">
                            <?php endif; ?>
                            <div class="box-text bg-cover" style="background-image:url(<?php echo esc_url( $item_offer['box_shape']['url'] ) ?>);">
                                <span><?php echo wp_kses_post( $item_offer['offer'] ); ?></span>
                            </div>
                            <h2 class="food-title"><?php echo wp_kses_post( $item_offer['top_title'] ); ?></h2>
                        </div>
                        <div class="food-content">
                            <h3>
                                <?php echo wp_kses_post( $item_offer['offer_title'] ); ?>
                            </h3>
                            <a href="<?php echo wp_kses_post( $item_offer['btn_url'] ); ?>" class="link-btn color-red">
                            <?php echo wp_kses_post( $item_offer['btn_text'] ); ?> <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Foodking_Offer );