<?php
/**
 * Newsletter Widget
 */

namespace Elementor;
class Foodking_Newsletter extends Widget_Base {

	public function get_name() {
        return 'foodking_newsletter';
    }

	public function get_title() {
        return __( 'Newsletter', 'foodking-toolkit' );
    }

	public function get_icon() {
        return 'eicon-mail';
    }

	public function get_categories() {
        return [ 'foodking-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Foodking_Newsletter_Area',
			[
				'label' => __( 'Newsletter Controls', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

            $this->add_control(
                'section_bg',
                [
                    'label' => __( 'Section Background Image', 'foodking-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_img_1',
                [
                    'label' => __( 'Shape Image 1', 'foodking-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_img_2',
                [
                    'label' => __( 'Shape Image 2', 'foodking-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_img_3',
                [
                    'label' => __( 'Shape Image 3', 'foodking-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'label'       => __( 'Title 1', 'foodking-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('subscribe our newsletter', 'foodking-toolkit'),
                    'label_block' => true,
                ]
            );
			$this->add_control(
				'title_2',
				[
					'label'       => __( 'Title 2', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('to get more offers', 'foodking-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
				'content',
				[
					'label'       => __( 'Content', 'foodking-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('At vero eos et accusamus et iusto odio dignissimos ducimus quie blanditiis praesentium voluptatum deleniti atque', 'foodking-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Email Placeholder Text', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter email address' , 'foodking-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'foodking-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://docs.envytheme.com/envydoc/foodking-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => 'https://envytheme.us13.list-manage.com/subscribe/post?u=1f4dcefed57b9c394873f34d2&id=b093890ff6',
                ]
            );

            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Subscribe Now' , 'foodking-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'agreement_text_1', [
                    'label' => __( 'Agreement text 1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'I Agree to the ' , 'foodking-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'agreement_text_2', [
                    'label' => __( 'Agreement text 2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Privacy Policy.' , 'foodking-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'agreement_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Agreement Link', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'newsletter_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
                'section_bg_color',
                [
                    'label'     => __( 'Section Background Color', 'foodking-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .fix' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
			
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Title Color', 'foodking-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-cta-banner-wrapper-3 .cta-content h3' => 'color: {{VALUE}} !important',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Title Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .main-cta-banner-wrapper-3 .cta-content h3',
                ]
            );

			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .cta-content p' => 'color: {{VALUE}} !important',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .cta-content p',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .theme-btn.bg-red' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .theme-btn.bg-red' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_hover_text_color',
				[
					'label'     => __( 'Button Hover Text Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .theme-btn.bg-red:hover' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'foodking-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .theme-btn.bg-red:hover::before' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .theme-btn.bg-red',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {
		$settings = $this->get_settings_for_display();
        $this-> add_inline_editing_attributes('title','none');
        // Button URL
        if ( ! empty( $settings['agreement_link']['url'] ) ) {
            $this->add_link_attributes( 'agreement_link', $settings['agreement_link'] );
        }
		?>
        <!-- Main Cta Banner Section Start -->
        <section class="main-cta-banner-3 fix section-padding pt-0">
            <div class="container">
                <div class="main-cta-banner-wrapper-3 bg-cover" style="background-image: url(<?php echo esc_url($settings['section_bg']['url']);?>);">
                    <div class="fry-shape">
                        <?php if($settings['shape_img_1']['url']):?>
                            <img src="<?php echo esc_url($settings['shape_img_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif; ?>
                    </div>
                    <div class="frame-shape">
                        <?php if($settings['shape_img_2']['url']):?>
                            <img src="<?php echo esc_url($settings['shape_img_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif; ?>
                    </div>
                    <div class="frame-shape-2">
                        <?php if($settings['shape_img_3']['url']):?>
                            <img src="<?php echo esc_url($settings['shape_img_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif; ?>
                    </div>
                    <div class="row justify-content-between">
                        <div class="col-xl-6 col-lg-6">
                            <div class="cta-content">
                                <h3 class="wow fadeInUp" data-wow-delay=".3s">
                                <?php echo esc_html($settings['title_1']);?> <br>
                                <?php echo esc_html($settings['title_2']);?>
                                </h3>
                                <p class="wow fadeInUp" data-wow-delay=".5s"><?php echo wp_kses_post($settings['content']);?></p>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-5 mt-4 mt-lg-0 wow fadeInUp" data-wow-delay=".4s">
                            <div class="newsletter-items">
                                <form class="newsletter-form mailchimp" method="post">
                                    <input type="email" name="EMAIL" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" required autocomplete="off">
                                    <div class="icon"><i class="fas fa-envelope"></i></div>
                                    <?php if($settings['button_text']): ?>
                                        <button class="theme-btn bg-red mt-3" type="submit">
                                        <span>
                                            <?php echo esc_html( $settings['button_text'] ); ?>
                                        </span>
                                        </button>
                                    <?php endif;?>
                                    <p class="mchimp-errmessage" style="display: none;"></p>
                                    <p class="mchimp-sucmessage" style="display: none;"></p>
                                </form>

                                <div class="input-save d-flex align-items-center">
                                    <input type="checkbox" class="form-check-input" name="save-for-next" id="saveForNext">
                                    <label for="saveForNext"><?php echo esc_html($settings['agreement_text_1']);?> <a <?php echo $this->get_render_attribute_string('agreement_link'); ?>><?php echo esc_html($settings['agreement_text_2']);?></a></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <script>
            ;(function($){
                "use strict";
                $(document).ready(function () {
                    // MAILCHIMP
                    if ($(".mailchimp").length > 0) {
                        $(".mailchimp").ajaxChimp({
                            callback: mailchimpCallback,
                            url: "<?php echo esc_js($settings['action_url']) ?>"
                        });
                    }
                    $(".memail").on("focus", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("keydown", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("click", function () {
                        $(".memail").val("");
                    });

                    function mailchimpCallback(resp) {
                        if (resp.result === "success") {
                            $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                            $(".mchimp-sucmessage").fadeOut(500);
                        } else if (resp.result === "error") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                        }
                    }
                });
            })(jQuery)
        </script>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Foodking_Newsletter );