<?php

namespace Elementor;
class Foodking_Marque_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_marque_two';
	}
    public function get_title() {
		return esc_html__( 'Marque Slide Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-navigation-horizontal';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

		$this->start_controls_section(
			'marque_content_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'item_one_part_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content One - First Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'populer', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'item_one_part_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content One - Last Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'dishes', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'marque_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Marque Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'item_two_part_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Two - First Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'item_two_part_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Two - Last Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'marque_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Marque Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'item_three_part_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Three - First Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'trending', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'item_three_part_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Three - Last Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'marque_img_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Marque Image 3', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'item_four_part_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Four - First Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'item_four_part_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Four - Middle Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'populer', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'item_four_part_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Marque Content Four - Last Word', 'foodking-toolkit' ),
                    'default' => esc_html__( 'dishes', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'marque_img_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Marque Image 4', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();

        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Marque Section Start -->
    <div class="marque-section fix section-padding pt-0">
        <div class="marquee-wrapper mt-0 text-slider">
            <div class="marquee-inner to-left">
                <ul class="marqee-list d-flex">
                    <li class="marquee-item">
                        <span class="text-slider text-color"><?php echo esc_html($settings['item_one_part_1']);?></span><span class="text-slider"></span> <span class="text-slider text-color"><?php echo esc_html($settings['item_one_part_2']);?></span>
                        <span class="text-slider">
                            <?php if($settings['marque_img_1']['url']):?>
                                <img src="<?php echo esc_url($settings['marque_img_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?>
                        </span> <span class="text-slider"></span> <span class="text-slider text-color"><?php echo esc_html($settings['item_two_part_1']);?></span>
                        <span class="text-slider text-color"><?php echo esc_html($settings['item_two_part_2']);?></span> 
                            <?php if($settings['marque_img_2']['url']):?>
                                <img src="<?php echo esc_url($settings['marque_img_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?> 
                         <span class="text-slider"></span> <span class="text-slider text-color"><?php echo esc_html($settings['item_three_part_1']);?></span>
                        <span class="text-slider text-color"><?php echo esc_html($settings['item_three_part_2']);?></span> <span class="text-slider"></span><span class="text-slider">
                            <?php if($settings['marque_img_3']['url']):?>
                                <img src="<?php echo esc_url($settings['marque_img_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?>
                        </span> <span class="text-slider"></span> <span class="text-slider text-color"><?php echo esc_html($settings['item_four_part_1']);?></span>
                        <span class="text-slider text-color"><?php echo esc_html($settings['item_four_part_2']);?></span><span class="text-slider"></span> <span class="text-slider text-color"><?php echo esc_html($settings['item_four_part_3']);?></span>
                        <span class="text-slider">
                            <?php if($settings['marque_img_4']['url']):?>
                                <img src="<?php echo esc_url($settings['marque_img_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif; ?> 
                        </span> <span class="text-slider"></span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Marque_Two_Widget );