<?php

namespace Elementor;
class Foodking_KFC_Banner_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_grid_banner_two';
	}
    public function get_title() {
		return esc_html__( 'KFC Banner', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-column';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'grid_banner_two_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'right_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Right Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Left Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_content_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Left Content Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Left Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CRISPY, EVERY BITE TASTE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'kfc chiken hot', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'wing & french fries', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Wheat tortilla with spicy chicken bites, cheese sauce', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'tomatoes and soft cheese', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            
            
            $this->add_control(
                'countdown_num_for_days',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Number for Days', 'foodking-toolkit' ),
                    'default' => esc_html__( '30', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'countdown_day_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Title for Days', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Day', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            
            $this->add_control(
                'countdown_num_for_hours',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Number for Days', 'foodking-toolkit' ),
                    'default' => esc_html__( '22', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'countdown_hours_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Title for Hours', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Hours', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'countdown_num_for_min',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Number for Minutes', 'foodking-toolkit' ),
                    'default' => esc_html__( '48', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'countdown_min_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Title for Minutes', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Min', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'countdown_num_for_sec',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Number for Seconds', 'foodking-toolkit' ),
                    'default' => esc_html__( '22', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'countdown_sec_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Countdown Title for Seconds', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Sec', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'grid_banner_two_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .kfc-banner',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .kfc-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .kfc-content p',
                ]
            );
            $this->add_control(
                'countdown_color',
                [
                    'label' => esc_html__( 'Countdown Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .kfc-wrapper .kfc-content .countdown-items li span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Countdown Typography', 'foodking-toolkit' ),
                    'name' => 'countdown_typography',
                    'selector' => '{{WRAPPER}} .kfc-wrapper .kfc-content .countdown-items li span',
                ]
            );
            $this->add_control(
                'countdown_content_color',
                [
                    'label' => esc_html__( 'Countdown Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .kfc-wrapper .kfc-content .countdown-items li p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Countdown Content Typography', 'foodking-toolkit' ),
                    'name' => 'countdown_content_typography',
                    'selector' => '{{WRAPPER}} .kfc-wrapper .kfc-content .countdown-items li p',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>

    <!-- KFC Banner Section Start -->
    <?php if($settings['right_bg_image']['url']):?>
        <section class="kfc-banner fix bg-cover section-padding" style="background-image: url(<?php echo esc_url($settings['right_bg_image']['url']);?>);">
            <div class="kfc-wrapper">
                <div class="container-fluid">
                    <div class="row justify-content-between">
                        <div class="col-lg-5">
                            <div class="kfc-image-items bg-cover" style="background-image: url(<?php echo esc_url($settings['left_bg_image']['url']);?>);">
                                <div class="kfc-image">
                                    <?php if($settings['left_content_image']['url']):?>
                                        <img src="<?php echo esc_url($settings['left_content_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                </div>
                                <div class="offer-shape">
                                    <?php if($settings['left_shape_image']['url']):?>
                                        <img src="<?php echo esc_url($settings['left_shape_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="kfc-content text-center">
                                <div class="section-title">
                                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                                    <h2 class="wow fadeInUp" data-wow-delay=".3s">
                                    <?php echo esc_html($settings['title_1']);?> <br>
                                    <?php echo esc_html($settings['title_2']);?>
                                    </h2>
                                </div>
                                <p class="mt-3 mt-lg-0 wow fadeInUp" data-wow-delay=".5s">
                                <?php echo esc_html($settings['subtitle_1']);?> <br>
                                <?php echo esc_html($settings['subtitle_2']);?>
                                </p>
                                <ul class="countdown-items wow fadeInUp" data-wow-delay=".7s">
                                    <li>
                                        <span id="Seconds"><?php echo esc_html($settings['countdown_num_for_sec']);?></span>
                                        <p><?php echo esc_html($settings['countdown_sec_title']);?></p>
                                    </li>
                                    <li>
                                        <span id="Minutes"><?php echo esc_html($settings['countdown_num_for_min']);?></span>
                                        <p><?php echo esc_html($settings['countdown_min_title']);?></p>
                                    </li>
                                    <li>
                                        <span id="Hours"><?php echo esc_html($settings['countdown_num_for_hours']);?></span>
                                        <p class="cont"><?php echo esc_html($settings['countdown_hours_title']);?></p>
                                    </li>
                                    <li>
                                        <span id="day"><?php echo esc_html($settings['countdown_num_for_days']);?></span>
                                        <p><?php echo esc_html($settings['countdown_day_title']);?></p>
                                    </li>



                                </ul>
                                <?php if($settings['btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn mt-5 wow fadeInUp" data-wow-delay=".8s">
                                        <span class="button-content-wrapper d-flex align-items-center">
                                            <span class="button-icon">
                                                <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                                <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                                <?php else: ?>
                                                    <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php endif; ?>
                                            </span>
                                            <span class="button-text"><?php echo esc_html($settings['btn_text']);?></span>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_KFC_Banner_Widget );