<?php

namespace Elementor;
class Foodking_Hero_Three_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_hero_three';
	}
    public function get_title() {
		return esc_html__( 'Hero Three', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-device-desktop';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'hero_three_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'hero_three_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Background Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'hero_three_banner_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Banner Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'hero_bg_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Hero Shadow Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'super delicious pizza', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'top_subtitle', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Star Your Order Just Only $25.00', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                    'default' => esc_html__( '#', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $repeater->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $repeater->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            $repeater->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 4', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_5',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 5', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_6',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 6', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Hero Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'hero_three_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .hero-section-3',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-3 .hero-content h1' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .hero-3 .hero-content h1',
                ]
            );
            $this->add_control(
                'sub_title_color',
                [
                    'label' => esc_html__( 'Sub Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-3 .hero-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Sub Title Typography', 'foodking-toolkit' ),
                    'name' => 'sub_title_typography',
                    'selector' => '{{WRAPPER}} .hero-3 .hero-content h4',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_icon_color',
                [
                    'label' => esc_html__( 'Button Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn.bg-yellow',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    
    <!-- Hero Section Start -->
    <section class="hero-section-3">
        <div class="pegi-wrp">
            <div class="pegi-number">
            </div>
        </div>
        <div class="swiper hero-slider-2">
            <div class="swiper-wrapper">
                <?php foreach($settings['lists'] as $item):?>
                    <div class="swiper-slide">
                        <div class="hero-3 bg-cover" style="background-image: url(<?php echo esc_url($item['hero_three_bg_image']['url']);?>);">
                            <div class="frame-shape" data-animation="fadeInUp" data-delay="2s">
                                <?php if($item['shape_image_1']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="frame-shape-2" data-animation="fadeInUp" data-delay="2.2s">
                                <?php if($item['shape_image_2']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="frame-shape-3">
                                <?php if($item['shape_image_3']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="frame-shape-4" data-animation="fadeInUp" data-delay="2.6s">
                                <?php if($item['shape_image_4']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="frame-shape-5" data-animation="fadeInUp" data-delay="2.8s">
                                <?php if($item['shape_image_5']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_5']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="frame-shape-6" data-animation="fadeInUp" data-delay="2.9s">
                                <?php if($item['shape_image_6']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_6']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="container">
                                <div class="row align-items-center">
                                    <div class="col-xl-5 col-lg-5">
                                        <div class="hero-content">
                                            <h1  data-animation="fadeInUp" data-delay=".4s"><?php echo esc_html($item['hero_bg_title']);?></h1>
                                            <h4 data-animation="fadeInUp" data-delay=".8s"><?php echo esc_html($item['top_subtitle']);?></h4>
                                            <div class="hero-button">
                                                <?php if($item['btn_text']): ?>
                                                    <a href="<?php echo esc_html($item['btn_link']);?>" class="theme-btn bg-yellow border-radius-none" data-animation="fadeInUp" data-delay="1s">
                                                        <span class="button-content-wrapper d-flex align-items-center">
                                                            <span class="button-text"><?php echo esc_html($item['btn_text']);?></span>
                                                            <?php if($item['btn_icon_type'] == 'theme'): ?>
                                                            <i class="<?php echo esc_attr($item['btn_icon']); ?>"></i>
                                                            <?php else: ?>
                                                            <?php Icons_Manager::render_icon( $item['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                            <?php endif; ?>
                                                        </span>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-7 col-lg-7 mt-5 mt-lg-0">
                                        <div class="pizza-image" data-animation="fadeInUp" data-delay="1.4s">
                                            <?php if($item['hero_three_banner_image']['url']):?>
                                                <img src="<?php echo esc_url($item['hero_three_banner_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Hero_Three_Widget );