<?php

namespace Elementor;
class Foodking_Hero_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_hero_one';
	}
    public function get_title() {
		return esc_html__( 'Hero One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-device-desktop';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'hero_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'hero_one_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Banner Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'hero_one_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Right Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'hero_bg_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Hero Shadow Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'fast food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'top_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'delicious <span>fried</span> chicken', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Order Now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $repeater->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $repeater->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            $repeater->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 4', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_5',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 5', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Slider', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'hero_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .hero-section',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-1 .hero-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .hero-1 .hero-content p',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-1 .hero-content h1' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .hero-1 .hero-content h1',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        <!-- Hero Section Start -->
        <section class="hero-section">
            <div class="swiper hero-slider">
                <div class="swiper-wrapper">
                    <?php foreach($settings['lists'] as $item):
                        $target = $item['btn_link']['is_external'] ? ' target="_blank"' : '';
			            $nofollow = $item['btn_link']['nofollow'] ? ' rel="nofollow"' : '';	
                        
                        ?>
                        <div class="swiper-slide">
                            <div class="hero-1 bg-cover" style="background-image: url(<?php echo esc_url($item['hero_one_image_2']['url']);?>);">
                                <div class="chilii-shape" data-animation="fadeInUp" data-delay="2.1s">
                                    <?php if($item['shape_image_1']['url']):?>
                                        <img src="<?php echo esc_url($item['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <div class="fire-shape" data-animation="fadeInUp" data-delay="2.4s">
                                    <?php if($item['shape_image_2']['url']):?>
                                        <img src="<?php echo esc_url($item['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <div class="chilii-shape-2" data-animation="fadeInUp" data-delay="2.7s">
                                    <?php if($item['shape_image_3']['url']):?>
                                        <img src="<?php echo esc_url($item['shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <div class="chilii-shape-3" data-animation="fadeInUp" data-delay="3s">
                                    <?php if($item['shape_image_4']['url']):?>
                                        <img src="<?php echo esc_url($item['shape_image_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <div class="offer-shape"  data-animation="fadeInUp" data-delay="2.1s">
                                    <?php if($item['shape_image_5']['url']):?>
                                        <img src="<?php echo esc_url($item['shape_image_5']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <h2 class="hero-back-title"  data-animation="fadeInRight" data-delay="2.5s"><?php echo esc_html($item['hero_bg_title']);?></h2>
                                <div class="container">
                                    <div class="row justify-content-between">
                                        <div class="col-xl-5 col-lg-7">
                                            <div class="hero-content">
                                                <p data-animation="fadeInUp"><?php echo esc_html($item['top_title']);?></p>
                                                <h1  data-animation="fadeInUp" data-delay="0.5s">
                                                    <?php echo wp_kses_post($item['title']);?>
                                                </h1>
                                                <div class="hero-button">
                                                    <?php if($item['btn_text']): ?>
                                                        <a href="<?php echo esc_url($item['btn_link']['url']); ?>" <?php echo esc_attr($target.$nofollow); ?> class="theme-btn" data-animation="fadeInUp" data-delay="0.9s">
                                                            <span class="button-content-wrapper d-flex align-items-center">
                                                            <span class="button-icon">
                                                                <?php if($item['btn_icon_type'] == 'theme'): ?>
                                                                <i class="<?php echo esc_attr($item['btn_icon']); ?>"></i>
                                                                <?php else: ?>
                                                                    <?php Icons_Manager::render_icon( $item['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                <?php endif; ?>
                                                            </span>
                                                            <span class="button-text"><?php echo esc_html($item['btn_text']);?></span>
                                                            </span>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-5 mt-5 mt-lg-0">
                                            <div class="chiken-image" data-animation="fadeInUp" data-delay="1.4s">
                                                <?php if($item['hero_one_image_1']['url']):?>
                                                    <img src="<?php echo esc_url($item['hero_one_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="swiper-dot text-center pt-5">
                <div class="dot"></div>
            </div>
        </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Hero_One_Widget );