<?php

namespace Elementor;
class Foodking_Grilled_Banner_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_single_banner_one';
	}
    public function get_title() {
		return esc_html__( 'Grilled Banner', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-featured-image';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'banner_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'banner_one_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_right_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 4', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_5',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 5', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'save 20%', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'tODAYS', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'ASTACKIN', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'DAY', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'grilled', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'chiken', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle 3', 'foodking-toolkit' ),
                    'default' => esc_html__( '$59,00', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .grilled-banner',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h4',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_middle_color',
                [
                    'label' => esc_html__( 'Title Middle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h2 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h2',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'subtitle_middle_color',
                [
                    'label' => esc_html__( 'Subtitle Middle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a .text-1' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'subtitle_last_color',
                [
                    'label' => esc_html__( 'Subtitle Last Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 .text-2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
        
    <!-- Grilled Banner Section Start -->
    <?php if($settings['banner_one_bg_image']['url']):?>
        <section class="grilled-banner fix section-padding bg-cover" style="background-image: url(<?php echo esc_url($settings['banner_one_bg_image']['url']);?>);">
            <div class="patato-shape">
                <?php if($settings['banner_shape_image_1']['url']):?>
                    <img src="<?php echo esc_url($settings['banner_shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="offer-shape float-bob-y">
                <?php if($settings['banner_shape_image_2']['url']):?>
                    <img src="<?php echo esc_url($settings['banner_shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="text-shape">
                <?php if($settings['banner_shape_image_3']['url']):?>
                    <img src="<?php echo esc_url($settings['banner_shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="spicy-shape">
                <?php if($settings['banner_shape_image_4']['url']):?>
                    <img src="<?php echo esc_url($settings['banner_shape_image_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="tomato-shape">
                <?php if($settings['banner_shape_image_5']['url']):?>
                    <img src="<?php echo esc_url($settings['banner_shape_image_5']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="container">
                <div class="grilled-wrapper">
                    <div class="row align-items-center">
                        <div class="col-xl-6 col-lg-6">
                            <div class="grilled-content">
                                <h4 class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></h4>
                                <h2 class="wow fadeInUp" data-wow-delay=".3s">
                                <?php echo esc_html($settings['title_1']);?> <span><?php echo esc_html($settings['title_2']);?></span> <?php echo esc_html($settings['title_3']);?>
                                </h2>
                                <h3 class="wow fadeInUp" data-wow-delay=".5s">
                                    <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                        <?php echo esc_html($settings['subtitle_1']);?> <span class="text-1"><?php echo esc_html($settings['subtitle_2']);?></span>
                                    </a>
                                    <span class="text-2"><?php echo esc_html($settings['subtitle_3']);?></span>
                                </h3>
                                <div class="grilled-button wow fadeInUp" data-wow-delay=".7s">
                                    <?php if($settings['btn_text']): ?>
                                        <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn">
                                            <span class="button-content-wrapper d-flex align-items-center">
                                                <span class="button-icon">
                                                    <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                                    <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                                    <?php else: ?>
                                                        <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    <?php endif; ?>
                                                </span>
                                                <span class="button-text"><?php echo esc_html($settings['btn_text']);?></span>
                                            </span>
                                        </a>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 mt-5 mt-lg-0 wow fadeInUp" data-wow-delay=".4s">
                            <div class="grilled-image">
                                <?php if($settings['banner_right_image']['url']):?>
                                    <img src="<?php echo esc_url($settings['banner_right_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Grilled_Banner_Widget );