<?php

namespace Elementor;
class Foodking_Gallery_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_gallery';
	}
    public function get_title() {
		return esc_html__( 'Gallery', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-photo-library';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'gallery_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'gallery_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Slider Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'gallery_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!--<< Gallery Section Start >>-->
    <div class="gallery-section fix section-bg section-padding">
        <div class="container">
            <div class="row g-4">
            <?php
                $i = 1;
                foreach ($settings['lists'] as $item):?>
                    <?php if($i == 1): ?>
                    <div class="col-lg-8">
                    <?php elseif($i == 2): ?>
                    <div class="col-lg-4">
                    <?php elseif($i == 3): ?>
                    <div class="col-lg-9">
                    <?php elseif($i == 4): ?>
                    <div class="col-lg-3">
                    <?php else: ?>
                    <div class="col-xl-6">
                        <?php endif; ?>
                        <?php if ($item['gallery_image']['url']): ?>
                            <div class="galler-image-2 bg-cover" style="background-image: url(<?php echo esc_url($item['gallery_image']['url']); ?>);">
                                <?php 
                                    // Get the URL of the image being displayed
                                    $image_url = $item['gallery_image']['url'];
                                    
                                    // Output the anchor tag with a dynamic href attribute
                                    echo '<a href="' . esc_url($image_url) . '" class="icon img-popup"><i class="fal fa-plus"></i></a>';
                                ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php $i++;
                endforeach; ?>
            </div>
        </div>
    </div>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Gallery_Widget );