<?php

namespace Elementor;
class Foodking_Food_Menu_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_menu';
	}
    public function get_title() {
		return esc_html__( 'Food Menu', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-bullet-list';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_menu_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'about our food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'trending food menu', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'card_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Menu Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Chicago Deep Pizza.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'card_content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Menu Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Its the perfect dining experience where Experience quick and efficient', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'card_price', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Menu Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$5.00', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Link', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_menu_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
            $this->add_control(
                'c1',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'c1_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'c2',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'c2_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'c3',
                [
                    'label' => esc_html__( 'Card Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .fooder-menu-wrapper .food-menu-items .food-menu-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card Title Typography', 'foodking-toolkit' ),
                    'name' => 'c3_typography',
                    'selector' => '{{WRAPPER}} .fooder-menu-wrapper .food-menu-items .food-menu-content h4',
                ]
            );
            $this->add_control(
                'c4',
                [
                    'label' => esc_html__( 'Card Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-menu-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card Content Typography', 'foodking-toolkit' ),
                    'name' => 'c4_typography',
                    'selector' => '{{WRAPPER}} .food-menu-content p',
                ]
            );
            $this->add_control(
                'c5',
                [
                    'label' => esc_html__( 'Card Price Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .fooder-menu-wrapper .food-menu-items .price' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card Price Typography', 'foodking-toolkit' ),
                    'name' => 'c5_typography',
                    'selector' => '{{WRAPPER}} .fooder-menu-wrapper .food-menu-items .price',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    <!-- Food Menu Section Start -->
    <section class="fooder-menu-section fix section-padding pb-0">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['title']);?></h2>
            </div>
            <div class="fooder-menu-wrapper">
                <div class="row">
                    <?php foreach($settings['lists'] as $item):?>
                        <?php if($item['card_title']):?>
                            <div class="col-xl-6 col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                                <div class="food-menu-items d-flex align-items-center justify-content-between">
                                    <div class="food-menu-content">
                                        <h4><?php echo esc_html($item['card_title']);?></h4>
                                        <p>
                                            <?php echo wp_kses_post($item['card_content']);?>
                                        </p>
                                    </div>
                                    <h4 class="price"><?php echo esc_html($item['card_price']);?></h4>
                                    <a href="<?php echo esc_url($item['link']); ?>"></a>
                                </div>
                            </div>
                        <?php endif;?>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Menu_Widget );