<?php

namespace Elementor;
class Foodking_Food_Banner_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_banner_two';
	}
    public function get_title() {
		return esc_html__( 'Food Banner Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-justified';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_banner_two_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'card_bg_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_product_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'bold_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'today', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'special', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_white_part',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title White Part', 'foodking-toolkit' ),
                    'default' => esc_html__( 'beef', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_color_part',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title Color Part', 'foodking-toolkit' ),
                    'default' => esc_html__( 'burger', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_1_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_1_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            
            $this->add_control(
                'card_2_bg_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_product_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CRISPY, EVERY BITE TASTE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'FASH FOOD', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'MEAL', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'The mouth-watering aroma of', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Content 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'sizzling burgers', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_2_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_2_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_two_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'card1_title_color',
                [
                    'label' => esc_html__( 'Card 1 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .burger-banner-items .burger-content h2, .burger-banner-items .burger-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Title Typography', 'foodking-toolkit' ),
                    'name' => 'card1_title_typography',
                    'selector' => '{{WRAPPER}} .burger-banner-items .burger-content h2, .burger-banner-items .burger-content h3',
                ]
            );
            $this->add_control(
                'card1_subtitle_color',
                [
                    'label' => esc_html__( 'Card 1 Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .burger-banner-items .burger-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'card1_subtitle_typography',
                    'selector' => '{{WRAPPER}} .burger-banner-items .burger-content h4',
                ]
            );
            $this->add_control(
                'card1_subtitle_span_color',
                [
                    'label' => esc_html__( 'Card 1 Subtitle Span Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .burger-banner-items .burger-content h4 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Subtitle Span Typography', 'foodking-toolkit' ),
                    'name' => 'card1_subtitle_span_typography',
                    'selector' => '{{WRAPPER}} .burger-banner-items .burger-content h4 span',
                ]
            );
            $this->add_control(
                'card2_top_title_color',
                [
                    'label' => esc_html__( 'Card 2 Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items .offer-content h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'card2_top_title_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items .offer-content h5',
                ]
            );
            $this->add_control(
                'card2_title_color',
                [
                    'label' => esc_html__( 'Card 2 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items .offer-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Title Typography', 'foodking-toolkit' ),
                    'name' => 'card2_title_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items .offer-content h3',
                ]
            );
            $this->add_control(
                'card2_content_color',
                [
                    'label' => esc_html__( 'Card 2 Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-2 .offer-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Content Typography', 'foodking-toolkit' ),
                    'name' => 'card2_content_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-2 .offer-content p',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL 1
        if ( ! empty( $settings['food_banner_1_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'food_banner_1_btn_link', $settings['food_banner_1_btn_link'] );
        }
        // Button URL 2
        if ( ! empty( $settings['food_banner_2_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'food_banner_2_btn_link', $settings['food_banner_2_btn_link'] );
        }
        ?>
    <!-- Food Banner Section Start -->
    <section class="food-banner-section fix section-padding section-bg pt-0">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-9 wow fadeInUp" data-wow-delay=".3s">
                    <?php if ($settings['card_bg_image_1']['url']): ?>
                        <div class="burger-banner-items bg-cover" style="background-image: url(<?php echo esc_url($settings['card_bg_image_1']['url']); ?>);">
                            <div class="burger-content text-center">
                                <h3><?php echo esc_html($settings['bold_title_1']); ?></h3>
                                <h2><?php echo esc_html($settings['bold_title_2']); ?></h2>
                                <h4><a <?php echo $this->get_render_attribute_string('food_banner_1_btn_link'); ?> class="text-white"><?php echo esc_html($settings['title_white_part']); ?> <span><?php echo esc_html($settings['title_color_part']); ?></span></a></h4>
                                <?php if($settings['food_banner_1_btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('food_banner_1_btn_link'); ?> class="theme-btn mt-4">
                                        <span class="button-content-wrapper d-flex align-items-center">
                                            <span class="button-icon">
                                                <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                                <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                                <?php else: ?>
                                                    <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php endif; ?>
                                            </span>
                                            <span class="button-text"><?php echo esc_html($settings['food_banner_1_btn_text']);?></span>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="burger-image">
                                <?php if ($settings['card_product_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_product_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="text-shape">
                                <?php if ($settings['card_1_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="burger-text">
                                <?php if ($settings['card_1_shape_img_2']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_2']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="col-xl-5 col-lg-9 mt-5 mt-xl-0 wow fadeInUp" data-wow-delay=".5s">
                    <?php if ($settings['card_2_bg_image_2']['url']): ?>
                        <div class="single-offer-items style-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_2_bg_image_2']['url']); ?>);">
                            <div class="offer-content">
                                <h5><?php echo esc_html($settings['top_title']); ?></h5>
                                <h3>
                                <?php echo esc_html($settings['title_1']); ?> <br>
                                <?php echo esc_html($settings['title_2']); ?>
                                </h3>
                                <p>
                                <?php echo esc_html($settings['content_1']); ?> <br>
                                <?php echo esc_html($settings['content_2']); ?>
                                </p>
                                <?php if($settings['food_banner_2_btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('food_banner_2_btn_link'); ?> class="theme-btn mt-4">
                                        <span class="button-content-wrapper d-flex align-items-center">
                                            <span class="button-icon">
                                                <?php if($settings['btn_icon_type_'] == 'theme'): ?>
                                                <i class="<?php echo esc_attr($settings['btn_icon_']); ?>"></i>
                                                <?php else: ?>
                                                    <?php Icons_Manager::render_icon( $settings['btn_icon_el_'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php endif; ?>
                                            </span>
                                            <span class="button-text"><?php echo esc_html($settings['food_banner_2_btn_text']);?></span>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="offer-img">
                                <?php if ($settings['card_2_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_2_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="roller-box">
                                <?php if ($settings['card_2_product_img_2']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_2_product_img_2']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Banner_Two_Widget );