<?php

namespace Elementor;
class Foodking_Food_Banner_Three_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_banner_three';
	}
    public function get_title() {
		return esc_html__( 'Food Banner Three', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-justified';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_banner_three_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Body Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_bg_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title1_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Delicious &', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title2_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'hot pizza', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_1_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_1_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            
            $this->add_control(
                'card_bg_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Top Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Todays', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'top_title__2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Top Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title1_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Bold Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'french fry', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title2_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'This Weekend only', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_2_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_2_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_2',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_2',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_2' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_2',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_2' => 'theme',
                    ]
                ]
            );

            $this->add_control(
                'card_bg_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_shape_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title1_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'chiken &', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title2_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'french fry', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_3_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'food_banner_3_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_3',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_3',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_3' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_3',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_3' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_three_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .food-banner-section',
                ]
            );
            $this->add_control(
                'card1',
                [
                    'label' => esc_html__( 'Card 1 Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items .offer-content h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'card1_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items .offer-content h5',
                ]
            );
            $this->add_control(
                'card2',
                [
                    'label' => esc_html__( 'Card 1 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-3 .offer-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Title Typography', 'foodking-toolkit' ),
                    'name' => 'card2_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-3 .offer-content h3',
                ]
            );
            $this->add_control(
                'card3',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card4',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card5',
                [
                    'label' => esc_html__( 'Card 2 Top Title Small Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-3 .french-content h4 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Top Title Small Typography', 'foodking-toolkit' ),
                    'name' => 'card6_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-3 .french-content h4 span',
                ]
            );
            $this->add_control(
                'card7',
                [
                    'label' => esc_html__( 'Card 2 Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-3 .french-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'card8_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-3 .french-content h4',
                ]
            );
            $this->add_control(
                'card9',
                [
                    'label' => esc_html__( 'Card 2 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-3 .french-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Title Typography_', 'foodking-toolkit' ),
                    'name' => 'card9_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-3 .french-content h3',
                ]
            );
            $this->add_control(
                'card10',
                [
                    'label' => esc_html__( 'Card 2 Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-3 .french-content h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Content Typography', 'foodking-toolkit' ),
                    'name' => 'card10_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-3 .french-content h5',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL 1
        if ( ! empty( $settings['food_banner_1_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'food_banner_1_btn_link', $settings['food_banner_1_btn_link'] );
        }
        // Button URL 2
        if ( ! empty( $settings['food_banner_2_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'food_banner_2_btn_link', $settings['food_banner_2_btn_link'] );
        }
        // Button URL 3
        if ( ! empty( $settings['food_banner_3_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'food_banner_3_btn_link', $settings['food_banner_3_btn_link'] );
        }
        ?>
    <!-- Food Banner Section Start -->
    <section class="food-banner-section section-padding fix">
        <div class="burger-shape-2">
            <?php if ($settings['section_shape_image']['url']): ?>
                <img src="<?php echo esc_url($settings['section_shape_image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
            <?php endif; ?>
        </div>
        <div class="container">
            <div class="row g-4">
                <div class="col-xl-4 col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                    <?php if ($settings['card_bg_image_1']['url']): ?>
                        <div class="single-offer-items bg-cover style-3" style="background-image: url(<?php echo esc_url($settings['card_bg_image_1']['url']); ?>);">
                            <div class="offer-content">
                                <h5><?php echo esc_html($settings['top_title_1']); ?></h5>
                                <h3>
                                <?php echo esc_html($settings['bold_title1_1']); ?> <br>
                                <?php echo esc_html($settings['bold_title2_1']); ?>
                                </h3>
                                <?php if($settings['food_banner_1_btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('food_banner_1_btn_link'); ?> class="link-btn">
                                    <?php echo esc_html($settings['food_banner_1_btn_text']); ?> 
                                        <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                        <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                        <?php else: ?>
                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php endif; ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="offer-image-2">
                                <?php if ($settings['card_1_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="small-pizza">
                                <?php if ($settings['card_1_shape_img_2']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_2']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-4 col-lg-6 wow fadeInUp" data-wow-delay=".5s">
                    <?php if ($settings['card_bg_image_2']['url']): ?>
                        <div class="single-offer-items bg-cover style-3" style="background-image: url(<?php echo esc_url($settings['card_bg_image_2']['url']); ?>);">
                            <div class="french-content">
                                <h4>
                                    <span><?php echo esc_html($settings['top_title_2']); ?></span><?php echo esc_html($settings['top_title__2']); ?>
                                </h4>
                                <h3><?php echo esc_html($settings['bold_title1_2']); ?></h3>
                                <h5><?php echo esc_html($settings['bold_title2_2']); ?></h5>
                                <?php if($settings['food_banner_2_btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('food_banner_2_btn_link'); ?> class="theme-btn bg-yellow">
                                        <span class="button-content-wrapper d-flex align-items-center">
                                            <span class="button-icon">
                                                <?php if($settings['btn_icon_type_2'] == 'theme'): ?>
                                                <i class="<?php echo esc_attr($settings['btn_icon_2']); ?>"></i>
                                                <?php else: ?>
                                                <?php Icons_Manager::render_icon( $settings['btn_icon_el_2'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php endif; ?>
                                            </span>
                                            <span class="button-text"><?php echo esc_html($settings['food_banner_2_btn_text']);?></span>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="french-image">
                                <?php if ($settings['card_2_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_2_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-4 col-lg-6 wow fadeInUp" data-wow-delay=".7s">
                    <?php if ($settings['card_bg_image_3']['url']): ?>
                        <div class="single-offer-items bg-cover style-3" style="background-image: url(<?php echo esc_url($settings['card_bg_image_3']['url']); ?>);">
                            <div class="offer-content">
                                <h5><?php echo esc_html($settings['top_title_3']); ?></h5>
                                <h3>
                                <?php echo esc_html($settings['bold_title1_3']); ?> <br>
                                <?php echo esc_html($settings['bold_title2_3']); ?>
                                </h3>
                                <?php if($settings['food_banner_3_btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('food_banner_3_btn_link'); ?> class="link-btn">
                                    <?php echo esc_html($settings['food_banner_3_btn_text']); ?> 
                                        <?php if($settings['btn_icon_type_3'] == 'theme'): ?>
                                        <i class="<?php echo esc_attr($settings['btn_icon_3']); ?>"></i>
                                        <?php else: ?>
                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el_3'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php endif; ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="offer-shape-3">
                                <?php if ($settings['card_3_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_3_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="main-food-3">
                                <?php if ($settings['card_3_shape_img_2']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_3_shape_img_2']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Banner_Three_Widget );