<?php

namespace Elementor;
class Foodking_Food_Banner_Four_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_banner_four';
	}
    public function get_title() {
		return esc_html__( 'Food Banner Four', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-justified';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_banner_four_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'card_1_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_product_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Food Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_shape_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'bold_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'today', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'special delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'beef', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bold_title_4',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Title 4', 'foodking-toolkit' ),
                    'default' => esc_html__( 'chiness pizza', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'card_2_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_product_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Food Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'burger combo', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_subtitle',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Subtitle', 'foodking-toolkit' ),
                    'default' => esc_html__( 'This Weekend only', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_content_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'limited offer  /', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_price_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$5', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );

            $this->add_control(
                'card_3_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_shape_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_product_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Food Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'SUPER', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'DELICIOUS', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'card_4_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-4 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_4_product_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-4 Food Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_4_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-4 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-4 Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'FASH FOOD', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-4 Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'MEAL', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_content_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-4 Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'The mouth-watering aroma of', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_content_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-4 Content 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'sizzling burgers', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_4_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_' => 'theme',
                    ]
                ]
            );

            $this->add_control(
                'card_5_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-5 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_5_shape_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-5 Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_5_product_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-5 Food Image', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_four_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .food-banner-section',
                ]
            );
            $this->add_control(
                'c1',
                [
                    'label' => esc_html__( 'Card 1 Title 1 Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Title 1 Typography', 'foodking-toolkit' ),
                    'name' => 'c1_typography',
                    'selector' => '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h3',
                ]
            );
            $this->add_control(
                'c2',
                [
                    'label' => esc_html__( 'Card 1 Title 2 Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Title 2 Typography', 'foodking-toolkit' ),
                    'name' => 'c2_typography',
                    'selector' => '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h2',
                ]
            );
            $this->add_control(
                'c3',
                [
                    'label' => esc_html__( 'Card 1 Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'c4',
                [
                    'label' => esc_html__( 'Card 1 Subtitle Bold Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h4 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'c3_typography',
                    'selector' => '{{WRAPPER}} .main-food-wrapper .pizza-banner-items-2 .pizza-content h4',
                ]
            );
            $this->add_control(
                'c5',
                [
                    'label' => esc_html__( 'Card 2 Bold Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Bold Title Typography', 'foodking-toolkit' ),
                    'name' => 'c5_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h4',
                ]
            );
            $this->add_control(
                'c6',
                [
                    'label' => esc_html__( 'Card 2 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Title Typography', 'foodking-toolkit' ),
                    'name' => 'c6_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h3',
                ]
            );
            $this->add_control(
                'c7',
                [
                    'label' => esc_html__( 'Card 2 Sub Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .text-white' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Sub Title Typography', 'foodking-toolkit' ),
                    'name' => 'c7_typography',
                    'selector' => '{{WRAPPER}} .text-white',
                ]
            );
            $this->add_control(
                'c8',
                [
                    'label' => esc_html__( 'Card 2 Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Content Typography', 'foodking-toolkit' ),
                    'name' => 'c8_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .burger-comboo-content h2',
                ]
            );
            $this->add_control(
                'c9',
                [
                    'label' => esc_html__( 'Card 3 Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 3 Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'c9_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h5',
                ]
            );
            $this->add_control(
                'c10',
                [
                    'label' => esc_html__( 'Card 3 Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 3 Title Typography', 'foodking-toolkit' ),
                    'name' => 'c10_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h3',
                ]
            );
            $this->add_control(
                'c11',
                [
                    'label' => esc_html__( 'Card 4 Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 4 Content Typography', 'foodking-toolkit' ),
                    'name' => 'c11_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items.style-4 .chicken-content h6',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_icon_color',
                [
                    'label' => esc_html__( 'Button Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn.bg-yellow',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL 1
        if ( ! empty( $settings['card_2_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'card_2_btn_link', $settings['card_2_btn_link'] );
        }
        // Button URL 2
        if ( ! empty( $settings['card_4_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'card_4_btn_link', $settings['card_4_btn_link'] );
        }
        ?>
    <!-- Food Banner Section Start -->
    <section class="food-banner-section">
        <div class="main-food-wrapper">
            <div class="row g-0">
                <div class="col-xl-5">
                    <?php if ($settings['card_1_bg_image']['url']): ?>
                        <div class="pizza-banner-items-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_1_bg_image']['url']); ?>);">
                            <div class="tomato-left-shape float-bob-y">
                                <?php if ($settings['card_1_shape_img_1']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_1']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="pizza-content text-center">
                                <h3><?php echo esc_html($settings['bold_title_1']); ?></h3>
                                <h2><?php echo esc_html($settings['bold_title_2']); ?></h2>
                                <h4><?php echo esc_html($settings['bold_title_3']); ?><span class="theme-color-3"><?php echo esc_html($settings['bold_title_4']); ?></span></h4>
                            </div>
                            <div class="offer-shape">
                                <?php if ($settings['card_1_shape_img_2']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_shape_img_2']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="pizza-image">
                                <?php if ($settings['card_1_product_img']['url']): ?>
                                    <img src="<?php echo esc_url($settings['card_1_product_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-xl-7">
                    <div class="row g-0">
                        <?php if ($settings['card_2_bg_image']['url']): ?>
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="single-offer-items style-4 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_2_bg_image']['url']); ?>);">
                                    <div class="burger-comboo-content">
                                        <h4><?php echo esc_html($settings['card_2_top_title']); ?></h4>
                                        <h3><?php echo esc_html($settings['card_2_title_1']); ?></h3>
                                        <h5 class="text-white"><?php echo esc_html($settings['card_2_subtitle']); ?></h5>
                                        <h2><span><?php echo esc_html($settings['card_2_content_1']); ?></span> <?php echo esc_html($settings['card_2_price_2']); ?></h2>
                                        <?php if($settings['card_2_btn_text']): ?>
                                            <a <?php echo $this->get_render_attribute_string('card_2_btn_link'); ?> class="theme-btn bg-yellow mt-4">
                                                <span class="button-content-wrapper d-flex align-items-center">
                                                    <span class="button-icon">
                                                        <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                                            <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                                        <?php else: ?>
                                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        <?php endif; ?>
                                                    </span>
                                                    <span class="button-text"><?php echo esc_html($settings['card_2_btn_text']);?></span>
                                                </span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="main-food">
                                        <?php if ($settings['card_2_product_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_2_product_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($settings['card_3_bg_image']['url']): ?>
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="single-offer-items style-4 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_3_bg_image']['url']); ?>);">
                                    <div class="chicken-content">
                                        <h5><?php echo esc_html($settings['card_3_top_title']); ?></h5>
                                        <h3>
                                        <?php echo esc_html($settings['card_3_title_1']); ?> <br>
                                        <?php echo esc_html($settings['card_3_title_2']); ?> 
                                        </h3>
                                    </div>
                                    <div class="offer-image">
                                        <?php if ($settings['card_3_shape_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_3_shape_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="main-food">
                                        <?php if ($settings['card_3_product_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_3_product_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($settings['card_4_bg_image']['url']): ?>
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="single-offer-items bg-cover style-4" style="background-image: url(<?php echo esc_url($settings['card_4_bg_image']['url']); ?>);">
                                    <div class="chicken-content">
                                        <h5 class="text-white">
                                            <?php echo esc_html($settings['card_4_top_title']); ?>
                                        </h5>
                                        <h3>
                                            <?php echo esc_html($settings['card_4_title_1']); ?> <br>
                                            <?php echo esc_html($settings['card_4_title_2']); ?>
                                        </h3>
                                        <h6>
                                            <?php echo esc_html($settings['card_4_content_1']); ?> <br>
                                            <?php echo esc_html($settings['card_4_content_2']); ?>
                                        </h6>
                                        <?php if($settings['card_4_btn_text']): ?>
                                            <a <?php echo $this->get_render_attribute_string('card_4_btn_link'); ?> class="theme-btn bg-yellow mt-5">
                                                <span class="button-content-wrapper d-flex align-items-center">
                                                    <span class="button-icon">
                                                        <?php if($settings['btn_icon_type_'] == 'theme'): ?>
                                                            <i class="<?php echo esc_attr($settings['btn_icon_']); ?>"></i>
                                                        <?php else: ?>
                                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el_'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        <?php endif; ?>
                                                    </span>
                                                    <span class="button-text"><?php echo esc_html($settings['card_4_btn_text']);?></span>
                                                </span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="french-image">
                                        <?php if ($settings['card_4_product_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_4_product_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($settings['card_5_bg_image']['url']): ?>
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="single-offer-items bg-cover style-4" style="background-image: url(<?php echo esc_url($settings['card_5_bg_image']['url']); ?>);">
                                    <div class="chicken-text">
                                        <?php if ($settings['card_5_shape_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_5_shape_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="chicken-french-image">
                                        <?php if ($settings['card_5_product_img']['url']): ?>
                                            <img src="<?php echo esc_url($settings['card_5_product_img']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Banner_Four_Widget );