<?php

namespace Elementor;
class Foodking_Contact_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_contact';
	}
    public function get_title() {
		return esc_html__( 'Contact', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-notes';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
        
        // Enqueue Google Maps API script
        add_action('elementor/frontend/after_enqueue_scripts', [$this, 'enqueue_google_maps_api']);
    }

    // Enqueue Google Maps API script
    public function enqueue_google_maps_api() {
        wp_enqueue_script('google-maps-api', 'https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY', [], null, true);
    }
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'contact_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'contact_left_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Left Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Get in touch', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'contact_left_content_1',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Contact Left Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit mattis', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'contact_left_content_2',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Contact Left Content 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'faucibus odio feugiat arc dolor.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'google_map_link',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Google Map iframe Link [Visit this link: https://maps-generator.com/  to make your own address]', 'foodking-toolkit' ),
                    'default' => esc_html__( 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d6678.7619084840835!2d144.9618311901502!3d-37.81450084255415!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6ad642b4758afc1d%3A0x3119cc820fdfc62e!2sEnvato!5e0!3m2!1sen!2sbd!4v1641984054261!5m2!1sen!2sbd', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'shortcode',
                [
                    'label' => esc_html__( 'Contact Form 7 PLugin Short code', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'contact_right_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Right Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Fill Up The Form', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'contact_right_content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Contact Left Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Your email address will not be published. Required fields are marked *', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'contact_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'left_title_color',
                [
                    'label' => esc_html__( 'Left Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-area .map-content-area h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Left Title Typography', 'foodking-toolkit' ),
                    'name' => 'left_title_typography',
                    'selector' => '{{WRAPPER}} .contact-area .map-content-area h3',
                ]
            );
            $this->add_control(
                'left_content_color',
                [
                    'label' => esc_html__( 'Left Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .map-content-area p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Left Content Typography', 'foodking-toolkit' ),
                    'name' => 'left_content_typography',
                    'selector' => '{{WRAPPER}} .map-content-area p',
                ]
            );
            $this->add_control(
                'right_title_color',
                [
                    'label' => esc_html__( 'Right Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-area .contact-form-items .contact-title h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Right Title Typography', 'foodking-toolkit' ),
                    'name' => 'right_title_typography',
                    'selector' => '{{WRAPPER}} .contact-area .contact-form-items .contact-title h3',
                ]
            );
            $this->add_control(
                'right_content_color',
                [
                    'label' => esc_html__( 'Right Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-title p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Right Content Typography', 'foodking-toolkit' ),
                    'name' => 'right_content_typography',
                    'selector' => '{{WRAPPER}} .contact-title p',
                ]
            );
            $this->add_control(
                'input_color',
                [
                    'label' => esc_html__( 'Input Field Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-area .contact-form-items .form-clt input' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Input Field Typography', 'foodking-toolkit' ),
                    'name' => 'input_typography',
                    'selector' => '{{WRAPPER}} .contact-area .contact-form-items .form-clt input',
                ]
            );
            $this->add_control(
                'input_icon_color',
                [
                    'label' => esc_html__( 'Input Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-area .contact-form-items .form-clt .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Input Icon Typography', 'foodking-toolkit' ),
                    'name' => 'input_icon_typography',
                    'selector' => '{{WRAPPER}} .contact-area .contact-form-items .form-clt .icon i',
                ]
            );
            $this->add_control(
                'textarea_color',
                [
                    'label' => esc_html__( 'Textarea Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-area .contact-form-items .form-clt-big textarea' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Textarea Typography', 'foodking-toolkit' ),
                    'name' => 'textarea_typography',
                    'selector' => '{{WRAPPER}} .contact-area .contact-form-items .form-clt-big textarea',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_color',
                [
                    'label' => esc_html__( 'Button Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} span.button-icon' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_warning_color',
                [
                    'label' => esc_html__( 'Button Warning Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7 form .wpcf7-response-output' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Text Typography', 'foodking-toolkit' ),
                    'name' => 'tbtn_typography',
                    'selector' => '{{WRAPPER}} input.wpcf7-form-control.wpcf7-submit.has-spinner.theme-btn',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!--<< Contact Section Start >>-->
    <section class="contact-section section-padding pt-0 section-bg">
        <div class="container">
            <div class="contact-area">
                <div class="row justify-content-between">
                    <div class="col-xl-6 col-lg-6">
                        <div class="map-content-area">
                            <h3 class="wow fadeInUp" data-wow-delay=".3s"> <?php echo esc_html($settings['contact_left_title']);?></h3>
                            <p class="wow fadeInUp" data-wow-delay=".5s">
                            <?php echo wp_kses_post($settings['contact_left_content_1']);?> <br>
                            <?php echo wp_kses_post($settings['contact_left_content_2']);?>
                            </p>
                            <div class="google-map wow fadeInUp" data-wow-delay=".7s">
                                <iframe src="<?php echo wp_kses_post($settings['google_map_link']);?>" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-5 mt-5 mt-lg-0">
                        <div class="contact-form-items">
                            <div class="contact-title">
                                <h3 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['contact_right_title']);?></h3>
                                <p class="wow fadeInUp" data-wow-delay=".5s"><?php echo wp_kses_post($settings['contact_right_content']);?></p>
                            </div>
                            <?php echo do_shortcode( $settings['shortcode'] ); ?><!-- Contact Form 7 Short Code -->
							<!-- end message -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Contact_Widget );