<?php

namespace Elementor;
class Foodking_Choose_Us_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_choose_us';
	}
    public function get_title() {
		return esc_html__( 'Choose Us', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-user-preferences';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'choose_us_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'choose_us_section_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Choose Us Background Image', 'foodking-toolkit' ),
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'flaticon_class',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Flaticons Class Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'flaticon-quality', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'super quality food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'A team of dreamers and doers building unique interactive music and art', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'choose_us_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'text_align-icon',
            [
                'label' => esc_html__( 'جهت آیکون ها ', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'چپ', 'textdomain' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'مرکز', 'textdomain' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'راست ', 'textdomain' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .food-icon-wrapper .single-food-icon .icon' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'width-icon-size',
            [
                'label' => esc_html__( 'اندازه آیکون ها', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 55,
                ],
                'selectors' => [
                    '{{WRAPPER}} .food-icon-wrapper .single-food-icon .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-icon-wrapper .single-food-icon .content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .food-icon-wrapper .single-food-icon .content h4',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-icon-wrapper .single-food-icon .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .food-icon-wrapper .single-food-icon .content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Choose Us Section Start -->
    <section class="choose-us fix section-padding pt-0 section-bg">
        <div class="container">
            <?php if($settings['choose_us_section_image']['url']):?>
                <div class="food-icon-wrapper bg-cover" style="background-image: url(<?php echo esc_url($settings['choose_us_section_image']['url']);?>);">
                    <div class="row g-4">
                        <?php foreach($settings['lists'] as $item):?>
                            <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                                <div class="single-food-icon">
                                    <div class="icon">
                                        <i class="<?php echo esc_attr($item['flaticon_class']); ?>"></i>
                                    </div>
                                    <div class="content">
                                        <h4><?php echo esc_html($item['title']);?></h4>
                                        <p>
                                        <?php echo wp_kses_post($item['content']);?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach;?>
                    </div>
                </div>
            <?php endif;?>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Choose_Us_Widget );