<?php

namespace Elementor;
class Foodking_Choose_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_choose_us_two';
	}
    public function get_title() {
		return esc_html__( 'Choose Us Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-user-preferences';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'choose_us_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Body Shape Image', 'foodking-toolkit' ),
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'icon_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Icon Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Best Quality Food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'A team of dreamers and doers building unique interactive music and art', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'choose_us_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .choose-us-2',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .choose-us-2 .food-icon-wrapper-2 .single-food-icon .content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .choose-us-2 .food-icon-wrapper-2 .single-food-icon .content h3',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .choose-us-2 .food-icon-wrapper-2 .single-food-icon .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .choose-us-2 .food-icon-wrapper-2 .single-food-icon .content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Choose Us Section Start -->
    <section class="choose-us-2 fix section-padding bg-cover" style="background-image: url(<?php echo esc_url($settings['section_shape_image']['url']);?>);">
        <div class="container">
            <div class="food-icon-wrapper-2">
                <div class="row g-5">
                    <?php foreach($settings['lists'] as $item):?>
                        <div class="col-lg-3 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="single-food-icon">
                                <div class="icon">
                                    <?php if($item['icon_image']['url']):?>
                                        <img src="<?php echo esc_url($item['icon_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                </div>
                                <div class="content">
                                    <h3><?php echo esc_html($item['title']);?></h3>
                                    <p><?php echo wp_kses_post($item['content']);?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Choose_Two_Widget );