<?php

namespace Elementor;
class Foodking_Teams_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_teams_two';
	}
    public function get_title() {
		return esc_html__( 'Team Members Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-person';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

		$this->start_controls_section(
			'teams_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		); 
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'about our food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'MEET OUR EXPERT CHEFS', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'grid',
                [
                    'label' => esc_html__( 'Select Column', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '12'  => esc_html__( '1 Column', 'foodking-toolkit' ),
                        '6' => esc_html__( '2 Column', 'foodking-toolkit' ),
                        '4'  => esc_html__( '3 Column', 'foodking-toolkit' ),
                        '3' => esc_html__( '4 Column', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'order',
                [
                    'label' => __( 'Cards Order By', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'foodking-toolkit' ),
                        'ASC'       => __( 'ASC', 'foodking-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );
            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'meet our team', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'teams_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .team-section',
                ]
            );
            $this->add_control(
                'member_box_bg_color',
                [
                    'label' => esc_html__( 'Member Card Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-image::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bg_color',
                [
                    'label' => esc_html__( 'Card Icon Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-image .social-link  ' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon__color',
                [
                    'label' => esc_html__( 'Card Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-image .social-link a i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bg_hover_color',
                [
                    'label' => esc_html__( 'Card Icon Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-image .social-link:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_hover_color',
                [
                    'label' => esc_html__( 'Card Icon Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-image .social-link a i:hover ' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'member_title__color',
                [
                    'label' => esc_html__( 'Member Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-team-items .team-content p ' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Member Title Typography', 'foodking-toolkit' ),
                    'name' => 'member_title_typography',
                    'selector' => '{{WRAPPER}} .single-team-items .team-content p',
                ]
            );
            $this->add_control(
                'pagination_bg_color',
                [
                    'label' => esc_html__( 'Pagination Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'pagination__color',
                [
                    'label' => esc_html__( 'Pagination Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'pagination_bg_hover_color',
                [
                    'label' => esc_html__( 'Pagination Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'pagination__hover_color',
                [
                    'label' => esc_html__( 'Pagination Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();

        $args = array(
            'post_type'         => 'teams',
            'posts_per_page'    => $settings['count'],
            'order'             => $settings['order'],
            'paged'             => get_query_var('paged') ? get_query_var('paged') : 1,
        );
        $cards_array = new \WP_Query( $args );

        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
        
    <!-- Team Section Start -->
    <section class="team-section section-padding section-bg fix">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['title']);?></h2>
            </div>
            <div class="row">
            <?php
                while ($cards_array->have_posts()): $cards_array->the_post();
                    $idd = get_the_ID();

                    if ( class_exists('ACF') ) {
                        $facebook_icon = get_field('facebook_icon');
                        $facebook_url = get_field('facebook_url');
                        $twitter_icon = get_field('twitter_icon');
                        $twitter_url = get_field('twitter_url');
                        $linkedin_icon = get_field('linkedin_icon');
                        $linkedin_url = get_field('linkedin_url');
                        $youtube_icon = get_field('youtube_icon');
                        $youtube_url = get_field('youtube_url');
                        $member_designation = get_field('member_designation');
                    }else{
                        $facebook_icon = $facebook_url = $twitter_icon = $twitter_url = $linkedin_icon = $linkedin_url = $youtube_icon = $youtube_url = $member_designation = '';
                    }
                    ?>
                    <div class="col-xl-<?php echo esc_attr($settings['grid']); ?> col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="single-team-items">
                            <div class="team-image">
                                <?php if(has_post_thumbnail()): ?>
                                    <img src="<?php the_post_thumbnail_url() ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                <?php endif; ?>
                                <div class="social-link">
                                    <?php if($facebook_icon): ?>
                                        <a href="<?php echo esc_url($facebook_url); ?>"><i class="<?php echo esc_attr($facebook_icon); ?>"></i></a>
                                    <?php endif; ?>
                                    <?php if($twitter_icon): ?>
                                        <a href="<?php echo esc_url($twitter_url); ?>"><i class="<?php echo esc_attr($twitter_icon); ?>"></i></a>
                                    <?php endif; ?>
                                    <?php if($linkedin_icon): ?>
                                        <a href="<?php echo esc_url($linkedin_url); ?>"><i class="<?php echo esc_attr($linkedin_icon); ?>"></i></a>
                                    <?php endif; ?>
                                    <?php if($youtube_icon): ?>
                                        <a href="<?php echo esc_url($youtube_url); ?>"><i class="<?php echo esc_attr($youtube_icon); ?>"></i></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="team-content">
                                <p><?php echo esc_html($member_designation); ?></p>
                                <h3>
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h3>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
            <div class="team-button text-center mt-5 wow fadeInUp" data-wow-delay=".4s">
                <?php if($settings['btn_text']): ?>
                    <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn"><?php echo esc_html($settings['btn_text']);?></a>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Teams_Two_Widget );