<?php

namespace Elementor;
class Foodking_Chef_Details_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_chefdetails_one';
	}
    public function get_title() {
		return esc_html__( 'Chef Details One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-gallery-group';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

		$this->start_controls_section(
			'teams_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		); 
            $this->add_control(
                'section_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Section Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'icon_1',
                [
                    'label' => esc_html__( 'Ratings Icons #1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'icon_2',
                [
                    'label' => esc_html__( 'Ratings Icons #2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'icon_3',
                [
                    'label' => esc_html__( 'Ratings Icons #3', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'icon_4',
                [
                    'label' => esc_html__( 'Ratings Icons #4', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'icon_5',
                [
                    'label' => esc_html__( 'Ratings Icons #5', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $this->add_control(
                'ratings_point',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Ratings Point', 'foodking-toolkit' ),
                    'default' => esc_html__( '(5k)', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'On the other hand, we denounce with righteous indignation dislike men who
                    are so beguiled and demoralized by the charms of pleasure of the moment so
                    blinded by desire that they cannot foresee the pain and trouble that are', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'contact with me', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'skill_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Skill Section Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'skill_content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Welcome to our culinary haven where each dish is a symphony of flavors meticulously', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            // Add controls for each skill bar
            $this->add_control(
                'expertise_1_content',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Expertise 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'cooking chiness', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'cooking_chinese_percentage',
                [
                    'label' => esc_html__( 'Cooking Chinese Percentage', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 0,
                    'min' => 0,
                    'max' => 100,
                ]
            );
            $this->add_control(
                'expertise_2_content',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Expertise 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'serve managment', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'serve_management_percentage',
                [
                    'label' => esc_html__( 'Serve Management Percentage', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 0,
                    'min' => 0,
                    'max' => 100,
                ]
            );
            $this->add_control(
                'expertise_3_content',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Expertise 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Human Interacation', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'human_interaction_percentage',
                [
                    'label' => esc_html__( 'Human Interaction Percentage', 'foodking-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 0,
                    'min' => 0,
                    'max' => 100,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'teams_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
            $this->add_control(
                'ratings_text_color',
                [
                    'label' => esc_html__( 'Ratings Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content .star a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'name_color',
                [
                    'label' => esc_html__( 'Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'designation_color',
                [
                    'label' => esc_html__( 'Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content .social-icon a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bg_color',
                [
                    'label' => esc_html__( 'Icon Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content .social-icon a' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_h_color',
                [
                    'label' => esc_html__( 'Icon Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content .social-icon a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_h_bg_color',
                [
                    'label' => esc_html__( 'Icon Hover Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .team-details-wrapper .team-details-content .social-icon a:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_h_bg_color',
                [
                    'label' => esc_html__( 'Button Hover Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();// Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
        
    <!-- Team Details Section Start -->
    <section class="team-details-section fix section-padding">
        <div class="container">
            <div class="team-details-wrapper">
            <?php
                if ( class_exists('ACF') ) {
                        $facebook_icon = get_field('facebook_icon');
                        $facebook_url = get_field('facebook_url');
                        $twitter_icon = get_field('twitter_icon');
                        $twitter_url = get_field('twitter_url');
                        $linkedin_icon = get_field('linkedin_icon');
                        $linkedin_url = get_field('linkedin_url');
                        $youtube_icon = get_field('youtube_icon');
                        $youtube_url = get_field('youtube_url');
                        $member_name = get_field('member_name');
                        $member_designation = get_field('member_designation');
                    }else{
                        $facebook_icon = $facebook_url = $twitter_icon = $twitter_url = $linkedin_icon = $linkedin_url = $youtube_icon = $youtube_url = $member_name = $member_designation = '';
                    }
                    ?>
                <div class="row justify-content-between align-items-center">
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                        <?php if($settings['section_image']['url']):?>
                            <div class="team-image bg-cover" style="background-image: url(<?php echo esc_url($settings['section_image']['url']);?>);"></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-5 mt-5 mt-lg-0 wow fadeInUp" data-wow-delay=".5s">
                        <div class="team-details-content">
                            <div class="star pb-3">
                                <a href="#"> <i class="<?php echo esc_attr( $settings['icon_1'] ); ?>"></i></a>
                                <a href="#"><i class="<?php echo esc_attr( $settings['icon_2'] ); ?>"></i></a>
                                <a href="#"> <i class="<?php echo esc_attr( $settings['icon_3'] ); ?>"></i></a>
                                <a href="#"><i class="<?php echo esc_attr( $settings['icon_4'] ); ?>"></i></a>
                                <a href="#"> <i class="<?php echo esc_attr( $settings['icon_5'] ); ?>"></i></a>
                                <a href="#"><?php echo esc_html($settings['ratings_point']);?></a>
                            </div>
                            <h3><?php echo esc_html($member_name); ?></h3>
                            <span><?php echo esc_html($member_designation); ?></span>
                            <p><?php echo wp_kses_post($settings['content']);?></p>
                            <div class="social-icon d-flex align-items-center">
                                <?php if($facebook_icon): ?>
                                    <a href="<?php echo esc_url($facebook_url); ?>"><i class="<?php echo esc_attr($facebook_icon); ?>"></i></a>
                                <?php endif; ?>
                                <?php if($twitter_icon): ?>
                                    <a href="<?php echo esc_url($twitter_url); ?>"><i class="<?php echo esc_attr($twitter_icon); ?>"></i></a>
                                <?php endif; ?>
                                <?php if($linkedin_icon): ?>
                                    <a href="<?php echo esc_url($linkedin_url); ?>"><i class="<?php echo esc_attr($linkedin_icon); ?>"></i></a>
                                <?php endif; ?>
                                <?php if($youtube_icon): ?>
                                    <a href="<?php echo esc_url($youtube_url); ?>"><i class="<?php echo esc_attr($youtube_icon); ?>"></i></a>
                                <?php endif; ?>
                            </div>
                            <?php if($settings['btn_text']): ?>
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn style-line-height mt-5"><?php echo esc_html($settings['btn_text']);?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Skill Section Start -->
    <section class="team-skill fix section-padding bg-cover" style="background-image: url(<?php echo esc_url($settings['skill_bg_image']['url']);?>);">
        <div class="container">
            <div class="team-skill-wrapper">
                <div class="row justify-content-between">
                    <!-- Loop through each skill and display a progress bar -->
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="team-skill-content">
                            <h3><?php echo wp_kses_post($settings['skill_content']);?></h3>
                        </div>
                    </div>
                    <div class="col-lg-5 mt-4 mt-lg-0 wow fadeInUp" data-wow-delay=".5s">
                        <div class="progress-wrap">
                            <div class="pro-items">
                                <div class="pro-head">
                                    <h6 class="title">
                                        <?php echo esc_html($settings['expertise_1_content']);?>
                                    </h6>
                                    <span class="point">
                                    <?php echo esc_html($settings['cooking_chinese_percentage']);?>%
                                    </span>
                                </div>
                                <div class="progress">
                                    <div class="progress-value" style="width: <?php echo esc_html($settings['cooking_chinese_percentage']);?>%;"></div>
                                </div>
                            </div>

                            <div class="pro-items">
                                <div class="pro-head">
                                    <h6 class="title">
                                        <?php echo esc_html($settings['expertise_2_content']);?>
                                    </h6>
                                    <span class="point">
                                    <?php echo esc_html($settings['serve_management_percentage']);?>%
                                    </span>
                                </div>
                                <div class="progress">
                                    <div class="progress-value" style="width: <?php echo esc_html($settings['serve_management_percentage']);?>%;"></div>
                                </div>
                            </div>

                            <div class="pro-items">
                                <div class="pro-head">
                                    <h6 class="title">
                                        <?php echo esc_html($settings['expertise_3_content']);?>
                                    </h6>
                                    <span class="point">
                                    <?php echo esc_html($settings['human_interaction_percentage']);?>%
                                    </span>
                                </div>
                                <div class="progress">
                                    <div class="progress-value" style="width: <?php echo esc_html($settings['human_interaction_percentage']);?>%;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Repeat the above code block for other skills -->
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Chef_Details_One_Widget );