<?php

namespace Elementor;
class foodking_breadcrumb_el extends Widget_Base {
	public function get_name() {
		return 'foodking_breadcrumb_el';
	}
    public function get_title() {
		return esc_html__( 'مسیر راهبری', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-chevron-left';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();

        ?>
        
    <!-- About Food Section Start -->
      <?php  if ( class_exists('ACF') ) {
        $hide_page_banner	= get_field('hide_page_banner');
        $banner_image 		= get_field('banner_image');
        $banner_title 		= get_field('banner_title');
        }else{
        $hide_page_banner = $banner_image = $banner_title = '';
        }

        if( !$banner_title){
        $banner_title = get_the_title();
        }

        if($hide_page_banner == false) :
        ?>

        <!--<< Breadcrumb Section Start >>-->
        <div class="breadcrumb-wrapper bg-cover <?php if(!$banner_image): ?>no-image<?php endif; ?>" <?php if($banner_image): ?> style="background-image: url(<?php echo esc_url($banner_image); ?>)"<?php endif; ?>>
            <div class="container">
                <div class="page-heading center">
                    <h1><?php echo esc_html($banner_title); ?></h1>
                    <ul class="breadcrumb-items">
                        <?php foodking_breadcrumb_trail(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php
        endif; ?>

    <?php

    }
}
Plugin::instance()->widgets_manager->register( new foodking_breadcrumb_el );