<?php

namespace Elementor;
class Foodking_Booking_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_booking';
	}
    public function get_title() {
		return esc_html__( 'رزرو', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-table-of-contents';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'banner_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'banner_one_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shortcode',
                [
                    'label' => esc_html__( 'Booking Contact Form 7 PLugin Short code', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'need booking?', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'reserve your table?', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'flaticon_classes',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Flaticon Class', 'foodking-toolkit' ),
                    'default' => esc_html__( 'flaticon-phone-call-2', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'support_info',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Support Info', 'foodking-toolkit' ),
                    'default' => esc_html__( '24/7 Support center', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'phone_number',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Phone Number', 'foodking-toolkit' ),
                    'default' => esc_html__( '+1718-904-4450', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'number_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Phone Number Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'form_shape_image_bg',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Form Background Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'reservation_text',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Form Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'create an reservation', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .grilled-banner',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h4',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_middle_color',
                [
                    'label' => esc_html__( 'Title Middle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h2 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h2',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'subtitle_middle_color',
                [
                    'label' => esc_html__( 'Subtitle Middle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a .text-1' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'subtitle_last_color',
                [
                    'label' => esc_html__( 'Subtitle Last Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .grilled-wrapper .grilled-content h3 .text-2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .grilled-wrapper .grilled-content h3 a',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['number_link']['url'] ) ) {
            $this->add_link_attributes( 'number_link', $settings['number_link'] );
        }
        ?>
        
    <!-- Booking Section Start -->
    <?php if($settings['banner_one_bg_image']['url']):?>
        <section class="booking-section fix section-padding bg-cover" style="background-image: url(<?php echo esc_url($settings['banner_one_bg_image']['url']);?>);">
            <div class="container">
                <div class="booking-wrapper style-responsive section-padding pb-0">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-lg-6">
                            <div class="booking-content">
                                <div class="section-title">
                                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                                    <h2 class="text-white wow fadeInUp" data-wow-delay=".3s">
                                    <?php echo esc_html($settings['title_1']);?> <br> <?php echo esc_html($settings['title_2']);?>
                                    </h2>
                                </div>
                                <div class="icon-items d-flex align-items-center wow fadeInUp" data-wow-delay=".5s">
                                    <div class="icon">
                                        <i class="<?php echo esc_attr($settings['flaticon_classes']);?>"></i>
                                    </div>
                                    <div class="content">
                                        <h5><?php echo esc_html($settings['support_info']);?></h5>
                                        <h3><a <?php echo $this->get_render_attribute_string('number_link'); ?>><?php echo esc_html($settings['phone_number']);?></a></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 mt-5 mt-lg-0 wow fadeInUp" data-wow-delay=".4s">
                            <div class="booking-contact bg-cover" style="background-image: url(<?php echo esc_url($settings['form_shape_image_bg']['url']);?>);">
                                <h4 class="text-center text-white"><?php echo esc_html($settings['reservation_text']);?></h4>
                                <?php echo do_shortcode( $settings['shortcode'] ); ?><!-- Contact Form 7 Short Code -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Booking_Widget );