<?php

namespace Elementor;
class Foodking_About_Four_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_about_four';
	}
    public function get_title() {
		return esc_html__( 'About Food Four', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-post-list';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'about_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'در مورد غذای ما', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'White Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'جایی که با کیفیت عالی روبرو می شوید', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Color Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'خدمات', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'این تجربه ناهار خوری عالی است که در آن هر ظرف با تازه و با کیفیت بالا ساخته می شود
 خدمات سریع و کارآمدی را تجربه کنید که تضمین می کند غذای شما تازه سرو می شود
 تجربه غذاخوری که در آن هر غذا با مواد تازه و باکیفیت درست می شود', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'flaticon_class_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Flaticons Class Name 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'flaticon-quality', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'icon_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'غذای فوق العاده با کیفیت', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'icon_content_1',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'تیمی متشکل از رویاپردازان و انجام دهندگان موسیقی و هنر تعاملی منحصر به فرد را ایجاد می کنند', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'flaticon_class_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Flaticons Class Name 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'flaticon-reputation', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'icon_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'شهرت خوب', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'icon_content_2',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'تیمی متشکل از رویاپردازان و انجام دهندگان موسیقی و هنر تعاملی منحصر به فرد را ایجاد می کنند', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'اطلاعات بیشتر درباره ما', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'bottom_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Bottom Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'برندون گاری', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'bottom_subtitle', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Bottom Subtitle', 'foodking-toolkit' ),
                    'default' => esc_html__( 'تجربه مشتری بالاترین اولویت ما است.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'about_product_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Right Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'about_text_bg_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Text Background Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'از سال ۱۹۸۵', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'since_color',
                [
                    'label' => esc_html__( 'Since Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper .about-image .since-text h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Since Typography', 'foodking-toolkit' ),
                    'name' => 'since_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper .about-image .since-text h3',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_bold_color',
                [
                    'label' => esc_html__( 'Title Bold Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .about-content p',
                ]
            );
            $this->add_control(
                'inner_title_color',
                [
                    'label' => esc_html__( 'Inner Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper .about-content .icon-area .icon-items .content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Inner Title Typography', 'foodking-toolkit' ),
                    'name' => 'inner_title_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper .about-content .icon-area .icon-items .content h4',
                ]
            );
            $this->add_control(
                'inner_content_color',
                [
                    'label' => esc_html__( 'Inner Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper .about-content .icon-area .icon-items .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Inner Content Typography', 'foodking-toolkit' ),
                    'name' => 'inner_content_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper .about-content .icon-area .icon-items .content p',
                ]
            );
            $this->add_control(
                'bottom_title_color',
                [
                    'label' => esc_html__( 'Bottom Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper .about-content .info-area .info-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Bottom Title Typography', 'foodking-toolkit' ),
                    'name' => 'bottom_title_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper .about-content .info-area .info-content span',
                ]
            );
            $this->add_control(
                'bottom_subtitle_color',
                [
                    'label' => esc_html__( 'Bottom Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .info-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Bottom Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'bottom_subtitle_typography',
                    'selector' => '{{WRAPPER}} .info-content h6',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>

    <!-- About Section Start -->
    <section class="about-section fix section-padding pt-0">
        <div class="container">
            <div class="about-wrapper style-2">
                <div class="row align-items-center justify-content-between">
                    <div class="col-xl-6 col-lg-6">
                        <div class="about-content">
                            <div class="section-title">
                                <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                                <h2 class="wow fadeInUp" data-wow-delay=".3s">
                                <?php echo esc_html($settings['title_1']);?> <span><?php echo esc_html($settings['title_2']);?></span>
                                </h2>
                            </div>
                            <p class="wow fadeInUp" data-wow-delay=".5s">
                                <?php echo wp_kses_post($settings['content']);?>
                            </p>
                            <div class="icon-area">
                                <div class="icon-items d-flex wow fadeInUp" data-wow-delay=".3s">
                                    <div class="icon">
                                        <i class="<?php echo esc_attr($settings['flaticon_class_1']);?>"></i>
                                    </div>
                                    <div class="content">
                                        <h4><?php echo esc_html($settings['icon_title_1']);?></h4>
                                        <p><?php echo wp_kses_post($settings['icon_content_1']);?></p>
                                    </div>
                                </div>
                                <div class="icon-items d-flex wow fadeInUp" data-wow-delay=".5s">
                                    <div class="icon">
                                        <i class="<?php echo esc_attr($settings['flaticon_class_2']);?>"></i>
                                    </div>
                                    <div class="content">
                                        <h4><?php echo esc_html($settings['icon_title_2']);?></h4>
                                        <p><?php echo wp_kses_post($settings['icon_content_2']);?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="info-area d-flex align-items-center">
                                <?php if($settings['btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn wow style-line-height fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['btn_text']);?></a>
                                <?php endif; ?>
                                <div class="info-content wow fadeInUp" data-wow-delay=".5s">
                                    <span><?php echo esc_html($settings['bottom_title']);?></span>
                                    <h6><?php echo esc_html($settings['bottom_subtitle']);?></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-6 mt-5 mt-lg-0">
                        <?php if($settings['about_product_image']['url']): ?>
                            <div class="about-image-2">
                                <img src="<?php echo esc_url($settings['about_product_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php if($settings['about_text_bg_title']): ?>
                                    <div class="since-text bg-cover">
                                        <h3><?php echo esc_html($settings['about_text_bg_title']);?></h3>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_About_Four_Widget );