<?php

namespace Elementor;
class Foodking_About_Five_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_about_five';
	}
    public function get_title() {
		return esc_html__( 'About Food Five', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-post-list';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'about_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'About Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'در مورد غذای ما', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'مورد خوشمزه داغ', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Tab Button 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'مرغ سرخ کرده', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_1 = new Repeater();
            $repeater_tab_1->add_control(
                'card_image_btn_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Food Image', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_1->add_control(
                'card_title_btn_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Food Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیتزا دیپ شیکاگو', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_1->add_control(
                'btn_link_1', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_1->add_control(
                'card_content_btn_1',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Card Food Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'این تجربه ناهار خوری عالی است که در آن تجربه سریع و کارآمد را داشته باشید', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists_tab_1',
                [
                    'label'   => esc_html__( 'Add List Content For Tab 1', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater_tab_1->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Tab Button 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیتزا', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_2 = new Repeater();
            $repeater_tab_2->add_control(
                'card_image_btn_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Food Image', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_2->add_control(
                'card_title_btn_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Food Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیتزا دیپ شیکاگو', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_2->add_control(
                'btn_link_2', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_2->add_control(
                'card_content_btn_2',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Card Food Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'این تجربه ناهار خوری عالی است که در آن تجربه سریع و کارآمد را داشته باشید', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists_tab_2',
                [
                    'label'   => esc_html__( 'Add List Content For Tab 2', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater_tab_2->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Tab Button 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'برگر', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_3 = new Repeater();
            $repeater_tab_3->add_control(
                'card_image_btn_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Food Image', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_3->add_control(
                'card_title_btn_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Food Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیتزا دیپ شیکاگو', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_3->add_control(
                'btn_link_3', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_3->add_control(
                'card_content_btn_3',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Card Food Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'این تجربه ناهار خوری عالی است که در آن تجربه سریع و کارآمد را داشته باشید', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists_tab_3',
                [
                    'label'   => esc_html__( 'Add List Content For Tab 3', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater_tab_3->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text_4',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Tab Button 4', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیش غذا', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_4 = new Repeater();
            $repeater_tab_4->add_control(
                'card_image_btn_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Food Image', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_4->add_control(
                'card_title_btn_4',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Food Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'پیتزا دیپ شیکاگو', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater_tab_4->add_control(
                'btn_link_4', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $repeater_tab_4->add_control(
                'card_content_btn_4',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Card Food Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'این تجربه ناهار خوری عالی است که در آن تجربه سریع و کارآمد را داشته باشید', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists_tab_4',
                [
                    'label'   => esc_html__( 'Add List Content For Tab 4', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater_tab_4->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .about-food-section',
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'toptitle_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title.text-center h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title.text-center h2',
                ]
            );
            $this->add_control(
                'btn_active_bg_color',
                [
                    'label' => esc_html__( 'Tab Button Active Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .nav .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_active_color',
                [
                    'label' => esc_html__( 'Tab Button Active Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .nav .nav-item .nav-link.active' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label' => esc_html__( 'Tab Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .nav .nav-item .nav-link' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Tab Button Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .nav .nav-item .nav-link' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Tab Button Typography', 'foodking-toolkit' ),
                    'name' => 'btn_typography',
                    'selector' => '{{WRAPPER}} .about-food-wrapper .nav .nav-item .nav-link',
                ]
            );
            $this->add_control(
                'product_title_color',
                [
                    'label' => esc_html__( 'Food Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .about-food-items .food-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'product_title_hover_color',
                [
                    'label' => esc_html__( 'Food Title Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-food-wrapper .about-food-items .food-content h3 a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Food Title Typography', 'foodking-toolkit' ),
                    'name' => 'product_title_typography',
                    'selector' => '{{WRAPPER}} .about-food-wrapper .about-food-items .food-content h3',
                ]
            );
            $this->add_control(
                'product_content_color',
                [
                    'label' => esc_html__( 'Food Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Food Content Typography', 'foodking-toolkit' ),
                    'name' => 'product_content_typography',
                    'selector' => '{{WRAPPER}} .food-content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL 1
        if ( ! empty( $settings['btn_link_1']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_1', $settings['btn_link_1'] );
        }
        // Button URL 2
        if ( ! empty( $settings['btn_link_2']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_2', $settings['btn_link_2'] );
        }
        // Button URL 3
        if ( ! empty( $settings['btn_link_3']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_3', $settings['btn_link_3'] );
        }
        // Button URL 4
        if ( ! empty( $settings['btn_link_4']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_4', $settings['btn_link_4'] );
        }
        ?>
        
    <!-- About Food Section Start -->
    <section class="about-food-section section-bg section-padding">
        <div class="container">
            <div class="about-food-wrapper style-2">
                <div class="section-title text-center">
                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                    <h2 class="wow fadeInUp" data-wow-delay=".3s">
                    <?php echo esc_html($settings['title']);?>
                    </h2>
                </div>
                <ul class="nav justify-content-center">
                    <li class="nav-item wow fadeInUp" data-wow-delay=".3s">
                        <a href="#chicken" data-bs-toggle="tab" class="nav-link active">
                            <?php echo esc_html($settings['btn_text_1']);?>
                        </a>
                    </li>
                    <li class="nav-item wow fadeInUp" data-wow-delay=".5s">
                        <a href="#pizza" data-bs-toggle="tab" class="nav-link">
                            <?php echo esc_html($settings['btn_text_2']);?>
                        </a>
                    </li>
                    <li class="nav-item wow fadeInUp" data-wow-delay=".7s">
                        <a href="#burger" data-bs-toggle="tab" class="nav-link">
                            <?php echo esc_html($settings['btn_text_3']);?>
                        </a>
                    </li>
                    <li class="nav-item wow fadeInUp" data-wow-delay=".8s">
                        <a href="#deserts" data-bs-toggle="tab" class="nav-link">
                            <?php echo esc_html($settings['btn_text_4']);?>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <?php if($settings['btn_text_1']):?>
                        <div id="chicken" class="tab-pane fade show active">
                            <div class="description-items">
                                <div class="row">
                                    <?php foreach($settings['lists_tab_1'] as $item_1):?>
                                        <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                                            <div class="about-food-items center">
                                                <div class="food-image">
                                                    <?php if($item_1['card_image_btn_1']['url']): ?>
                                                        <img src="<?php echo esc_url($item_1['card_image_btn_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="food-content">
                                                    <h3><a <?php echo $this->get_render_attribute_string('btn_link_1'); ?>><?php echo esc_html($item_1['card_title_btn_1']);?></a></h3>
                                                    <p>
                                                        <?php echo wp_kses_post($item_1['card_content_btn_1']);?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    <?php endif;?>

                    <?php if($settings['btn_text_2']):?>
                        <div id="pizza" class="tab-pane fade">
                            <div class="description-items">
                                <div class="row">
                                    <?php foreach($settings['lists_tab_2'] as $item_2):?>
                                        <div class="col-xl-3 col-lg-6">
                                            <div class="about-food-items center">
                                                <div class="food-image">
                                                    <?php if($item_2['card_image_btn_2']['url']): ?>
                                                        <img src="<?php echo esc_url($item_2['card_image_btn_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="food-content">
                                                    <h3><a <?php echo $this->get_render_attribute_string('btn_link_2'); ?>><?php echo esc_html($item_2['card_title_btn_2']);?></a></h3>
                                                    <p>
                                                        <?php echo wp_kses_post($item_2['card_content_btn_2']);?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    <?php endif;?>

                    <?php if($settings['btn_text_3']):?>
                        <div id="burger" class="tab-pane fade">
                            <div class="description-items">
                                <div class="row">
                                    <?php foreach($settings['lists_tab_3'] as $item_3):?>
                                        <div class="col-xl-3 col-lg-6">
                                            <div class="about-food-items center">
                                                <div class="food-image">
                                                    <?php if($item_3['card_image_btn_3']['url']): ?>
                                                        <img src="<?php echo esc_url($item_3['card_image_btn_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="food-content">
                                                    <h3><a <?php echo $this->get_render_attribute_string('btn_link_3'); ?>><?php echo esc_html($item_3['card_title_btn_3']);?></a></h3>
                                                    <p>
                                                        <?php echo wp_kses_post($item_3['card_content_btn_3']);?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    <?php endif;?>

                    <?php if($settings['btn_text_4']):?>
                        <div id="deserts" class="tab-pane fade">
                            <div class="description-items">
                                <div class="row">
                                    <?php foreach($settings['lists_tab_4'] as $item_4):?>
                                        <div class="col-xl-3 col-lg-6">
                                            <div class="about-food-items center">
                                                <div class="food-image">
                                                    <?php if($item_4['card_image_btn_4']['url']): ?>
                                                        <img src="<?php echo esc_url($item_4['card_image_btn_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="food-content">
                                                    <h3><a <?php echo $this->get_render_attribute_string('btn_link_4'); ?>><?php echo esc_html($item_4['card_title_btn_4']);?></a></h3>
                                                    <p>
                                                        <?php echo wp_kses_post($item_4['card_content_btn_4']);?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_About_Five_Widget );