<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = 'foodking_opt';

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    // Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {
        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();
            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {
                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    // All the possible arguments for Redux.
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'تنظیمات قالب ', 'foodking-toolkit' ),
        'page_title'           => __( 'تنظیمات قالب ', 'foodking-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 90,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'opt_nameion',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'foodking-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text i7s displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'foodking-toolkit' );
    }
    Redux::setArgs( $opt_name, $args );



/**
 * START CONTROL
 * */

// General Options
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'تنظیمات عمومی', 'foodking-toolkit' ),
    'id'                => 'general_options',
    'customizer'        => false,
    'icon'              => ' el el-home',
    'fields'     => array(
        array(
            'id'       => 'main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو سایت ', 'foodking-toolkit' ),
            'desc'     => esc_html__( 'اندازه های پیشنهادی - عرض: 140 پیکسل، ارتفاع: 50 پیکسل.', 'foodking-toolkit' ),
        ),
        array(
            'title'     => __( 'ابعاد لوگوی سایت', 'foodking-toolkit' ),
            'id'        => 'main_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.logo img'
        ),
        array(
            'id'       => 'main_logo2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو دوم سایت', 'foodking-toolkit' ),
            'desc'     => esc_html__( 'سایز پیشنهادی - عرض: 140px,  50px.ارتفاع ', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'sidebar_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو موبایل', 'foodking-toolkit' ),
            'desc'     => esc_html__( 'اندازه های پیشنهادی - عرض: 140 پیکسل، ارتفاع: 50 پیکسل.', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'side_menu_icon1',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'منوی کناری نماد یک', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'side_menu_icon2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'منوی کناری نماد دو', 'foodking-toolkit' ),
        ),
        array(
            'title'     => __( 'ابعاد لوگوی موبایل', 'foodking-toolkit' ),
            'id'        => 'sidebar_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.offcanvas__logo img'
        ),
        array(
            'id'       => 'footer_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'لوگو فوتر', 'foodking-toolkit' ),
            'desc'     => esc_html__( 'اندازه های پیشنهادی - عرض: 140 پیکسل، ارتفاع: 50 پیکسل.', 'foodking-toolkit' ),
        ),
        array(
            'title'     => __( 'ابعاد لوگوی پاورقی', 'foodking-toolkit' ),
            'id'        => 'footer_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.footer-logo img'
        ),
    ),
) );

// Preloader Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'پیش بارگذار', 'foodking-toolkit' ),
    'id'               => 'preloader_opt',
    'customizer'        => false,
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(

        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'پیش لودر', 'foodking-toolkit' ),
            'on'      => esc_html__( 'فعال', 'foodking-toolkit' ),
            'off'     => esc_html__( 'غیرفعال', 'foodking-toolkit' ),
            'default' => true,
        ),
        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'متن پیش بارگذاری', 'foodking-toolkit' ),
            'subtitle'  => esc_html__('برای جداکردن از کاما استفاده کنید ', 'foodking-toolkit'),
            'default'  => esc_html__( 'فودکینگ', 'foodking-toolkit' ),
        ),

        array(
            'id'       => 'loading_text2',
            'type'     => 'text',
            'title'    => esc_html__( 'عنوان متن پیش بارگذاری', 'foodking-toolkit' ),
            'default'  => esc_html__( 'لطفا صبر کنید.', 'foodking-toolkit' ),
        ),
    )
));

// Header Topbar Option
Redux::setSection( $opt_name, array(
    'title' => esc_html__('سربرگ بالایی', 'foodking-toolkit'),
    'id'    => 'header_options',
    'icon'  => 'el el-align-justify',
    'customizer' => false,
    'fields' => array(
        array(
            'id'    => 'top_bar_number',
            'type'  => 'text',
            'title' => esc_html__('درصد', 'foodking-toolkit'),
            'default'   => esc_html__('100%', 'foodking-toolkit'),
        ),
        array(
            'id'    => 'info_field_1',
            'type'  => 'text',
            'title' => esc_html__('فیلد اطلاعات 1', 'foodking-toolkit'),
            'default'   => esc_html__('تحویل مطمئن بدون تماس با پیک', 'foodking-toolkit'),
        ),
        array(
            'id'    => 'icon_field',
            'type'  => 'text',
            'title' => esc_html__('فیلد آیکون', 'foodking-toolkit'),
            'default'   => esc_html__('fas fa-truck', 'foodking-toolkit'),
            'desc'     => esc_html__( 'نماد بیشتر را در اینجا پیدا کنید - https://fontawesome.com/icons [فقط از کلاس نماد استفاده کنید]', 'foodking-toolkit' ),
        ),
        array(
            'id'    => 'info_field_2',
            'type'  => 'text',
            'title' => esc_html__('فیلد اطلاعات 2', 'foodking-toolkit'),
            'default'   => esc_html__('سفارشتان را پیگیری کنید', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'enable_search_bar',
            'type'      => 'switch',
            'title'     => esc_html__('نوار جستجو را فعال کنید', 'foodking-toolkit'),
            'default'   => '1',
        ),
        array(
            'id'        => 'search_placeholder_text',
            'type'      => 'text',
            'title'     => esc_html__('متن نگهدارنده جستجو', 'foodking-toolkit'),
            'required'  => array('enable_search_bar','equals','1'),
            'default'   => esc_html__('جستجو', 'foodking-toolkit'),
        ),
    )
) );

// Header Option
Redux::setSection( $opt_name, array(
	'title' => esc_html__('سربرگ', 'foodking-toolkit'),
	'icon'  => 'el el-caret-up',
	'customizer' => false,
	'fields' => array(
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => esc_html__('فعال کردن دکمه بازگشت به بالا', 'foodking-toolkit'),
            'default'   => '1'
        ),

        array(
            'id'        => 'enable_sticky_header',
            'type'      => 'switch',
            'title'     => esc_html__('فعال کردن سربرگ چسبان', 'foodking-toolkit'),
            'desc'      => esc_html__('', 'foodking-toolkit'),
            'default'   => '1',
        ),
        
        array(
            'id'   =>'divider_1',
            'desc' => esc_html__('▽ گزینه هایی برای سبد خرید', 'foodking-toolkit'),
            'type' => 'info',
            'style' => 'warning',
        ),

        array(
            'id'   =>'divider_2',
            'desc' => esc_html__('▽ Options for Contact Button', 'foodking-toolkit'),
            'type' => 'info',
            'style' => 'warning',
        ),

        array(
			'id'    => 'header_btn',
            'type'  => 'text',
			'title' => esc_html__('متن دکمه سربرگ', 'foodking-toolkit'),
            'default'   => esc_html__('با ما تماس بگیرید', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'header_btn_link',
            'type'  => 'text',
			'title' => esc_html__('لینک دکمه سربرگ', 'foodking-toolkit'),
            'default'   => '#',
        ),

        array(
            'id'   =>'divider_3',
            'desc' => esc_html__('▽ گزینه هایی برای منظقه خارج از بوم  ', 'foodking-toolkit'),
            'type' => 'info',
            'style' => 'warning',
        ),

        array(
			'id'        => 'header_sidebar_desc',
            'type'      => 'text',
			'title'     => esc_html__('توضیح کوتاه', 'foodking-toolkit'),
            'default'   => esc_html__('این شامل تعاملات بین یک کسب و کار و مشتریان آن است. این در مورد رفع نیازهای مشتریان و حل مشکلات آنها است. خدمات موثر به مشتری بسیار مهم است.', 'foodking-toolkit'),
        ),
        array(
            'id'       => 'gallery_img_1',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس  1', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'gallery_img_2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس 2', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'gallery_img_3',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس 3', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'gallery_img_4',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس 4', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'gallery_img_5',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس 5 ', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'gallery_img_6',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'گالری عکس 6', 'foodking-toolkit' ),
        ),
        array(
			'id'    => 'sidebar_title',
            'type'  => 'text',
			'title' => esc_html__('عنوان اطلاعات', 'foodking-toolkit'),
            'default'   => esc_html__('محتوا اطلاعات', 'foodking-toolkit'),
        ),
        array(
            'id'    => 'contact_icon_field_1',
            'type'  => 'text',
            'title' => esc_html__('فیلد آیکون 1', 'foodking-toolkit'),
            'default'   => esc_html__('fas fa-map-marker-alt', 'foodking-toolkit'),
            'desc'     => esc_html__( 'نماد بیشتر را در اینجا پیدا کنید - https://fontawesome.com/icons [فقط از کلاس نماد استفاده کنید]', 'foodking-toolkit' ),
        ),
        array(
			'id'    => 'contact_field_1',
            'type'  => 'text',
			'title' => esc_html__('محل', 'foodking-toolkit'),
            'default'   => esc_html__('خیابان اصلی، ملبورن، استرالیا', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'contact_field_1_link',
            'type'  => 'text',
			'title' => esc_html__('لینک مکان', 'foodking-toolkit'),
            'default'   => '#',
        ),
        array(
            'id'    => 'contact_icon_field_2',
            'type'  => 'text',
            'title' => esc_html__('فیلد آیکون 2', 'foodking-toolkit'),
            'default'   => esc_html__('far fa-envelope', 'foodking-toolkit'),
            'desc'     => esc_html__( 'نماد بیشتر را در اینجا پیدا کنید - https://fontawesome.com/icons [فقط از کلاس نماد استفاده کنید] ', 'foodking-toolkit' ),
        ),
        array(
			'id'    => 'contact_field_2',
            'type'  => 'text',
			'title' => esc_html__('پست الکترونیک', 'foodking-toolkit'),
            'default'   => esc_html__('INFO@FOODKING.COM', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'header_sidebar_email_link',
            'type'  => 'text',
			'title' => esc_html__('لینک آدرس ایمیل', 'foodking-toolkit'),
            'default'   => '#',
        ),
        array(
            'id'    => 'contact_icon_field_3',
            'type'  => 'text',
            'title' => esc_html__('فیلد نماد 3', 'foodking-toolkit'),
            'default'   => esc_html__('far fa-clock', 'foodking-toolkit'),
            'desc'     => esc_html__( 'نماد بیشتر را در اینجا پیدا کنید - https://fontawesome.com/icons [فقط از کلاس نماد استفاده کنید]', 'foodking-toolkit' ),
        ),
        array(
			'id'    => 'contact_field_3',
            'type'  => 'text',
			'title' => esc_html__('دسترسی', 'foodking-toolkit'),
            'default'   => esc_html__('MOD-FRIDAY, 09AM -05PM', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'contact_field_3_link',
            'type'  => 'text',
			'title' => esc_html__('لینک در دسترس بودن', 'foodking-toolkit'),
            'default'   => '#',
        ),
        array(
            'id'    => 'contact_icon_field_4',
            'type'  => 'text',
            'title' => esc_html__('فیلد آیکون 4', 'foodking-toolkit'),
            'default'   => esc_html__('fas fa-phone', 'foodking-toolkit'),
            'desc'     => esc_html__( 'نماد بیشتر را در اینجا پیدا کنید - https://fontawesome.com/icons [فقط از کلاس نماد استفاده کنید]', 'foodking-toolkit' ),
        ),
        array(
			'id'    => 'contact_field_4',
            'type'  => 'text',
			'title' => esc_html__('شماره تلفن', 'foodking-toolkit'),
            'default'   => esc_html__('+11002345909', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'header_sidebar_phone_link',
            'type'  => 'text',
			'title' => esc_html__('لینک شماره تلفن', 'foodking-toolkit'),
            'default'   => '#',
        ),
        array(
			'id'    => 'order_btn',
            'type'  => 'text',
			'title' => esc_html__('متن دکمه سفارش', 'foodking-toolkit'),
            'default'   => esc_html__('اکنون سفارش دهید', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'order_btn_link',
            'type'  => 'text',
			'title' => esc_html__('لینک دکمه سفارش', 'foodking-toolkit'),
            'default'   => '#',
        ),
	)
) );

// Footer Area 
Redux::setSection( $opt_name, array( 
    'title'             => esc_html__( 'پاورقی', 'foodking-toolkit' ),
    'id'                => 'footer',
    'customizer'        => false, 
    'icon'              => 'el el-edit', 
    'fields' => array( 
        array( 
            'title'     => esc_html__( 'کد کوتاه بلوک پاورقی فودکینگ', 'foodking-toolkit' ),
            'id'        => 'foodking_footer_content', 
            'type'      => 'text', 
        ), 
         
        array( 
            'id'   =>'divider_footer', 
            'desc' => '<div style="font-size:16px;">فوتر فودکینگ با استفاده از المنتور ساخته شده است. برای افزودن یا به‌روزرسانی محتوای پاورقی، لطفاً به پیشخوان وردپرس -> بلوک های فودکینگ بروید.</div> <br><br>  <img src="'.esc_url(get_template_directory_uri() .'/assets/img/foodking-block.png').'"> <br> ',
            'type' => 'info', 
        ), 
    ) 
));

// Main CTA Banner
Redux::setSection( $opt_name, array(
    'title' => esc_html__('بنر CTA', 'foodking-toolkit'),
    'id'    => 'cta_banner_options',
    'icon'  => 'el el-volume-up',
    'customizer' => false,
    'fields' => array(
        array(
            'id'       => 'cta_banner_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'زمینه بنر CTA', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'cta_sec_img',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'تصویر بنر CTA', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'cta_shape_img_1',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'تصویر 1', 'foodking-toolkit' ),
        ),
        array(
            'id'       => 'cta_shape_img_2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'تصویر 2', 'foodking-toolkit' ),
        ),
        array(
            'id'        => 'cta_subtitle',
            'type'      => 'text',
            'title'     => esc_html__('عنوان فرعی', 'foodking-toolkit'),
            'default'   => esc_html__('ترد ، هر طعم نیش', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'cta_title_1',
            'type'      => 'text',
            'title'     => esc_html__('عنوان 1', 'foodking-toolkit'),
            'default'   => esc_html__('30 دقیقه سریع', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'cta_title_2',
            'type'      => 'text',
            'title'     => esc_html__('عنوان 2', 'foodking-toolkit'),
            'default'   => esc_html__('بیرون بر', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'cta_title_3',
            'type'      => 'text',
            'title'     => esc_html__('عنوان 3', 'foodking-toolkit'),
            'default'   => esc_html__('چالش', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'cta_btn',
            'type'  => 'text',
			'title' => esc_html__('متن دکمه CTA', 'foodking-toolkit'),
            'default'   => esc_html__('اکنون سفارش دهید', 'foodking-toolkit'),
        ),
        array(
			'id'    => 'cta_btn_link',
            'type'  => 'text',
			'title' => esc_html__('پیوند دکمه CTA', 'foodking-toolkit'),
            'default'   => '#',
        ),
    ),
) );

// Blog Page
Redux::setSection( $opt_name, array(
    'title' => esc_html__('تنظیمات وبلاگ', 'foodking-toolkit'),
    'id'    => 'blog_options',
    'icon'  => 'el el-book',
    'customizer' => false,
    'fields' => array(
        array(
            'id'   =>'divider_1',
            'desc' => esc_html__('▽ گزینه های صفحه وبلاگ', 'foodking-toolkit'),
            'type' => 'info',
            'style' => 'warning',
        ),

        array(
            'id' => 'foodking_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'کانتینر', 'foodking-toolkit' ),
                'container-fluid'           => esc_html__( 'سیال کانتینر', 'foodking-toolkit' ),
            ),
            'title'     => esc_html__( 'عرض وبلاگ', 'foodking-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'foodking_blog_grid',
            'type' => 'select',
            'options' => array(
                'col-lg-12 col-md-12'       => esc_html__( 'یک ستون', 'foodking-toolkit' ),
                'col-lg-6 col-sm-6 col-md-6'         => esc_html__( 'دو ستون', 'foodking-toolkit' ),
                'col-lg-4 col-md-6'         => esc_html__( 'سه ستون', 'foodking-toolkit' ),
                'col-lg-3 col-md-6'         => esc_html__( 'چهار ستون', 'foodking-toolkit' ),
            ),
            'title'     => esc_html__( 'ستون وبلاگ', 'foodking-toolkit' ),
            'default'   => 'col-lg-12 col-sm-12 col-md-12',
        ),
        array(
            'id' => 'foodking_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'foodking_with_sidebar'              => 'با نوار کناری',
                'foodking_without_sidebar'           => 'بدون نوار کناری (عرض کامل)',
                'foodking_without_sidebar_center'    => 'بدون نوار کناری (مرکز)',
            ),
            'title'     => esc_html__( 'نوار کناری وبلاگ', 'foodking-toolkit' ),
            'default'   => 'foodking_with_sidebar',
        ),
        array(
            'id' => 'foodking_blog_sidebar_position',
            'type' => 'select',
            'options' => array(
                'left'  => ' چپ',
                'right' => 'راست',
            ),
            'title'     => esc_html__( 'موقعیت نوار کناری وبلاگ', 'foodking-toolkit' ),
            'default'   => 'راست',
            'required' => array( 'foodking_blog_sidebar', '=', 'foodking_with_sidebar' ),
        ),

        array(
            'id'       => 'blog_header_banner',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'بنر وبلاگ', 'foodking-toolkit' ),
        ),
        array(
            'id'        => 'blog_page_title',
            'type'      => 'text',
            'title'     => esc_html__('عنوان بنر صفحه', 'foodking-toolkit'),
            'default'   => esc_html__('صفحه وبلاگ', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'read_more',
            'type'      => 'text',
            'title'     => esc_html__('متن دکمه نوشته های وبلاگ', 'foodking-toolkit'),
            'default'   => esc_html__('مشاهده بیشتر', 'foodking-toolkit'),
        ),

        array(
            'id'   =>'divider_2',
            'desc' => esc_html__('▽ گزینه های صفحه تک وبلاگ', 'foodking-toolkit'),
            'type' => 'info',
            'style' => 'warning',
        ),

        array(
            'id' => 'foodking_single_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'کانتینر', 'foodking-toolkit' ),
                'container-fluid'           => esc_html__( 'سیال کانتینر', 'foodking-toolkit' ),
            ),
            'title'     => esc_html__( 'عرض وبلاگ', 'foodking-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'foodking_single_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'foodking_with_single_sidebar'              => 'با نوار کناری',
                'foodking_without_single_sidebar'           => 'بدون نوار کناری ( تمام عرض )',
                'foodking_without_single_sidebar_center'    => 'بدون نوار کناری( مرکز )',
            ),
            'title'     => esc_html__( 'نوار کناری یک وبلاگ', 'foodking-toolkit' ),
            'default'   => 'foodking_with_single_sidebar',
        ),

        array(
            'id' => 'foodking_single_blog_sidebar_position',
            'type' => 'select',
            'options' => array(
                'left'              => 'چپ',
                'right'           => 'راست',
            ),
            'title'     => esc_html__( 'موقعیت نوار کناری یک وبلاگ', 'foodking-toolkit' ),
            'default'   => 'راست',
            'required' => array( 'foodking_single_blog_sidebar', '=', 'foodking_with_single_sidebar' ),
        ),
        array(
            'id'       => 'single_blog_header_banner',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'بنر وبلاگ', 'foodking-toolkit' ),
        ),
        array(
            'id'        => 'single_blog_page_title',
            'type'      => 'text',
            'title'     => esc_html__('عنوان بنر وبلاگ', 'foodking-toolkit'),
            'default'   => esc_html__('مجرد وبلاگ', 'foodking-toolkit'),
        ),
    ),
) );

// 404 Page
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404 صفحه خطا', 'foodking-toolkit' ),
    'id'                => 'error_page_page',
    'customizer'        => false,
    'icon'              => 'el el-bullhorn',
    'fields' => array(
        array(
            'id'        => 'error_page_title',
            'type'      => 'text',
            'title'     => esc_html__('عنوان 404', 'foodking-toolkit'),
            'default'   => esc_html__('404', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'error_page_desc',
            'type'      => 'text',
            'title'     => esc_html__('404 توضیحات', 'foodking-toolkit'),
            'default'   => esc_html__('ما متاسفم که صفحه یافت نشد', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'error_page_action_url',
            'type'      => 'text',
            'title'     => esc_html__('404 URL عمل', 'foodking-toolkit'),
            'default'   => esc_html__('بازگشت به خانه', 'foodking-toolkit'),
        ),
    )
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title'         => __( 'محصول ووکامرسی', 'foodking-toolkit' ),
    'desc'          => __( 'تنظیمات صفحه محصول را مدیریت کنید.', 'foodking-toolkit' ),
    'icon'          => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        
        array(
            'id'        => 'products_page_count',
            'desc'      => __( 'تعداد محصولات در هر صفحه در صفحات محصول.', 'foodking-toolkit' ),
            'type'      => 'text',
            'title'     => __( 'محصولات در هر صفحه', 'foodking-toolkit' ),
            'default'   => '6',
        ),
        array(
			'id'    => 'hide_product_banner',
            'type'  => 'switch',
            'title' => esc_html__('مخفی کردن پرچم محصول منفرد', 'foodking-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_product_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('مخفی کردن منو راهبری یک محصول منفرد', 'foodking-toolkit'),
            'default'   => '0',
            'required'    => array('hide_product_banner','equals','0'),
        ),
        array(
            'id'       => 'shop_banner_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'پس زمینه بنر فروشگاه', 'foodking-toolkit' ),
        ),
        array(
            'id'    => 'product_sidebar',
            'type'  => 'select',
            'options' => array(
                'foodking_product_no_sidebar'       => 'هیچ یک',
                'left-sidebar'  => 'نوار کناری در سمت چپ',
                'right-sidebar' => 'نوار کناری در سمت راست',
            ),
            'title'     => __( 'موقعیت نوار کناری محصول', 'foodking-toolkit' ),
            'default'   => 'foodking_product_no_sidebar',
        ),
        array(
            'id'        => 'enable_product_meta',
            'type'      => 'switch',
            'title'     => esc_html__('متا محصول را فعال کنید', 'foodking-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'des_tab_title',
            'type'      => 'text',
            'default'   => 'شرح',
            'title'     => esc_html__('توضیحات عنوان برگه', 'foodking-toolkit'),
        ),
        array(
            'id'        => 'review_tab_title',
            'type'      => 'text',
            'default'   => 'بررسی',
            'title'     => esc_html__('عنوان برگه را بررسی می کند', 'foodking-toolkit'),
        ),
    ),
));

// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('پروفایل های اجتماعی', 'foodking-toolkit'),
	'desc'  => 'از پروفایل های اجتماعی در مکان های مختلف داخل قالب استفاده می شود.',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'foodking_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'بارگذاری در پنجره جدید. ( _blank )',
                '_self'     => 'بارگذاری شده در همان قاب که کلیک شده است. ( _self )',
                '_parent'   => 'در پنجره والدین بارگیری کنید. ( _parent )',
                '_top'      => 'در بدنه کامل پنجره بارگذاری کنید ( _top )',
            ),
            'title'     => esc_html__( 'هدف پیوند اجتماعی', 'foodking-toolkit' ),
            'default'   => '_blank',
        ),

        array(
			'id'    => 'facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('آدرس فیس بوک', 'foodking-toolkit')
		),
        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
			'title' => esc_html__('آدرس توییتر', 'foodking-toolkit')
		),
        array(
			'id'    => 'vimeo_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس ویمو', 'foodking-toolkit')
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
			'title' => esc_html__('آدرس اینستاگرام', 'foodking-toolkit')
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('آدرس لینکدین', 'foodking-toolkit')
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' =>esc_html__('آدرس پینترست', 'foodking-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' =>esc_html__('آدرس دربیل', 'foodking-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' =>esc_html__('آدرس تامبلر', 'foodking-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس یوتیوب', 'foodking-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس فلیکر', 'foodking-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس بی هنس', 'foodking-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس گیت هاب', 'foodking-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس اسکایپ', 'foodking-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' =>  esc_html__('RSS آدرس', 'foodking-toolkit')
		),
		array(
			'id'    => 'tiktok_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس تیک تاک', 'foodking-toolkit')
		),
		array(
			'id'    => 'gogole_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس گوگل', 'foodking-toolkit')
		),
		array(
			'id'    => 'medium_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس مدیوم', 'foodking-toolkit')
		),
        array(
			'id'    => 'snapchat_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس اسنپ چت', 'foodking-toolkit')
		),
        array(
			'id'    => 'wechat_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس ویچت', 'foodking-toolkit')
		),
        array(
			'id'    => 'whatsapp_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس واتساپ', 'foodking-toolkit')
		),
        array(
			'id'    => 'telegram_url',
			'type'  => 'text',
			'title' =>  esc_html__('آدرس تلگرام', 'foodking-toolkit')
        ),
    ),
) );

// Styling
Redux::setSection( $opt_name, array(
    'title'        => esc_html__( 'گزینه های رنگبندی ', 'foodking-toolkit' ),
    'id'           => 'styling_options',
    'customizer'   => false,
    'icon'         => ' el el-magic',
    'fields'     => array(
        array(
            'id'            => 'primary_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ اصلی', 'foodking-toolkit'),
            'default'       => '#00813D',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'secondary_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ ثانویه', 'foodking-toolkit'),
            'default'       => '#D12525',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'main_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ اصلی', 'foodking-toolkit'),
            'default'       => '#FFB936',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'text_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ متن', 'foodking-toolkit'),
            'default'       => '#5C5C5B',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'white_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ سفید', 'foodking-toolkit'),
            'default'       => '#fff',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'black_color',
            'type'          => 'color',
            'title'         => esc_html__('رنگ سیاه', 'foodking-toolkit'),
            'default'       => '#212121',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'       		=> 'bg_color',
            'type'     		=> 'color',
            'title'    		=> __('رنگ پس زمینه', 'foodking-toolkit'), 
            'default'       => '#f4f1ea',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'       		=> 'top_header_bg_color',
            'type'     		=> 'color',
            'title'    		=> __('رنگ پس زمینه نوار بالا', 'foodking-toolkit'), 
            'default'       => '#f4f1ea',
            'validate'      => 'color',
            'transparent'   => false,
        ),
    ),
) );

// Typography
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'تایپوگرافی', 'foodking-toolkit' ),
    'desc' => esc_html__( 'فونت ها و تایپ های خود را مدیریت کنید.', 'foodking-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'primary_typography',
            'type'          => 'typography',
            'title'         => esc_html__( 'تایپوگرافی بدنه اصلی ', 'foodking-toolkit' ),
            'google'        => false,
            'font-backup'   => true,
            'all_styles'    => false,
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output'      => array('body'),
            'default'     => array(
                'font-family' => 'IRANYekanWeb(FaNum) Light',
            ),
        ),

    ),
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
    'title'         => esc_html__('تنظیمات پیشرفته', 'foodking-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
    'fields' => array(
        array(
            'id' => 'css_code',
            'type' => 'ace_editor',
            'title' => esc_html__('کد CSS سفارشی', 'foodking-toolkit'),
            'desc' => esc_html__('    .btn-primary{ پس زمینه: #000; }   : استفاده نکنید به عنوان مثال   <style> از تگ های', 'foodking-toolkit'),
            'subtitle' => esc_html__('کد های خود را اینجا بچسبانید.', 'foodking-toolkit'),
            'mode' => 'css',
            'theme' => 'monokai'
        ),
        array(
            'id'        => 'js_code',
            'type'      => 'ace_editor',
            'title'     => esc_html__('کد JS سفارشی', 'foodking-toolkit'),
            'desc'      => esc_html__('به عنوان مثال، هشدار ("سلام جهان!"); از برچسب‌های&lt;اسکریپت&gt;استفاده نکنید.', 'foodking-toolkit'),
            'subtitle'  => esc_html__('کد JS خود را در اینجا جایگذاری کنید.', 'foodking-toolkit'),
            'mode'      => 'javascript',
            'theme'     => 'monokai'
        )
    )
) );






/**
 * END CONTROL
 * */
    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    // Custom function for the callback validation referenced above
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    // Custom function for the callback referenced above
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'foodking-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'foodking-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    // Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    // Filter hook for filtering the default value of any given field. Very useful in development mode.
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    // Removes the demo link and the notice of integrated demo from the redux-framework plugin
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }
