/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-08 22:09:26 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1906 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=18384 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5652 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=83355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13028 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `section` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `result` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131042 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5317 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=1355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `prod_id` bigint NOT NULL,
  `quantity` int NOT NULL,
  `user_id` bigint DEFAULT NULL,
  `wishlist_id` bigint DEFAULT NULL,
  `position` int DEFAULT '0',
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `on_sale` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_yith_wcwl_itemmeta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `yith_wcwl_item_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `item_id` (`yith_wcwl_item_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `dateadded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  UNIQUE KEY `wishlist_token_2` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("15", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2024-08-03 00:25:11", "2024-08-03 00:25:11", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-08-03 00:25:20", "2024-08-03 03:55:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("36", "action_scheduler/migration_hook", "failed", "2024-08-06 23:13:56", "2024-08-06 23:13:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1722986036;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1722986036;}", "1", "1", "2024-08-06 23:14:35", "2024-08-07 02:44:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("40", "action_scheduler/migration_hook", "failed", "2024-08-07 23:57:22", "2024-08-07 23:57:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723075042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723075042;}", "1", "1", "2024-08-07 23:57:22", "2024-08-08 03:27:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "action_scheduler/migration_hook", "failed", "2024-08-11 00:55:35", "2024-08-11 00:55:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723337735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723337735;}", "1", "1", "2024-08-11 00:55:39", "2024-08-11 04:25:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "action_scheduler/migration_hook", "failed", "2024-08-11 22:54:10", "2024-08-11 22:54:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723416850;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723416850;}", "1", "1", "2024-08-11 22:54:27", "2024-08-12 02:24:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "action_scheduler/migration_hook", "failed", "2024-08-13 23:45:15", "2024-08-13 23:45:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723592715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723592715;}", "1", "1", "2024-08-13 23:45:15", "2024-08-14 03:15:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("62", "action_scheduler/migration_hook", "failed", "2024-08-14 00:44:32", "2024-08-14 00:44:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723596272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723596272;}", "1", "1", "2024-08-14 00:44:32", "2024-08-14 04:14:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("67", "action_scheduler/migration_hook", "failed", "2024-08-16 23:08:40", "2024-08-16 23:08:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723849720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723849720;}", "1", "1", "2024-08-16 23:09:35", "2024-08-17 02:39:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("74", "action_scheduler/migration_hook", "failed", "2024-08-19 00:01:33", "2024-08-19 00:01:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1724025693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1724025693;}", "1", "1", "2024-08-19 00:01:35", "2024-08-19 03:31:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("77", "action_scheduler/migration_hook", "failed", "2024-08-20 01:38:18", "2024-08-20 01:38:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1724117898;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1724117898;}", "1", "1", "2024-08-20 01:39:19", "2024-08-20 05:09:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("80", "action_scheduler/migration_hook", "failed", "2024-08-20 23:20:11", "2024-08-20 23:20:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1724196011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1724196011;}", "1", "1", "2024-08-20 23:20:19", "2024-08-21 02:50:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("86", "action_scheduler/migration_hook", "failed", "2024-08-21 22:44:50", "2024-08-21 22:44:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1724280290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1724280290;}", "1", "1", "2024-08-21 22:44:56", "2024-08-22 02:14:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("92", "action_scheduler/migration_hook", "failed", "2024-08-22 23:46:22", "2024-08-22 23:46:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1724370382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1724370382;}", "1", "1", "2024-08-22 23:46:34", "2024-08-23 03:16:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "action_scheduler/migration_hook", "failed", "2024-11-01 23:49:48", "2024-11-01 23:49:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730504988;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730504988;}", "1", "1", "2024-11-01 23:50:39", "2024-11-02 03:20:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("243", "action_scheduler/migration_hook", "failed", "2024-12-27 23:17:07", "2024-12-27 23:17:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735341427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735341427;}", "1", "1", "2024-12-27 23:17:26", "2024-12-28 02:47:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("974", "woocommerce_geoip_updater", "complete", "2025-10-09 08:41:15", "2025-10-09 08:41:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759999275;s:18:\"\0*\0first_timestamp\";i:1757393268;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759999275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "1", "2025-10-09 08:50:21", "2025-10-09 12:20:21", "17199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1244", "woocommerce_cleanup_draft_orders", "complete", "2025-10-09 04:26:43", "2025-10-09 04:26:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984003;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-09 06:52:02", "2025-10-09 10:22:02", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1245", "woocommerce_scheduled_sales", "complete", "2025-10-09 04:26:43", "2025-10-09 04:26:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984003;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-09 06:52:02", "2025-10-09 10:22:02", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1246", "wc_admin_daily_wrapper", "complete", "2025-10-09 04:26:44", "2025-10-09 04:26:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984004;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-09 06:52:03", "2025-10-09 10:22:03", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1247", "woocommerce_cleanup_personal_data", "complete", "2025-10-09 04:26:45", "2025-10-09 04:26:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984005;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-09 06:52:04", "2025-10-09 10:22:04", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1248", "woocommerce_cleanup_logs", "complete", "2025-10-09 04:26:45", "2025-10-09 04:26:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984005;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-09 06:52:04", "2025-10-09 10:22:04", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1249", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-09 04:26:45", "2025-10-09 04:26:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984005;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-09 06:52:04", "2025-10-09 10:22:04", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1251", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-09 04:26:45", "2025-10-09 04:26:45", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759984005;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759984005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-09 06:52:04", "2025-10-09 10:22:04", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1253", "woocommerce_refresh_order_count_cache", "complete", "2025-10-08 21:21:53", "2025-10-08 21:21:53", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759958513;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759958513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-09 02:20:35", "2025-10-09 05:50:35", "17189", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1254", "woocommerce_cleanup_sessions", "complete", "2025-10-08 21:21:53", "2025-10-08 21:21:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759958513;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759958513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-09 02:20:35", "2025-10-09 05:50:35", "17189", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1259", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-08 21:41:49", "2025-10-08 21:41:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759959709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759959709;}", "7", "1", "2025-10-09 02:20:35", "2025-10-09 05:50:35", "17189", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1260", "woocommerce_refresh_order_count_cache", "complete", "2025-10-09 14:20:35", "2025-10-09 14:20:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760019635;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760019635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-09 14:51:39", "2025-10-09 18:21:39", "17212", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1261", "woocommerce_cleanup_sessions", "complete", "2025-10-09 14:20:35", "2025-10-09 14:20:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760019635;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760019635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-09 14:51:39", "2025-10-09 18:21:39", "17212", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1262", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 03:20:35", "2025-10-09 03:20:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759980035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759980035;}", "7", "1", "2025-10-09 06:52:02", "2025-10-09 10:22:02", "17192", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1263", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 07:52:02", "2025-10-09 07:52:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759996322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759996322;}", "7", "1", "2025-10-09 08:50:21", "2025-10-09 12:20:21", "17199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1264", "woocommerce_cleanup_draft_orders", "complete", "2025-10-10 06:52:02", "2025-10-10 06:52:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079122;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-10 07:42:45", "2025-10-10 11:12:45", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1265", "woocommerce_scheduled_sales", "complete", "2025-10-10 06:52:02", "2025-10-10 06:52:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079122;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-10 07:42:45", "2025-10-10 11:12:45", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1266", "wc_admin_daily_wrapper", "complete", "2025-10-10 06:52:03", "2025-10-10 06:52:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079123;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-10 07:42:46", "2025-10-10 11:12:46", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1267", "woocommerce_cleanup_personal_data", "complete", "2025-10-10 06:52:04", "2025-10-10 06:52:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079124;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-10 07:42:48", "2025-10-10 11:12:48", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1268", "woocommerce_cleanup_logs", "complete", "2025-10-10 06:52:04", "2025-10-10 06:52:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079124;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-10 07:42:48", "2025-10-10 11:12:48", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1269", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-10 06:52:04", "2025-10-10 06:52:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079124;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-10 07:42:48", "2025-10-10 11:12:48", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1270", "generate_category_lookup_table_wrapper", "complete", "2025-10-09 06:52:14", "2025-10-09 06:52:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759992734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759992734;}", "7", "1", "2025-10-09 07:07:46", "2025-10-09 10:37:46", "17194", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1271", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-10 06:52:04", "2025-10-10 06:52:04", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760079124;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760079124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-10 07:42:48", "2025-10-10 11:12:48", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1272", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 09:50:21", "2025-10-09 09:50:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760003421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760003421;}", "7", "1", "2025-10-09 10:03:53", "2025-10-09 13:33:53", "17203", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1273", "woocommerce_geoip_updater", "complete", "2025-10-24 08:50:21", "2025-10-24 08:50:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761295821;s:18:\"\0*\0first_timestamp\";i:1757393268;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761295821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "1", "2025-10-24 08:58:57", "2025-10-24 12:28:57", "17761", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1274", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 11:03:53", "2025-10-09 11:03:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760007833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760007833;}", "7", "1", "2025-10-09 12:55:16", "2025-10-09 16:25:16", "17205", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1275", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 13:55:16", "2025-10-09 13:55:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760018116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760018116;}", "7", "1", "2025-10-09 14:51:39", "2025-10-09 18:21:39", "17212", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1276", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 15:51:39", "2025-10-09 15:51:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760025099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760025099;}", "7", "1", "2025-10-09 16:02:43", "2025-10-09 19:32:43", "17218", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1277", "woocommerce_refresh_order_count_cache", "complete", "2025-10-10 02:51:39", "2025-10-10 02:51:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760064699;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760064699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-10 05:34:55", "2025-10-10 09:04:55", "17234", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1278", "woocommerce_cleanup_sessions", "complete", "2025-10-10 02:51:39", "2025-10-10 02:51:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760064699;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760064699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-10 05:34:55", "2025-10-10 09:04:55", "17234", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1279", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 17:02:43", "2025-10-09 17:02:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760029363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760029363;}", "7", "1", "2025-10-09 18:05:18", "2025-10-09 21:35:18", "17225", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1280", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 19:05:18", "2025-10-09 19:05:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760036718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760036718;}", "7", "1", "2025-10-09 21:19:04", "2025-10-10 00:49:04", "17230", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1281", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 22:19:04", "2025-10-09 22:19:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760048344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760048344;}", "7", "1", "2025-10-10 02:20:09", "2025-10-10 05:50:09", "17232", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1282", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 03:20:09", "2025-10-10 03:20:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760066409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760066409;}", "7", "1", "2025-10-10 05:34:55", "2025-10-10 09:04:55", "17234", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1283", "woocommerce_refresh_order_count_cache", "complete", "2025-10-10 17:34:55", "2025-10-10 17:34:55", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760117695;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760117695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-10 18:05:10", "2025-10-10 21:35:10", "17254", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1284", "woocommerce_cleanup_sessions", "complete", "2025-10-10 17:34:55", "2025-10-10 17:34:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760117695;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760117695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-10 18:05:10", "2025-10-10 21:35:10", "17254", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1285", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 06:34:55", "2025-10-10 06:34:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760078095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760078095;}", "7", "1", "2025-10-10 07:42:45", "2025-10-10 11:12:45", "17236", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1286", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 08:42:45", "2025-10-10 08:42:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760085765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760085765;}", "7", "1", "2025-10-10 10:05:06", "2025-10-10 13:35:06", "17238", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1287", "woocommerce_cleanup_draft_orders", "complete", "2025-10-11 07:42:45", "2025-10-11 07:42:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168565;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-11 08:48:34", "2025-10-11 12:18:34", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1288", "woocommerce_scheduled_sales", "complete", "2025-10-11 07:42:45", "2025-10-11 07:42:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168565;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-11 08:48:34", "2025-10-11 12:18:34", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1289", "wc_admin_daily_wrapper", "complete", "2025-10-11 07:42:46", "2025-10-11 07:42:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168566;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-11 08:48:34", "2025-10-11 12:18:34", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1290", "woocommerce_cleanup_personal_data", "complete", "2025-10-11 07:42:48", "2025-10-11 07:42:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168568;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-11 08:48:36", "2025-10-11 12:18:36", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1291", "woocommerce_cleanup_logs", "complete", "2025-10-11 07:42:48", "2025-10-11 07:42:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168568;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-11 08:48:36", "2025-10-11 12:18:36", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1292", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-11 07:42:48", "2025-10-11 07:42:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168568;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-11 08:48:36", "2025-10-11 12:18:36", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1293", "generate_category_lookup_table_wrapper", "complete", "2025-10-10 07:42:58", "2025-10-10 07:42:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760082178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760082178;}", "7", "1", "2025-10-10 10:05:06", "2025-10-10 13:35:06", "17238", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1294", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-11 07:42:48", "2025-10-11 07:42:48", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760168568;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760168568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-11 08:48:37", "2025-10-11 12:18:37", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1295", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 11:05:06", "2025-10-10 11:05:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760094306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760094306;}", "7", "1", "2025-10-10 11:25:15", "2025-10-10 14:55:15", "17241", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1296", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 12:25:15", "2025-10-10 12:25:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760099115;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760099115;}", "7", "1", "2025-10-10 12:31:50", "2025-10-10 16:01:50", "17245", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1297", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 13:31:50", "2025-10-10 13:31:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760103110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760103110;}", "7", "1", "2025-10-10 14:30:31", "2025-10-10 18:00:31", "17251", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1298", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 15:30:31", "2025-10-10 15:30:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760110231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760110231;}", "7", "1", "2025-10-10 18:05:10", "2025-10-10 21:35:10", "17254", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1299", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 19:05:10", "2025-10-10 19:05:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760123110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760123110;}", "7", "1", "2025-10-10 20:59:35", "2025-10-11 00:29:35", "17256", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1300", "woocommerce_refresh_order_count_cache", "complete", "2025-10-11 06:05:10", "2025-10-11 06:05:10", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760162710;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760162710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-11 07:12:36", "2025-10-11 10:42:36", "17264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1301", "woocommerce_cleanup_sessions", "complete", "2025-10-11 06:05:10", "2025-10-11 06:05:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760162710;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760162710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-11 07:12:36", "2025-10-11 10:42:36", "17264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1302", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 21:59:35", "2025-10-10 21:59:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760133575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760133575;}", "7", "1", "2025-10-11 01:29:17", "2025-10-11 04:59:17", "17260", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1303", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 02:29:17", "2025-10-11 02:29:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760149757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760149757;}", "7", "1", "2025-10-11 07:12:36", "2025-10-11 10:42:36", "17264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1304", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 08:12:36", "2025-10-11 08:12:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760170356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760170356;}", "7", "1", "2025-10-11 08:48:36", "2025-10-11 12:18:36", "17268", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1305", "woocommerce_refresh_order_count_cache", "complete", "2025-10-11 19:12:36", "2025-10-11 19:12:36", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760209956;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760209956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-11 20:39:36", "2025-10-12 00:09:36", "17303", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1306", "woocommerce_cleanup_sessions", "complete", "2025-10-11 19:12:36", "2025-10-11 19:12:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760209956;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760209956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-11 20:39:36", "2025-10-12 00:09:36", "17303", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1307", "woocommerce_cleanup_draft_orders", "complete", "2025-10-12 08:48:34", "2025-10-12 08:48:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258914;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-12 10:34:39", "2025-10-12 14:04:39", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1308", "woocommerce_scheduled_sales", "complete", "2025-10-12 08:48:34", "2025-10-12 08:48:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258914;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-12 10:34:39", "2025-10-12 14:04:39", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1309", "wc_admin_daily_wrapper", "complete", "2025-10-12 08:48:34", "2025-10-12 08:48:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258914;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-12 10:34:40", "2025-10-12 14:04:40", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1310", "woocommerce_cleanup_personal_data", "complete", "2025-10-12 08:48:36", "2025-10-12 08:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258916;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-12 10:34:41", "2025-10-12 14:04:41", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1311", "woocommerce_cleanup_logs", "complete", "2025-10-12 08:48:36", "2025-10-12 08:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258916;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-12 10:34:42", "2025-10-12 14:04:42", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1312", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-12 08:48:36", "2025-10-12 08:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258916;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-12 10:34:42", "2025-10-12 14:04:42", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1313", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 09:48:36", "2025-10-11 09:48:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760176116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760176116;}", "7", "1", "2025-10-11 12:36:25", "2025-10-11 16:06:25", "17276", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1314", "generate_category_lookup_table_wrapper", "complete", "2025-10-11 08:48:47", "2025-10-11 08:48:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760172527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760172527;}", "7", "1", "2025-10-11 08:59:50", "2025-10-11 12:29:50", "17271", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1315", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-12 08:48:37", "2025-10-12 08:48:37", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258917;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-12 10:34:42", "2025-10-12 14:04:42", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1316", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 13:36:25", "2025-10-11 13:36:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760189785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760189785;}", "7", "1", "2025-10-11 14:01:22", "2025-10-11 17:31:22", "17294", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1317", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 15:01:22", "2025-10-11 15:01:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760194882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760194882;}", "7", "1", "2025-10-11 16:08:51", "2025-10-11 19:38:51", "17298", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1318", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 17:08:51", "2025-10-11 17:08:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760202531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760202531;}", "7", "1", "2025-10-11 17:48:06", "2025-10-11 21:18:06", "17301", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1319", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 18:48:06", "2025-10-11 18:48:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760208486;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760208486;}", "7", "1", "2025-10-11 20:39:36", "2025-10-12 00:09:36", "17303", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1320", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 21:39:36", "2025-10-11 21:39:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760218776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760218776;}", "7", "1", "2025-10-12 02:20:01", "2025-10-12 05:50:01", "17305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1321", "woocommerce_refresh_order_count_cache", "complete", "2025-10-12 08:39:36", "2025-10-12 08:39:36", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258376;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-12 10:34:39", "2025-10-12 14:04:39", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1322", "woocommerce_cleanup_sessions", "complete", "2025-10-12 08:39:36", "2025-10-12 08:39:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760258376;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760258376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-12 10:34:39", "2025-10-12 14:04:39", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1323", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 03:20:00", "2025-10-12 03:20:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760239200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760239200;}", "7", "1", "2025-10-12 08:14:54", "2025-10-12 11:44:54", "17307", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1324", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 09:14:54", "2025-10-12 09:14:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760260494;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760260494;}", "7", "1", "2025-10-12 10:34:42", "2025-10-12 14:04:42", "17310", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1325", "woocommerce_refresh_order_count_cache", "complete", "2025-10-12 22:34:39", "2025-10-12 22:34:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760308479;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760308479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-13 02:19:48", "2025-10-13 05:49:48", "17343", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1326", "woocommerce_cleanup_sessions", "complete", "2025-10-12 22:34:39", "2025-10-12 22:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760308479;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760308479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-13 02:19:48", "2025-10-13 05:49:48", "17343", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1327", "woocommerce_cleanup_draft_orders", "complete", "2025-10-13 10:34:39", "2025-10-13 10:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351679;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-13 11:49:34", "2025-10-13 15:19:34", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1328", "woocommerce_scheduled_sales", "complete", "2025-10-13 10:34:39", "2025-10-13 10:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351679;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-13 11:49:34", "2025-10-13 15:19:34", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1329", "wc_admin_daily_wrapper", "complete", "2025-10-13 10:34:40", "2025-10-13 10:34:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351680;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-13 11:49:35", "2025-10-13 15:19:35", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1330", "woocommerce_cleanup_personal_data", "complete", "2025-10-13 10:34:41", "2025-10-13 10:34:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351681;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-13 11:49:36", "2025-10-13 15:19:36", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1331", "woocommerce_cleanup_logs", "complete", "2025-10-13 10:34:42", "2025-10-13 10:34:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351682;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-13 11:49:36", "2025-10-13 15:19:36", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1332", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-13 10:34:42", "2025-10-13 10:34:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351682;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-13 11:49:37", "2025-10-13 15:19:37", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1333", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 11:34:42", "2025-10-12 11:34:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760268882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760268882;}", "7", "1", "2025-10-12 11:42:55", "2025-10-12 15:12:55", "17315", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1334", "generate_category_lookup_table_wrapper", "complete", "2025-10-12 10:34:52", "2025-10-12 10:34:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760265292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760265292;}", "7", "1", "2025-10-12 10:40:41", "2025-10-12 14:10:41", "17313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1335", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-13 10:34:42", "2025-10-13 10:34:42", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760351682;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760351682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-13 11:49:37", "2025-10-13 15:19:37", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1336", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 12:42:55", "2025-10-12 12:42:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760272975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760272975;}", "7", "1", "2025-10-12 13:01:20", "2025-10-12 16:31:20", "17318", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1337", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 14:01:20", "2025-10-12 14:01:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760277680;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760277680;}", "7", "1", "2025-10-12 14:05:51", "2025-10-12 17:35:51", "17322", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1338", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 15:05:51", "2025-10-12 15:05:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760281551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760281551;}", "7", "1", "2025-10-12 15:41:29", "2025-10-12 19:11:29", "17332", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1339", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 16:41:28", "2025-10-12 16:41:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760287288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760287288;}", "7", "1", "2025-10-12 17:21:44", "2025-10-12 20:51:44", "17337", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1340", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 18:21:44", "2025-10-12 18:21:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760293304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760293304;}", "7", "1", "2025-10-12 18:46:34", "2025-10-12 22:16:34", "17339", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1341", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 19:46:34", "2025-10-12 19:46:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760298394;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760298394;}", "7", "1", "2025-10-13 02:19:48", "2025-10-13 05:49:48", "17343", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1342", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 03:19:48", "2025-10-13 03:19:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760325588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760325588;}", "7", "1", "2025-10-13 06:22:37", "2025-10-13 09:52:37", "17345", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1343", "woocommerce_refresh_order_count_cache", "complete", "2025-10-13 14:19:48", "2025-10-13 14:19:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760365188;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760365188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-13 14:50:32", "2025-10-13 18:20:32", "17361", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1344", "woocommerce_cleanup_sessions", "complete", "2025-10-13 14:19:48", "2025-10-13 14:19:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760365188;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760365188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-13 14:50:32", "2025-10-13 18:20:32", "17361", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1345", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 07:22:37", "2025-10-13 07:22:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760340157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760340157;}", "7", "1", "2025-10-13 09:36:38", "2025-10-13 13:06:38", "17351", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1346", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 10:36:38", "2025-10-13 10:36:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760351798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760351798;}", "7", "1", "2025-10-13 11:49:37", "2025-10-13 15:19:37", "17354", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1347", "woocommerce_cleanup_draft_orders", "complete", "2025-10-14 11:49:34", "2025-10-14 11:49:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442574;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-14 12:45:05", "2025-10-14 16:15:05", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1348", "woocommerce_scheduled_sales", "complete", "2025-10-14 11:49:34", "2025-10-14 11:49:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442574;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-14 12:45:06", "2025-10-14 16:15:06", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1349", "wc_admin_daily_wrapper", "complete", "2025-10-14 11:49:35", "2025-10-14 11:49:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442575;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-14 12:45:06", "2025-10-14 16:15:06", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1350", "woocommerce_cleanup_personal_data", "complete", "2025-10-14 11:49:36", "2025-10-14 11:49:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442576;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-14 12:45:08", "2025-10-14 16:15:08", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1351", "woocommerce_cleanup_logs", "complete", "2025-10-14 11:49:36", "2025-10-14 11:49:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442576;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-14 12:45:08", "2025-10-14 16:15:08", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1352", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-14 11:49:37", "2025-10-14 11:49:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442577;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-14 12:45:08", "2025-10-14 16:15:08", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1353", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 12:49:37", "2025-10-13 12:49:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760359777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760359777;}", "7", "1", "2025-10-13 13:38:48", "2025-10-13 17:08:48", "17359", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1354", "generate_category_lookup_table_wrapper", "complete", "2025-10-13 11:49:47", "2025-10-13 11:49:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760356187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760356187;}", "7", "1", "2025-10-13 12:21:44", "2025-10-13 15:51:44", "17356", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1355", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-14 11:49:37", "2025-10-14 11:49:37", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760442577;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760442577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-14 12:45:09", "2025-10-14 16:15:09", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1356", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 14:38:48", "2025-10-13 14:38:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760366328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760366328;}", "7", "1", "2025-10-13 14:50:33", "2025-10-13 18:20:33", "17361", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1357", "woocommerce_refresh_order_count_cache", "complete", "2025-10-14 02:50:32", "2025-10-14 02:50:32", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760410232;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760410232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-14 06:06:38", "2025-10-14 09:36:38", "17388", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1358", "woocommerce_cleanup_sessions", "complete", "2025-10-14 02:50:32", "2025-10-14 02:50:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760410232;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760410232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-14 06:06:38", "2025-10-14 09:36:38", "17388", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1359", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 15:50:32", "2025-10-13 15:50:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760370632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760370632;}", "7", "1", "2025-10-13 16:33:55", "2025-10-13 20:03:55", "17367", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1360", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 17:33:55", "2025-10-13 17:33:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760376835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760376835;}", "7", "1", "2025-10-13 17:48:08", "2025-10-13 21:18:08", "17373", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1361", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 18:48:08", "2025-10-13 18:48:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760381288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760381288;}", "7", "1", "2025-10-13 19:49:23", "2025-10-13 23:19:23", "17375", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1362", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 20:49:23", "2025-10-13 20:49:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760388563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760388563;}", "7", "1", "2025-10-13 21:22:52", "2025-10-14 00:52:52", "17379", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1363", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-13 22:22:52", "2025-10-13 22:22:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760394172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760394172;}", "7", "1", "2025-10-14 02:20:49", "2025-10-14 05:50:49", "17386", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1364", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 03:20:49", "2025-10-14 03:20:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760412049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760412049;}", "7", "1", "2025-10-14 06:06:38", "2025-10-14 09:36:38", "17388", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1365", "woocommerce_refresh_order_count_cache", "complete", "2025-10-14 18:06:38", "2025-10-14 18:06:38", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760465198;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760465198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-14 19:06:59", "2025-10-14 22:36:59", "17421", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1366", "woocommerce_cleanup_sessions", "complete", "2025-10-14 18:06:38", "2025-10-14 18:06:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760465198;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760465198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-14 19:06:59", "2025-10-14 22:36:59", "17421", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1367", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 07:06:38", "2025-10-14 07:06:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760425598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760425598;}", "7", "1", "2025-10-14 07:31:43", "2025-10-14 11:01:43", "17392", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1368", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 08:31:43", "2025-10-14 08:31:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760430703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760430703;}", "7", "1", "2025-10-14 09:40:11", "2025-10-14 13:10:11", "17395", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1369", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 10:40:11", "2025-10-14 10:40:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760438411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760438411;}", "7", "1", "2025-10-14 11:30:09", "2025-10-14 15:00:09", "17398", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1370", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 12:30:09", "2025-10-14 12:30:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760445009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760445009;}", "7", "1", "2025-10-14 12:45:08", "2025-10-14 16:15:08", "17401", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1371", "woocommerce_cleanup_draft_orders", "complete", "2025-10-15 12:45:06", "2025-10-15 12:45:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532306;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-15 14:38:00", "2025-10-15 18:08:00", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1372", "woocommerce_scheduled_sales", "complete", "2025-10-15 12:45:06", "2025-10-15 12:45:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532306;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-15 14:38:00", "2025-10-15 18:08:00", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1373", "wc_admin_daily_wrapper", "complete", "2025-10-15 12:45:07", "2025-10-15 12:45:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532307;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-15 14:38:00", "2025-10-15 18:08:00", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1374", "woocommerce_cleanup_personal_data", "complete", "2025-10-15 12:45:08", "2025-10-15 12:45:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532308;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-15 14:38:01", "2025-10-15 18:08:01", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1375", "woocommerce_cleanup_logs", "complete", "2025-10-15 12:45:08", "2025-10-15 12:45:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532308;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-15 14:38:02", "2025-10-15 18:08:02", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1376", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-15 12:45:08", "2025-10-15 12:45:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532308;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-15 14:38:02", "2025-10-15 18:08:02", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1377", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 13:45:08", "2025-10-14 13:45:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760449508;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760449508;}", "7", "1", "2025-10-14 13:47:49", "2025-10-14 17:17:49", "17405", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1378", "generate_category_lookup_table_wrapper", "complete", "2025-10-14 12:45:19", "2025-10-14 12:45:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760445919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760445919;}", "7", "1", "2025-10-14 13:35:49", "2025-10-14 17:05:49", "17403", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1379", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-15 12:45:09", "2025-10-15 12:45:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760532309;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760532309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-15 14:38:02", "2025-10-15 18:08:02", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1380", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 14:47:49", "2025-10-14 14:47:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760453269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760453269;}", "7", "1", "2025-10-14 15:55:39", "2025-10-14 19:25:39", "17407", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1381", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 16:55:39", "2025-10-14 16:55:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760460939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760460939;}", "7", "1", "2025-10-14 17:02:44", "2025-10-14 20:32:44", "17412", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1382", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 18:02:44", "2025-10-14 18:02:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760464964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760464964;}", "7", "1", "2025-10-14 18:02:54", "2025-10-14 21:32:54", "17417", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1383", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 19:02:54", "2025-10-14 19:02:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760468574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760468574;}", "7", "1", "2025-10-14 19:06:59", "2025-10-14 22:36:59", "17421", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1384", "woocommerce_refresh_order_count_cache", "complete", "2025-10-15 07:06:59", "2025-10-15 07:06:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760512019;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760512019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-15 07:28:24", "2025-10-15 10:58:24", "17448", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1385", "woocommerce_cleanup_sessions", "complete", "2025-10-15 07:06:59", "2025-10-15 07:06:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760512019;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760512019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-15 07:28:24", "2025-10-15 10:58:24", "17448", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1386", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 20:06:59", "2025-10-14 20:06:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760472419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760472419;}", "7", "1", "2025-10-14 20:59:16", "2025-10-15 00:29:16", "17424", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1387", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-14 21:59:16", "2025-10-14 21:59:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760479156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760479156;}", "7", "1", "2025-10-15 02:20:59", "2025-10-15 05:50:59", "17431", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1388", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 03:20:58", "2025-10-15 03:20:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760498458;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760498458;}", "7", "1", "2025-10-15 04:47:21", "2025-10-15 08:17:21", "17435", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1389", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 05:47:20", "2025-10-15 05:47:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760507240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760507240;}", "7", "1", "2025-10-15 05:48:32", "2025-10-15 09:18:32", "17441", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1390", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 06:48:31", "2025-10-15 06:48:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760510911;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760510911;}", "7", "1", "2025-10-15 06:53:56", "2025-10-15 10:23:56", "17446", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1391", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 07:53:56", "2025-10-15 07:53:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760514836;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760514836;}", "7", "1", "2025-10-15 07:58:25", "2025-10-15 11:28:25", "17450", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1392", "woocommerce_refresh_order_count_cache", "complete", "2025-10-15 19:28:24", "2025-10-15 19:28:24", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760556504;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760556504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-16 00:49:21", "2025-10-16 04:19:21", "17482", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1393", "woocommerce_cleanup_sessions", "complete", "2025-10-15 19:28:24", "2025-10-15 19:28:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760556504;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760556504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-16 00:49:21", "2025-10-16 04:19:21", "17482", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1394", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 08:58:25", "2025-10-15 08:58:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760518705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760518705;}", "7", "1", "2025-10-15 10:10:42", "2025-10-15 13:40:42", "17457", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1395", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 11:10:42", "2025-10-15 11:10:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760526642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760526642;}", "7", "1", "2025-10-15 11:12:40", "2025-10-15 14:42:40", "17460", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1396", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 12:12:40", "2025-10-15 12:12:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760530360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760530360;}", "7", "1", "2025-10-15 14:38:00", "2025-10-15 18:08:00", "17465", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1397", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 15:37:59", "2025-10-15 15:37:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760542679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760542679;}", "7", "1", "2025-10-15 15:56:33", "2025-10-15 19:26:33", "17471", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1398", "woocommerce_cleanup_draft_orders", "complete", "2025-10-16 14:38:00", "2025-10-16 14:38:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625480;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-16 14:45:33", "2025-10-16 18:15:33", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1399", "woocommerce_scheduled_sales", "complete", "2025-10-16 14:38:00", "2025-10-16 14:38:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625480;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-16 14:45:33", "2025-10-16 18:15:33", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1400", "wc_admin_daily_wrapper", "complete", "2025-10-16 14:38:00", "2025-10-16 14:38:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625480;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-16 14:45:34", "2025-10-16 18:15:34", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1401", "woocommerce_cleanup_personal_data", "complete", "2025-10-16 14:38:01", "2025-10-16 14:38:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625481;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-16 14:45:35", "2025-10-16 18:15:35", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1402", "woocommerce_cleanup_logs", "complete", "2025-10-16 14:38:02", "2025-10-16 14:38:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625482;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-16 14:45:35", "2025-10-16 18:15:35", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1403", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-16 14:38:02", "2025-10-16 14:38:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625482;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-16 14:45:35", "2025-10-16 18:15:35", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1404", "generate_category_lookup_table_wrapper", "complete", "2025-10-15 14:38:12", "2025-10-15 14:38:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760539092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760539092;}", "7", "1", "2025-10-15 14:45:09", "2025-10-15 18:15:09", "17467", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1405", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-16 14:38:02", "2025-10-16 14:38:02", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760625482;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760625482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-16 14:45:36", "2025-10-16 18:15:36", "17509", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1406", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 16:56:33", "2025-10-15 16:56:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760547393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760547393;}", "7", "1", "2025-10-15 17:35:36", "2025-10-15 21:05:36", "17476", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1407", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 18:35:36", "2025-10-15 18:35:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760553336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760553336;}", "7", "1", "2025-10-15 18:37:15", "2025-10-15 22:07:15", "17479", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1408", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-15 19:37:15", "2025-10-15 19:37:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760557035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760557035;}", "7", "1", "2025-10-16 00:49:21", "2025-10-16 04:19:21", "17482", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1409", "woocommerce_refresh_order_count_cache", "complete", "2025-10-16 12:49:21", "2025-10-16 12:49:21", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760618961;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760618961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-16 13:10:30", "2025-10-16 16:40:30", "17502", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1410", "woocommerce_cleanup_sessions", "complete", "2025-10-16 12:49:21", "2025-10-16 12:49:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760618961;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760618961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-16 13:10:30", "2025-10-16 16:40:30", "17502", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1411", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 01:49:21", "2025-10-16 01:49:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760579361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760579361;}", "7", "1", "2025-10-16 02:19:47", "2025-10-16 05:49:47", "17484", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1412", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 03:19:47", "2025-10-16 03:19:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760584787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760584787;}", "7", "1", "2025-10-16 06:05:30", "2025-10-16 09:35:30", "17487", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1413", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 07:05:30", "2025-10-16 07:05:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760598330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760598330;}", "7", "1", "2025-10-16 07:20:48", "2025-10-16 10:50:48", "17490", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1414", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 08:20:48", "2025-10-16 08:20:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760602848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760602848;}", "7", "1", "2025-10-16 09:08:20", "2025-10-16 12:38:20", "17493", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1415", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 10:08:20", "2025-10-16 10:08:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760609300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760609300;}", "7", "1", "2025-10-16 10:38:25", "2025-10-16 14:08:25", "17498", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1416", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 11:38:25", "2025-10-16 11:38:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760614705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760614705;}", "7", "1", "2025-10-16 13:10:30", "2025-10-16 16:40:30", "17502", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1417", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 14:10:30", "2025-10-16 14:10:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760623830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760623830;}", "7", "1", "2025-10-16 14:21:56", "2025-10-16 17:51:56", "17507", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1418", "woocommerce_refresh_order_count_cache", "complete", "2025-10-17 01:10:30", "2025-10-17 01:10:30", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760663430;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760663430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-17 02:20:15", "2025-10-17 05:50:15", "17532", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1419", "woocommerce_cleanup_sessions", "complete", "2025-10-17 01:10:30", "2025-10-17 01:10:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760663430;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760663430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-17 02:20:15", "2025-10-17 05:50:15", "17532", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1420", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 15:21:55", "2025-10-16 15:21:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760628115;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760628115;}", "7", "1", "2025-10-16 16:53:01", "2025-10-16 20:23:01", "17513", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1421", "woocommerce_cleanup_draft_orders", "complete", "2025-10-17 14:45:33", "2025-10-17 14:45:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712333;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-17 14:57:17", "2025-10-17 18:27:17", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1422", "woocommerce_scheduled_sales", "complete", "2025-10-17 14:45:33", "2025-10-17 14:45:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712333;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-17 14:57:18", "2025-10-17 18:27:18", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1423", "wc_admin_daily_wrapper", "complete", "2025-10-17 14:45:34", "2025-10-17 14:45:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712334;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-17 14:57:19", "2025-10-17 18:27:19", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1424", "woocommerce_cleanup_personal_data", "complete", "2025-10-17 14:45:35", "2025-10-17 14:45:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712335;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-17 14:57:20", "2025-10-17 18:27:20", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1425", "woocommerce_cleanup_logs", "complete", "2025-10-17 14:45:35", "2025-10-17 14:45:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712335;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-17 14:57:20", "2025-10-17 18:27:20", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1426", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-17 14:45:35", "2025-10-17 14:45:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712335;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-17 14:57:20", "2025-10-17 18:27:20", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1427", "generate_category_lookup_table_wrapper", "complete", "2025-10-16 14:45:46", "2025-10-16 14:45:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760625946;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760625946;}", "7", "1", "2025-10-16 14:45:48", "2025-10-16 18:15:48", "17511", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1428", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-17 14:45:36", "2025-10-17 14:45:36", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760712336;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760712336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-17 14:57:20", "2025-10-17 18:27:20", "17541", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1429", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 17:53:01", "2025-10-16 17:53:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760637181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760637181;}", "7", "1", "2025-10-16 18:28:17", "2025-10-16 21:58:17", "17522", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1430", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 19:28:17", "2025-10-16 19:28:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760642897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760642897;}", "7", "1", "2025-10-16 19:58:44", "2025-10-16 23:28:44", "17524", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1431", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 20:58:44", "2025-10-16 20:58:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760648324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760648324;}", "7", "1", "2025-10-16 21:42:57", "2025-10-17 01:12:57", "17526", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1432", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 22:42:57", "2025-10-16 22:42:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760654577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760654577;}", "7", "1", "2025-10-16 22:51:06", "2025-10-17 02:21:06", "17530", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1433", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-16 23:51:06", "2025-10-16 23:51:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760658666;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760658666;}", "7", "1", "2025-10-17 02:20:14", "2025-10-17 05:50:14", "17532", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1434", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-17 03:20:14", "2025-10-17 03:20:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760671214;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760671214;}", "7", "1", "2025-10-17 10:40:14", "2025-10-17 14:10:14", "17535", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1435", "woocommerce_refresh_order_count_cache", "complete", "2025-10-17 14:20:15", "2025-10-17 14:20:15", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760710815;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760710815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-17 14:43:38", "2025-10-17 18:13:38", "17538", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1436", "woocommerce_cleanup_sessions", "complete", "2025-10-17 14:20:15", "2025-10-17 14:20:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760710815;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760710815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-17 14:43:39", "2025-10-17 18:13:39", "17538", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1437", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-17 11:40:14", "2025-10-17 11:40:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760701214;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760701214;}", "7", "1", "2025-10-17 14:43:38", "2025-10-17 18:13:38", "17538", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1438", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-17 15:43:38", "2025-10-17 15:43:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760715818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760715818;}", "7", "1", "2025-10-17 15:57:18", "2025-10-17 19:27:18", "17543", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1439", "woocommerce_refresh_order_count_cache", "complete", "2025-10-18 02:43:39", "2025-10-18 02:43:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760755419;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760755419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-18 07:36:14", "2025-10-18 11:06:14", "17550", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1440", "woocommerce_cleanup_sessions", "complete", "2025-10-18 02:43:39", "2025-10-18 02:43:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760755419;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760755419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-18 07:36:14", "2025-10-18 11:06:14", "17550", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1441", "woocommerce_cleanup_draft_orders", "complete", "2025-10-18 14:57:17", "2025-10-18 14:57:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799437;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-18 15:50:42", "2025-10-18 19:20:42", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1442", "woocommerce_scheduled_sales", "complete", "2025-10-18 14:57:18", "2025-10-18 14:57:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799438;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-18 15:50:43", "2025-10-18 19:20:43", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1443", "wc_admin_daily_wrapper", "complete", "2025-10-18 14:57:19", "2025-10-18 14:57:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799439;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-18 15:50:43", "2025-10-18 19:20:43", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1444", "woocommerce_cleanup_personal_data", "complete", "2025-10-18 14:57:20", "2025-10-18 14:57:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799440;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-18 15:50:44", "2025-10-18 19:20:44", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1445", "woocommerce_cleanup_logs", "complete", "2025-10-18 14:57:20", "2025-10-18 14:57:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799440;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-18 15:50:44", "2025-10-18 19:20:44", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1446", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-18 14:57:20", "2025-10-18 14:57:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799440;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-18 15:50:45", "2025-10-18 19:20:45", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1447", "generate_category_lookup_table_wrapper", "complete", "2025-10-17 14:57:30", "2025-10-17 14:57:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760713050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760713050;}", "7", "1", "2025-10-17 15:57:18", "2025-10-17 19:27:18", "17543", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1448", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-18 14:57:20", "2025-10-18 14:57:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760799440;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760799440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-18 15:50:45", "2025-10-18 19:20:45", "17574", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1449", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-17 16:57:18", "2025-10-17 16:57:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760720238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760720238;}", "7", "1", "2025-10-17 17:08:16", "2025-10-17 20:38:16", "17545", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1450", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-17 18:08:16", "2025-10-17 18:08:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760724496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760724496;}", "7", "1", "2025-10-18 02:20:14", "2025-10-18 05:50:14", "17547", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1451", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 03:20:14", "2025-10-18 03:20:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760757614;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760757614;}", "7", "1", "2025-10-18 07:36:14", "2025-10-18 11:06:14", "17550", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1452", "woocommerce_refresh_order_count_cache", "complete", "2025-10-18 19:36:14", "2025-10-18 19:36:14", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760816174;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760816174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-18 20:21:43", "2025-10-18 23:51:43", "17585", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1453", "woocommerce_cleanup_sessions", "complete", "2025-10-18 19:36:14", "2025-10-18 19:36:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760816174;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760816174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-18 20:21:43", "2025-10-18 23:51:43", "17585", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1454", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 08:36:14", "2025-10-18 08:36:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760776574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760776574;}", "7", "1", "2025-10-18 08:39:01", "2025-10-18 12:09:01", "17556", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1455", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 09:39:01", "2025-10-18 09:39:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760780341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760780341;}", "7", "1", "2025-10-18 10:37:18", "2025-10-18 14:07:18", "17558", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1456", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 11:37:18", "2025-10-18 11:37:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760787438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760787438;}", "7", "1", "2025-10-18 11:53:56", "2025-10-18 15:23:56", "17560", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1457", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 12:53:56", "2025-10-18 12:53:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760792036;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760792036;}", "7", "1", "2025-10-18 13:07:07", "2025-10-18 16:37:07", "17565", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1458", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 14:07:07", "2025-10-18 14:07:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760796427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760796427;}", "7", "1", "2025-10-18 14:51:38", "2025-10-18 18:21:38", "17571", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1459", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 15:51:38", "2025-10-18 15:51:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760802698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760802698;}", "7", "1", "2025-10-18 16:31:48", "2025-10-18 20:01:48", "17577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1460", "woocommerce_cleanup_draft_orders", "complete", "2025-10-19 15:50:42", "2025-10-19 15:50:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889042;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-19 18:18:45", "2025-10-19 21:48:45", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1461", "woocommerce_scheduled_sales", "complete", "2025-10-19 15:50:43", "2025-10-19 15:50:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889043;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-19 18:18:45", "2025-10-19 21:48:45", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1462", "wc_admin_daily_wrapper", "complete", "2025-10-19 15:50:43", "2025-10-19 15:50:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889043;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-19 18:18:45", "2025-10-19 21:48:45", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1463", "woocommerce_cleanup_personal_data", "complete", "2025-10-19 15:50:44", "2025-10-19 15:50:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889044;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-19 18:18:46", "2025-10-19 21:48:46", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1464", "woocommerce_cleanup_logs", "complete", "2025-10-19 15:50:44", "2025-10-19 15:50:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889044;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-19 18:18:47", "2025-10-19 21:48:47", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1465", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-19 15:50:45", "2025-10-19 15:50:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889045;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-19 18:18:47", "2025-10-19 21:48:47", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1466", "generate_category_lookup_table_wrapper", "complete", "2025-10-18 15:50:55", "2025-10-18 15:50:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760802655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760802655;}", "7", "1", "2025-10-18 16:31:48", "2025-10-18 20:01:48", "17577", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1467", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-19 15:50:45", "2025-10-19 15:50:45", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760889045;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760889045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-19 18:18:47", "2025-10-19 21:48:47", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1468", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 17:31:48", "2025-10-18 17:31:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760808708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760808708;}", "7", "1", "2025-10-18 18:24:03", "2025-10-18 21:54:03", "17582", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1469", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 19:24:03", "2025-10-18 19:24:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760815443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760815443;}", "7", "1", "2025-10-18 20:21:43", "2025-10-18 23:51:43", "17585", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1470", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-18 21:21:43", "2025-10-18 21:21:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760822503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760822503;}", "7", "1", "2025-10-19 02:18:58", "2025-10-19 05:48:58", "17587", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1471", "woocommerce_refresh_order_count_cache", "complete", "2025-10-19 08:21:43", "2025-10-19 08:21:43", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760862103;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760862103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-19 08:25:28", "2025-10-19 11:55:28", "17592", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1472", "woocommerce_cleanup_sessions", "complete", "2025-10-19 08:21:43", "2025-10-19 08:21:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760862103;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760862103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-19 08:25:28", "2025-10-19 11:55:28", "17592", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1473", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 03:18:58", "2025-10-19 03:18:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760843938;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760843938;}", "7", "1", "2025-10-19 05:50:21", "2025-10-19 09:20:21", "17589", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1474", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 06:50:21", "2025-10-19 06:50:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760856621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760856621;}", "7", "1", "2025-10-19 08:25:28", "2025-10-19 11:55:28", "17592", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1475", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 09:25:28", "2025-10-19 09:25:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760865928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760865928;}", "7", "1", "2025-10-19 09:39:52", "2025-10-19 13:09:52", "17595", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1476", "woocommerce_refresh_order_count_cache", "complete", "2025-10-19 20:25:28", "2025-10-19 20:25:28", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760905528;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760905528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-19 20:35:20", "2025-10-20 00:05:20", "17612", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1477", "woocommerce_cleanup_sessions", "complete", "2025-10-19 20:25:28", "2025-10-19 20:25:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760905528;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760905528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-19 20:35:20", "2025-10-20 00:05:20", "17612", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1478", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 10:39:52", "2025-10-19 10:39:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760870392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760870392;}", "7", "1", "2025-10-19 12:48:35", "2025-10-19 16:18:35", "17597", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1479", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 13:48:35", "2025-10-19 13:48:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760881715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760881715;}", "7", "1", "2025-10-19 18:18:44", "2025-10-19 21:48:44", "17603", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1480", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 19:18:44", "2025-10-19 19:18:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760901524;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760901524;}", "7", "1", "2025-10-19 19:18:51", "2025-10-19 22:48:51", "17609", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1481", "woocommerce_cleanup_draft_orders", "complete", "2025-10-20 18:18:45", "2025-10-20 18:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984325;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-20 20:02:10", "2025-10-20 23:32:10", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1482", "woocommerce_scheduled_sales", "complete", "2025-10-20 18:18:45", "2025-10-20 18:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984325;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-20 20:02:11", "2025-10-20 23:32:11", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1483", "wc_admin_daily_wrapper", "complete", "2025-10-20 18:18:45", "2025-10-20 18:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984325;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-20 20:02:11", "2025-10-20 23:32:11", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1484", "woocommerce_cleanup_personal_data", "complete", "2025-10-20 18:18:46", "2025-10-20 18:18:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984326;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-20 20:02:12", "2025-10-20 23:32:12", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1485", "woocommerce_cleanup_logs", "complete", "2025-10-20 18:18:47", "2025-10-20 18:18:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984327;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-20 20:02:13", "2025-10-20 23:32:13", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1486", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-20 18:18:47", "2025-10-20 18:18:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984327;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-20 20:02:13", "2025-10-20 23:32:13", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1487", "generate_category_lookup_table_wrapper", "complete", "2025-10-19 18:18:57", "2025-10-19 18:18:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760897937;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760897937;}", "7", "1", "2025-10-19 18:27:15", "2025-10-19 21:57:15", "17605", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1488", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-20 18:18:47", "2025-10-20 18:18:47", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984327;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-20 20:02:13", "2025-10-20 23:32:13", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1489", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 20:18:51", "2025-10-19 20:18:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760905131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760905131;}", "7", "1", "2025-10-19 20:35:20", "2025-10-20 00:05:20", "17612", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1490", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 21:35:20", "2025-10-19 21:35:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760909720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760909720;}", "7", "1", "2025-10-19 22:34:15", "2025-10-20 02:04:15", "17617", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1491", "woocommerce_refresh_order_count_cache", "complete", "2025-10-20 08:35:20", "2025-10-20 08:35:20", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760949320;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760949320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-20 09:29:20", "2025-10-20 12:59:20", "17629", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1492", "woocommerce_cleanup_sessions", "complete", "2025-10-20 08:35:20", "2025-10-20 08:35:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760949320;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760949320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-20 09:29:20", "2025-10-20 12:59:20", "17629", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1493", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-19 23:34:15", "2025-10-19 23:34:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760916855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760916855;}", "7", "1", "2025-10-20 02:19:04", "2025-10-20 05:49:04", "17619", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1494", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 03:19:04", "2025-10-20 03:19:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760930344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760930344;}", "7", "1", "2025-10-20 05:10:01", "2025-10-20 08:40:01", "17621", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1495", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 06:10:01", "2025-10-20 06:10:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760940601;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760940601;}", "7", "1", "2025-10-20 06:20:49", "2025-10-20 09:50:49", "17623", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1496", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 07:20:49", "2025-10-20 07:20:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760944849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760944849;}", "7", "1", "2025-10-20 07:57:44", "2025-10-20 11:27:44", "17625", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1497", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 08:57:44", "2025-10-20 08:57:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760950664;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760950664;}", "7", "1", "2025-10-20 09:29:20", "2025-10-20 12:59:20", "17629", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1498", "woocommerce_refresh_order_count_cache", "complete", "2025-10-20 21:29:20", "2025-10-20 21:29:20", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760995760;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760995760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-20 21:48:57", "2025-10-21 01:18:57", "17672", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1499", "woocommerce_cleanup_sessions", "complete", "2025-10-20 21:29:20", "2025-10-20 21:29:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760995760;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760995760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-20 21:48:57", "2025-10-21 01:18:57", "17672", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1500", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 10:29:20", "2025-10-20 10:29:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760956160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760956160;}", "7", "1", "2025-10-20 11:34:14", "2025-10-20 15:04:14", "17634", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1501", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 12:34:14", "2025-10-20 12:34:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760963654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760963654;}", "7", "1", "2025-10-20 13:12:05", "2025-10-20 16:42:05", "17637", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1502", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 14:12:05", "2025-10-20 14:12:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760969525;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760969525;}", "7", "1", "2025-10-20 14:32:56", "2025-10-20 18:02:56", "17640", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1503", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 15:32:56", "2025-10-20 15:32:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760974376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760974376;}", "7", "1", "2025-10-20 16:07:19", "2025-10-20 19:37:19", "17644", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1504", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 17:07:19", "2025-10-20 17:07:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760980039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760980039;}", "7", "1", "2025-10-20 17:07:57", "2025-10-20 20:37:57", "17654", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1505", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 18:07:57", "2025-10-20 18:07:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760983677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760983677;}", "7", "1", "2025-10-20 20:02:10", "2025-10-20 23:32:10", "17667", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1506", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 21:02:10", "2025-10-20 21:02:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760994130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760994130;}", "7", "1", "2025-10-20 21:48:57", "2025-10-21 01:18:57", "17672", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1507", "woocommerce_cleanup_draft_orders", "complete", "2025-10-21 20:02:11", "2025-10-21 20:02:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076931;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-22 02:22:10", "2025-10-22 05:52:10", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1508", "woocommerce_scheduled_sales", "complete", "2025-10-21 20:02:11", "2025-10-21 20:02:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076931;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-22 02:22:10", "2025-10-22 05:52:10", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1509", "wc_admin_daily_wrapper", "complete", "2025-10-21 20:02:11", "2025-10-21 20:02:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076931;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-22 02:22:11", "2025-10-22 05:52:11", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1510", "woocommerce_cleanup_personal_data", "complete", "2025-10-21 20:02:13", "2025-10-21 20:02:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076933;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1511", "woocommerce_cleanup_logs", "complete", "2025-10-21 20:02:13", "2025-10-21 20:02:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076933;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1512", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-21 20:02:13", "2025-10-21 20:02:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076933;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1513", "generate_category_lookup_table_wrapper", "complete", "2025-10-20 20:02:23", "2025-10-20 20:02:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760990543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760990543;}", "7", "1", "2025-10-20 20:03:07", "2025-10-20 23:33:07", "17669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1514", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-21 20:02:13", "2025-10-21 20:02:13", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761076933;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761076933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-22 02:22:13", "2025-10-22 05:52:13", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1515", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-20 22:48:57", "2025-10-20 22:48:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761000537;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761000537;}", "7", "1", "2025-10-21 02:19:27", "2025-10-21 05:49:27", "17677", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1516", "woocommerce_refresh_order_count_cache", "complete", "2025-10-21 09:48:57", "2025-10-21 09:48:57", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761040137;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761040137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-21 13:21:59", "2025-10-21 16:51:59", "17688", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1517", "woocommerce_cleanup_sessions", "complete", "2025-10-21 09:48:57", "2025-10-21 09:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761040137;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761040137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-21 13:21:59", "2025-10-21 16:51:59", "17688", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1518", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 03:19:27", "2025-10-21 03:19:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761016767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761016767;}", "7", "1", "2025-10-21 05:53:32", "2025-10-21 09:23:32", "17680", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1519", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 06:53:32", "2025-10-21 06:53:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761029612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761029612;}", "7", "1", "2025-10-21 06:55:24", "2025-10-21 10:25:24", "17683", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1520", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 07:55:24", "2025-10-21 07:55:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761033324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761033324;}", "7", "1", "2025-10-21 09:27:07", "2025-10-21 12:57:07", "17685", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1521", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 10:27:07", "2025-10-21 10:27:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761042427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761042427;}", "7", "1", "2025-10-21 13:21:59", "2025-10-21 16:51:59", "17688", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1522", "woocommerce_refresh_order_count_cache", "complete", "2025-10-22 01:21:59", "2025-10-22 01:21:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761096119;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761096119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1523", "woocommerce_cleanup_sessions", "complete", "2025-10-22 01:21:59", "2025-10-22 01:21:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761096119;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761096119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1524", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 14:21:59", "2025-10-21 14:21:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761056519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761056519;}", "7", "1", "2025-10-21 19:19:40", "2025-10-21 22:49:40", "17691", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1525", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-21 20:19:40", "2025-10-21 20:19:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761077980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761077980;}", "7", "1", "2025-10-22 02:22:12", "2025-10-22 05:52:12", "17694", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1526", "woocommerce_cleanup_draft_orders", "complete", "2025-10-23 02:22:10", "2025-10-23 02:22:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186130;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-23 02:23:08", "2025-10-23 05:53:08", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1527", "woocommerce_scheduled_sales", "complete", "2025-10-23 02:22:10", "2025-10-23 02:22:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186130;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-23 02:23:08", "2025-10-23 05:53:08", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1528", "wc_admin_daily_wrapper", "complete", "2025-10-23 02:22:11", "2025-10-23 02:22:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186131;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-23 02:23:08", "2025-10-23 05:53:08", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1529", "woocommerce_cleanup_personal_data", "complete", "2025-10-23 02:22:12", "2025-10-23 02:22:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186132;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-23 02:23:09", "2025-10-23 05:53:09", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1530", "woocommerce_cleanup_logs", "complete", "2025-10-23 02:22:12", "2025-10-23 02:22:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186132;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-23 02:23:10", "2025-10-23 05:53:10", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1531", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-23 02:22:12", "2025-10-23 02:22:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186132;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-23 02:23:10", "2025-10-23 05:53:10", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1532", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 03:22:12", "2025-10-22 03:22:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761103332;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761103332;}", "7", "1", "2025-10-22 05:53:05", "2025-10-22 09:23:05", "17696", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1533", "woocommerce_refresh_order_count_cache", "complete", "2025-10-22 14:22:12", "2025-10-22 14:22:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761142932;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761142932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-22 15:10:35", "2025-10-22 18:40:35", "17714", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1534", "woocommerce_cleanup_sessions", "complete", "2025-10-22 14:22:12", "2025-10-22 14:22:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761142932;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761142932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-22 15:10:35", "2025-10-22 18:40:35", "17714", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1535", "generate_category_lookup_table_wrapper", "complete", "2025-10-22 02:22:23", "2025-10-22 02:22:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761099743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761099743;}", "7", "1", "2025-10-22 05:53:05", "2025-10-22 09:23:05", "17696", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1536", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-23 02:22:13", "2025-10-23 02:22:13", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186133;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-23 02:23:10", "2025-10-23 05:53:10", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1537", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 06:53:05", "2025-10-22 06:53:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761115985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761115985;}", "7", "1", "2025-10-22 08:25:55", "2025-10-22 11:55:55", "17698", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1538", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 09:25:55", "2025-10-22 09:25:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761125155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761125155;}", "7", "1", "2025-10-22 10:15:12", "2025-10-22 13:45:12", "17700", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1539", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 11:15:12", "2025-10-22 11:15:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761131712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761131712;}", "7", "1", "2025-10-22 12:29:31", "2025-10-22 15:59:31", "17706", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1540", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 13:29:31", "2025-10-22 13:29:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761139771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761139771;}", "7", "1", "2025-10-22 15:10:35", "2025-10-22 18:40:35", "17714", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1541", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 16:10:35", "2025-10-22 16:10:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761149435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761149435;}", "7", "1", "2025-10-22 16:40:45", "2025-10-22 20:10:45", "17716", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1542", "woocommerce_refresh_order_count_cache", "complete", "2025-10-23 03:10:35", "2025-10-23 03:10:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761189035;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761189035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1543", "woocommerce_cleanup_sessions", "complete", "2025-10-23 03:10:35", "2025-10-23 03:10:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761189035;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761189035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1544", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 17:40:45", "2025-10-22 17:40:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761154845;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761154845;}", "7", "1", "2025-10-22 20:13:12", "2025-10-22 23:43:12", "17719", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1545", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 21:13:12", "2025-10-22 21:13:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761167592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761167592;}", "7", "1", "2025-10-22 21:37:39", "2025-10-23 01:07:39", "17724", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1546", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-22 22:37:39", "2025-10-22 22:37:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761172659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761172659;}", "7", "1", "2025-10-23 02:23:08", "2025-10-23 05:53:08", "17728", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1547", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-23 03:23:08", "2025-10-23 03:23:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761189788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761189788;}", "7", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1548", "woocommerce_cleanup_draft_orders", "complete", "2025-10-24 02:23:08", "2025-10-24 02:23:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272588;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-24 03:08:38", "2025-10-24 06:38:38", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1549", "woocommerce_scheduled_sales", "complete", "2025-10-24 02:23:08", "2025-10-24 02:23:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272588;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-24 03:08:38", "2025-10-24 06:38:38", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1550", "wc_admin_daily_wrapper", "complete", "2025-10-24 02:23:08", "2025-10-24 02:23:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272588;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-24 03:08:39", "2025-10-24 06:38:39", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1551", "woocommerce_cleanup_personal_data", "complete", "2025-10-24 02:23:09", "2025-10-24 02:23:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272589;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-24 03:08:40", "2025-10-24 06:38:40", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1552", "woocommerce_cleanup_logs", "complete", "2025-10-24 02:23:10", "2025-10-24 02:23:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272590;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-24 03:08:40", "2025-10-24 06:38:40", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1553", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-24 02:23:10", "2025-10-24 02:23:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272590;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-24 03:08:40", "2025-10-24 06:38:40", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1554", "generate_category_lookup_table_wrapper", "complete", "2025-10-23 02:23:20", "2025-10-23 02:23:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761186200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761186200;}", "7", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1555", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-24 02:23:10", "2025-10-24 02:23:10", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761272590;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761272590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-24 03:08:40", "2025-10-24 06:38:40", "17752", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1556", "fetch_patterns", "complete", "2025-10-23 02:23:49", "2025-10-23 02:23:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761186229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761186229;}", "2", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1557", "woocommerce_run_update_callback", "complete", "2025-10-23 02:23:56", "2025-10-23 02:23:56", "10", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761186236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761186236;}", "4", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1558", "woocommerce_update_db_to_current_version", "complete", "2025-10-23 02:23:57", "2025-10-23 02:23:57", "10", "{\"version\":\"10.3.0\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761186237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761186237;}", "4", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1559", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-10-23 02:23:57", "2025-10-23 02:23:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761186237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761186237;}", "4", "1", "2025-10-23 10:21:16", "2025-10-23 13:51:16", "17730", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1560", "woocommerce_refresh_order_count_cache", "complete", "2025-10-23 22:21:16", "2025-10-23 22:21:16", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761258076;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761258076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-24 02:20:40", "2025-10-24 05:50:40", "17749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1561", "woocommerce_cleanup_sessions", "complete", "2025-10-23 22:21:16", "2025-10-23 22:21:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761258076;s:18:\"\0*\0first_timestamp\";i:1757414808;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761258076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-24 02:20:40", "2025-10-24 05:50:40", "17749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1562", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-23 11:21:16", "2025-10-23 11:21:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761218476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761218476;}", "7", "1", "2025-10-23 12:35:28", "2025-10-23 16:05:28", "17732", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1563", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-23 13:35:28", "2025-10-23 13:35:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761226528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761226528;}", "7", "1", "2025-10-23 14:15:31", "2025-10-23 17:45:31", "17742", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1564", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-23 15:15:31", "2025-10-23 15:15:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761232531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761232531;}", "7", "1", "2025-10-23 18:43:30", "2025-10-23 22:13:30", "17747", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1565", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-23 19:43:30", "2025-10-23 19:43:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761248610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761248610;}", "7", "1", "2025-10-24 02:20:39", "2025-10-24 05:50:39", "17749", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1566", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 03:20:39", "2025-10-24 03:20:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761276039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761276039;}", "7", "1", "2025-10-24 06:42:56", "2025-10-24 10:12:56", "17754", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1567", "woocommerce_refresh_order_count_cache", "complete", "2025-10-24 14:20:40", "2025-10-24 14:20:40", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761315640;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761315640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-24 15:33:26", "2025-10-24 19:03:26", "17769", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1569", "woocommerce_cleanup_draft_orders", "complete", "2025-10-25 03:08:38", "2025-10-25 03:08:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361718;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-25 10:27:48", "2025-10-25 13:57:48", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1570", "woocommerce_scheduled_sales", "complete", "2025-10-25 03:08:39", "2025-10-25 03:08:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361719;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361719;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-25 10:27:49", "2025-10-25 13:57:49", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1571", "wc_admin_daily_wrapper", "complete", "2025-10-25 03:08:39", "2025-10-25 03:08:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361719;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361719;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-25 10:27:49", "2025-10-25 13:57:49", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1572", "woocommerce_cleanup_personal_data", "complete", "2025-10-25 03:08:40", "2025-10-25 03:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361720;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-25 10:27:51", "2025-10-25 13:57:51", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1573", "woocommerce_cleanup_logs", "complete", "2025-10-25 03:08:40", "2025-10-25 03:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361720;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-25 10:27:51", "2025-10-25 13:57:51", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1574", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-25 03:08:40", "2025-10-25 03:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361720;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-25 10:27:51", "2025-10-25 13:57:51", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1575", "woocommerce_cleanup_sessions", "complete", "2025-10-25 03:00:00", "2025-10-25 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361200;s:18:\"\0*\0first_timestamp\";i:1761361200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-25 10:27:48", "2025-10-25 13:57:48", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1576", "generate_category_lookup_table_wrapper", "complete", "2025-10-24 03:08:50", "2025-10-24 03:08:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761275330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761275330;}", "7", "1", "2025-10-24 06:42:56", "2025-10-24 10:12:56", "17754", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1577", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-25 03:08:40", "2025-10-25 03:08:40", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761361720;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761361720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-25 10:27:52", "2025-10-25 13:57:52", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1578", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 07:42:56", "2025-10-24 07:42:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761291776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761291776;}", "7", "1", "2025-10-24 08:43:32", "2025-10-24 12:13:32", "17757", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1579", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 09:43:32", "2025-10-24 09:43:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761299012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761299012;}", "7", "1", "2025-10-24 10:18:59", "2025-10-24 13:48:59", "17763", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1580", "woocommerce_geoip_updater", "complete", "2025-11-08 08:58:57", "2025-11-08 08:58:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762592337;s:18:\"\0*\0first_timestamp\";i:1757393268;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762592337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "1", "2025-11-08 08:59:09", "2025-11-08 12:29:09", "18308", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1581", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 11:18:59", "2025-10-24 11:18:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761304739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761304739;}", "7", "1", "2025-10-24 11:52:25", "2025-10-24 15:22:25", "17765", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1582", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 12:52:25", "2025-10-24 12:52:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761310345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761310345;}", "7", "1", "2025-10-24 13:31:17", "2025-10-24 17:01:17", "17767", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1583", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 14:31:17", "2025-10-24 14:31:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761316277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761316277;}", "7", "1", "2025-10-24 15:33:26", "2025-10-24 19:03:26", "17769", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1584", "woocommerce_refresh_order_count_cache", "complete", "2025-10-25 03:33:26", "2025-10-25 03:33:26", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761363206;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761363206;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-25 10:27:51", "2025-10-25 13:57:51", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1585", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 16:33:26", "2025-10-24 16:33:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761323606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761323606;}", "7", "1", "2025-10-24 18:13:42", "2025-10-24 21:43:42", "17776", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1586", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 19:13:42", "2025-10-24 19:13:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761333222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761333222;}", "7", "1", "2025-10-24 21:06:53", "2025-10-25 00:36:53", "17781", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1587", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 22:06:53", "2025-10-24 22:06:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761343613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761343613;}", "7", "1", "2025-10-24 22:11:02", "2025-10-25 01:41:02", "17785", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1588", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-24 23:11:02", "2025-10-24 23:11:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761347462;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761347462;}", "7", "1", "2025-10-25 02:20:57", "2025-10-25 05:50:57", "17788", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1589", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 03:20:57", "2025-10-25 03:20:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761362457;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761362457;}", "7", "1", "2025-10-25 10:27:51", "2025-10-25 13:57:51", "17792", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1590", "fetch_patterns", "complete", "2025-10-25 02:21:37", "2025-10-25 02:21:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761358897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761358897;}", "2", "1", "2025-10-25 02:21:47", "2025-10-25 05:51:47", "17790", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1591", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-10-25 02:21:45", "2025-10-25 02:21:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761358905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761358905;}", "4", "1", "2025-10-25 02:21:47", "2025-10-25 05:51:47", "17790", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1593", "woocommerce_cleanup_draft_orders", "complete", "2025-10-26 10:27:48", "2025-10-26 10:27:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474468;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-26 13:18:43", "2025-10-26 16:48:43", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1594", "woocommerce_scheduled_sales", "complete", "2025-10-26 10:27:49", "2025-10-26 10:27:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474469;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-26 13:18:44", "2025-10-26 16:48:44", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1595", "wc_admin_daily_wrapper", "complete", "2025-10-26 10:27:49", "2025-10-26 10:27:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474469;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-26 13:18:44", "2025-10-26 16:48:44", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1596", "woocommerce_cleanup_personal_data", "complete", "2025-10-26 10:27:51", "2025-10-26 10:27:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474471;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-26 13:18:45", "2025-10-26 16:48:45", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1597", "woocommerce_cleanup_logs", "complete", "2025-10-26 10:27:51", "2025-10-26 10:27:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474471;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-26 13:18:45", "2025-10-26 16:48:45", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1598", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-26 10:27:51", "2025-10-26 10:27:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474471;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-26 13:18:46", "2025-10-26 16:48:46", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1599", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 11:27:51", "2025-10-25 11:27:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761391671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761391671;}", "7", "1", "2025-10-25 11:29:16", "2025-10-25 14:59:16", "17798", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1600", "woocommerce_refresh_order_count_cache", "complete", "2025-10-25 22:27:52", "2025-10-25 22:27:52", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761431272;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761431272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-26 02:20:24", "2025-10-26 05:50:24", "17814", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1601", "woocommerce_cleanup_sessions", "complete", "2025-10-26 03:00:00", "2025-10-26 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761447600;s:18:\"\0*\0first_timestamp\";i:1761447600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761447600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-26 06:05:47", "2025-10-26 09:35:47", "17817", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1602", "generate_category_lookup_table_wrapper", "complete", "2025-10-25 10:28:02", "2025-10-25 10:28:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761388082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761388082;}", "7", "1", "2025-10-25 10:59:57", "2025-10-25 14:29:57", "17794", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1603", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-26 10:27:52", "2025-10-26 10:27:52", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761474472;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761474472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-26 13:18:46", "2025-10-26 16:48:46", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1604", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 12:29:16", "2025-10-25 12:29:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761395356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761395356;}", "7", "1", "2025-10-25 12:29:57", "2025-10-25 15:59:57", "17801", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1605", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 13:29:57", "2025-10-25 13:29:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761398997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761398997;}", "7", "1", "2025-10-25 13:59:16", "2025-10-25 17:29:16", "17803", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1606", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 14:59:16", "2025-10-25 14:59:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761404356;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761404356;}", "7", "1", "2025-10-25 16:06:32", "2025-10-25 19:36:32", "17805", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1607", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 17:06:32", "2025-10-25 17:06:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761411992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761411992;}", "7", "1", "2025-10-25 17:43:54", "2025-10-25 21:13:54", "17807", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1608", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 18:43:54", "2025-10-25 18:43:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761417834;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761417834;}", "7", "1", "2025-10-25 19:31:53", "2025-10-25 23:01:53", "17812", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1609", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-25 20:31:53", "2025-10-25 20:31:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761424313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761424313;}", "7", "1", "2025-10-26 02:20:24", "2025-10-26 05:50:24", "17814", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1610", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 03:20:23", "2025-10-26 03:20:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761448823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761448823;}", "7", "1", "2025-10-26 06:05:47", "2025-10-26 09:35:47", "17817", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1611", "woocommerce_refresh_order_count_cache", "complete", "2025-10-26 14:20:24", "2025-10-26 14:20:24", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761488424;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761488424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-26 14:21:17", "2025-10-26 17:51:17", "17835", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1613", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 07:05:47", "2025-10-26 07:05:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761462347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761462347;}", "7", "1", "2025-10-26 08:17:02", "2025-10-26 11:47:02", "17822", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1614", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 09:17:02", "2025-10-26 09:17:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761470222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761470222;}", "7", "1", "2025-10-26 09:42:17", "2025-10-26 13:12:17", "17824", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1615", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 10:42:16", "2025-10-26 10:42:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761475336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761475336;}", "7", "1", "2025-10-26 13:18:46", "2025-10-26 16:48:46", "17831", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1616", "woocommerce_cleanup_draft_orders", "complete", "2025-10-27 13:18:43", "2025-10-27 13:18:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571123;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-27 14:08:38", "2025-10-27 17:38:38", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1617", "woocommerce_scheduled_sales", "complete", "2025-10-27 13:18:44", "2025-10-27 13:18:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571124;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 14:08:38", "2025-10-27 17:38:38", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1618", "wc_admin_daily_wrapper", "complete", "2025-10-27 13:18:44", "2025-10-27 13:18:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571124;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 14:08:39", "2025-10-27 17:38:39", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1619", "woocommerce_cleanup_personal_data", "complete", "2025-10-27 13:18:45", "2025-10-27 13:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571125;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 14:08:40", "2025-10-27 17:38:40", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1620", "woocommerce_cleanup_logs", "complete", "2025-10-27 13:18:45", "2025-10-27 13:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571125;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 14:08:40", "2025-10-27 17:38:40", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1621", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-27 13:18:46", "2025-10-27 13:18:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571126;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-27 14:08:40", "2025-10-27 17:38:40", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1622", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 14:18:46", "2025-10-26 14:18:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761488326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761488326;}", "7", "1", "2025-10-26 14:21:17", "2025-10-26 17:51:17", "17835", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1623", "woocommerce_cleanup_sessions", "complete", "2025-10-27 03:00:00", "2025-10-27 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761534000;s:18:\"\0*\0first_timestamp\";i:1761534000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761534000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-27 04:55:17", "2025-10-27 08:25:17", "17858", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1624", "generate_category_lookup_table_wrapper", "complete", "2025-10-26 13:18:56", "2025-10-26 13:18:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761484736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761484736;}", "7", "1", "2025-10-26 13:26:09", "2025-10-26 16:56:09", "17833", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1625", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-27 13:18:46", "2025-10-27 13:18:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761571126;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761571126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-27 14:08:40", "2025-10-27 17:38:40", "17873", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1626", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 15:21:17", "2025-10-26 15:21:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761492077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761492077;}", "7", "1", "2025-10-26 16:06:22", "2025-10-26 19:36:22", "17837", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1627", "woocommerce_refresh_order_count_cache", "complete", "2025-10-27 02:21:17", "2025-10-27 02:21:17", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761531677;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761531677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-27 04:55:17", "2025-10-27 08:25:17", "17858", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1628", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 17:06:22", "2025-10-26 17:06:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761498382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761498382;}", "7", "1", "2025-10-26 17:17:04", "2025-10-26 20:47:04", "17846", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1629", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 18:17:04", "2025-10-26 18:17:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761502624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761502624;}", "7", "1", "2025-10-26 21:24:10", "2025-10-27 00:54:10", "17849", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1630", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-26 22:24:10", "2025-10-26 22:24:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761517450;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761517450;}", "7", "1", "2025-10-27 01:51:54", "2025-10-27 05:21:54", "17854", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1631", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 02:51:54", "2025-10-27 02:51:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761533514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761533514;}", "7", "1", "2025-10-27 04:55:17", "2025-10-27 08:25:17", "17858", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1632", "woocommerce_refresh_order_count_cache", "complete", "2025-10-27 16:55:17", "2025-10-27 16:55:17", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761584117;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761584117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-27 17:43:00", "2025-10-27 21:13:00", "17881", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1633", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 05:55:17", "2025-10-27 05:55:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761544517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761544517;}", "7", "1", "2025-10-27 06:12:34", "2025-10-27 09:42:34", "17861", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1635", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 07:12:34", "2025-10-27 07:12:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761549154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761549154;}", "7", "1", "2025-10-27 08:29:06", "2025-10-27 11:59:06", "17865", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1636", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 09:29:06", "2025-10-27 09:29:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761557346;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761557346;}", "7", "1", "2025-10-27 13:16:05", "2025-10-27 16:46:05", "17871", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1637", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 14:16:05", "2025-10-27 14:16:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761574565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761574565;}", "7", "1", "2025-10-27 15:23:43", "2025-10-27 18:53:43", "17876", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1638", "woocommerce_cleanup_draft_orders", "complete", "2025-10-28 14:08:38", "2025-10-28 14:08:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660518;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-28 15:06:45", "2025-10-28 18:36:45", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1639", "woocommerce_scheduled_sales", "complete", "2025-10-28 14:08:38", "2025-10-28 14:08:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660518;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-28 15:06:45", "2025-10-28 18:36:45", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1640", "wc_admin_daily_wrapper", "complete", "2025-10-28 14:08:39", "2025-10-28 14:08:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660519;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-28 15:06:46", "2025-10-28 18:36:46", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1641", "woocommerce_cleanup_personal_data", "complete", "2025-10-28 14:08:40", "2025-10-28 14:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660520;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-28 15:06:47", "2025-10-28 18:36:47", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1642", "woocommerce_cleanup_logs", "complete", "2025-10-28 14:08:40", "2025-10-28 14:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660520;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-28 15:06:48", "2025-10-28 18:36:48", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1643", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-28 14:08:40", "2025-10-28 14:08:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660520;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-28 15:06:48", "2025-10-28 18:36:48", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1644", "woocommerce_cleanup_sessions", "complete", "2025-10-28 03:00:00", "2025-10-28 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761620400;s:18:\"\0*\0first_timestamp\";i:1761620400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761620400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-28 05:28:16", "2025-10-28 08:58:16", "17891", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1645", "generate_category_lookup_table_wrapper", "complete", "2025-10-27 14:08:50", "2025-10-27 14:08:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761574130;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761574130;}", "7", "1", "2025-10-27 15:23:43", "2025-10-27 18:53:43", "17876", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1646", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-28 14:08:40", "2025-10-28 14:08:40", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761660520;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761660520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-28 15:06:48", "2025-10-28 18:36:48", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1647", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 16:23:43", "2025-10-27 16:23:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761582223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761582223;}", "7", "1", "2025-10-27 17:43:00", "2025-10-27 21:13:00", "17881", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1648", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 18:43:00", "2025-10-27 18:43:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761590580;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761590580;}", "7", "1", "2025-10-27 21:33:13", "2025-10-28 01:03:13", "17885", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1649", "woocommerce_refresh_order_count_cache", "complete", "2025-10-28 05:43:00", "2025-10-28 05:43:00", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761630180;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761630180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-28 07:41:42", "2025-10-28 11:11:42", "17893", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1650", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-27 22:33:13", "2025-10-27 22:33:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761604393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761604393;}", "7", "1", "2025-10-28 02:20:34", "2025-10-28 05:50:34", "17888", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1651", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 03:20:34", "2025-10-28 03:20:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761621634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761621634;}", "7", "1", "2025-10-28 05:28:16", "2025-10-28 08:58:16", "17891", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1653", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 06:28:16", "2025-10-28 06:28:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761632896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761632896;}", "7", "1", "2025-10-28 07:41:42", "2025-10-28 11:11:42", "17893", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1654", "woocommerce_refresh_order_count_cache", "complete", "2025-10-28 19:41:42", "2025-10-28 19:41:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761680502;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761680502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-29 01:00:26", "2025-10-29 04:30:26", "17917", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1655", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 08:41:42", "2025-10-28 08:41:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761640902;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761640902;}", "7", "1", "2025-10-28 09:13:45", "2025-10-28 12:43:45", "17896", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1656", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 10:13:45", "2025-10-28 10:13:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761646425;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761646425;}", "7", "1", "2025-10-28 10:15:04", "2025-10-28 13:45:04", "17898", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1657", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 11:15:04", "2025-10-28 11:15:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761650104;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761650104;}", "7", "1", "2025-10-28 13:37:08", "2025-10-28 17:07:08", "17903", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1658", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 14:37:08", "2025-10-28 14:37:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761662228;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761662228;}", "7", "1", "2025-10-28 15:06:48", "2025-10-28 18:36:48", "17905", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1659", "woocommerce_cleanup_draft_orders", "complete", "2025-10-29 15:06:45", "2025-10-29 15:06:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750405;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-29 16:29:26", "2025-10-29 19:59:26", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1660", "woocommerce_scheduled_sales", "complete", "2025-10-29 15:06:45", "2025-10-29 15:06:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750405;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-29 16:29:26", "2025-10-29 19:59:26", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1661", "wc_admin_daily_wrapper", "complete", "2025-10-29 15:06:46", "2025-10-29 15:06:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750406;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-29 16:29:27", "2025-10-29 19:59:27", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1662", "woocommerce_cleanup_personal_data", "complete", "2025-10-29 15:06:47", "2025-10-29 15:06:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750407;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-29 16:29:28", "2025-10-29 19:59:28", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1663", "woocommerce_cleanup_logs", "complete", "2025-10-29 15:06:48", "2025-10-29 15:06:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750408;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-29 16:29:28", "2025-10-29 19:59:28", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1664", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-29 15:06:48", "2025-10-29 15:06:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750408;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-29 16:29:28", "2025-10-29 19:59:28", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1665", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 16:06:48", "2025-10-28 16:06:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761667608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761667608;}", "7", "1", "2025-10-28 16:49:47", "2025-10-28 20:19:47", "17909", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1666", "woocommerce_cleanup_sessions", "complete", "2025-10-29 03:00:00", "2025-10-29 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761706800;s:18:\"\0*\0first_timestamp\";i:1761706800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761706800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-29 05:42:55", "2025-10-29 09:12:55", "17922", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1667", "generate_category_lookup_table_wrapper", "complete", "2025-10-28 15:06:58", "2025-10-28 15:06:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761664018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761664018;}", "7", "1", "2025-10-28 15:23:52", "2025-10-28 18:53:52", "17907", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1668", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-29 15:06:48", "2025-10-29 15:06:48", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761750408;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761750408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-29 16:29:29", "2025-10-29 19:59:29", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1669", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 17:49:47", "2025-10-28 17:49:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761673787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761673787;}", "7", "1", "2025-10-28 17:54:33", "2025-10-28 21:24:33", "17913", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1670", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-28 18:54:33", "2025-10-28 18:54:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761677673;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761677673;}", "7", "1", "2025-10-29 01:00:26", "2025-10-29 04:30:26", "17917", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1671", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 02:00:26", "2025-10-29 02:00:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761703226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761703226;}", "7", "1", "2025-10-29 02:20:19", "2025-10-29 05:50:19", "17919", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1672", "woocommerce_refresh_order_count_cache", "complete", "2025-10-29 13:00:26", "2025-10-29 13:00:26", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761742826;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761742826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-29 16:29:26", "2025-10-29 19:59:26", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1673", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 03:20:19", "2025-10-29 03:20:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761708019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761708019;}", "7", "1", "2025-10-29 05:42:55", "2025-10-29 09:12:55", "17922", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1675", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 06:42:55", "2025-10-29 06:42:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761720175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761720175;}", "7", "1", "2025-10-29 06:46:54", "2025-10-29 10:16:54", "17928", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1676", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 07:46:54", "2025-10-29 07:46:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761724014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761724014;}", "7", "1", "2025-10-29 08:15:19", "2025-10-29 11:45:19", "17930", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1677", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 09:15:19", "2025-10-29 09:15:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761729319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761729319;}", "7", "1", "2025-10-29 09:25:00", "2025-10-29 12:55:00", "17939", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1678", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 10:25:00", "2025-10-29 10:25:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761733500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761733500;}", "7", "1", "2025-10-29 11:04:50", "2025-10-29 14:34:50", "17943", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1679", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 12:04:50", "2025-10-29 12:04:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761739490;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761739490;}", "7", "1", "2025-10-29 12:09:34", "2025-10-29 15:39:34", "17945", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1680", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 13:09:34", "2025-10-29 13:09:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761743374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761743374;}", "7", "1", "2025-10-29 16:29:26", "2025-10-29 19:59:26", "17950", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1681", "woocommerce_refresh_order_count_cache", "complete", "2025-10-30 04:29:26", "2025-10-30 04:29:26", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761798566;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761798566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-30 05:17:24", "2025-10-30 08:47:24", "17966", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1682", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 17:29:26", "2025-10-29 17:29:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761758966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761758966;}", "7", "1", "2025-10-29 18:07:37", "2025-10-29 21:37:37", "17955", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1683", "woocommerce_cleanup_draft_orders", "complete", "2025-10-30 16:29:26", "2025-10-30 16:29:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841766;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-30 20:07:46", "2025-10-30 23:37:46", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1684", "woocommerce_scheduled_sales", "complete", "2025-10-30 16:29:26", "2025-10-30 16:29:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841766;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-30 20:07:46", "2025-10-30 23:37:46", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1685", "wc_admin_daily_wrapper", "complete", "2025-10-30 16:29:27", "2025-10-30 16:29:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841767;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841767;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-30 20:07:46", "2025-10-30 23:37:46", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1686", "woocommerce_cleanup_personal_data", "complete", "2025-10-30 16:29:28", "2025-10-30 16:29:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841768;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-30 20:07:47", "2025-10-30 23:37:47", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1687", "woocommerce_cleanup_logs", "complete", "2025-10-30 16:29:28", "2025-10-30 16:29:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841768;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1688", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-30 16:29:28", "2025-10-30 16:29:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841768;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1689", "woocommerce_cleanup_sessions", "complete", "2025-10-30 03:00:00", "2025-10-30 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761793200;s:18:\"\0*\0first_timestamp\";i:1761793200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761793200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-30 05:17:24", "2025-10-30 08:47:24", "17966", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1690", "generate_category_lookup_table_wrapper", "complete", "2025-10-29 16:29:39", "2025-10-29 16:29:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761755379;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761755379;}", "7", "1", "2025-10-29 16:30:10", "2025-10-29 20:00:10", "17952", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1691", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-30 16:29:29", "2025-10-30 16:29:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761841769;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761841769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1692", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 19:07:37", "2025-10-29 19:07:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761764857;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761764857;}", "7", "1", "2025-10-29 21:57:39", "2025-10-30 01:27:39", "17960", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1693", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-29 22:57:39", "2025-10-29 22:57:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761778659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761778659;}", "7", "1", "2025-10-30 02:19:48", "2025-10-30 05:49:48", "17963", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1694", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 03:19:48", "2025-10-30 03:19:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761794388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761794388;}", "7", "1", "2025-10-30 05:17:24", "2025-10-30 08:47:24", "17966", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1695", "woocommerce_cleanup_sessions", "complete", "2025-10-30 17:17:24", "2025-10-30 17:17:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761844644;s:18:\"\0*\0first_timestamp\";i:1761793200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761844644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1696", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 06:17:24", "2025-10-30 06:17:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761805044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761805044;}", "7", "1", "2025-10-30 06:36:44", "2025-10-30 10:06:44", "17969", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1697", "woocommerce_refresh_order_count_cache", "complete", "2025-10-30 17:17:24", "2025-10-30 17:17:24", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761844644;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761844644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1698", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 07:36:44", "2025-10-30 07:36:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761809804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761809804;}", "7", "1", "2025-10-30 08:36:50", "2025-10-30 12:06:50", "17972", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1699", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 09:36:50", "2025-10-30 09:36:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761817010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761817010;}", "7", "1", "2025-10-30 12:01:48", "2025-10-30 15:31:48", "17976", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1700", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 13:01:48", "2025-10-30 13:01:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761829308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761829308;}", "7", "1", "2025-10-30 13:27:55", "2025-10-30 16:57:55", "17978", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1701", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 14:27:55", "2025-10-30 14:27:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761834475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761834475;}", "7", "1", "2025-10-30 14:30:17", "2025-10-30 18:00:17", "17981", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1702", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 15:30:17", "2025-10-30 15:30:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761838217;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761838217;}", "7", "1", "2025-10-30 16:21:28", "2025-10-30 19:51:28", "17984", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1703", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 17:21:28", "2025-10-30 17:21:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761844888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761844888;}", "7", "1", "2025-10-30 20:07:48", "2025-10-30 23:37:48", "17986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1704", "woocommerce_cleanup_draft_orders", "complete", "2025-10-31 20:07:46", "2025-10-31 20:07:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941266;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-31 21:33:25", "2025-11-01 01:03:25", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1705", "woocommerce_scheduled_sales", "complete", "2025-10-31 20:07:46", "2025-10-31 20:07:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941266;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-31 21:33:25", "2025-11-01 01:03:25", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1706", "wc_admin_daily_wrapper", "complete", "2025-10-31 20:07:46", "2025-10-31 20:07:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941266;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-31 21:33:26", "2025-11-01 01:03:26", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1707", "woocommerce_cleanup_personal_data", "complete", "2025-10-31 20:07:48", "2025-10-31 20:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941268;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-31 21:33:27", "2025-11-01 01:03:27", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1708", "woocommerce_cleanup_logs", "complete", "2025-10-31 20:07:48", "2025-10-31 20:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941268;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-31 21:33:27", "2025-11-01 01:03:27", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1709", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-31 20:07:48", "2025-10-31 20:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941268;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-31 21:33:27", "2025-11-01 01:03:27", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1711", "woocommerce_refresh_order_count_cache", "complete", "2025-10-31 08:07:48", "2025-10-31 08:07:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761898068;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761898068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-10-31 09:43:48", "2025-10-31 13:13:48", "18001", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1712", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-30 21:07:48", "2025-10-30 21:07:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761858468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761858468;}", "7", "1", "2025-10-30 23:08:05", "2025-10-31 02:38:05", "17992", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1713", "woocommerce_cleanup_sessions", "complete", "2025-10-31 03:00:00", "2025-10-31 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761879600;s:18:\"\0*\0first_timestamp\";i:1761879600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761879600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-31 04:54:51", "2025-10-31 08:24:51", "17997", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1714", "generate_category_lookup_table_wrapper", "complete", "2025-10-30 20:07:58", "2025-10-30 20:07:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761854878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761854878;}", "7", "1", "2025-10-30 20:32:36", "2025-10-31 00:02:36", "17988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1715", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-31 20:07:48", "2025-10-31 20:07:48", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761941268;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761941268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-31 21:33:28", "2025-11-01 01:03:28", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1716", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 00:08:05", "2025-10-31 00:08:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761869285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761869285;}", "7", "1", "2025-10-31 02:19:56", "2025-10-31 05:49:56", "17995", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1717", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 03:19:56", "2025-10-31 03:19:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761880796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761880796;}", "7", "1", "2025-10-31 04:54:51", "2025-10-31 08:24:51", "17997", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1718", "woocommerce_cleanup_sessions", "complete", "2025-10-31 16:54:51", "2025-10-31 16:54:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761929691;s:18:\"\0*\0first_timestamp\";i:1761879600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761929691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-10-31 17:43:01", "2025-10-31 21:13:01", "18010", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1719", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 05:54:51", "2025-10-31 05:54:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761890091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761890091;}", "7", "1", "2025-10-31 06:05:59", "2025-10-31 09:35:59", "17999", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1720", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 07:05:59", "2025-10-31 07:05:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761894359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761894359;}", "7", "1", "2025-10-31 09:43:47", "2025-10-31 13:13:47", "18001", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1721", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 10:43:47", "2025-10-31 10:43:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761907427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761907427;}", "7", "1", "2025-10-31 10:54:35", "2025-10-31 14:24:35", "18004", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1722", "woocommerce_refresh_order_count_cache", "complete", "2025-10-31 21:43:48", "2025-10-31 21:43:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761947028;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761947028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-01 02:22:23", "2025-11-01 05:52:23", "18024", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1723", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 11:54:35", "2025-10-31 11:54:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761911675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761911675;}", "7", "1", "2025-10-31 12:31:35", "2025-10-31 16:01:35", "18008", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1724", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 13:31:35", "2025-10-31 13:31:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761917495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761917495;}", "7", "1", "2025-10-31 17:43:01", "2025-10-31 21:13:01", "18010", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1725", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 18:43:01", "2025-10-31 18:43:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761936181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761936181;}", "7", "1", "2025-10-31 18:52:30", "2025-10-31 22:22:30", "18014", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1727", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 19:52:30", "2025-10-31 19:52:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761940350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761940350;}", "7", "1", "2025-10-31 21:33:25", "2025-11-01 01:03:25", "18020", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1728", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-31 22:33:25", "2025-10-31 22:33:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761950005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761950005;}", "7", "1", "2025-11-01 02:22:23", "2025-11-01 05:52:23", "18024", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1729", "woocommerce_cleanup_draft_orders", "complete", "2025-11-01 21:33:25", "2025-11-01 21:33:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032805;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-01 21:57:08", "2025-11-02 01:27:08", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1730", "woocommerce_scheduled_sales", "complete", "2025-11-01 21:33:26", "2025-11-01 21:33:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032806;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-01 21:57:08", "2025-11-02 01:27:08", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1731", "wc_admin_daily_wrapper", "complete", "2025-11-01 21:33:26", "2025-11-01 21:33:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032806;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-01 21:57:09", "2025-11-02 01:27:09", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1732", "woocommerce_cleanup_personal_data", "complete", "2025-11-01 21:33:27", "2025-11-01 21:33:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032807;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-01 21:57:10", "2025-11-02 01:27:10", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1733", "woocommerce_cleanup_logs", "complete", "2025-11-01 21:33:27", "2025-11-01 21:33:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032807;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-01 21:57:10", "2025-11-02 01:27:10", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1734", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-01 21:33:27", "2025-11-01 21:33:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032807;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-01 21:57:10", "2025-11-02 01:27:10", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1735", "woocommerce_cleanup_sessions", "complete", "2025-11-01 03:00:00", "2025-11-01 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761966000;s:18:\"\0*\0first_timestamp\";i:1761966000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761966000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-01 04:16:26", "2025-11-01 07:46:26", "18027", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1736", "generate_category_lookup_table_wrapper", "complete", "2025-10-31 21:33:38", "2025-10-31 21:33:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761946418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761946418;}", "7", "1", "2025-10-31 21:33:57", "2025-11-01 01:03:57", "18022", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1737", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-01 21:33:28", "2025-11-01 21:33:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762032808;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762032808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-01 21:57:10", "2025-11-02 01:27:10", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1738", "woocommerce_refresh_order_count_cache", "complete", "2025-11-01 14:22:23", "2025-11-01 14:22:23", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762006943;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762006943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-01 15:53:48", "2025-11-01 19:23:48", "18055", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1739", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 03:22:23", "2025-11-01 03:22:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761967343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761967343;}", "7", "1", "2025-11-01 04:16:26", "2025-11-01 07:46:26", "18027", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1740", "fetch_patterns", "complete", "2025-11-01 02:23:05", "2025-11-01 02:23:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761963785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761963785;}", "2", "1", "2025-11-01 04:16:26", "2025-11-01 07:46:26", "18027", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1741", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-11-01 02:23:12", "2025-11-01 02:23:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761963792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761963792;}", "4", "1", "2025-11-01 04:16:26", "2025-11-01 07:46:26", "18027", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1742", "woocommerce_cleanup_sessions", "complete", "2025-11-01 16:16:26", "2025-11-01 16:16:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762013786;s:18:\"\0*\0first_timestamp\";i:1761966000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762013786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-01 17:23:00", "2025-11-01 20:53:00", "18059", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1743", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 05:16:26", "2025-11-01 05:16:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761974186;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761974186;}", "7", "1", "2025-11-01 05:46:36", "2025-11-01 09:16:36", "18030", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1744", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 06:46:36", "2025-11-01 06:46:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761979596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761979596;}", "7", "1", "2025-11-01 07:40:35", "2025-11-01 11:10:35", "18034", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1745", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 08:40:35", "2025-11-01 08:40:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761986435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761986435;}", "7", "1", "2025-11-01 09:07:58", "2025-11-01 12:37:58", "18037", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1746", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 10:07:58", "2025-11-01 10:07:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761991678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761991678;}", "7", "1", "2025-11-01 10:09:04", "2025-11-01 13:39:04", "18040", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1747", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 11:09:04", "2025-11-01 11:09:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761995344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761995344;}", "7", "1", "2025-11-01 11:23:57", "2025-11-01 14:53:57", "18048", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1748", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 12:23:57", "2025-11-01 12:23:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1761999837;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1761999837;}", "7", "1", "2025-11-01 12:41:11", "2025-11-01 16:11:11", "18052", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1749", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 13:41:11", "2025-11-01 13:41:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762004471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762004471;}", "7", "1", "2025-11-01 15:53:48", "2025-11-01 19:23:48", "18055", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1750", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 16:53:47", "2025-11-01 16:53:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762016027;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762016027;}", "7", "1", "2025-11-01 17:23:00", "2025-11-01 20:53:00", "18059", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1751", "woocommerce_refresh_order_count_cache", "complete", "2025-11-02 03:53:48", "2025-11-02 03:53:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762055628;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762055628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-02 05:16:08", "2025-11-02 08:46:08", "18068", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1753", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 18:23:00", "2025-11-01 18:23:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762021380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762021380;}", "7", "1", "2025-11-01 18:44:10", "2025-11-01 22:14:10", "18061", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1754", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 19:44:10", "2025-11-01 19:44:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762026250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762026250;}", "7", "1", "2025-11-01 21:57:08", "2025-11-02 01:27:08", "18063", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1755", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-01 22:57:08", "2025-11-01 22:57:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762037828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762037828;}", "7", "1", "2025-11-02 02:19:31", "2025-11-02 05:49:31", "18065", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1756", "woocommerce_cleanup_draft_orders", "complete", "2025-11-02 21:57:08", "2025-11-02 21:57:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120628;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-02 22:02:48", "2025-11-03 01:32:48", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1757", "woocommerce_scheduled_sales", "complete", "2025-11-02 21:57:08", "2025-11-02 21:57:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120628;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-02 22:02:48", "2025-11-03 01:32:48", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1758", "wc_admin_daily_wrapper", "complete", "2025-11-02 21:57:09", "2025-11-02 21:57:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120629;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-02 22:02:49", "2025-11-03 01:32:49", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1759", "woocommerce_cleanup_personal_data", "complete", "2025-11-02 21:57:10", "2025-11-02 21:57:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120630;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-02 22:02:50", "2025-11-03 01:32:50", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1760", "woocommerce_cleanup_logs", "complete", "2025-11-02 21:57:10", "2025-11-02 21:57:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120630;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-02 22:02:50", "2025-11-03 01:32:50", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1761", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-02 21:57:10", "2025-11-02 21:57:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120630;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-02 22:02:50", "2025-11-03 01:32:50", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1762", "woocommerce_cleanup_sessions", "complete", "2025-11-02 03:00:00", "2025-11-02 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762052400;s:18:\"\0*\0first_timestamp\";i:1762052400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762052400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-02 05:16:08", "2025-11-02 08:46:08", "18068", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1763", "generate_category_lookup_table_wrapper", "complete", "2025-11-01 21:57:20", "2025-11-01 21:57:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762034240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762034240;}", "7", "1", "2025-11-02 02:19:31", "2025-11-02 05:49:31", "18065", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1764", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-02 21:57:10", "2025-11-02 21:57:10", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762120630;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762120630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-02 22:02:50", "2025-11-03 01:32:50", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1765", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 03:19:31", "2025-11-02 03:19:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762053571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762053571;}", "7", "1", "2025-11-02 05:16:08", "2025-11-02 08:46:08", "18068", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1766", "woocommerce_cleanup_sessions", "complete", "2025-11-02 17:16:08", "2025-11-02 17:16:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762103768;s:18:\"\0*\0first_timestamp\";i:1762052400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762103768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-02 22:02:48", "2025-11-03 01:32:48", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1767", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 06:16:08", "2025-11-02 06:16:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762064168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762064168;}", "7", "1", "2025-11-02 09:03:05", "2025-11-02 12:33:05", "18073", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1768", "woocommerce_refresh_order_count_cache", "complete", "2025-11-02 17:16:08", "2025-11-02 17:16:08", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762103768;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762103768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-02 22:02:48", "2025-11-03 01:32:48", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1769", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 10:03:05", "2025-11-02 10:03:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762077785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762077785;}", "7", "1", "2025-11-02 10:03:07", "2025-11-02 13:33:07", "18081", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1770", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 11:03:07", "2025-11-02 11:03:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762081387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762081387;}", "7", "1", "2025-11-02 12:06:57", "2025-11-02 15:36:57", "18083", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1771", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 13:06:57", "2025-11-02 13:06:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762088817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762088817;}", "7", "1", "2025-11-02 15:00:15", "2025-11-02 18:30:15", "18096", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1772", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 16:00:15", "2025-11-02 16:00:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762099215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762099215;}", "7", "1", "2025-11-02 16:12:09", "2025-11-02 19:42:09", "18098", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1773", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 17:12:09", "2025-11-02 17:12:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762103529;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762103529;}", "7", "1", "2025-11-02 22:02:48", "2025-11-03 01:32:48", "18102", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1774", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-02 23:02:48", "2025-11-02 23:02:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762124568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762124568;}", "7", "1", "2025-11-03 02:19:50", "2025-11-03 05:49:50", "18106", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1776", "woocommerce_refresh_order_count_cache", "complete", "2025-11-03 10:02:48", "2025-11-03 10:02:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762164168;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762164168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-03 10:10:27", "2025-11-03 13:40:27", "18118", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1777", "woocommerce_cleanup_draft_orders", "complete", "2025-11-03 22:02:48", "2025-11-03 22:02:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207368;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-04 01:01:41", "2025-11-04 04:31:41", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1778", "woocommerce_scheduled_sales", "complete", "2025-11-03 22:02:48", "2025-11-03 22:02:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207368;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-04 01:01:41", "2025-11-04 04:31:41", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1779", "wc_admin_daily_wrapper", "complete", "2025-11-03 22:02:49", "2025-11-03 22:02:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207369;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-04 01:01:42", "2025-11-04 04:31:42", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1780", "woocommerce_cleanup_personal_data", "complete", "2025-11-03 22:02:50", "2025-11-03 22:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207370;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-04 01:01:43", "2025-11-04 04:31:43", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1781", "woocommerce_cleanup_logs", "complete", "2025-11-03 22:02:50", "2025-11-03 22:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207370;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-04 01:01:43", "2025-11-04 04:31:43", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1782", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-03 22:02:50", "2025-11-03 22:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207370;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-04 01:01:43", "2025-11-04 04:31:43", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1783", "woocommerce_cleanup_sessions", "complete", "2025-11-03 03:00:00", "2025-11-03 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762138800;s:18:\"\0*\0first_timestamp\";i:1762138800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762138800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-03 05:37:10", "2025-11-03 09:07:10", "18108", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1784", "generate_category_lookup_table_wrapper", "complete", "2025-11-02 22:03:00", "2025-11-02 22:03:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762120980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762120980;}", "7", "1", "2025-11-02 22:27:34", "2025-11-03 01:57:34", "18104", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1785", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-03 22:02:50", "2025-11-03 22:02:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207370;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-04 01:01:44", "2025-11-04 04:31:44", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1786", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 03:19:50", "2025-11-03 03:19:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762139990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762139990;}", "7", "1", "2025-11-03 05:37:10", "2025-11-03 09:07:10", "18108", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1787", "woocommerce_cleanup_sessions", "complete", "2025-11-03 17:37:10", "2025-11-03 17:37:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762191430;s:18:\"\0*\0first_timestamp\";i:1762138800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762191430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-03 18:51:23", "2025-11-03 22:21:23", "18135", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1788", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 06:37:10", "2025-11-03 06:37:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762151830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762151830;}", "7", "1", "2025-11-03 06:46:14", "2025-11-03 10:16:14", "18111", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1789", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 07:46:14", "2025-11-03 07:46:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762155974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762155974;}", "7", "1", "2025-11-03 08:22:48", "2025-11-03 11:52:48", "18114", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1790", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 09:22:48", "2025-11-03 09:22:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762161768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762161768;}", "7", "1", "2025-11-03 09:55:57", "2025-11-03 13:25:57", "18116", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1791", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 10:55:57", "2025-11-03 10:55:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762167357;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762167357;}", "7", "1", "2025-11-03 11:00:08", "2025-11-03 14:30:08", "18122", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1792", "woocommerce_refresh_order_count_cache", "complete", "2025-11-03 22:10:27", "2025-11-03 22:10:27", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762207827;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762207827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-04 01:01:43", "2025-11-04 04:31:43", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1793", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 12:00:08", "2025-11-03 12:00:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762171208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762171208;}", "7", "1", "2025-11-03 12:43:45", "2025-11-03 16:13:45", "18124", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1794", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 13:43:45", "2025-11-03 13:43:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762177425;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762177425;}", "7", "1", "2025-11-03 14:14:15", "2025-11-03 17:44:15", "18126", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1795", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 15:14:15", "2025-11-03 15:14:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762182855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762182855;}", "7", "1", "2025-11-03 15:31:45", "2025-11-03 19:01:45", "18129", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1796", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 16:31:45", "2025-11-03 16:31:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762187505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762187505;}", "7", "1", "2025-11-03 18:51:23", "2025-11-03 22:21:23", "18135", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1797", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 19:51:23", "2025-11-03 19:51:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762199483;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762199483;}", "7", "1", "2025-11-03 21:15:10", "2025-11-04 00:45:10", "18139", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1799", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-03 22:15:10", "2025-11-03 22:15:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762208110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762208110;}", "7", "1", "2025-11-04 01:01:43", "2025-11-04 04:31:43", "18142", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1800", "woocommerce_cleanup_draft_orders", "complete", "2025-11-05 01:01:41", "2025-11-05 01:01:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304501;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-05 02:04:04", "2025-11-05 05:34:04", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1801", "woocommerce_scheduled_sales", "complete", "2025-11-05 01:01:41", "2025-11-05 01:01:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304501;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-05 02:04:04", "2025-11-05 05:34:04", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1802", "wc_admin_daily_wrapper", "complete", "2025-11-05 01:01:42", "2025-11-05 01:01:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304502;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-05 02:04:05", "2025-11-05 05:34:05", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1803", "woocommerce_cleanup_personal_data", "complete", "2025-11-05 01:01:43", "2025-11-05 01:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304503;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-05 02:04:07", "2025-11-05 05:34:07", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1804", "woocommerce_cleanup_logs", "complete", "2025-11-05 01:01:43", "2025-11-05 01:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304503;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-05 02:04:07", "2025-11-05 05:34:07", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1805", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-05 01:01:43", "2025-11-05 01:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304503;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-05 02:04:07", "2025-11-05 05:34:07", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1806", "woocommerce_refresh_order_count_cache", "complete", "2025-11-04 13:01:43", "2025-11-04 13:01:43", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762261303;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762261303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-04 13:25:59", "2025-11-04 16:55:59", "18156", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1807", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 02:01:43", "2025-11-04 02:01:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762221703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762221703;}", "7", "1", "2025-11-04 02:19:55", "2025-11-04 05:49:55", "18148", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1809", "generate_category_lookup_table_wrapper", "complete", "2025-11-04 01:01:54", "2025-11-04 01:01:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762218114;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762218114;}", "7", "1", "2025-11-04 01:07:43", "2025-11-04 04:37:43", "18144", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1810", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-05 01:01:44", "2025-11-05 01:01:44", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762304504;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762304504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-05 02:04:07", "2025-11-05 05:34:07", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1811", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 03:19:55", "2025-11-04 03:19:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762226395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762226395;}", "7", "1", "2025-11-04 03:56:07", "2025-11-04 07:26:07", "18150", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1812", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 04:56:07", "2025-11-04 04:56:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762232167;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762232167;}", "7", "1", "2025-11-04 06:54:33", "2025-11-04 10:24:33", "18152", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1813", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 07:54:33", "2025-11-04 07:54:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762242873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762242873;}", "7", "1", "2025-11-04 11:12:25", "2025-11-04 14:42:25", "18154", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1814", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 12:12:25", "2025-11-04 12:12:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762258345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762258345;}", "7", "1", "2025-11-04 13:25:59", "2025-11-04 16:55:59", "18156", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1815", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 14:25:59", "2025-11-04 14:25:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762266359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762266359;}", "7", "1", "2025-11-04 16:49:46", "2025-11-04 20:19:46", "18159", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1816", "woocommerce_refresh_order_count_cache", "complete", "2025-11-05 01:25:59", "2025-11-05 01:25:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762305959;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762305959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-05 02:04:07", "2025-11-05 05:34:07", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1817", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 17:49:46", "2025-11-04 17:49:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762278586;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762278586;}", "7", "1", "2025-11-04 18:19:32", "2025-11-04 21:49:32", "18162", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1818", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 19:19:32", "2025-11-04 19:19:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762283972;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762283972;}", "7", "1", "2025-11-04 19:24:09", "2025-11-04 22:54:09", "18165", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1819", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 20:24:09", "2025-11-04 20:24:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762287849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762287849;}", "7", "1", "2025-11-04 21:09:35", "2025-11-05 00:39:35", "18170", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1820", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-04 22:09:35", "2025-11-04 22:09:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762294175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762294175;}", "7", "1", "2025-11-05 02:04:04", "2025-11-05 05:34:04", "18173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1821", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 03:04:04", "2025-11-05 03:04:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762311844;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762311844;}", "7", "1", "2025-11-05 08:04:30", "2025-11-05 11:34:30", "18177", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1822", "woocommerce_cleanup_draft_orders", "complete", "2025-11-06 02:04:04", "2025-11-06 02:04:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394644;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-06 02:21:35", "2025-11-06 05:51:35", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1823", "woocommerce_scheduled_sales", "complete", "2025-11-06 02:04:04", "2025-11-06 02:04:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394644;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-06 02:21:35", "2025-11-06 05:51:35", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1824", "wc_admin_daily_wrapper", "complete", "2025-11-06 02:04:05", "2025-11-06 02:04:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394645;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394645;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-06 02:21:36", "2025-11-06 05:51:36", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1825", "woocommerce_cleanup_personal_data", "complete", "2025-11-06 02:04:07", "2025-11-06 02:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394647;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-06 02:21:37", "2025-11-06 05:51:37", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1826", "woocommerce_cleanup_logs", "complete", "2025-11-06 02:04:07", "2025-11-06 02:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394647;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-06 02:21:37", "2025-11-06 05:51:37", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1827", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-06 02:04:07", "2025-11-06 02:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394647;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-06 02:21:37", "2025-11-06 05:51:37", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1828", "woocommerce_refresh_order_count_cache", "complete", "2025-11-05 14:04:07", "2025-11-05 14:04:07", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762351447;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762351447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-05 15:08:25", "2025-11-05 18:38:25", "18184", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1830", "generate_category_lookup_table_wrapper", "complete", "2025-11-05 02:04:17", "2025-11-05 02:04:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762308257;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762308257;}", "7", "1", "2025-11-05 02:23:51", "2025-11-05 05:53:51", "18175", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1831", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-06 02:04:07", "2025-11-06 02:04:07", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762394647;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762394647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-06 02:21:38", "2025-11-06 05:51:38", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1832", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 09:04:29", "2025-11-05 09:04:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762333469;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762333469;}", "7", "1", "2025-11-05 10:34:49", "2025-11-05 14:04:49", "18179", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1833", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 11:34:49", "2025-11-05 11:34:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762342489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762342489;}", "7", "1", "2025-11-05 11:56:31", "2025-11-05 15:26:31", "18182", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1834", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 12:56:31", "2025-11-05 12:56:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762347391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762347391;}", "7", "1", "2025-11-05 15:08:25", "2025-11-05 18:38:25", "18184", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1835", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 16:08:25", "2025-11-05 16:08:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762358905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762358905;}", "7", "1", "2025-11-05 19:29:06", "2025-11-05 22:59:06", "18188", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1836", "woocommerce_refresh_order_count_cache", "complete", "2025-11-06 03:08:25", "2025-11-06 03:08:25", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762398505;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762398505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-06 05:01:37", "2025-11-06 08:31:37", "18199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1837", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 20:29:06", "2025-11-05 20:29:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762374546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762374546;}", "7", "1", "2025-11-05 21:10:57", "2025-11-06 00:40:57", "18195", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1838", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-05 22:10:57", "2025-11-05 22:10:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762380657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762380657;}", "7", "1", "2025-11-06 02:21:35", "2025-11-06 05:51:35", "18197", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1839", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 03:21:35", "2025-11-06 03:21:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762399295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762399295;}", "7", "1", "2025-11-06 05:01:37", "2025-11-06 08:31:37", "18199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1840", "woocommerce_cleanup_draft_orders", "complete", "2025-11-07 02:21:35", "2025-11-07 02:21:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482095;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-07 09:19:34", "2025-11-07 12:49:34", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1841", "woocommerce_scheduled_sales", "complete", "2025-11-07 02:21:35", "2025-11-07 02:21:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482095;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-07 09:19:34", "2025-11-07 12:49:34", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1842", "wc_admin_daily_wrapper", "complete", "2025-11-07 02:21:36", "2025-11-07 02:21:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482096;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-07 09:19:35", "2025-11-07 12:49:35", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1843", "woocommerce_cleanup_personal_data", "complete", "2025-11-07 02:21:37", "2025-11-07 02:21:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482097;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1844", "woocommerce_cleanup_logs", "complete", "2025-11-07 02:21:37", "2025-11-07 02:21:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482097;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1845", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-07 02:21:37", "2025-11-07 02:21:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482097;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1846", "woocommerce_cleanup_sessions", "complete", "2025-11-07 03:00:00", "2025-11-07 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762484400;s:18:\"\0*\0first_timestamp\";i:1762484400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762484400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1847", "generate_category_lookup_table_wrapper", "complete", "2025-11-06 02:21:48", "2025-11-06 02:21:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762395708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762395708;}", "7", "1", "2025-11-06 05:01:36", "2025-11-06 08:31:36", "18199", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1848", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-07 02:21:38", "2025-11-07 02:21:38", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762482098;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762482098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1849", "woocommerce_refresh_order_count_cache", "complete", "2025-11-06 17:01:37", "2025-11-06 17:01:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762448497;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762448497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-06 17:50:39", "2025-11-06 21:20:39", "18238", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1850", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 06:01:37", "2025-11-06 06:01:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762408897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762408897;}", "7", "1", "2025-11-06 06:04:40", "2025-11-06 09:34:40", "18205", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1851", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 07:04:40", "2025-11-06 07:04:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762412680;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762412680;}", "7", "1", "2025-11-06 07:13:41", "2025-11-06 10:43:41", "18207", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1852", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 08:13:41", "2025-11-06 08:13:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762416821;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762416821;}", "7", "1", "2025-11-06 09:38:31", "2025-11-06 13:08:31", "18212", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1853", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 10:38:31", "2025-11-06 10:38:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762425511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762425511;}", "7", "1", "2025-11-06 11:34:18", "2025-11-06 15:04:18", "18222", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1854", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 12:34:18", "2025-11-06 12:34:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762432458;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762432458;}", "7", "1", "2025-11-06 15:03:07", "2025-11-06 18:33:07", "18227", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1855", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 16:03:07", "2025-11-06 16:03:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762444987;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762444987;}", "7", "1", "2025-11-06 16:11:35", "2025-11-06 19:41:35", "18233", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1856", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 17:11:35", "2025-11-06 17:11:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762449095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762449095;}", "7", "1", "2025-11-06 17:50:39", "2025-11-06 21:20:39", "18238", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1857", "woocommerce_refresh_order_count_cache", "complete", "2025-11-07 05:50:39", "2025-11-07 05:50:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762494639;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762494639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1858", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 18:50:39", "2025-11-06 18:50:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762455039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762455039;}", "7", "1", "2025-11-06 19:01:54", "2025-11-06 22:31:54", "18247", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1859", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 20:01:54", "2025-11-06 20:01:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762459314;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762459314;}", "7", "1", "2025-11-06 21:17:17", "2025-11-07 00:47:17", "18252", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1860", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-06 22:17:17", "2025-11-06 22:17:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762467437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762467437;}", "7", "1", "2025-11-06 23:41:23", "2025-11-07 03:11:23", "18256", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1861", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 00:41:23", "2025-11-07 00:41:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762476083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762476083;}", "7", "1", "2025-11-07 02:20:24", "2025-11-07 05:50:24", "18259", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1862", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 03:20:24", "2025-11-07 03:20:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762485624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762485624;}", "7", "1", "2025-11-07 09:19:36", "2025-11-07 12:49:36", "18262", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1863", "woocommerce_cleanup_draft_orders", "complete", "2025-11-08 09:19:34", "2025-11-08 09:19:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593574;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-08 09:33:49", "2025-11-08 13:03:49", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1864", "woocommerce_scheduled_sales", "complete", "2025-11-08 09:19:34", "2025-11-08 09:19:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593574;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-08 09:33:49", "2025-11-08 13:03:49", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1865", "wc_admin_daily_wrapper", "complete", "2025-11-08 09:19:35", "2025-11-08 09:19:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593575;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-08 09:33:49", "2025-11-08 13:03:49", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1866", "woocommerce_cleanup_personal_data", "complete", "2025-11-08 09:19:36", "2025-11-08 09:19:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593576;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-08 09:33:51", "2025-11-08 13:03:51", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1867", "woocommerce_cleanup_logs", "complete", "2025-11-08 09:19:36", "2025-11-08 09:19:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593576;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-08 09:33:51", "2025-11-08 13:03:51", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1868", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-08 09:19:36", "2025-11-08 09:19:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593576;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-11-08 09:33:51", "2025-11-08 13:03:51", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1870", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 10:19:36", "2025-11-07 10:19:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762510776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762510776;}", "7", "1", "2025-11-07 10:31:52", "2025-11-07 14:01:52", "18265", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1871", "woocommerce_refresh_order_count_cache", "complete", "2025-11-07 21:19:36", "2025-11-07 21:19:36", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762550376;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762550376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-08 00:14:09", "2025-11-08 03:44:09", "18292", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1872", "woocommerce_cleanup_sessions", "complete", "2025-11-08 03:00:00", "2025-11-08 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762570800;s:18:\"\0*\0first_timestamp\";i:1762570800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762570800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-11-08 04:59:14", "2025-11-08 08:29:14", "18299", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1873", "generate_category_lookup_table_wrapper", "complete", "2025-11-07 09:19:46", "2025-11-07 09:19:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762507186;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762507186;}", "7", "1", "2025-11-07 10:31:52", "2025-11-07 14:01:52", "18265", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1874", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-08 09:19:36", "2025-11-08 09:19:36", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762593576;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762593576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-11-08 09:33:51", "2025-11-08 13:03:51", "18311", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1875", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 11:31:52", "2025-11-07 11:31:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762515112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762515112;}", "7", "1", "2025-11-07 11:33:00", "2025-11-07 15:03:00", "18273", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1876", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 12:33:00", "2025-11-07 12:33:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762518780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762518780;}", "7", "1", "2025-11-07 12:41:28", "2025-11-07 16:11:28", "18276", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1877", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 13:41:28", "2025-11-07 13:41:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762522888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762522888;}", "7", "1", "2025-11-07 13:54:02", "2025-11-07 17:24:02", "18279", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1878", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 14:54:02", "2025-11-07 14:54:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762527242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762527242;}", "7", "1", "2025-11-07 15:04:40", "2025-11-07 18:34:40", "18286", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1879", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 16:04:40", "2025-11-07 16:04:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762531480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762531480;}", "7", "1", "2025-11-07 16:36:17", "2025-11-07 20:06:17", "18290", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1880", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-07 17:36:16", "2025-11-07 17:36:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762536976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762536976;}", "7", "1", "2025-11-08 00:14:09", "2025-11-08 03:44:09", "18292", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1881", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 01:14:09", "2025-11-08 01:14:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762564449;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762564449;}", "7", "1", "2025-11-08 01:16:32", "2025-11-08 04:46:32", "18294", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1882", "woocommerce_refresh_order_count_cache", "complete", "2025-11-08 12:14:09", "2025-11-08 12:14:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762604049;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762604049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-08 14:20:45", "2025-11-08 17:50:45", "18316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1883", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 02:16:32", "2025-11-08 02:16:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762568192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762568192;}", "7", "1", "2025-11-08 02:19:54", "2025-11-08 05:49:54", "18297", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1884", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 03:19:54", "2025-11-08 03:19:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762571994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762571994;}", "7", "1", "2025-11-08 04:59:14", "2025-11-08 08:29:14", "18299", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1886", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 05:59:14", "2025-11-08 05:59:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762581554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762581554;}", "7", "1", "2025-11-08 06:15:25", "2025-11-08 09:45:25", "18305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1887", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 07:15:25", "2025-11-08 07:15:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762586125;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762586125;}", "7", "1", "2025-11-08 08:59:09", "2025-11-08 12:29:09", "18308", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1888", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 09:59:09", "2025-11-08 09:59:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762595949;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762595949;}", "7", "1", "2025-11-08 10:39:49", "2025-11-08 14:09:49", "18313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1889", "woocommerce_geoip_updater", "pending", "2025-11-23 08:59:09", "2025-11-23 08:59:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763888349;s:18:\"\0*\0first_timestamp\";i:1757393268;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763888349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1890", "woocommerce_cleanup_draft_orders", "pending", "2025-11-09 09:33:49", "2025-11-09 09:33:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680829;s:18:\"\0*\0first_timestamp\";i:1722642063;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1891", "woocommerce_scheduled_sales", "pending", "2025-11-09 09:33:49", "2025-11-09 09:33:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680829;s:18:\"\0*\0first_timestamp\";i:1757451600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1892", "wc_admin_daily_wrapper", "pending", "2025-11-09 09:33:49", "2025-11-09 09:33:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680829;s:18:\"\0*\0first_timestamp\";i:1757393208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1893", "woocommerce_cleanup_personal_data", "pending", "2025-11-09 09:33:51", "2025-11-09 09:33:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680831;s:18:\"\0*\0first_timestamp\";i:1757393218;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1894", "woocommerce_cleanup_logs", "pending", "2025-11-09 09:33:51", "2025-11-09 09:33:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680831;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1895", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-11-09 09:33:51", "2025-11-09 09:33:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680831;s:18:\"\0*\0first_timestamp\";i:1757404008;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1896", "woocommerce_cleanup_sessions", "pending", "2025-11-09 03:00:00", "2025-11-09 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762657200;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762657200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1897", "generate_category_lookup_table_wrapper", "complete", "2025-11-08 09:34:01", "2025-11-08 09:34:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762594441;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762594441;}", "7", "1", "2025-11-08 10:39:49", "2025-11-08 14:09:49", "18313", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1898", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-11-09 09:33:51", "2025-11-09 09:33:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762680831;s:18:\"\0*\0first_timestamp\";i:1757393179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762680831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1899", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 11:39:49", "2025-11-08 11:39:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762601989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762601989;}", "7", "1", "2025-11-08 14:20:45", "2025-11-08 17:50:45", "18316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1900", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 15:20:45", "2025-11-08 15:20:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762615245;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762615245;}", "7", "1", "2025-11-08 18:11:35", "2025-11-08 21:41:35", "18318", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1901", "woocommerce_refresh_order_count_cache", "pending", "2025-11-09 02:20:45", "2025-11-09 02:20:45", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762654845;s:18:\"\0*\0first_timestamp\";i:1749565472;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762654845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1902", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 19:11:35", "2025-11-08 19:11:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762629095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762629095;}", "7", "1", "2025-11-08 19:11:54", "2025-11-08 22:41:54", "18334", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1903", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 20:11:53", "2025-11-08 20:11:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762632713;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762632713;}", "7", "1", "2025-11-08 20:52:55", "2025-11-09 00:22:55", "18353", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1904", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 21:52:55", "2025-11-08 21:52:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762638775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762638775;}", "7", "1", "2025-11-08 21:53:25", "2025-11-09 01:23:25", "18367", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1905", "woocommerce_cancel_unpaid_orders", "pending", "2025-11-08 22:53:25", "2025-11-08 22:53:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762642405;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762642405;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "woocommerce");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "15", "ایجاد فعالیت", "2024-08-03 00:25:11", "2024-08-03 00:25:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "15", "عملیات توسط Async Request شروع شد", "2024-08-03 00:25:20", "2024-08-03 00:25:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "15", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2024-08-03 00:25:20", "2024-08-03 00:25:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "36", "ایجاد فعالیت", "2024-08-06 23:12:56", "2024-08-06 23:12:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "36", "عملیات توسط WP Cron شروع شد", "2024-08-06 23:14:35", "2024-08-06 23:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "36", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-06 23:14:35", "2024-08-06 23:14:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "40", "ایجاد فعالیت", "2024-08-07 23:56:22", "2024-08-07 23:56:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "40", "عملیات توسط WP Cron شروع شد", "2024-08-07 23:57:22", "2024-08-07 23:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "40", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-07 23:57:22", "2024-08-07 23:57:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("116", "49", "ایجاد فعالیت", "2024-08-11 00:54:35", "2024-08-11 00:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("117", "49", "عملیات توسط WP Cron شروع شد", "2024-08-11 00:55:39", "2024-08-11 00:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("118", "49", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-11 00:55:39", "2024-08-11 00:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("134", "55", "ایجاد فعالیت", "2024-08-11 22:53:10", "2024-08-11 22:53:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("135", "55", "عملیات توسط Async Request شروع شد", "2024-08-11 22:54:27", "2024-08-11 22:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("136", "55", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-11 22:54:27", "2024-08-11 22:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("146", "59", "ایجاد فعالیت", "2024-08-13 23:44:15", "2024-08-13 23:44:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("147", "59", "عملیات توسط WP Cron شروع شد", "2024-08-13 23:45:15", "2024-08-13 23:45:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("148", "59", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-13 23:45:15", "2024-08-13 23:45:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("155", "62", "ایجاد فعالیت", "2024-08-14 00:43:32", "2024-08-14 00:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "62", "عملیات توسط WP Cron شروع شد", "2024-08-14 00:44:32", "2024-08-14 00:44:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "62", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-14 00:44:32", "2024-08-14 00:44:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("170", "67", "ایجاد فعالیت", "2024-08-16 23:07:40", "2024-08-16 23:07:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "67", "عملیات توسط WP Cron شروع شد", "2024-08-16 23:09:35", "2024-08-16 23:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "67", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-16 23:09:35", "2024-08-16 23:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("191", "74", "ایجاد فعالیت", "2024-08-19 00:00:33", "2024-08-19 00:00:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("192", "74", "عملیات توسط WP Cron شروع شد", "2024-08-19 00:01:35", "2024-08-19 00:01:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("193", "74", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-19 00:01:35", "2024-08-19 00:01:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("200", "77", "ایجاد فعالیت", "2024-08-20 01:37:18", "2024-08-20 01:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("201", "77", "عملیات توسط WP Cron شروع شد", "2024-08-20 01:39:19", "2024-08-20 01:39:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("202", "77", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-20 01:39:19", "2024-08-20 01:39:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "80", "ایجاد فعالیت", "2024-08-20 23:19:11", "2024-08-20 23:19:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "80", "عملیات توسط Async Request شروع شد", "2024-08-20 23:20:19", "2024-08-20 23:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "80", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-20 23:20:19", "2024-08-20 23:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("227", "86", "ایجاد فعالیت", "2024-08-21 22:43:50", "2024-08-21 22:43:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("228", "86", "عملیات توسط WP Cron شروع شد", "2024-08-21 22:44:56", "2024-08-21 22:44:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("229", "86", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-21 22:44:56", "2024-08-21 22:44:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("245", "92", "ایجاد فعالیت", "2024-08-22 23:45:22", "2024-08-22 23:45:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("246", "92", "عملیات توسط WP Cron شروع شد", "2024-08-22 23:46:34", "2024-08-22 23:46:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "92", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-22 23:46:34", "2024-08-22 23:46:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("497", "176", "ایجاد فعالیت", "2024-11-01 23:48:48", "2024-11-01 23:48:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("498", "176", "عملیات توسط WP Cron شروع شد", "2024-11-01 23:50:39", "2024-11-01 23:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("499", "176", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-11-01 23:50:39", "2024-11-01 23:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "243", "ایجاد فعالیت", "2024-12-27 23:16:07", "2024-12-27 23:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "243", "عملیات توسط WP Cron شروع شد", "2024-12-27 23:17:26", "2024-12-27 23:17:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "243", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-27 23:17:26", "2024-12-27 23:17:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2873", "974", "ایجاد فعالیت", "2025-09-24 08:41:15", "2025-09-24 08:41:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3683", "1244", "ایجاد فعالیت", "2025-10-08 04:26:43", "2025-10-08 04:26:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3686", "1245", "ایجاد فعالیت", "2025-10-08 04:26:43", "2025-10-08 04:26:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3689", "1246", "ایجاد فعالیت", "2025-10-08 04:26:44", "2025-10-08 04:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3692", "1247", "ایجاد فعالیت", "2025-10-08 04:26:45", "2025-10-08 04:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3695", "1248", "ایجاد فعالیت", "2025-10-08 04:26:45", "2025-10-08 04:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3698", "1249", "ایجاد فعالیت", "2025-10-08 04:26:45", "2025-10-08 04:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3702", "1251", "ایجاد فعالیت", "2025-10-08 04:26:45", "2025-10-08 04:26:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3710", "1253", "ایجاد فعالیت", "2025-10-08 09:21:53", "2025-10-08 09:21:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3713", "1254", "ایجاد فعالیت", "2025-10-08 09:21:53", "2025-10-08 09:21:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3727", "1259", "ایجاد فعالیت", "2025-10-08 20:41:49", "2025-10-08 20:41:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3729", "1253", "عملیات توسط WP Cron شروع شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3730", "1253", "عملیات توسط WP Cron کامل شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3731", "1260", "ایجاد فعالیت", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3732", "1254", "عملیات توسط WP Cron شروع شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3733", "1254", "عملیات توسط WP Cron کامل شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3734", "1261", "ایجاد فعالیت", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3735", "1259", "عملیات توسط WP Cron شروع شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3736", "1262", "ایجاد فعالیت", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3737", "1259", "عملیات توسط WP Cron کامل شد", "2025-10-09 02:20:35", "2025-10-09 02:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3738", "1262", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3739", "1263", "ایجاد فعالیت", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3740", "1262", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3741", "1244", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3742", "1244", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3743", "1264", "ایجاد فعالیت", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3744", "1245", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3745", "1245", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3746", "1265", "ایجاد فعالیت", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3747", "1246", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:02", "2025-10-09 06:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3748", "1246", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:03", "2025-10-09 06:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3749", "1266", "ایجاد فعالیت", "2025-10-09 06:52:03", "2025-10-09 06:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3750", "1247", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:03", "2025-10-09 06:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3751", "1247", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3752", "1267", "ایجاد فعالیت", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3753", "1248", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3754", "1248", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3755", "1268", "ایجاد فعالیت", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3756", "1249", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3757", "1249", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3758", "1269", "ایجاد فعالیت", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3759", "1251", "عملیات توسط WP Cron شروع شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3760", "1270", "ایجاد فعالیت", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3761", "1251", "عملیات توسط WP Cron کامل شد", "2025-10-09 06:52:04", "2025-10-09 06:52:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3762", "1271", "ایجاد فعالیت", "2025-10-09 06:52:05", "2025-10-09 06:52:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3763", "1270", "عملیات توسط WP Cron شروع شد", "2025-10-09 07:07:46", "2025-10-09 07:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3764", "1270", "عملیات توسط WP Cron کامل شد", "2025-10-09 07:07:46", "2025-10-09 07:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3765", "1263", "عملیات توسط WP Cron شروع شد", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3766", "1272", "ایجاد فعالیت", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3767", "1263", "عملیات توسط WP Cron کامل شد", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3768", "974", "عملیات توسط WP Cron شروع شد", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3769", "974", "عملیات توسط WP Cron کامل شد", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3770", "1273", "ایجاد فعالیت", "2025-10-09 08:50:21", "2025-10-09 08:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3771", "1272", "عملیات توسط WP Cron شروع شد", "2025-10-09 10:03:53", "2025-10-09 10:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3772", "1274", "ایجاد فعالیت", "2025-10-09 10:03:53", "2025-10-09 10:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3773", "1272", "عملیات توسط WP Cron کامل شد", "2025-10-09 10:03:53", "2025-10-09 10:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3774", "1274", "عملیات توسط WP Cron شروع شد", "2025-10-09 12:55:16", "2025-10-09 12:55:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3775", "1275", "ایجاد فعالیت", "2025-10-09 12:55:16", "2025-10-09 12:55:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3776", "1274", "عملیات توسط WP Cron کامل شد", "2025-10-09 12:55:16", "2025-10-09 12:55:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3777", "1275", "عملیات توسط WP Cron شروع شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3778", "1276", "ایجاد فعالیت", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3779", "1275", "عملیات توسط WP Cron کامل شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3780", "1260", "عملیات توسط WP Cron شروع شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3781", "1260", "عملیات توسط WP Cron کامل شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3782", "1277", "ایجاد فعالیت", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3783", "1261", "عملیات توسط WP Cron شروع شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3784", "1261", "عملیات توسط WP Cron کامل شد", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3785", "1278", "ایجاد فعالیت", "2025-10-09 14:51:39", "2025-10-09 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3786", "1276", "عملیات توسط WP Cron شروع شد", "2025-10-09 16:02:42", "2025-10-09 16:02:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3787", "1279", "ایجاد فعالیت", "2025-10-09 16:02:43", "2025-10-09 16:02:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3788", "1276", "عملیات توسط WP Cron کامل شد", "2025-10-09 16:02:43", "2025-10-09 16:02:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3789", "1279", "عملیات توسط WP Cron شروع شد", "2025-10-09 18:05:18", "2025-10-09 18:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3790", "1280", "ایجاد فعالیت", "2025-10-09 18:05:18", "2025-10-09 18:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3791", "1279", "عملیات توسط WP Cron کامل شد", "2025-10-09 18:05:18", "2025-10-09 18:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3792", "1280", "عملیات توسط WP Cron شروع شد", "2025-10-09 21:19:04", "2025-10-09 21:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3793", "1281", "ایجاد فعالیت", "2025-10-09 21:19:04", "2025-10-09 21:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3794", "1280", "عملیات توسط WP Cron کامل شد", "2025-10-09 21:19:04", "2025-10-09 21:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3795", "1281", "عملیات توسط WP Cron شروع شد", "2025-10-10 02:20:08", "2025-10-10 02:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3796", "1282", "ایجاد فعالیت", "2025-10-10 02:20:09", "2025-10-10 02:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3797", "1281", "عملیات توسط WP Cron کامل شد", "2025-10-10 02:20:09", "2025-10-10 02:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3798", "1277", "عملیات توسط WP Cron شروع شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3799", "1277", "عملیات توسط WP Cron کامل شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3800", "1283", "ایجاد فعالیت", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3801", "1278", "عملیات توسط WP Cron شروع شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3802", "1278", "عملیات توسط WP Cron کامل شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3803", "1284", "ایجاد فعالیت", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3804", "1282", "عملیات توسط WP Cron شروع شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3805", "1285", "ایجاد فعالیت", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3806", "1282", "عملیات توسط WP Cron کامل شد", "2025-10-10 05:34:55", "2025-10-10 05:34:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3807", "1285", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3808", "1286", "ایجاد فعالیت", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3809", "1285", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3810", "1264", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3811", "1264", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3812", "1287", "ایجاد فعالیت", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3813", "1265", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3814", "1265", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3815", "1288", "ایجاد فعالیت", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3816", "1266", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:45", "2025-10-10 07:42:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3817", "1266", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:46", "2025-10-10 07:42:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3818", "1289", "ایجاد فعالیت", "2025-10-10 07:42:46", "2025-10-10 07:42:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3819", "1267", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:46", "2025-10-10 07:42:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3820", "1267", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3821", "1290", "ایجاد فعالیت", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3822", "1268", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3823", "1268", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3824", "1291", "ایجاد فعالیت", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3825", "1269", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3826", "1269", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3827", "1292", "ایجاد فعالیت", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3828", "1271", "عملیات توسط WP Cron شروع شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3829", "1293", "ایجاد فعالیت", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3830", "1271", "عملیات توسط WP Cron کامل شد", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3831", "1294", "ایجاد فعالیت", "2025-10-10 07:42:48", "2025-10-10 07:42:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3832", "1293", "عملیات توسط WP Cron شروع شد", "2025-10-10 10:05:06", "2025-10-10 10:05:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3833", "1293", "عملیات توسط WP Cron کامل شد", "2025-10-10 10:05:06", "2025-10-10 10:05:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3834", "1286", "عملیات توسط WP Cron شروع شد", "2025-10-10 10:05:06", "2025-10-10 10:05:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3835", "1295", "ایجاد فعالیت", "2025-10-10 10:05:06", "2025-10-10 10:05:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3836", "1286", "عملیات توسط WP Cron کامل شد", "2025-10-10 10:05:06", "2025-10-10 10:05:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3837", "1295", "عملیات توسط WP Cron شروع شد", "2025-10-10 11:25:15", "2025-10-10 11:25:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3838", "1296", "ایجاد فعالیت", "2025-10-10 11:25:15", "2025-10-10 11:25:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3839", "1295", "عملیات توسط WP Cron کامل شد", "2025-10-10 11:25:15", "2025-10-10 11:25:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3840", "1296", "عملیات توسط WP Cron شروع شد", "2025-10-10 12:31:50", "2025-10-10 12:31:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3841", "1297", "ایجاد فعالیت", "2025-10-10 12:31:50", "2025-10-10 12:31:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3842", "1296", "عملیات توسط WP Cron کامل شد", "2025-10-10 12:31:50", "2025-10-10 12:31:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3843", "1297", "عملیات توسط WP Cron شروع شد", "2025-10-10 14:30:31", "2025-10-10 14:30:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3844", "1298", "ایجاد فعالیت", "2025-10-10 14:30:31", "2025-10-10 14:30:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3845", "1297", "عملیات توسط WP Cron کامل شد", "2025-10-10 14:30:31", "2025-10-10 14:30:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3846", "1298", "عملیات توسط WP Cron شروع شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3847", "1299", "ایجاد فعالیت", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3848", "1298", "عملیات توسط WP Cron کامل شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3849", "1283", "عملیات توسط WP Cron شروع شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3850", "1283", "عملیات توسط WP Cron کامل شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3851", "1300", "ایجاد فعالیت", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3852", "1284", "عملیات توسط WP Cron شروع شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3853", "1284", "عملیات توسط WP Cron کامل شد", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3854", "1301", "ایجاد فعالیت", "2025-10-10 18:05:10", "2025-10-10 18:05:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3855", "1299", "عملیات توسط WP Cron شروع شد", "2025-10-10 20:59:35", "2025-10-10 20:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3856", "1302", "ایجاد فعالیت", "2025-10-10 20:59:35", "2025-10-10 20:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3857", "1299", "عملیات توسط WP Cron کامل شد", "2025-10-10 20:59:35", "2025-10-10 20:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3858", "1302", "عملیات توسط WP Cron شروع شد", "2025-10-11 01:29:16", "2025-10-11 01:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3859", "1303", "ایجاد فعالیت", "2025-10-11 01:29:17", "2025-10-11 01:29:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3860", "1302", "عملیات توسط WP Cron کامل شد", "2025-10-11 01:29:17", "2025-10-11 01:29:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3861", "1303", "عملیات توسط WP Cron شروع شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3862", "1304", "ایجاد فعالیت", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3863", "1303", "عملیات توسط WP Cron کامل شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3864", "1300", "عملیات توسط WP Cron شروع شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3865", "1300", "عملیات توسط WP Cron کامل شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3866", "1305", "ایجاد فعالیت", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3867", "1301", "عملیات توسط WP Cron شروع شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3868", "1301", "عملیات توسط WP Cron کامل شد", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3869", "1306", "ایجاد فعالیت", "2025-10-11 07:12:36", "2025-10-11 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3870", "1287", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3871", "1287", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3872", "1307", "ایجاد فعالیت", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3873", "1288", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3874", "1288", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3875", "1308", "ایجاد فعالیت", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3876", "1289", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3877", "1289", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3878", "1309", "ایجاد فعالیت", "2025-10-11 08:48:34", "2025-10-11 08:48:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3879", "1290", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:35", "2025-10-11 08:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3880", "1290", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3881", "1310", "ایجاد فعالیت", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3882", "1291", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3883", "1291", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3884", "1311", "ایجاد فعالیت", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3885", "1292", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3886", "1292", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3887", "1312", "ایجاد فعالیت", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3888", "1304", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3889", "1313", "ایجاد فعالیت", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3890", "1304", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3891", "1294", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:48:36", "2025-10-11 08:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3892", "1314", "ایجاد فعالیت", "2025-10-11 08:48:37", "2025-10-11 08:48:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3893", "1294", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:48:37", "2025-10-11 08:48:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3894", "1315", "ایجاد فعالیت", "2025-10-11 08:48:37", "2025-10-11 08:48:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3895", "1314", "عملیات توسط WP Cron شروع شد", "2025-10-11 08:59:50", "2025-10-11 08:59:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3896", "1314", "عملیات توسط WP Cron کامل شد", "2025-10-11 08:59:50", "2025-10-11 08:59:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3897", "1313", "عملیات توسط WP Cron شروع شد", "2025-10-11 12:36:25", "2025-10-11 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3898", "1316", "ایجاد فعالیت", "2025-10-11 12:36:25", "2025-10-11 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3899", "1313", "عملیات توسط WP Cron کامل شد", "2025-10-11 12:36:25", "2025-10-11 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3900", "1316", "عملیات توسط WP Cron شروع شد", "2025-10-11 14:01:22", "2025-10-11 14:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3901", "1317", "ایجاد فعالیت", "2025-10-11 14:01:22", "2025-10-11 14:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3902", "1316", "عملیات توسط WP Cron کامل شد", "2025-10-11 14:01:22", "2025-10-11 14:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3903", "1317", "عملیات توسط WP Cron شروع شد", "2025-10-11 16:08:51", "2025-10-11 16:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3904", "1318", "ایجاد فعالیت", "2025-10-11 16:08:51", "2025-10-11 16:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3905", "1317", "عملیات توسط WP Cron کامل شد", "2025-10-11 16:08:51", "2025-10-11 16:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3906", "1318", "عملیات توسط WP Cron شروع شد", "2025-10-11 17:48:06", "2025-10-11 17:48:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3907", "1319", "ایجاد فعالیت", "2025-10-11 17:48:06", "2025-10-11 17:48:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3908", "1318", "عملیات توسط WP Cron کامل شد", "2025-10-11 17:48:06", "2025-10-11 17:48:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3909", "1319", "عملیات توسط WP Cron شروع شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3910", "1320", "ایجاد فعالیت", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3911", "1319", "عملیات توسط WP Cron کامل شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3912", "1305", "عملیات توسط WP Cron شروع شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3913", "1305", "عملیات توسط WP Cron کامل شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3914", "1321", "ایجاد فعالیت", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3915", "1306", "عملیات توسط WP Cron شروع شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3916", "1306", "عملیات توسط WP Cron کامل شد", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3917", "1322", "ایجاد فعالیت", "2025-10-11 20:39:36", "2025-10-11 20:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3918", "1320", "عملیات توسط WP Cron شروع شد", "2025-10-12 02:20:00", "2025-10-12 02:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3919", "1323", "ایجاد فعالیت", "2025-10-12 02:20:01", "2025-10-12 02:20:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("3920", "1320", "عملیات توسط WP Cron کامل شد", "2025-10-12 02:20:01", "2025-10-12 02:20:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("3921", "1323", "عملیات توسط WP Cron شروع شد", "2025-10-12 08:14:54", "2025-10-12 08:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3922", "1324", "ایجاد فعالیت", "2025-10-12 08:14:54", "2025-10-12 08:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3923", "1323", "عملیات توسط WP Cron کامل شد", "2025-10-12 08:14:54", "2025-10-12 08:14:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3924", "1321", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3925", "1321", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3926", "1325", "ایجاد فعالیت", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3927", "1322", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3928", "1322", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3929", "1326", "ایجاد فعالیت", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3930", "1307", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3931", "1307", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3932", "1327", "ایجاد فعالیت", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3933", "1308", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3934", "1308", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3935", "1328", "ایجاد فعالیت", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3936", "1309", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:39", "2025-10-12 10:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3937", "1309", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:40", "2025-10-12 10:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3938", "1329", "ایجاد فعالیت", "2025-10-12 10:34:40", "2025-10-12 10:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3939", "1310", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:40", "2025-10-12 10:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3940", "1310", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:41", "2025-10-12 10:34:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3941", "1330", "ایجاد فعالیت", "2025-10-12 10:34:41", "2025-10-12 10:34:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3942", "1311", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:41", "2025-10-12 10:34:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3943", "1311", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3944", "1331", "ایجاد فعالیت", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3945", "1312", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3946", "1312", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3947", "1332", "ایجاد فعالیت", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3948", "1324", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3949", "1333", "ایجاد فعالیت", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3950", "1324", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3951", "1315", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3952", "1334", "ایجاد فعالیت", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3953", "1315", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3954", "1335", "ایجاد فعالیت", "2025-10-12 10:34:42", "2025-10-12 10:34:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3955", "1334", "عملیات توسط WP Cron شروع شد", "2025-10-12 10:40:40", "2025-10-12 10:40:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3956", "1334", "عملیات توسط WP Cron کامل شد", "2025-10-12 10:40:41", "2025-10-12 10:40:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3957", "1333", "عملیات توسط WP Cron شروع شد", "2025-10-12 11:42:55", "2025-10-12 11:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3958", "1336", "ایجاد فعالیت", "2025-10-12 11:42:55", "2025-10-12 11:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3959", "1333", "عملیات توسط WP Cron کامل شد", "2025-10-12 11:42:55", "2025-10-12 11:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3960", "1336", "عملیات توسط WP Cron شروع شد", "2025-10-12 13:01:20", "2025-10-12 13:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3961", "1337", "ایجاد فعالیت", "2025-10-12 13:01:20", "2025-10-12 13:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3962", "1336", "عملیات توسط WP Cron کامل شد", "2025-10-12 13:01:20", "2025-10-12 13:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3963", "1337", "عملیات توسط WP Cron شروع شد", "2025-10-12 14:05:51", "2025-10-12 14:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3964", "1338", "ایجاد فعالیت", "2025-10-12 14:05:51", "2025-10-12 14:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3965", "1337", "عملیات توسط WP Cron کامل شد", "2025-10-12 14:05:51", "2025-10-12 14:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3966", "1338", "عملیات توسط WP Cron شروع شد", "2025-10-12 15:41:28", "2025-10-12 15:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3967", "1339", "ایجاد فعالیت", "2025-10-12 15:41:28", "2025-10-12 15:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3968", "1338", "عملیات توسط WP Cron کامل شد", "2025-10-12 15:41:28", "2025-10-12 15:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3969", "1339", "عملیات توسط WP Cron شروع شد", "2025-10-12 17:21:44", "2025-10-12 17:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3970", "1340", "ایجاد فعالیت", "2025-10-12 17:21:44", "2025-10-12 17:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3971", "1339", "عملیات توسط WP Cron کامل شد", "2025-10-12 17:21:44", "2025-10-12 17:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3972", "1340", "عملیات توسط WP Cron شروع شد", "2025-10-12 18:46:34", "2025-10-12 18:46:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3973", "1341", "ایجاد فعالیت", "2025-10-12 18:46:34", "2025-10-12 18:46:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3974", "1340", "عملیات توسط WP Cron کامل شد", "2025-10-12 18:46:34", "2025-10-12 18:46:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3975", "1341", "عملیات توسط WP Cron شروع شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3976", "1342", "ایجاد فعالیت", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3977", "1341", "عملیات توسط WP Cron کامل شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3978", "1325", "عملیات توسط WP Cron شروع شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3979", "1325", "عملیات توسط WP Cron کامل شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3980", "1343", "ایجاد فعالیت", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3981", "1326", "عملیات توسط WP Cron شروع شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3982", "1326", "عملیات توسط WP Cron کامل شد", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3983", "1344", "ایجاد فعالیت", "2025-10-13 02:19:48", "2025-10-13 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3984", "1342", "عملیات توسط WP Cron شروع شد", "2025-10-13 06:22:37", "2025-10-13 06:22:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3985", "1345", "ایجاد فعالیت", "2025-10-13 06:22:37", "2025-10-13 06:22:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3986", "1342", "عملیات توسط WP Cron کامل شد", "2025-10-13 06:22:37", "2025-10-13 06:22:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3987", "1345", "عملیات توسط WP Cron شروع شد", "2025-10-13 09:36:38", "2025-10-13 09:36:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3988", "1346", "ایجاد فعالیت", "2025-10-13 09:36:38", "2025-10-13 09:36:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3989", "1345", "عملیات توسط WP Cron کامل شد", "2025-10-13 09:36:38", "2025-10-13 09:36:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3990", "1327", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3991", "1327", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3992", "1347", "ایجاد فعالیت", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3993", "1328", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3994", "1328", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3995", "1348", "ایجاد فعالیت", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3996", "1329", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:34", "2025-10-13 11:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3997", "1329", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:35", "2025-10-13 11:49:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3998", "1349", "ایجاد فعالیت", "2025-10-13 11:49:35", "2025-10-13 11:49:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3999", "1330", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:35", "2025-10-13 11:49:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4000", "1330", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:36", "2025-10-13 11:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4001", "1350", "ایجاد فعالیت", "2025-10-13 11:49:36", "2025-10-13 11:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4002", "1331", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:36", "2025-10-13 11:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4003", "1331", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:36", "2025-10-13 11:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4004", "1351", "ایجاد فعالیت", "2025-10-13 11:49:36", "2025-10-13 11:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4005", "1332", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4006", "1332", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4007", "1352", "ایجاد فعالیت", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4008", "1346", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4009", "1353", "ایجاد فعالیت", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4010", "1346", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4011", "1335", "عملیات توسط WP Cron شروع شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4012", "1354", "ایجاد فعالیت", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4013", "1335", "عملیات توسط WP Cron کامل شد", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4014", "1355", "ایجاد فعالیت", "2025-10-13 11:49:37", "2025-10-13 11:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4015", "1354", "عملیات توسط WP Cron شروع شد", "2025-10-13 12:21:44", "2025-10-13 12:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4016", "1354", "عملیات توسط WP Cron کامل شد", "2025-10-13 12:21:44", "2025-10-13 12:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4017", "1353", "عملیات توسط WP Cron شروع شد", "2025-10-13 13:38:48", "2025-10-13 13:38:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4018", "1356", "ایجاد فعالیت", "2025-10-13 13:38:48", "2025-10-13 13:38:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4019", "1353", "عملیات توسط WP Cron کامل شد", "2025-10-13 13:38:48", "2025-10-13 13:38:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4020", "1343", "عملیات توسط WP Cron شروع شد", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4021", "1343", "عملیات توسط WP Cron کامل شد", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4022", "1357", "ایجاد فعالیت", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4023", "1344", "عملیات توسط WP Cron شروع شد", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4024", "1344", "عملیات توسط WP Cron کامل شد", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4025", "1358", "ایجاد فعالیت", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4026", "1356", "عملیات توسط WP Cron شروع شد", "2025-10-13 14:50:32", "2025-10-13 14:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4027", "1359", "ایجاد فعالیت", "2025-10-13 14:50:33", "2025-10-13 14:50:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4028", "1356", "عملیات توسط WP Cron کامل شد", "2025-10-13 14:50:33", "2025-10-13 14:50:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4029", "1359", "عملیات توسط WP Cron شروع شد", "2025-10-13 16:33:55", "2025-10-13 16:33:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4030", "1360", "ایجاد فعالیت", "2025-10-13 16:33:55", "2025-10-13 16:33:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4031", "1359", "عملیات توسط WP Cron کامل شد", "2025-10-13 16:33:55", "2025-10-13 16:33:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4032", "1360", "عملیات توسط WP Cron شروع شد", "2025-10-13 17:48:08", "2025-10-13 17:48:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4033", "1361", "ایجاد فعالیت", "2025-10-13 17:48:08", "2025-10-13 17:48:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4034", "1360", "عملیات توسط WP Cron کامل شد", "2025-10-13 17:48:08", "2025-10-13 17:48:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4035", "1361", "عملیات توسط WP Cron شروع شد", "2025-10-13 19:49:22", "2025-10-13 19:49:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4036", "1362", "ایجاد فعالیت", "2025-10-13 19:49:23", "2025-10-13 19:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("4037", "1361", "عملیات توسط WP Cron کامل شد", "2025-10-13 19:49:23", "2025-10-13 19:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("4038", "1362", "عملیات توسط WP Cron شروع شد", "2025-10-13 21:22:52", "2025-10-13 21:22:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4039", "1363", "ایجاد فعالیت", "2025-10-13 21:22:52", "2025-10-13 21:22:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4040", "1362", "عملیات توسط WP Cron کامل شد", "2025-10-13 21:22:52", "2025-10-13 21:22:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4041", "1363", "عملیات توسط WP Cron شروع شد", "2025-10-14 02:20:49", "2025-10-14 02:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4042", "1364", "ایجاد فعالیت", "2025-10-14 02:20:49", "2025-10-14 02:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4043", "1363", "عملیات توسط WP Cron کامل شد", "2025-10-14 02:20:49", "2025-10-14 02:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4044", "1357", "عملیات توسط WP Cron شروع شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4045", "1357", "عملیات توسط WP Cron کامل شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4046", "1365", "ایجاد فعالیت", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4047", "1358", "عملیات توسط WP Cron شروع شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4048", "1358", "عملیات توسط WP Cron کامل شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4049", "1366", "ایجاد فعالیت", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4050", "1364", "عملیات توسط WP Cron شروع شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4051", "1367", "ایجاد فعالیت", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4052", "1364", "عملیات توسط WP Cron کامل شد", "2025-10-14 06:06:38", "2025-10-14 06:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4053", "1367", "عملیات توسط WP Cron شروع شد", "2025-10-14 07:31:43", "2025-10-14 07:31:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4054", "1368", "ایجاد فعالیت", "2025-10-14 07:31:43", "2025-10-14 07:31:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4055", "1367", "عملیات توسط WP Cron کامل شد", "2025-10-14 07:31:43", "2025-10-14 07:31:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4056", "1368", "عملیات توسط WP Cron شروع شد", "2025-10-14 09:40:11", "2025-10-14 09:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4057", "1369", "ایجاد فعالیت", "2025-10-14 09:40:11", "2025-10-14 09:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4058", "1368", "عملیات توسط WP Cron کامل شد", "2025-10-14 09:40:11", "2025-10-14 09:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4059", "1369", "عملیات توسط WP Cron شروع شد", "2025-10-14 11:30:09", "2025-10-14 11:30:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4060", "1370", "ایجاد فعالیت", "2025-10-14 11:30:09", "2025-10-14 11:30:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4061", "1369", "عملیات توسط WP Cron کامل شد", "2025-10-14 11:30:09", "2025-10-14 11:30:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4062", "1347", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:05", "2025-10-14 12:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4063", "1347", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:05", "2025-10-14 12:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4064", "1371", "ایجاد فعالیت", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4065", "1348", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4066", "1348", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4067", "1372", "ایجاد فعالیت", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4068", "1349", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4069", "1349", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:06", "2025-10-14 12:45:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4070", "1373", "ایجاد فعالیت", "2025-10-14 12:45:07", "2025-10-14 12:45:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4071", "1350", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:07", "2025-10-14 12:45:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4072", "1350", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4073", "1374", "ایجاد فعالیت", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4074", "1351", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4075", "1351", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4076", "1375", "ایجاد فعالیت", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4077", "1352", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4078", "1352", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4079", "1376", "ایجاد فعالیت", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4080", "1370", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4081", "1377", "ایجاد فعالیت", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4082", "1370", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4083", "1355", "عملیات توسط WP Cron شروع شد", "2025-10-14 12:45:08", "2025-10-14 12:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4084", "1378", "ایجاد فعالیت", "2025-10-14 12:45:09", "2025-10-14 12:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4085", "1355", "عملیات توسط WP Cron کامل شد", "2025-10-14 12:45:09", "2025-10-14 12:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4086", "1379", "ایجاد فعالیت", "2025-10-14 12:45:09", "2025-10-14 12:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4087", "1378", "عملیات توسط WP Cron شروع شد", "2025-10-14 13:35:49", "2025-10-14 13:35:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4088", "1378", "عملیات توسط WP Cron کامل شد", "2025-10-14 13:35:49", "2025-10-14 13:35:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4089", "1377", "عملیات توسط WP Cron شروع شد", "2025-10-14 13:47:49", "2025-10-14 13:47:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4090", "1380", "ایجاد فعالیت", "2025-10-14 13:47:49", "2025-10-14 13:47:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4091", "1377", "عملیات توسط WP Cron کامل شد", "2025-10-14 13:47:49", "2025-10-14 13:47:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4092", "1380", "عملیات توسط WP Cron شروع شد", "2025-10-14 15:55:39", "2025-10-14 15:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4093", "1381", "ایجاد فعالیت", "2025-10-14 15:55:39", "2025-10-14 15:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4094", "1380", "عملیات توسط WP Cron کامل شد", "2025-10-14 15:55:39", "2025-10-14 15:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4095", "1381", "عملیات توسط WP Cron شروع شد", "2025-10-14 17:02:44", "2025-10-14 17:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4096", "1382", "ایجاد فعالیت", "2025-10-14 17:02:44", "2025-10-14 17:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4097", "1381", "عملیات توسط WP Cron کامل شد", "2025-10-14 17:02:44", "2025-10-14 17:02:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4098", "1382", "عملیات توسط WP Cron شروع شد", "2025-10-14 18:02:54", "2025-10-14 18:02:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4099", "1383", "ایجاد فعالیت", "2025-10-14 18:02:54", "2025-10-14 18:02:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4100", "1382", "عملیات توسط WP Cron کامل شد", "2025-10-14 18:02:54", "2025-10-14 18:02:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4101", "1365", "عملیات توسط WP Cron شروع شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4102", "1365", "عملیات توسط WP Cron کامل شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4103", "1384", "ایجاد فعالیت", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4104", "1366", "عملیات توسط WP Cron شروع شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4105", "1366", "عملیات توسط WP Cron کامل شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4106", "1385", "ایجاد فعالیت", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4107", "1383", "عملیات توسط WP Cron شروع شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4108", "1386", "ایجاد فعالیت", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4109", "1383", "عملیات توسط WP Cron کامل شد", "2025-10-14 19:06:59", "2025-10-14 19:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4110", "1386", "عملیات توسط WP Cron شروع شد", "2025-10-14 20:59:16", "2025-10-14 20:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4111", "1387", "ایجاد فعالیت", "2025-10-14 20:59:16", "2025-10-14 20:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4112", "1386", "عملیات توسط WP Cron کامل شد", "2025-10-14 20:59:16", "2025-10-14 20:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4113", "1387", "عملیات توسط WP Cron شروع شد", "2025-10-15 02:20:58", "2025-10-15 02:20:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4114", "1388", "ایجاد فعالیت", "2025-10-15 02:20:59", "2025-10-15 02:20:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4115", "1387", "عملیات توسط WP Cron کامل شد", "2025-10-15 02:20:59", "2025-10-15 02:20:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4116", "1388", "عملیات توسط WP Cron شروع شد", "2025-10-15 04:47:20", "2025-10-15 04:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4117", "1389", "ایجاد فعالیت", "2025-10-15 04:47:20", "2025-10-15 04:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4118", "1388", "عملیات توسط WP Cron کامل شد", "2025-10-15 04:47:21", "2025-10-15 04:47:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4119", "1389", "عملیات توسط WP Cron شروع شد", "2025-10-15 05:48:31", "2025-10-15 05:48:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4120", "1390", "ایجاد فعالیت", "2025-10-15 05:48:32", "2025-10-15 05:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4121", "1389", "عملیات توسط WP Cron کامل شد", "2025-10-15 05:48:32", "2025-10-15 05:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4122", "1390", "عملیات توسط WP Cron شروع شد", "2025-10-15 06:53:56", "2025-10-15 06:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4123", "1391", "ایجاد فعالیت", "2025-10-15 06:53:56", "2025-10-15 06:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4124", "1390", "عملیات توسط WP Cron کامل شد", "2025-10-15 06:53:56", "2025-10-15 06:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4125", "1384", "عملیات توسط WP Cron شروع شد", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4126", "1384", "عملیات توسط WP Cron کامل شد", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4127", "1392", "ایجاد فعالیت", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4128", "1385", "عملیات توسط WP Cron شروع شد", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4129", "1385", "عملیات توسط WP Cron کامل شد", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4130", "1393", "ایجاد فعالیت", "2025-10-15 07:28:24", "2025-10-15 07:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4131", "1391", "عملیات توسط WP Cron شروع شد", "2025-10-15 07:58:25", "2025-10-15 07:58:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4132", "1394", "ایجاد فعالیت", "2025-10-15 07:58:25", "2025-10-15 07:58:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4133", "1391", "عملیات توسط WP Cron کامل شد", "2025-10-15 07:58:25", "2025-10-15 07:58:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4134", "1394", "عملیات توسط WP Cron شروع شد", "2025-10-15 10:10:42", "2025-10-15 10:10:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4135", "1395", "ایجاد فعالیت", "2025-10-15 10:10:42", "2025-10-15 10:10:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4136", "1394", "عملیات توسط WP Cron کامل شد", "2025-10-15 10:10:42", "2025-10-15 10:10:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4137", "1395", "عملیات توسط WP Cron شروع شد", "2025-10-15 11:12:40", "2025-10-15 11:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4138", "1396", "ایجاد فعالیت", "2025-10-15 11:12:40", "2025-10-15 11:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4139", "1395", "عملیات توسط WP Cron کامل شد", "2025-10-15 11:12:40", "2025-10-15 11:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4140", "1396", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:37:59", "2025-10-15 14:37:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4141", "1397", "ایجاد فعالیت", "2025-10-15 14:37:59", "2025-10-15 14:37:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4142", "1396", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4143", "1371", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4144", "1371", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4145", "1398", "ایجاد فعالیت", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4146", "1372", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4147", "1372", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4148", "1399", "ایجاد فعالیت", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4149", "1373", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4150", "1373", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4151", "1400", "ایجاد فعالیت", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4152", "1374", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:00", "2025-10-15 14:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4153", "1374", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:01", "2025-10-15 14:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4154", "1401", "ایجاد فعالیت", "2025-10-15 14:38:01", "2025-10-15 14:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4155", "1375", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:01", "2025-10-15 14:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4156", "1375", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4157", "1402", "ایجاد فعالیت", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4158", "1376", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4159", "1376", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4160", "1403", "ایجاد فعالیت", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4161", "1379", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4162", "1404", "ایجاد فعالیت", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4163", "1379", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4164", "1405", "ایجاد فعالیت", "2025-10-15 14:38:02", "2025-10-15 14:38:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4165", "1404", "عملیات توسط WP Cron شروع شد", "2025-10-15 14:45:09", "2025-10-15 14:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4166", "1404", "عملیات توسط WP Cron کامل شد", "2025-10-15 14:45:09", "2025-10-15 14:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4167", "1397", "عملیات توسط WP Cron شروع شد", "2025-10-15 15:56:33", "2025-10-15 15:56:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4168", "1406", "ایجاد فعالیت", "2025-10-15 15:56:33", "2025-10-15 15:56:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4169", "1397", "عملیات توسط WP Cron کامل شد", "2025-10-15 15:56:33", "2025-10-15 15:56:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4170", "1406", "عملیات توسط WP Cron شروع شد", "2025-10-15 17:35:36", "2025-10-15 17:35:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4171", "1407", "ایجاد فعالیت", "2025-10-15 17:35:36", "2025-10-15 17:35:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4172", "1406", "عملیات توسط WP Cron کامل شد", "2025-10-15 17:35:36", "2025-10-15 17:35:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4173", "1407", "عملیات توسط WP Cron شروع شد", "2025-10-15 18:37:15", "2025-10-15 18:37:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4174", "1408", "ایجاد فعالیت", "2025-10-15 18:37:15", "2025-10-15 18:37:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4175", "1407", "عملیات توسط WP Cron کامل شد", "2025-10-15 18:37:15", "2025-10-15 18:37:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4176", "1392", "عملیات توسط WP Cron شروع شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4177", "1392", "عملیات توسط WP Cron کامل شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4178", "1409", "ایجاد فعالیت", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4179", "1393", "عملیات توسط WP Cron شروع شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4180", "1393", "عملیات توسط WP Cron کامل شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4181", "1410", "ایجاد فعالیت", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4182", "1408", "عملیات توسط WP Cron شروع شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4183", "1411", "ایجاد فعالیت", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4184", "1408", "عملیات توسط WP Cron کامل شد", "2025-10-16 00:49:21", "2025-10-16 00:49:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4185", "1411", "عملیات توسط WP Cron شروع شد", "2025-10-16 02:19:47", "2025-10-16 02:19:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4186", "1412", "ایجاد فعالیت", "2025-10-16 02:19:47", "2025-10-16 02:19:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4187", "1411", "عملیات توسط WP Cron کامل شد", "2025-10-16 02:19:47", "2025-10-16 02:19:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4188", "1412", "عملیات توسط WP Cron شروع شد", "2025-10-16 06:05:30", "2025-10-16 06:05:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4189", "1413", "ایجاد فعالیت", "2025-10-16 06:05:30", "2025-10-16 06:05:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4190", "1412", "عملیات توسط WP Cron کامل شد", "2025-10-16 06:05:30", "2025-10-16 06:05:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4191", "1413", "عملیات توسط WP Cron شروع شد", "2025-10-16 07:20:48", "2025-10-16 07:20:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4192", "1414", "ایجاد فعالیت", "2025-10-16 07:20:48", "2025-10-16 07:20:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4193", "1413", "عملیات توسط WP Cron کامل شد", "2025-10-16 07:20:48", "2025-10-16 07:20:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4194", "1414", "عملیات توسط WP Cron شروع شد", "2025-10-16 09:08:20", "2025-10-16 09:08:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4195", "1415", "ایجاد فعالیت", "2025-10-16 09:08:20", "2025-10-16 09:08:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4196", "1414", "عملیات توسط WP Cron کامل شد", "2025-10-16 09:08:20", "2025-10-16 09:08:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4197", "1415", "عملیات توسط WP Cron شروع شد", "2025-10-16 10:38:25", "2025-10-16 10:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4198", "1416", "ایجاد فعالیت", "2025-10-16 10:38:25", "2025-10-16 10:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4199", "1415", "عملیات توسط WP Cron کامل شد", "2025-10-16 10:38:25", "2025-10-16 10:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4200", "1416", "عملیات توسط WP Cron شروع شد", "2025-10-16 13:10:29", "2025-10-16 13:10:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4201", "1417", "ایجاد فعالیت", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4202", "1416", "عملیات توسط WP Cron کامل شد", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4203", "1409", "عملیات توسط WP Cron شروع شد", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4204", "1409", "عملیات توسط WP Cron کامل شد", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4205", "1418", "ایجاد فعالیت", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4206", "1410", "عملیات توسط WP Cron شروع شد", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4207", "1410", "عملیات توسط WP Cron کامل شد", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4208", "1419", "ایجاد فعالیت", "2025-10-16 13:10:30", "2025-10-16 13:10:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4209", "1417", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:21:55", "2025-10-16 14:21:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4210", "1420", "ایجاد فعالیت", "2025-10-16 14:21:55", "2025-10-16 14:21:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4211", "1417", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:21:56", "2025-10-16 14:21:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4212", "1398", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4213", "1398", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4214", "1421", "ایجاد فعالیت", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4215", "1399", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4216", "1399", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4217", "1422", "ایجاد فعالیت", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4218", "1400", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:33", "2025-10-16 14:45:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4219", "1400", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:34", "2025-10-16 14:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4220", "1423", "ایجاد فعالیت", "2025-10-16 14:45:34", "2025-10-16 14:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4221", "1401", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:34", "2025-10-16 14:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4222", "1401", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4223", "1424", "ایجاد فعالیت", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4224", "1402", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4225", "1402", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4226", "1425", "ایجاد فعالیت", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4227", "1403", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4228", "1403", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4229", "1426", "ایجاد فعالیت", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4230", "1405", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:35", "2025-10-16 14:45:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4231", "1427", "ایجاد فعالیت", "2025-10-16 14:45:36", "2025-10-16 14:45:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4232", "1405", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:36", "2025-10-16 14:45:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4233", "1428", "ایجاد فعالیت", "2025-10-16 14:45:36", "2025-10-16 14:45:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4234", "1427", "عملیات توسط WP Cron شروع شد", "2025-10-16 14:45:48", "2025-10-16 14:45:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4235", "1427", "عملیات توسط WP Cron کامل شد", "2025-10-16 14:45:48", "2025-10-16 14:45:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4236", "1420", "عملیات توسط WP Cron شروع شد", "2025-10-16 16:53:01", "2025-10-16 16:53:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4237", "1429", "ایجاد فعالیت", "2025-10-16 16:53:01", "2025-10-16 16:53:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4238", "1420", "عملیات توسط WP Cron کامل شد", "2025-10-16 16:53:01", "2025-10-16 16:53:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4239", "1429", "عملیات توسط WP Cron شروع شد", "2025-10-16 18:28:17", "2025-10-16 18:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4240", "1430", "ایجاد فعالیت", "2025-10-16 18:28:17", "2025-10-16 18:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4241", "1429", "عملیات توسط WP Cron کامل شد", "2025-10-16 18:28:17", "2025-10-16 18:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4242", "1430", "عملیات توسط WP Cron شروع شد", "2025-10-16 19:58:44", "2025-10-16 19:58:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4243", "1431", "ایجاد فعالیت", "2025-10-16 19:58:44", "2025-10-16 19:58:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4244", "1430", "عملیات توسط WP Cron کامل شد", "2025-10-16 19:58:44", "2025-10-16 19:58:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4245", "1431", "عملیات توسط WP Cron شروع شد", "2025-10-16 21:42:57", "2025-10-16 21:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4246", "1432", "ایجاد فعالیت", "2025-10-16 21:42:57", "2025-10-16 21:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4247", "1431", "عملیات توسط WP Cron کامل شد", "2025-10-16 21:42:57", "2025-10-16 21:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4248", "1432", "عملیات توسط WP Cron شروع شد", "2025-10-16 22:51:06", "2025-10-16 22:51:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4249", "1433", "ایجاد فعالیت", "2025-10-16 22:51:06", "2025-10-16 22:51:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4250", "1432", "عملیات توسط WP Cron کامل شد", "2025-10-16 22:51:06", "2025-10-16 22:51:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4251", "1433", "عملیات توسط WP Cron شروع شد", "2025-10-17 02:20:14", "2025-10-17 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4252", "1434", "ایجاد فعالیت", "2025-10-17 02:20:14", "2025-10-17 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4253", "1433", "عملیات توسط WP Cron کامل شد", "2025-10-17 02:20:14", "2025-10-17 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4254", "1418", "عملیات توسط WP Cron شروع شد", "2025-10-17 02:20:14", "2025-10-17 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4255", "1418", "عملیات توسط WP Cron کامل شد", "2025-10-17 02:20:15", "2025-10-17 02:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4256", "1435", "ایجاد فعالیت", "2025-10-17 02:20:15", "2025-10-17 02:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4257", "1419", "عملیات توسط WP Cron شروع شد", "2025-10-17 02:20:15", "2025-10-17 02:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4258", "1419", "عملیات توسط WP Cron کامل شد", "2025-10-17 02:20:15", "2025-10-17 02:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4259", "1436", "ایجاد فعالیت", "2025-10-17 02:20:15", "2025-10-17 02:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4260", "1434", "عملیات توسط WP Cron شروع شد", "2025-10-17 10:40:14", "2025-10-17 10:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4261", "1437", "ایجاد فعالیت", "2025-10-17 10:40:14", "2025-10-17 10:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4262", "1434", "عملیات توسط WP Cron کامل شد", "2025-10-17 10:40:14", "2025-10-17 10:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4263", "1437", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:43:38", "2025-10-17 14:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4264", "1438", "ایجاد فعالیت", "2025-10-17 14:43:38", "2025-10-17 14:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4265", "1437", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:43:38", "2025-10-17 14:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4266", "1435", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:43:38", "2025-10-17 14:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4267", "1435", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:43:38", "2025-10-17 14:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4268", "1439", "ایجاد فعالیت", "2025-10-17 14:43:39", "2025-10-17 14:43:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4269", "1436", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:43:39", "2025-10-17 14:43:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4270", "1436", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:43:39", "2025-10-17 14:43:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4271", "1440", "ایجاد فعالیت", "2025-10-17 14:43:39", "2025-10-17 14:43:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4272", "1421", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:17", "2025-10-17 14:57:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4273", "1421", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:17", "2025-10-17 14:57:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4274", "1441", "ایجاد فعالیت", "2025-10-17 14:57:17", "2025-10-17 14:57:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4275", "1422", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:17", "2025-10-17 14:57:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4276", "1422", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:18", "2025-10-17 14:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4277", "1442", "ایجاد فعالیت", "2025-10-17 14:57:18", "2025-10-17 14:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4278", "1423", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:18", "2025-10-17 14:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4279", "1423", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:19", "2025-10-17 14:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4280", "1443", "ایجاد فعالیت", "2025-10-17 14:57:19", "2025-10-17 14:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4281", "1424", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:19", "2025-10-17 14:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4282", "1424", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4283", "1444", "ایجاد فعالیت", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4284", "1425", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4285", "1425", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4286", "1445", "ایجاد فعالیت", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4287", "1426", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4288", "1426", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4289", "1446", "ایجاد فعالیت", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4290", "1428", "عملیات توسط WP Cron شروع شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4291", "1447", "ایجاد فعالیت", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4292", "1428", "عملیات توسط WP Cron کامل شد", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4293", "1448", "ایجاد فعالیت", "2025-10-17 14:57:20", "2025-10-17 14:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4294", "1447", "عملیات توسط WP Cron شروع شد", "2025-10-17 15:57:18", "2025-10-17 15:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4295", "1447", "عملیات توسط WP Cron کامل شد", "2025-10-17 15:57:18", "2025-10-17 15:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4296", "1438", "عملیات توسط WP Cron شروع شد", "2025-10-17 15:57:18", "2025-10-17 15:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4297", "1449", "ایجاد فعالیت", "2025-10-17 15:57:18", "2025-10-17 15:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4298", "1438", "عملیات توسط WP Cron کامل شد", "2025-10-17 15:57:18", "2025-10-17 15:57:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4299", "1449", "عملیات توسط WP Cron شروع شد", "2025-10-17 17:08:16", "2025-10-17 17:08:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4300", "1450", "ایجاد فعالیت", "2025-10-17 17:08:16", "2025-10-17 17:08:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4301", "1449", "عملیات توسط WP Cron کامل شد", "2025-10-17 17:08:16", "2025-10-17 17:08:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4302", "1450", "عملیات توسط WP Cron شروع شد", "2025-10-18 02:20:14", "2025-10-18 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4303", "1451", "ایجاد فعالیت", "2025-10-18 02:20:14", "2025-10-18 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4304", "1450", "عملیات توسط WP Cron کامل شد", "2025-10-18 02:20:14", "2025-10-18 02:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4305", "1439", "عملیات توسط WP Cron شروع شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4306", "1439", "عملیات توسط WP Cron کامل شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4307", "1452", "ایجاد فعالیت", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4308", "1440", "عملیات توسط WP Cron شروع شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4309", "1440", "عملیات توسط WP Cron کامل شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4310", "1453", "ایجاد فعالیت", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4311", "1451", "عملیات توسط WP Cron شروع شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4312", "1454", "ایجاد فعالیت", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4313", "1451", "عملیات توسط WP Cron کامل شد", "2025-10-18 07:36:14", "2025-10-18 07:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4314", "1454", "عملیات توسط WP Cron شروع شد", "2025-10-18 08:39:01", "2025-10-18 08:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4315", "1455", "ایجاد فعالیت", "2025-10-18 08:39:01", "2025-10-18 08:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4316", "1454", "عملیات توسط WP Cron کامل شد", "2025-10-18 08:39:01", "2025-10-18 08:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4317", "1455", "عملیات توسط WP Cron شروع شد", "2025-10-18 10:37:18", "2025-10-18 10:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4318", "1456", "ایجاد فعالیت", "2025-10-18 10:37:18", "2025-10-18 10:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4319", "1455", "عملیات توسط WP Cron کامل شد", "2025-10-18 10:37:18", "2025-10-18 10:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("4320", "1456", "عملیات توسط WP Cron شروع شد", "2025-10-18 11:53:56", "2025-10-18 11:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4321", "1457", "ایجاد فعالیت", "2025-10-18 11:53:56", "2025-10-18 11:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4322", "1456", "عملیات توسط WP Cron کامل شد", "2025-10-18 11:53:56", "2025-10-18 11:53:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4323", "1457", "عملیات توسط WP Cron شروع شد", "2025-10-18 13:07:07", "2025-10-18 13:07:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4324", "1458", "ایجاد فعالیت", "2025-10-18 13:07:07", "2025-10-18 13:07:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4325", "1457", "عملیات توسط WP Cron کامل شد", "2025-10-18 13:07:07", "2025-10-18 13:07:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4326", "1458", "عملیات توسط WP Cron شروع شد", "2025-10-18 14:51:38", "2025-10-18 14:51:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4327", "1459", "ایجاد فعالیت", "2025-10-18 14:51:38", "2025-10-18 14:51:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4328", "1458", "عملیات توسط WP Cron کامل شد", "2025-10-18 14:51:38", "2025-10-18 14:51:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4329", "1441", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:42", "2025-10-18 15:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4330", "1441", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:42", "2025-10-18 15:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4331", "1460", "ایجاد فعالیت", "2025-10-18 15:50:42", "2025-10-18 15:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4332", "1442", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:42", "2025-10-18 15:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4333", "1442", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4334", "1461", "ایجاد فعالیت", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4335", "1443", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4336", "1443", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4337", "1462", "ایجاد فعالیت", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4338", "1444", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:43", "2025-10-18 15:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4339", "1444", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4340", "1463", "ایجاد فعالیت", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4341", "1445", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4342", "1445", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4343", "1464", "ایجاد فعالیت", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4344", "1446", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:44", "2025-10-18 15:50:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4345", "1446", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4346", "1465", "ایجاد فعالیت", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4347", "1448", "عملیات توسط WP Cron شروع شد", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4348", "1466", "ایجاد فعالیت", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4349", "1448", "عملیات توسط WP Cron کامل شد", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4350", "1467", "ایجاد فعالیت", "2025-10-18 15:50:45", "2025-10-18 15:50:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4351", "1466", "عملیات توسط WP Cron شروع شد", "2025-10-18 16:31:48", "2025-10-18 16:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4352", "1466", "عملیات توسط WP Cron کامل شد", "2025-10-18 16:31:48", "2025-10-18 16:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4353", "1459", "عملیات توسط WP Cron شروع شد", "2025-10-18 16:31:48", "2025-10-18 16:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4354", "1468", "ایجاد فعالیت", "2025-10-18 16:31:48", "2025-10-18 16:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4355", "1459", "عملیات توسط WP Cron کامل شد", "2025-10-18 16:31:48", "2025-10-18 16:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4356", "1468", "عملیات توسط WP Cron شروع شد", "2025-10-18 18:24:03", "2025-10-18 18:24:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4357", "1469", "ایجاد فعالیت", "2025-10-18 18:24:03", "2025-10-18 18:24:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4358", "1468", "عملیات توسط WP Cron کامل شد", "2025-10-18 18:24:03", "2025-10-18 18:24:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4359", "1469", "عملیات توسط WP Cron شروع شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4360", "1470", "ایجاد فعالیت", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4361", "1469", "عملیات توسط WP Cron کامل شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4362", "1452", "عملیات توسط WP Cron شروع شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4363", "1452", "عملیات توسط WP Cron کامل شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4364", "1471", "ایجاد فعالیت", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4365", "1453", "عملیات توسط WP Cron شروع شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4366", "1453", "عملیات توسط WP Cron کامل شد", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4367", "1472", "ایجاد فعالیت", "2025-10-18 20:21:43", "2025-10-18 20:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4368", "1470", "عملیات توسط WP Cron شروع شد", "2025-10-19 02:18:57", "2025-10-19 02:18:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4369", "1473", "ایجاد فعالیت", "2025-10-19 02:18:58", "2025-10-19 02:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4370", "1470", "عملیات توسط WP Cron کامل شد", "2025-10-19 02:18:58", "2025-10-19 02:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("4371", "1473", "عملیات توسط WP Cron شروع شد", "2025-10-19 05:50:21", "2025-10-19 05:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4372", "1474", "ایجاد فعالیت", "2025-10-19 05:50:21", "2025-10-19 05:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4373", "1473", "عملیات توسط WP Cron کامل شد", "2025-10-19 05:50:21", "2025-10-19 05:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("4374", "1474", "عملیات توسط WP Cron شروع شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4375", "1475", "ایجاد فعالیت", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4376", "1474", "عملیات توسط WP Cron کامل شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4377", "1471", "عملیات توسط WP Cron شروع شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4378", "1471", "عملیات توسط WP Cron کامل شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4379", "1476", "ایجاد فعالیت", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4380", "1472", "عملیات توسط WP Cron شروع شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4381", "1472", "عملیات توسط WP Cron کامل شد", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4382", "1477", "ایجاد فعالیت", "2025-10-19 08:25:28", "2025-10-19 08:25:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4383", "1475", "عملیات توسط WP Cron شروع شد", "2025-10-19 09:39:52", "2025-10-19 09:39:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4384", "1478", "ایجاد فعالیت", "2025-10-19 09:39:52", "2025-10-19 09:39:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4385", "1475", "عملیات توسط WP Cron کامل شد", "2025-10-19 09:39:52", "2025-10-19 09:39:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4386", "1478", "عملیات توسط WP Cron شروع شد", "2025-10-19 12:48:35", "2025-10-19 12:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4387", "1479", "ایجاد فعالیت", "2025-10-19 12:48:35", "2025-10-19 12:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4388", "1478", "عملیات توسط WP Cron کامل شد", "2025-10-19 12:48:35", "2025-10-19 12:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4389", "1479", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:44", "2025-10-19 18:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4390", "1480", "ایجاد فعالیت", "2025-10-19 18:18:44", "2025-10-19 18:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4391", "1479", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:44", "2025-10-19 18:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4392", "1460", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:44", "2025-10-19 18:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4393", "1460", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4394", "1481", "ایجاد فعالیت", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4395", "1461", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4396", "1461", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4397", "1482", "ایجاد فعالیت", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4398", "1462", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4399", "1462", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4400", "1483", "ایجاد فعالیت", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4401", "1463", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:45", "2025-10-19 18:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4402", "1463", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:46", "2025-10-19 18:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4403", "1484", "ایجاد فعالیت", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4404", "1464", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4405", "1464", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4406", "1485", "ایجاد فعالیت", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4407", "1465", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4408", "1465", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4409", "1486", "ایجاد فعالیت", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4410", "1467", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4411", "1487", "ایجاد فعالیت", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4412", "1467", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4413", "1488", "ایجاد فعالیت", "2025-10-19 18:18:47", "2025-10-19 18:18:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4414", "1487", "عملیات توسط WP Cron شروع شد", "2025-10-19 18:27:15", "2025-10-19 18:27:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4415", "1487", "عملیات توسط WP Cron کامل شد", "2025-10-19 18:27:15", "2025-10-19 18:27:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4416", "1480", "عملیات توسط WP Cron شروع شد", "2025-10-19 19:18:51", "2025-10-19 19:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4417", "1489", "ایجاد فعالیت", "2025-10-19 19:18:51", "2025-10-19 19:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4418", "1480", "عملیات توسط WP Cron کامل شد", "2025-10-19 19:18:51", "2025-10-19 19:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4419", "1489", "عملیات توسط WP Cron شروع شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4420", "1490", "ایجاد فعالیت", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4421", "1489", "عملیات توسط WP Cron کامل شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4422", "1476", "عملیات توسط WP Cron شروع شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4423", "1476", "عملیات توسط WP Cron کامل شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4424", "1491", "ایجاد فعالیت", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4425", "1477", "عملیات توسط WP Cron شروع شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4426", "1477", "عملیات توسط WP Cron کامل شد", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4427", "1492", "ایجاد فعالیت", "2025-10-19 20:35:20", "2025-10-19 20:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4428", "1490", "عملیات توسط WP Cron شروع شد", "2025-10-19 22:34:15", "2025-10-19 22:34:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4429", "1493", "ایجاد فعالیت", "2025-10-19 22:34:15", "2025-10-19 22:34:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4430", "1490", "عملیات توسط WP Cron کامل شد", "2025-10-19 22:34:15", "2025-10-19 22:34:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("4431", "1493", "عملیات توسط WP Cron شروع شد", "2025-10-20 02:19:04", "2025-10-20 02:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4432", "1494", "ایجاد فعالیت", "2025-10-20 02:19:04", "2025-10-20 02:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4433", "1493", "عملیات توسط WP Cron کامل شد", "2025-10-20 02:19:04", "2025-10-20 02:19:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4434", "1494", "عملیات توسط WP Cron شروع شد", "2025-10-20 05:10:01", "2025-10-20 05:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4435", "1495", "ایجاد فعالیت", "2025-10-20 05:10:01", "2025-10-20 05:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4436", "1494", "عملیات توسط WP Cron کامل شد", "2025-10-20 05:10:01", "2025-10-20 05:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4437", "1495", "عملیات توسط WP Cron شروع شد", "2025-10-20 06:20:49", "2025-10-20 06:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4438", "1496", "ایجاد فعالیت", "2025-10-20 06:20:49", "2025-10-20 06:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4439", "1495", "عملیات توسط WP Cron کامل شد", "2025-10-20 06:20:49", "2025-10-20 06:20:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4440", "1496", "عملیات توسط WP Cron شروع شد", "2025-10-20 07:57:44", "2025-10-20 07:57:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4441", "1497", "ایجاد فعالیت", "2025-10-20 07:57:44", "2025-10-20 07:57:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4442", "1496", "عملیات توسط WP Cron کامل شد", "2025-10-20 07:57:44", "2025-10-20 07:57:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4443", "1491", "عملیات توسط WP Cron شروع شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4444", "1491", "عملیات توسط WP Cron کامل شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4445", "1498", "ایجاد فعالیت", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4446", "1492", "عملیات توسط WP Cron شروع شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4447", "1492", "عملیات توسط WP Cron کامل شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4448", "1499", "ایجاد فعالیت", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4449", "1497", "عملیات توسط WP Cron شروع شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4450", "1500", "ایجاد فعالیت", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4451", "1497", "عملیات توسط WP Cron کامل شد", "2025-10-20 09:29:20", "2025-10-20 09:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4452", "1500", "عملیات توسط WP Cron شروع شد", "2025-10-20 11:34:14", "2025-10-20 11:34:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4453", "1501", "ایجاد فعالیت", "2025-10-20 11:34:14", "2025-10-20 11:34:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4454", "1500", "عملیات توسط WP Cron کامل شد", "2025-10-20 11:34:14", "2025-10-20 11:34:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("4455", "1501", "عملیات توسط WP Cron شروع شد", "2025-10-20 13:12:05", "2025-10-20 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4456", "1502", "ایجاد فعالیت", "2025-10-20 13:12:05", "2025-10-20 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4457", "1501", "عملیات توسط WP Cron کامل شد", "2025-10-20 13:12:05", "2025-10-20 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4458", "1502", "عملیات توسط WP Cron شروع شد", "2025-10-20 14:32:56", "2025-10-20 14:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4459", "1503", "ایجاد فعالیت", "2025-10-20 14:32:56", "2025-10-20 14:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4460", "1502", "عملیات توسط WP Cron کامل شد", "2025-10-20 14:32:56", "2025-10-20 14:32:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4461", "1503", "عملیات توسط WP Cron شروع شد", "2025-10-20 16:07:19", "2025-10-20 16:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4462", "1504", "ایجاد فعالیت", "2025-10-20 16:07:19", "2025-10-20 16:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4463", "1503", "عملیات توسط WP Cron کامل شد", "2025-10-20 16:07:19", "2025-10-20 16:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4464", "1504", "عملیات توسط WP Cron شروع شد", "2025-10-20 17:07:57", "2025-10-20 17:07:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4465", "1505", "ایجاد فعالیت", "2025-10-20 17:07:57", "2025-10-20 17:07:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4466", "1504", "عملیات توسط WP Cron کامل شد", "2025-10-20 17:07:57", "2025-10-20 17:07:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4467", "1505", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:10", "2025-10-20 20:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4468", "1506", "ایجاد فعالیت", "2025-10-20 20:02:10", "2025-10-20 20:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4469", "1505", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:10", "2025-10-20 20:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4470", "1481", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:10", "2025-10-20 20:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4471", "1481", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:10", "2025-10-20 20:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4472", "1507", "ایجاد فعالیت", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4473", "1482", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4474", "1482", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4475", "1508", "ایجاد فعالیت", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4476", "1483", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4477", "1483", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4478", "1509", "ایجاد فعالیت", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4479", "1484", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:11", "2025-10-20 20:02:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4480", "1484", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:12", "2025-10-20 20:02:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4481", "1510", "ایجاد فعالیت", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4482", "1485", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4483", "1485", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4484", "1511", "ایجاد فعالیت", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4485", "1486", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4486", "1486", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4487", "1512", "ایجاد فعالیت", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4488", "1488", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4489", "1513", "ایجاد فعالیت", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4490", "1488", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4491", "1514", "ایجاد فعالیت", "2025-10-20 20:02:13", "2025-10-20 20:02:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4492", "1513", "عملیات توسط WP Cron شروع شد", "2025-10-20 20:03:07", "2025-10-20 20:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4493", "1513", "عملیات توسط WP Cron کامل شد", "2025-10-20 20:03:07", "2025-10-20 20:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4494", "1506", "عملیات توسط WP Cron شروع شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4495", "1515", "ایجاد فعالیت", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4496", "1506", "عملیات توسط WP Cron کامل شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4497", "1498", "عملیات توسط WP Cron شروع شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4498", "1498", "عملیات توسط WP Cron کامل شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4499", "1516", "ایجاد فعالیت", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4500", "1499", "عملیات توسط WP Cron شروع شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4501", "1499", "عملیات توسط WP Cron کامل شد", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4502", "1517", "ایجاد فعالیت", "2025-10-20 21:48:57", "2025-10-20 21:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4503", "1515", "عملیات توسط WP Cron شروع شد", "2025-10-21 02:19:27", "2025-10-21 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4504", "1518", "ایجاد فعالیت", "2025-10-21 02:19:27", "2025-10-21 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4505", "1515", "عملیات توسط WP Cron کامل شد", "2025-10-21 02:19:27", "2025-10-21 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4506", "1518", "عملیات توسط WP Cron شروع شد", "2025-10-21 05:53:31", "2025-10-21 05:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4507", "1519", "ایجاد فعالیت", "2025-10-21 05:53:32", "2025-10-21 05:53:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4508", "1518", "عملیات توسط WP Cron کامل شد", "2025-10-21 05:53:32", "2025-10-21 05:53:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4509", "1519", "عملیات توسط WP Cron شروع شد", "2025-10-21 06:55:24", "2025-10-21 06:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4510", "1520", "ایجاد فعالیت", "2025-10-21 06:55:24", "2025-10-21 06:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4511", "1519", "عملیات توسط WP Cron کامل شد", "2025-10-21 06:55:24", "2025-10-21 06:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4512", "1520", "عملیات توسط WP Cron شروع شد", "2025-10-21 09:27:07", "2025-10-21 09:27:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4513", "1521", "ایجاد فعالیت", "2025-10-21 09:27:07", "2025-10-21 09:27:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4514", "1520", "عملیات توسط WP Cron کامل شد", "2025-10-21 09:27:07", "2025-10-21 09:27:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("4515", "1516", "عملیات توسط WP Cron شروع شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4516", "1516", "عملیات توسط WP Cron کامل شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4517", "1522", "ایجاد فعالیت", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4518", "1517", "عملیات توسط WP Cron شروع شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4519", "1517", "عملیات توسط WP Cron کامل شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4520", "1523", "ایجاد فعالیت", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4521", "1521", "عملیات توسط WP Cron شروع شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4522", "1524", "ایجاد فعالیت", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4523", "1521", "عملیات توسط WP Cron کامل شد", "2025-10-21 13:21:59", "2025-10-21 13:21:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4524", "1524", "عملیات توسط WP Cron شروع شد", "2025-10-21 19:19:40", "2025-10-21 19:19:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4525", "1525", "ایجاد فعالیت", "2025-10-21 19:19:40", "2025-10-21 19:19:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4526", "1524", "عملیات توسط WP Cron کامل شد", "2025-10-21 19:19:40", "2025-10-21 19:19:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4527", "1507", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4528", "1507", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4529", "1526", "ایجاد فعالیت", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4530", "1508", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4531", "1508", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4532", "1527", "ایجاد فعالیت", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4533", "1509", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:10", "2025-10-22 02:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4534", "1509", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:11", "2025-10-22 02:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4535", "1528", "ایجاد فعالیت", "2025-10-22 02:22:11", "2025-10-22 02:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4536", "1510", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:11", "2025-10-22 02:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4537", "1510", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4538", "1529", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4539", "1511", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4540", "1511", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4541", "1530", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4542", "1512", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4543", "1512", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4544", "1531", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4545", "1525", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4546", "1532", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4547", "1525", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4548", "1522", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4549", "1522", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4550", "1533", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4551", "1523", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4552", "1523", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4553", "1534", "ایجاد فعالیت", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4554", "1514", "عملیات توسط WP Cron شروع شد", "2025-10-22 02:22:12", "2025-10-22 02:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4555", "1535", "ایجاد فعالیت", "2025-10-22 02:22:13", "2025-10-22 02:22:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4556", "1514", "عملیات توسط WP Cron کامل شد", "2025-10-22 02:22:13", "2025-10-22 02:22:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4557", "1536", "ایجاد فعالیت", "2025-10-22 02:22:13", "2025-10-22 02:22:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4558", "1535", "عملیات توسط WP Cron شروع شد", "2025-10-22 05:53:05", "2025-10-22 05:53:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4559", "1535", "عملیات توسط WP Cron کامل شد", "2025-10-22 05:53:05", "2025-10-22 05:53:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4560", "1532", "عملیات توسط WP Cron شروع شد", "2025-10-22 05:53:05", "2025-10-22 05:53:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4561", "1537", "ایجاد فعالیت", "2025-10-22 05:53:05", "2025-10-22 05:53:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4562", "1532", "عملیات توسط WP Cron کامل شد", "2025-10-22 05:53:05", "2025-10-22 05:53:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4563", "1537", "عملیات توسط WP Cron شروع شد", "2025-10-22 08:25:55", "2025-10-22 08:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4564", "1538", "ایجاد فعالیت", "2025-10-22 08:25:55", "2025-10-22 08:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4565", "1537", "عملیات توسط WP Cron کامل شد", "2025-10-22 08:25:55", "2025-10-22 08:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4566", "1538", "عملیات توسط WP Cron شروع شد", "2025-10-22 10:15:12", "2025-10-22 10:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4567", "1539", "ایجاد فعالیت", "2025-10-22 10:15:12", "2025-10-22 10:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4568", "1538", "عملیات توسط WP Cron کامل شد", "2025-10-22 10:15:12", "2025-10-22 10:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4569", "1539", "عملیات توسط WP Cron شروع شد", "2025-10-22 12:29:31", "2025-10-22 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4570", "1540", "ایجاد فعالیت", "2025-10-22 12:29:31", "2025-10-22 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4571", "1539", "عملیات توسط WP Cron کامل شد", "2025-10-22 12:29:31", "2025-10-22 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4572", "1540", "عملیات توسط WP Cron شروع شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4573", "1541", "ایجاد فعالیت", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4574", "1540", "عملیات توسط WP Cron کامل شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4575", "1533", "عملیات توسط WP Cron شروع شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4576", "1533", "عملیات توسط WP Cron کامل شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4577", "1542", "ایجاد فعالیت", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4578", "1534", "عملیات توسط WP Cron شروع شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4579", "1534", "عملیات توسط WP Cron کامل شد", "2025-10-22 15:10:35", "2025-10-22 15:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("4580", "1543", "ایجاد فعالیت", "2025-10-22 15:10:36", "2025-10-22 15:10:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("4581", "1541", "عملیات توسط WP Cron شروع شد", "2025-10-22 16:40:45", "2025-10-22 16:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4582", "1544", "ایجاد فعالیت", "2025-10-22 16:40:45", "2025-10-22 16:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4583", "1541", "عملیات توسط WP Cron کامل شد", "2025-10-22 16:40:45", "2025-10-22 16:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4584", "1544", "عملیات توسط WP Cron شروع شد", "2025-10-22 20:13:12", "2025-10-22 20:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4585", "1545", "ایجاد فعالیت", "2025-10-22 20:13:12", "2025-10-22 20:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4586", "1544", "عملیات توسط WP Cron کامل شد", "2025-10-22 20:13:12", "2025-10-22 20:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4587", "1545", "عملیات توسط WP Cron شروع شد", "2025-10-22 21:37:39", "2025-10-22 21:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4588", "1546", "ایجاد فعالیت", "2025-10-22 21:37:39", "2025-10-22 21:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4589", "1545", "عملیات توسط WP Cron کامل شد", "2025-10-22 21:37:39", "2025-10-22 21:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4590", "1546", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4591", "1547", "ایجاد فعالیت", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4592", "1546", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4593", "1526", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4594", "1526", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4595", "1548", "ایجاد فعالیت", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4596", "1527", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4597", "1527", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4598", "1549", "ایجاد فعالیت", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4599", "1528", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4600", "1528", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4601", "1550", "ایجاد فعالیت", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4602", "1529", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:08", "2025-10-23 02:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4603", "1529", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:09", "2025-10-23 02:23:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4604", "1551", "ایجاد فعالیت", "2025-10-23 02:23:09", "2025-10-23 02:23:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4605", "1530", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:09", "2025-10-23 02:23:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4606", "1530", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:09", "2025-10-23 02:23:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4607", "1552", "ایجاد فعالیت", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4608", "1531", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4609", "1531", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4610", "1553", "ایجاد فعالیت", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4611", "1536", "عملیات توسط WP Cron شروع شد", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4612", "1554", "ایجاد فعالیت", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4613", "1536", "عملیات توسط WP Cron کامل شد", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4614", "1555", "ایجاد فعالیت", "2025-10-23 02:23:10", "2025-10-23 02:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4615", "1556", "ایجاد فعالیت", "2025-10-23 02:23:49", "2025-10-23 02:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4616", "1557", "ایجاد فعالیت", "2025-10-23 02:23:56", "2025-10-23 02:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4617", "1558", "ایجاد فعالیت", "2025-10-23 02:23:56", "2025-10-23 02:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4618", "1559", "ایجاد فعالیت", "2025-10-23 02:23:56", "2025-10-23 02:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4619", "1554", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4620", "1554", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4621", "1556", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4622", "1556", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4623", "1557", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4624", "1557", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4625", "1558", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4626", "1558", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4627", "1559", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4628", "1559", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4629", "1542", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4630", "1542", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4631", "1560", "ایجاد فعالیت", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4632", "1543", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4633", "1543", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4634", "1561", "ایجاد فعالیت", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4635", "1547", "عملیات توسط WP Cron شروع شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4636", "1562", "ایجاد فعالیت", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4637", "1547", "عملیات توسط WP Cron کامل شد", "2025-10-23 10:21:16", "2025-10-23 10:21:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4638", "1562", "عملیات توسط WP Cron شروع شد", "2025-10-23 12:35:28", "2025-10-23 12:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4639", "1563", "ایجاد فعالیت", "2025-10-23 12:35:28", "2025-10-23 12:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4640", "1562", "عملیات توسط WP Cron کامل شد", "2025-10-23 12:35:28", "2025-10-23 12:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4641", "1563", "عملیات توسط WP Cron شروع شد", "2025-10-23 14:15:31", "2025-10-23 14:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4642", "1564", "ایجاد فعالیت", "2025-10-23 14:15:31", "2025-10-23 14:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4643", "1563", "عملیات توسط WP Cron کامل شد", "2025-10-23 14:15:31", "2025-10-23 14:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4644", "1564", "عملیات توسط WP Cron شروع شد", "2025-10-23 18:43:30", "2025-10-23 18:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4645", "1565", "ایجاد فعالیت", "2025-10-23 18:43:30", "2025-10-23 18:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4646", "1564", "عملیات توسط WP Cron کامل شد", "2025-10-23 18:43:30", "2025-10-23 18:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("4647", "1565", "عملیات توسط WP Cron شروع شد", "2025-10-24 02:20:39", "2025-10-24 02:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4648", "1566", "ایجاد فعالیت", "2025-10-24 02:20:39", "2025-10-24 02:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4649", "1565", "عملیات توسط WP Cron کامل شد", "2025-10-24 02:20:39", "2025-10-24 02:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4650", "1560", "عملیات توسط WP Cron شروع شد", "2025-10-24 02:20:40", "2025-10-24 02:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4651", "1560", "عملیات توسط WP Cron کامل شد", "2025-10-24 02:20:40", "2025-10-24 02:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4652", "1567", "ایجاد فعالیت", "2025-10-24 02:20:40", "2025-10-24 02:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4653", "1561", "عملیات توسط WP Cron شروع شد", "2025-10-24 02:20:40", "2025-10-24 02:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4654", "1561", "عملیات توسط WP Cron کامل شد", "2025-10-24 02:20:40", "2025-10-24 02:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4656", "1548", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:38", "2025-10-24 03:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4657", "1548", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:38", "2025-10-24 03:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4658", "1569", "ایجاد فعالیت", "2025-10-24 03:08:38", "2025-10-24 03:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4659", "1549", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:38", "2025-10-24 03:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4660", "1549", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:38", "2025-10-24 03:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4661", "1570", "ایجاد فعالیت", "2025-10-24 03:08:39", "2025-10-24 03:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4662", "1550", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:39", "2025-10-24 03:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4663", "1550", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:39", "2025-10-24 03:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4664", "1571", "ایجاد فعالیت", "2025-10-24 03:08:39", "2025-10-24 03:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4665", "1551", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:39", "2025-10-24 03:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4666", "1551", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4667", "1572", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4668", "1552", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4669", "1552", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4670", "1573", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4671", "1553", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4672", "1553", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4673", "1574", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4674", "1555", "عملیات توسط WP Cron شروع شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4676", "1575", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4677", "1576", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4678", "1555", "عملیات توسط WP Cron کامل شد", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4679", "1577", "ایجاد فعالیت", "2025-10-24 03:08:40", "2025-10-24 03:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4680", "1576", "عملیات توسط WP Cron شروع شد", "2025-10-24 06:42:56", "2025-10-24 06:42:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4681", "1576", "عملیات توسط WP Cron کامل شد", "2025-10-24 06:42:56", "2025-10-24 06:42:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4682", "1566", "عملیات توسط WP Cron شروع شد", "2025-10-24 06:42:56", "2025-10-24 06:42:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4683", "1578", "ایجاد فعالیت", "2025-10-24 06:42:56", "2025-10-24 06:42:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4684", "1566", "عملیات توسط WP Cron کامل شد", "2025-10-24 06:42:56", "2025-10-24 06:42:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4685", "1578", "عملیات توسط WP Cron شروع شد", "2025-10-24 08:43:31", "2025-10-24 08:43:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4686", "1579", "ایجاد فعالیت", "2025-10-24 08:43:32", "2025-10-24 08:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4687", "1578", "عملیات توسط WP Cron کامل شد", "2025-10-24 08:43:32", "2025-10-24 08:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4688", "1273", "عملیات توسط WP Cron شروع شد", "2025-10-24 08:58:57", "2025-10-24 08:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4689", "1273", "عملیات توسط WP Cron کامل شد", "2025-10-24 08:58:57", "2025-10-24 08:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4690", "1580", "ایجاد فعالیت", "2025-10-24 08:58:57", "2025-10-24 08:58:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4691", "1579", "عملیات توسط WP Cron شروع شد", "2025-10-24 10:18:59", "2025-10-24 10:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4692", "1581", "ایجاد فعالیت", "2025-10-24 10:18:59", "2025-10-24 10:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4693", "1579", "عملیات توسط WP Cron کامل شد", "2025-10-24 10:18:59", "2025-10-24 10:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("4694", "1581", "عملیات توسط WP Cron شروع شد", "2025-10-24 11:52:25", "2025-10-24 11:52:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4695", "1582", "ایجاد فعالیت", "2025-10-24 11:52:25", "2025-10-24 11:52:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4696", "1581", "عملیات توسط WP Cron کامل شد", "2025-10-24 11:52:25", "2025-10-24 11:52:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("4697", "1582", "عملیات توسط WP Cron شروع شد", "2025-10-24 13:31:17", "2025-10-24 13:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4698", "1583", "ایجاد فعالیت", "2025-10-24 13:31:17", "2025-10-24 13:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4699", "1582", "عملیات توسط WP Cron کامل شد", "2025-10-24 13:31:17", "2025-10-24 13:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4700", "1567", "عملیات توسط WP Cron شروع شد", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4701", "1567", "عملیات توسط WP Cron کامل شد", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4702", "1584", "ایجاد فعالیت", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4703", "1583", "عملیات توسط WP Cron شروع شد", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4704", "1585", "ایجاد فعالیت", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4705", "1583", "عملیات توسط WP Cron کامل شد", "2025-10-24 15:33:26", "2025-10-24 15:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4706", "1585", "عملیات توسط WP Cron شروع شد", "2025-10-24 18:13:42", "2025-10-24 18:13:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4707", "1586", "ایجاد فعالیت", "2025-10-24 18:13:42", "2025-10-24 18:13:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4708", "1585", "عملیات توسط WP Cron کامل شد", "2025-10-24 18:13:42", "2025-10-24 18:13:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4709", "1586", "عملیات توسط WP Cron شروع شد", "2025-10-24 21:06:52", "2025-10-24 21:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4710", "1587", "ایجاد فعالیت", "2025-10-24 21:06:53", "2025-10-24 21:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4711", "1586", "عملیات توسط WP Cron کامل شد", "2025-10-24 21:06:53", "2025-10-24 21:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4712", "1587", "عملیات توسط WP Cron شروع شد", "2025-10-24 22:11:02", "2025-10-24 22:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4713", "1588", "ایجاد فعالیت", "2025-10-24 22:11:02", "2025-10-24 22:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4714", "1587", "عملیات توسط WP Cron کامل شد", "2025-10-24 22:11:02", "2025-10-24 22:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4715", "1588", "عملیات توسط WP Cron شروع شد", "2025-10-25 02:20:57", "2025-10-25 02:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4716", "1589", "ایجاد فعالیت", "2025-10-25 02:20:57", "2025-10-25 02:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4717", "1588", "عملیات توسط WP Cron کامل شد", "2025-10-25 02:20:57", "2025-10-25 02:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4718", "1590", "ایجاد فعالیت", "2025-10-25 02:21:37", "2025-10-25 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("4719", "1591", "ایجاد فعالیت", "2025-10-25 02:21:44", "2025-10-25 02:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4720", "1590", "عملیات توسط WP Cron شروع شد", "2025-10-25 02:21:47", "2025-10-25 02:21:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4721", "1590", "عملیات توسط WP Cron کامل شد", "2025-10-25 02:21:47", "2025-10-25 02:21:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4722", "1591", "عملیات توسط WP Cron شروع شد", "2025-10-25 02:21:47", "2025-10-25 02:21:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4723", "1591", "عملیات توسط WP Cron کامل شد", "2025-10-25 02:21:47", "2025-10-25 02:21:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4724", "1575", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4725", "1575", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4727", "1569", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4728", "1569", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4729", "1593", "ایجاد فعالیت", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4730", "1570", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:48", "2025-10-25 10:27:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4731", "1570", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4732", "1594", "ایجاد فعالیت", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4733", "1571", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4734", "1571", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4735", "1595", "ایجاد فعالیت", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4736", "1572", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:49", "2025-10-25 10:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("4737", "1572", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4738", "1596", "ایجاد فعالیت", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4739", "1573", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4740", "1573", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4741", "1597", "ایجاد فعالیت", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4742", "1574", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4743", "1574", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4744", "1598", "ایجاد فعالیت", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4745", "1589", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4746", "1599", "ایجاد فعالیت", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4747", "1589", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4748", "1584", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4749", "1584", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:51", "2025-10-25 10:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4750", "1600", "ایجاد فعالیت", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4751", "1577", "عملیات توسط WP Cron شروع شد", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4753", "1601", "ایجاد فعالیت", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4754", "1602", "ایجاد فعالیت", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4755", "1577", "عملیات توسط WP Cron کامل شد", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4756", "1603", "ایجاد فعالیت", "2025-10-25 10:27:52", "2025-10-25 10:27:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4757", "1602", "عملیات توسط Async Request شروع شد", "2025-10-25 10:59:57", "2025-10-25 10:59:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4758", "1602", "عملیات توسط Async Request کامل شد", "2025-10-25 10:59:57", "2025-10-25 10:59:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4759", "1599", "عملیات توسط WP Cron شروع شد", "2025-10-25 11:29:16", "2025-10-25 11:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4760", "1604", "ایجاد فعالیت", "2025-10-25 11:29:16", "2025-10-25 11:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4761", "1599", "عملیات توسط WP Cron کامل شد", "2025-10-25 11:29:16", "2025-10-25 11:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4762", "1604", "عملیات توسط WP Cron شروع شد", "2025-10-25 12:29:57", "2025-10-25 12:29:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4763", "1605", "ایجاد فعالیت", "2025-10-25 12:29:57", "2025-10-25 12:29:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4764", "1604", "عملیات توسط WP Cron کامل شد", "2025-10-25 12:29:57", "2025-10-25 12:29:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4765", "1605", "عملیات توسط WP Cron شروع شد", "2025-10-25 13:59:16", "2025-10-25 13:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4766", "1606", "ایجاد فعالیت", "2025-10-25 13:59:16", "2025-10-25 13:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4767", "1605", "عملیات توسط WP Cron کامل شد", "2025-10-25 13:59:16", "2025-10-25 13:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4768", "1606", "عملیات توسط WP Cron شروع شد", "2025-10-25 16:06:32", "2025-10-25 16:06:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4769", "1607", "ایجاد فعالیت", "2025-10-25 16:06:32", "2025-10-25 16:06:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4770", "1606", "عملیات توسط WP Cron کامل شد", "2025-10-25 16:06:32", "2025-10-25 16:06:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4771", "1607", "عملیات توسط WP Cron شروع شد", "2025-10-25 17:43:54", "2025-10-25 17:43:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4772", "1608", "ایجاد فعالیت", "2025-10-25 17:43:54", "2025-10-25 17:43:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4773", "1607", "عملیات توسط WP Cron کامل شد", "2025-10-25 17:43:54", "2025-10-25 17:43:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4774", "1608", "عملیات توسط WP Cron شروع شد", "2025-10-25 19:31:53", "2025-10-25 19:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4775", "1609", "ایجاد فعالیت", "2025-10-25 19:31:53", "2025-10-25 19:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4776", "1608", "عملیات توسط WP Cron کامل شد", "2025-10-25 19:31:53", "2025-10-25 19:31:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4777", "1609", "عملیات توسط WP Cron شروع شد", "2025-10-26 02:20:23", "2025-10-26 02:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("4778", "1610", "ایجاد فعالیت", "2025-10-26 02:20:24", "2025-10-26 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4779", "1609", "عملیات توسط WP Cron کامل شد", "2025-10-26 02:20:24", "2025-10-26 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4780", "1600", "عملیات توسط WP Cron شروع شد", "2025-10-26 02:20:24", "2025-10-26 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4781", "1600", "عملیات توسط WP Cron کامل شد", "2025-10-26 02:20:24", "2025-10-26 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4782", "1611", "ایجاد فعالیت", "2025-10-26 02:20:24", "2025-10-26 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("4783", "1601", "عملیات توسط WP Cron شروع شد", "2025-10-26 06:05:46", "2025-10-26 06:05:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4784", "1601", "عملیات توسط WP Cron کامل شد", "2025-10-26 06:05:47", "2025-10-26 06:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4786", "1610", "عملیات توسط WP Cron شروع شد", "2025-10-26 06:05:47", "2025-10-26 06:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4787", "1613", "ایجاد فعالیت", "2025-10-26 06:05:47", "2025-10-26 06:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4788", "1610", "عملیات توسط WP Cron کامل شد", "2025-10-26 06:05:47", "2025-10-26 06:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4789", "1613", "عملیات توسط WP Cron شروع شد", "2025-10-26 08:17:02", "2025-10-26 08:17:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4790", "1614", "ایجاد فعالیت", "2025-10-26 08:17:02", "2025-10-26 08:17:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4791", "1613", "عملیات توسط WP Cron کامل شد", "2025-10-26 08:17:02", "2025-10-26 08:17:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("4792", "1614", "عملیات توسط WP Cron شروع شد", "2025-10-26 09:42:16", "2025-10-26 09:42:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4793", "1615", "ایجاد فعالیت", "2025-10-26 09:42:16", "2025-10-26 09:42:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4794", "1614", "عملیات توسط WP Cron کامل شد", "2025-10-26 09:42:16", "2025-10-26 09:42:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4795", "1593", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:43", "2025-10-26 13:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4796", "1593", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:43", "2025-10-26 13:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4797", "1616", "ایجاد فعالیت", "2025-10-26 13:18:43", "2025-10-26 13:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4798", "1594", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:43", "2025-10-26 13:18:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4799", "1594", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4800", "1617", "ایجاد فعالیت", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4801", "1595", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4802", "1595", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4803", "1618", "ایجاد فعالیت", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4804", "1596", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:44", "2025-10-26 13:18:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("4805", "1596", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4806", "1619", "ایجاد فعالیت", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4807", "1597", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4808", "1597", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4809", "1620", "ایجاد فعالیت", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4810", "1598", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:45", "2025-10-26 13:18:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4811", "1598", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4812", "1621", "ایجاد فعالیت", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4813", "1615", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4814", "1622", "ایجاد فعالیت", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4815", "1615", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4816", "1603", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4818", "1623", "ایجاد فعالیت", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4819", "1624", "ایجاد فعالیت", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4820", "1603", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4821", "1625", "ایجاد فعالیت", "2025-10-26 13:18:46", "2025-10-26 13:18:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4822", "1624", "عملیات توسط WP Cron شروع شد", "2025-10-26 13:26:09", "2025-10-26 13:26:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4823", "1624", "عملیات توسط WP Cron کامل شد", "2025-10-26 13:26:09", "2025-10-26 13:26:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4824", "1622", "عملیات توسط WP Cron شروع شد", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4825", "1626", "ایجاد فعالیت", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4826", "1622", "عملیات توسط WP Cron کامل شد", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4827", "1611", "عملیات توسط WP Cron شروع شد", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4828", "1611", "عملیات توسط WP Cron کامل شد", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4829", "1627", "ایجاد فعالیت", "2025-10-26 14:21:17", "2025-10-26 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4830", "1626", "عملیات توسط WP Cron شروع شد", "2025-10-26 16:06:22", "2025-10-26 16:06:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4831", "1628", "ایجاد فعالیت", "2025-10-26 16:06:22", "2025-10-26 16:06:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4832", "1626", "عملیات توسط WP Cron کامل شد", "2025-10-26 16:06:22", "2025-10-26 16:06:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("4833", "1628", "عملیات توسط WP Cron شروع شد", "2025-10-26 17:17:04", "2025-10-26 17:17:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4834", "1629", "ایجاد فعالیت", "2025-10-26 17:17:04", "2025-10-26 17:17:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4835", "1628", "عملیات توسط WP Cron کامل شد", "2025-10-26 17:17:04", "2025-10-26 17:17:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4836", "1629", "عملیات توسط WP Cron شروع شد", "2025-10-26 21:24:10", "2025-10-26 21:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4837", "1630", "ایجاد فعالیت", "2025-10-26 21:24:10", "2025-10-26 21:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4838", "1629", "عملیات توسط WP Cron کامل شد", "2025-10-26 21:24:10", "2025-10-26 21:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4839", "1630", "عملیات توسط WP Cron شروع شد", "2025-10-27 01:51:54", "2025-10-27 01:51:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4840", "1631", "ایجاد فعالیت", "2025-10-27 01:51:54", "2025-10-27 01:51:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4841", "1630", "عملیات توسط WP Cron کامل شد", "2025-10-27 01:51:54", "2025-10-27 01:51:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4842", "1627", "عملیات توسط WP Cron شروع شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4843", "1627", "عملیات توسط WP Cron کامل شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4844", "1632", "ایجاد فعالیت", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4845", "1631", "عملیات توسط WP Cron شروع شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4846", "1633", "ایجاد فعالیت", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4847", "1631", "عملیات توسط WP Cron کامل شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4848", "1623", "عملیات توسط WP Cron شروع شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4849", "1623", "عملیات توسط WP Cron کامل شد", "2025-10-27 04:55:17", "2025-10-27 04:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("4851", "1633", "عملیات توسط WP Cron شروع شد", "2025-10-27 06:12:34", "2025-10-27 06:12:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4852", "1635", "ایجاد فعالیت", "2025-10-27 06:12:34", "2025-10-27 06:12:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4853", "1633", "عملیات توسط WP Cron کامل شد", "2025-10-27 06:12:34", "2025-10-27 06:12:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4854", "1635", "عملیات توسط WP Cron شروع شد", "2025-10-27 08:29:06", "2025-10-27 08:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4855", "1636", "ایجاد فعالیت", "2025-10-27 08:29:06", "2025-10-27 08:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4856", "1635", "عملیات توسط WP Cron کامل شد", "2025-10-27 08:29:06", "2025-10-27 08:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("4857", "1636", "عملیات توسط WP Cron شروع شد", "2025-10-27 13:16:05", "2025-10-27 13:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4858", "1637", "ایجاد فعالیت", "2025-10-27 13:16:05", "2025-10-27 13:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4859", "1636", "عملیات توسط WP Cron کامل شد", "2025-10-27 13:16:05", "2025-10-27 13:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("4860", "1616", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4861", "1616", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4862", "1638", "ایجاد فعالیت", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4863", "1617", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4864", "1617", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4865", "1639", "ایجاد فعالیت", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4866", "1618", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4867", "1618", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:38", "2025-10-27 14:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4868", "1640", "ایجاد فعالیت", "2025-10-27 14:08:39", "2025-10-27 14:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4869", "1619", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:39", "2025-10-27 14:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4870", "1619", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4871", "1641", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4872", "1620", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4873", "1620", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4874", "1642", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4875", "1621", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4876", "1621", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4877", "1643", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4878", "1625", "عملیات توسط WP Cron شروع شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4880", "1644", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4881", "1645", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4882", "1625", "عملیات توسط WP Cron کامل شد", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4883", "1646", "ایجاد فعالیت", "2025-10-27 14:08:40", "2025-10-27 14:08:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4884", "1645", "عملیات توسط WP Cron شروع شد", "2025-10-27 15:23:43", "2025-10-27 15:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4885", "1645", "عملیات توسط WP Cron کامل شد", "2025-10-27 15:23:43", "2025-10-27 15:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4886", "1637", "عملیات توسط WP Cron شروع شد", "2025-10-27 15:23:43", "2025-10-27 15:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4887", "1647", "ایجاد فعالیت", "2025-10-27 15:23:43", "2025-10-27 15:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4888", "1637", "عملیات توسط WP Cron کامل شد", "2025-10-27 15:23:43", "2025-10-27 15:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4889", "1647", "عملیات توسط WP Cron شروع شد", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4890", "1648", "ایجاد فعالیت", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4891", "1647", "عملیات توسط WP Cron کامل شد", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4892", "1632", "عملیات توسط WP Cron شروع شد", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4893", "1632", "عملیات توسط WP Cron کامل شد", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4894", "1649", "ایجاد فعالیت", "2025-10-27 17:43:00", "2025-10-27 17:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4895", "1648", "عملیات توسط WP Cron شروع شد", "2025-10-27 21:33:13", "2025-10-27 21:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4896", "1650", "ایجاد فعالیت", "2025-10-27 21:33:13", "2025-10-27 21:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4897", "1648", "عملیات توسط WP Cron کامل شد", "2025-10-27 21:33:13", "2025-10-27 21:33:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4898", "1650", "عملیات توسط WP Cron شروع شد", "2025-10-28 02:20:33", "2025-10-28 02:20:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4899", "1651", "ایجاد فعالیت", "2025-10-28 02:20:34", "2025-10-28 02:20:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4900", "1650", "عملیات توسط WP Cron کامل شد", "2025-10-28 02:20:34", "2025-10-28 02:20:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4901", "1644", "عملیات توسط WP Cron شروع شد", "2025-10-28 05:28:16", "2025-10-28 05:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4902", "1644", "عملیات توسط WP Cron کامل شد", "2025-10-28 05:28:16", "2025-10-28 05:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4904", "1651", "عملیات توسط WP Cron شروع شد", "2025-10-28 05:28:16", "2025-10-28 05:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4905", "1653", "ایجاد فعالیت", "2025-10-28 05:28:16", "2025-10-28 05:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4906", "1651", "عملیات توسط WP Cron کامل شد", "2025-10-28 05:28:16", "2025-10-28 05:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("4907", "1649", "عملیات توسط WP Cron شروع شد", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4908", "1649", "عملیات توسط WP Cron کامل شد", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4909", "1654", "ایجاد فعالیت", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4910", "1653", "عملیات توسط WP Cron شروع شد", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4911", "1655", "ایجاد فعالیت", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4912", "1653", "عملیات توسط WP Cron کامل شد", "2025-10-28 07:41:42", "2025-10-28 07:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("4913", "1655", "عملیات توسط WP Cron شروع شد", "2025-10-28 09:13:45", "2025-10-28 09:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4914", "1656", "ایجاد فعالیت", "2025-10-28 09:13:45", "2025-10-28 09:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4915", "1655", "عملیات توسط WP Cron کامل شد", "2025-10-28 09:13:45", "2025-10-28 09:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4916", "1656", "عملیات توسط WP Cron شروع شد", "2025-10-28 10:15:04", "2025-10-28 10:15:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4917", "1657", "ایجاد فعالیت", "2025-10-28 10:15:04", "2025-10-28 10:15:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4918", "1656", "عملیات توسط WP Cron کامل شد", "2025-10-28 10:15:04", "2025-10-28 10:15:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4919", "1657", "عملیات توسط WP Cron شروع شد", "2025-10-28 13:37:08", "2025-10-28 13:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4920", "1658", "ایجاد فعالیت", "2025-10-28 13:37:08", "2025-10-28 13:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4921", "1657", "عملیات توسط WP Cron کامل شد", "2025-10-28 13:37:08", "2025-10-28 13:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("4922", "1638", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4923", "1638", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4924", "1659", "ایجاد فعالیت", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4925", "1639", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4926", "1639", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4927", "1660", "ایجاد فعالیت", "2025-10-28 15:06:45", "2025-10-28 15:06:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("4928", "1640", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:46", "2025-10-28 15:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4929", "1640", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:46", "2025-10-28 15:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4930", "1661", "ایجاد فعالیت", "2025-10-28 15:06:46", "2025-10-28 15:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4931", "1641", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:46", "2025-10-28 15:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("4932", "1641", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:47", "2025-10-28 15:06:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4933", "1662", "ایجاد فعالیت", "2025-10-28 15:06:47", "2025-10-28 15:06:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4934", "1642", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:47", "2025-10-28 15:06:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4935", "1642", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4936", "1663", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4937", "1643", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4938", "1643", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4939", "1664", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4940", "1658", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4941", "1665", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4942", "1658", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4943", "1646", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4945", "1666", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4946", "1667", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4947", "1646", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4948", "1668", "ایجاد فعالیت", "2025-10-28 15:06:48", "2025-10-28 15:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4949", "1667", "عملیات توسط WP Cron شروع شد", "2025-10-28 15:23:52", "2025-10-28 15:23:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4950", "1667", "عملیات توسط WP Cron کامل شد", "2025-10-28 15:23:52", "2025-10-28 15:23:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4951", "1665", "عملیات توسط WP Cron شروع شد", "2025-10-28 16:49:47", "2025-10-28 16:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4952", "1669", "ایجاد فعالیت", "2025-10-28 16:49:47", "2025-10-28 16:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4953", "1665", "عملیات توسط WP Cron کامل شد", "2025-10-28 16:49:47", "2025-10-28 16:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4954", "1669", "عملیات توسط WP Cron شروع شد", "2025-10-28 17:54:33", "2025-10-28 17:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4955", "1670", "ایجاد فعالیت", "2025-10-28 17:54:33", "2025-10-28 17:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4956", "1669", "عملیات توسط WP Cron کامل شد", "2025-10-28 17:54:33", "2025-10-28 17:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4957", "1670", "عملیات توسط WP Cron شروع شد", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4958", "1671", "ایجاد فعالیت", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4959", "1670", "عملیات توسط WP Cron کامل شد", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4960", "1654", "عملیات توسط WP Cron شروع شد", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4961", "1654", "عملیات توسط WP Cron کامل شد", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4962", "1672", "ایجاد فعالیت", "2025-10-29 01:00:26", "2025-10-29 01:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4963", "1671", "عملیات توسط WP Cron شروع شد", "2025-10-29 02:20:19", "2025-10-29 02:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4964", "1673", "ایجاد فعالیت", "2025-10-29 02:20:19", "2025-10-29 02:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4965", "1671", "عملیات توسط WP Cron کامل شد", "2025-10-29 02:20:19", "2025-10-29 02:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4966", "1666", "عملیات توسط WP Cron شروع شد", "2025-10-29 05:42:55", "2025-10-29 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4967", "1666", "عملیات توسط WP Cron کامل شد", "2025-10-29 05:42:55", "2025-10-29 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4969", "1673", "عملیات توسط WP Cron شروع شد", "2025-10-29 05:42:55", "2025-10-29 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4970", "1675", "ایجاد فعالیت", "2025-10-29 05:42:55", "2025-10-29 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4971", "1673", "عملیات توسط WP Cron کامل شد", "2025-10-29 05:42:55", "2025-10-29 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4972", "1675", "عملیات توسط WP Cron شروع شد", "2025-10-29 06:46:54", "2025-10-29 06:46:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4973", "1676", "ایجاد فعالیت", "2025-10-29 06:46:54", "2025-10-29 06:46:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4974", "1675", "عملیات توسط WP Cron کامل شد", "2025-10-29 06:46:54", "2025-10-29 06:46:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4975", "1676", "عملیات توسط WP Cron شروع شد", "2025-10-29 08:15:19", "2025-10-29 08:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4976", "1677", "ایجاد فعالیت", "2025-10-29 08:15:19", "2025-10-29 08:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4977", "1676", "عملیات توسط WP Cron کامل شد", "2025-10-29 08:15:19", "2025-10-29 08:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("4978", "1677", "عملیات توسط WP Cron شروع شد", "2025-10-29 09:25:00", "2025-10-29 09:25:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4979", "1678", "ایجاد فعالیت", "2025-10-29 09:25:00", "2025-10-29 09:25:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4980", "1677", "عملیات توسط WP Cron کامل شد", "2025-10-29 09:25:00", "2025-10-29 09:25:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4981", "1678", "عملیات توسط WP Cron شروع شد", "2025-10-29 11:04:50", "2025-10-29 11:04:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4982", "1679", "ایجاد فعالیت", "2025-10-29 11:04:50", "2025-10-29 11:04:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4983", "1678", "عملیات توسط WP Cron کامل شد", "2025-10-29 11:04:50", "2025-10-29 11:04:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4984", "1679", "عملیات توسط WP Cron شروع شد", "2025-10-29 12:09:34", "2025-10-29 12:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4985", "1680", "ایجاد فعالیت", "2025-10-29 12:09:34", "2025-10-29 12:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4986", "1679", "عملیات توسط WP Cron کامل شد", "2025-10-29 12:09:34", "2025-10-29 12:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4987", "1672", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4988", "1672", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4989", "1681", "ایجاد فعالیت", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4990", "1680", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4991", "1682", "ایجاد فعالیت", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4992", "1680", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4993", "1659", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4994", "1659", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4995", "1683", "ایجاد فعالیت", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4996", "1660", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4997", "1660", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4998", "1684", "ایجاد فعالیت", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("4999", "1661", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:26", "2025-10-29 16:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5000", "1661", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:27", "2025-10-29 16:29:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5001", "1685", "ایجاد فعالیت", "2025-10-29 16:29:27", "2025-10-29 16:29:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5002", "1662", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:27", "2025-10-29 16:29:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5003", "1662", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5004", "1686", "ایجاد فعالیت", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5005", "1663", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5006", "1663", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5007", "1687", "ایجاد فعالیت", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5008", "1664", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5009", "1664", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:28", "2025-10-29 16:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5010", "1688", "ایجاد فعالیت", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5011", "1668", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5013", "1689", "ایجاد فعالیت", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5014", "1690", "ایجاد فعالیت", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5015", "1668", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5016", "1691", "ایجاد فعالیت", "2025-10-29 16:29:29", "2025-10-29 16:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5017", "1690", "عملیات توسط WP Cron شروع شد", "2025-10-29 16:30:10", "2025-10-29 16:30:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5018", "1690", "عملیات توسط WP Cron کامل شد", "2025-10-29 16:30:10", "2025-10-29 16:30:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5019", "1682", "عملیات توسط WP Cron شروع شد", "2025-10-29 18:07:37", "2025-10-29 18:07:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5020", "1692", "ایجاد فعالیت", "2025-10-29 18:07:37", "2025-10-29 18:07:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5021", "1682", "عملیات توسط WP Cron کامل شد", "2025-10-29 18:07:37", "2025-10-29 18:07:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5022", "1692", "عملیات توسط WP Cron شروع شد", "2025-10-29 21:57:39", "2025-10-29 21:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5023", "1693", "ایجاد فعالیت", "2025-10-29 21:57:39", "2025-10-29 21:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5024", "1692", "عملیات توسط WP Cron کامل شد", "2025-10-29 21:57:39", "2025-10-29 21:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5025", "1693", "عملیات توسط WP Cron شروع شد", "2025-10-30 02:19:48", "2025-10-30 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5026", "1694", "ایجاد فعالیت", "2025-10-30 02:19:48", "2025-10-30 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5027", "1693", "عملیات توسط WP Cron کامل شد", "2025-10-30 02:19:48", "2025-10-30 02:19:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5028", "1689", "عملیات توسط WP Cron شروع شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5029", "1689", "عملیات توسط WP Cron کامل شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5030", "1695", "ایجاد فعالیت", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5031", "1694", "عملیات توسط WP Cron شروع شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5032", "1696", "ایجاد فعالیت", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5033", "1694", "عملیات توسط WP Cron کامل شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5034", "1681", "عملیات توسط WP Cron شروع شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5035", "1681", "عملیات توسط WP Cron کامل شد", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5036", "1697", "ایجاد فعالیت", "2025-10-30 05:17:24", "2025-10-30 05:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5037", "1696", "عملیات توسط WP Cron شروع شد", "2025-10-30 06:36:44", "2025-10-30 06:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5038", "1698", "ایجاد فعالیت", "2025-10-30 06:36:44", "2025-10-30 06:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5039", "1696", "عملیات توسط WP Cron کامل شد", "2025-10-30 06:36:44", "2025-10-30 06:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5040", "1698", "عملیات توسط WP Cron شروع شد", "2025-10-30 08:36:50", "2025-10-30 08:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5041", "1699", "ایجاد فعالیت", "2025-10-30 08:36:50", "2025-10-30 08:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5042", "1698", "عملیات توسط WP Cron کامل شد", "2025-10-30 08:36:50", "2025-10-30 08:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5043", "1699", "عملیات توسط WP Cron شروع شد", "2025-10-30 12:01:48", "2025-10-30 12:01:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5044", "1700", "ایجاد فعالیت", "2025-10-30 12:01:48", "2025-10-30 12:01:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5045", "1699", "عملیات توسط WP Cron کامل شد", "2025-10-30 12:01:48", "2025-10-30 12:01:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5046", "1700", "عملیات توسط WP Cron شروع شد", "2025-10-30 13:27:55", "2025-10-30 13:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5047", "1701", "ایجاد فعالیت", "2025-10-30 13:27:55", "2025-10-30 13:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5048", "1700", "عملیات توسط WP Cron کامل شد", "2025-10-30 13:27:55", "2025-10-30 13:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5049", "1701", "عملیات توسط WP Cron شروع شد", "2025-10-30 14:30:17", "2025-10-30 14:30:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5050", "1702", "ایجاد فعالیت", "2025-10-30 14:30:17", "2025-10-30 14:30:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5051", "1701", "عملیات توسط WP Cron کامل شد", "2025-10-30 14:30:17", "2025-10-30 14:30:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5052", "1702", "عملیات توسط WP Cron شروع شد", "2025-10-30 16:21:28", "2025-10-30 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5053", "1703", "ایجاد فعالیت", "2025-10-30 16:21:28", "2025-10-30 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5054", "1702", "عملیات توسط WP Cron کامل شد", "2025-10-30 16:21:28", "2025-10-30 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5055", "1683", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5056", "1683", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5057", "1704", "ایجاد فعالیت", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5058", "1684", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5059", "1684", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5060", "1705", "ایجاد فعالیت", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5061", "1685", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5062", "1685", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5063", "1706", "ایجاد فعالیت", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5064", "1686", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:46", "2025-10-30 20:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5065", "1686", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:47", "2025-10-30 20:07:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5066", "1707", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5067", "1687", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5068", "1687", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5069", "1708", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5070", "1688", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5071", "1688", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5072", "1709", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5073", "1695", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5074", "1695", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5076", "1697", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5077", "1697", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5078", "1711", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5079", "1703", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5080", "1712", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5081", "1703", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5082", "1691", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5084", "1713", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5085", "1714", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5086", "1691", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5087", "1715", "ایجاد فعالیت", "2025-10-30 20:07:48", "2025-10-30 20:07:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5088", "1714", "عملیات توسط WP Cron شروع شد", "2025-10-30 20:32:36", "2025-10-30 20:32:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5089", "1714", "عملیات توسط WP Cron کامل شد", "2025-10-30 20:32:36", "2025-10-30 20:32:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5090", "1712", "عملیات توسط WP Cron شروع شد", "2025-10-30 23:08:05", "2025-10-30 23:08:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5091", "1716", "ایجاد فعالیت", "2025-10-30 23:08:05", "2025-10-30 23:08:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5092", "1712", "عملیات توسط WP Cron کامل شد", "2025-10-30 23:08:05", "2025-10-30 23:08:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5093", "1716", "عملیات توسط WP Cron شروع شد", "2025-10-31 02:19:56", "2025-10-31 02:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("5094", "1717", "ایجاد فعالیت", "2025-10-31 02:19:56", "2025-10-31 02:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("5095", "1716", "عملیات توسط WP Cron کامل شد", "2025-10-31 02:19:56", "2025-10-31 02:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("5096", "1713", "عملیات توسط WP Cron شروع شد", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5097", "1713", "عملیات توسط WP Cron کامل شد", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5098", "1718", "ایجاد فعالیت", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5099", "1717", "عملیات توسط WP Cron شروع شد", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5100", "1719", "ایجاد فعالیت", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5101", "1717", "عملیات توسط WP Cron کامل شد", "2025-10-31 04:54:51", "2025-10-31 04:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5102", "1719", "عملیات توسط WP Cron شروع شد", "2025-10-31 06:05:59", "2025-10-31 06:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5103", "1720", "ایجاد فعالیت", "2025-10-31 06:05:59", "2025-10-31 06:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5104", "1719", "عملیات توسط WP Cron کامل شد", "2025-10-31 06:05:59", "2025-10-31 06:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5105", "1720", "عملیات توسط WP Cron شروع شد", "2025-10-31 09:43:47", "2025-10-31 09:43:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5106", "1721", "ایجاد فعالیت", "2025-10-31 09:43:47", "2025-10-31 09:43:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5107", "1720", "عملیات توسط WP Cron کامل شد", "2025-10-31 09:43:47", "2025-10-31 09:43:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5108", "1711", "عملیات توسط WP Cron شروع شد", "2025-10-31 09:43:47", "2025-10-31 09:43:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5109", "1711", "عملیات توسط WP Cron کامل شد", "2025-10-31 09:43:48", "2025-10-31 09:43:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5110", "1722", "ایجاد فعالیت", "2025-10-31 09:43:48", "2025-10-31 09:43:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5111", "1721", "عملیات توسط WP Cron شروع شد", "2025-10-31 10:54:35", "2025-10-31 10:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5112", "1723", "ایجاد فعالیت", "2025-10-31 10:54:35", "2025-10-31 10:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5113", "1721", "عملیات توسط WP Cron کامل شد", "2025-10-31 10:54:35", "2025-10-31 10:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5114", "1723", "عملیات توسط WP Cron شروع شد", "2025-10-31 12:31:35", "2025-10-31 12:31:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5115", "1724", "ایجاد فعالیت", "2025-10-31 12:31:35", "2025-10-31 12:31:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5116", "1723", "عملیات توسط WP Cron کامل شد", "2025-10-31 12:31:35", "2025-10-31 12:31:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5117", "1724", "عملیات توسط WP Cron شروع شد", "2025-10-31 17:43:01", "2025-10-31 17:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("5118", "1725", "ایجاد فعالیت", "2025-10-31 17:43:01", "2025-10-31 17:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("5119", "1724", "عملیات توسط WP Cron کامل شد", "2025-10-31 17:43:01", "2025-10-31 17:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("5120", "1718", "عملیات توسط WP Cron شروع شد", "2025-10-31 17:43:01", "2025-10-31 17:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("5121", "1718", "عملیات توسط WP Cron کامل شد", "2025-10-31 17:43:01", "2025-10-31 17:43:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("5123", "1725", "عملیات توسط WP Cron شروع شد", "2025-10-31 18:52:30", "2025-10-31 18:52:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5124", "1727", "ایجاد فعالیت", "2025-10-31 18:52:30", "2025-10-31 18:52:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5125", "1725", "عملیات توسط WP Cron کامل شد", "2025-10-31 18:52:30", "2025-10-31 18:52:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5126", "1727", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5127", "1728", "ایجاد فعالیت", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5128", "1727", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5129", "1704", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5130", "1704", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5131", "1729", "ایجاد فعالیت", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5132", "1705", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5133", "1705", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:25", "2025-10-31 21:33:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5134", "1730", "ایجاد فعالیت", "2025-10-31 21:33:26", "2025-10-31 21:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5135", "1706", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:26", "2025-10-31 21:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5136", "1706", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:26", "2025-10-31 21:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5137", "1731", "ایجاد فعالیت", "2025-10-31 21:33:26", "2025-10-31 21:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5138", "1707", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:26", "2025-10-31 21:33:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5139", "1707", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5140", "1732", "ایجاد فعالیت", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5141", "1708", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5142", "1708", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5143", "1733", "ایجاد فعالیت", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5144", "1709", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5145", "1709", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5146", "1734", "ایجاد فعالیت", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5147", "1715", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:27", "2025-10-31 21:33:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5149", "1735", "ایجاد فعالیت", "2025-10-31 21:33:28", "2025-10-31 21:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5150", "1736", "ایجاد فعالیت", "2025-10-31 21:33:28", "2025-10-31 21:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5151", "1715", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:28", "2025-10-31 21:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5152", "1737", "ایجاد فعالیت", "2025-10-31 21:33:28", "2025-10-31 21:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5153", "1736", "عملیات توسط WP Cron شروع شد", "2025-10-31 21:33:57", "2025-10-31 21:33:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5154", "1736", "عملیات توسط WP Cron کامل شد", "2025-10-31 21:33:57", "2025-10-31 21:33:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5155", "1722", "عملیات توسط WP Cron شروع شد", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5156", "1722", "عملیات توسط WP Cron کامل شد", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5157", "1738", "ایجاد فعالیت", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5158", "1728", "عملیات توسط WP Cron شروع شد", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5159", "1739", "ایجاد فعالیت", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5160", "1728", "عملیات توسط WP Cron کامل شد", "2025-11-01 02:22:23", "2025-11-01 02:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5161", "1740", "ایجاد فعالیت", "2025-11-01 02:23:05", "2025-11-01 02:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5162", "1741", "ایجاد فعالیت", "2025-11-01 02:23:11", "2025-11-01 02:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("5163", "1740", "عملیات توسط WP Cron شروع شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5164", "1740", "عملیات توسط WP Cron کامل شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5165", "1741", "عملیات توسط WP Cron شروع شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5166", "1741", "عملیات توسط WP Cron کامل شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5167", "1735", "عملیات توسط WP Cron شروع شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5168", "1735", "عملیات توسط WP Cron کامل شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5169", "1742", "ایجاد فعالیت", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5170", "1739", "عملیات توسط WP Cron شروع شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5171", "1743", "ایجاد فعالیت", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5172", "1739", "عملیات توسط WP Cron کامل شد", "2025-11-01 04:16:26", "2025-11-01 04:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("5173", "1743", "عملیات توسط WP Cron شروع شد", "2025-11-01 05:46:36", "2025-11-01 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5174", "1744", "ایجاد فعالیت", "2025-11-01 05:46:36", "2025-11-01 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5175", "1743", "عملیات توسط WP Cron کامل شد", "2025-11-01 05:46:36", "2025-11-01 05:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5176", "1744", "عملیات توسط WP Cron شروع شد", "2025-11-01 07:40:35", "2025-11-01 07:40:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5177", "1745", "ایجاد فعالیت", "2025-11-01 07:40:35", "2025-11-01 07:40:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5178", "1744", "عملیات توسط WP Cron کامل شد", "2025-11-01 07:40:35", "2025-11-01 07:40:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5179", "1745", "عملیات توسط WP Cron شروع شد", "2025-11-01 09:07:58", "2025-11-01 09:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5180", "1746", "ایجاد فعالیت", "2025-11-01 09:07:58", "2025-11-01 09:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5181", "1745", "عملیات توسط WP Cron کامل شد", "2025-11-01 09:07:58", "2025-11-01 09:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5182", "1746", "عملیات توسط WP Cron شروع شد", "2025-11-01 10:09:04", "2025-11-01 10:09:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5183", "1747", "ایجاد فعالیت", "2025-11-01 10:09:04", "2025-11-01 10:09:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5184", "1746", "عملیات توسط WP Cron کامل شد", "2025-11-01 10:09:04", "2025-11-01 10:09:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5185", "1747", "عملیات توسط WP Cron شروع شد", "2025-11-01 11:23:56", "2025-11-01 11:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("5186", "1748", "ایجاد فعالیت", "2025-11-01 11:23:57", "2025-11-01 11:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5187", "1747", "عملیات توسط WP Cron کامل شد", "2025-11-01 11:23:57", "2025-11-01 11:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5188", "1748", "عملیات توسط WP Cron شروع شد", "2025-11-01 12:41:11", "2025-11-01 12:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("5189", "1749", "ایجاد فعالیت", "2025-11-01 12:41:11", "2025-11-01 12:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("5190", "1748", "عملیات توسط WP Cron کامل شد", "2025-11-01 12:41:11", "2025-11-01 12:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("5191", "1749", "عملیات توسط WP Cron شروع شد", "2025-11-01 15:53:47", "2025-11-01 15:53:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5192", "1750", "ایجاد فعالیت", "2025-11-01 15:53:47", "2025-11-01 15:53:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5193", "1749", "عملیات توسط WP Cron کامل شد", "2025-11-01 15:53:48", "2025-11-01 15:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5194", "1738", "عملیات توسط WP Cron شروع شد", "2025-11-01 15:53:48", "2025-11-01 15:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5195", "1738", "عملیات توسط WP Cron کامل شد", "2025-11-01 15:53:48", "2025-11-01 15:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5196", "1751", "ایجاد فعالیت", "2025-11-01 15:53:48", "2025-11-01 15:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5197", "1742", "عملیات توسط WP Cron شروع شد", "2025-11-01 17:23:00", "2025-11-01 17:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5198", "1742", "عملیات توسط WP Cron کامل شد", "2025-11-01 17:23:00", "2025-11-01 17:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5200", "1750", "عملیات توسط WP Cron شروع شد", "2025-11-01 17:23:00", "2025-11-01 17:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5201", "1753", "ایجاد فعالیت", "2025-11-01 17:23:00", "2025-11-01 17:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5202", "1750", "عملیات توسط WP Cron کامل شد", "2025-11-01 17:23:00", "2025-11-01 17:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5203", "1753", "عملیات توسط WP Cron شروع شد", "2025-11-01 18:44:10", "2025-11-01 18:44:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5204", "1754", "ایجاد فعالیت", "2025-11-01 18:44:10", "2025-11-01 18:44:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5205", "1753", "عملیات توسط WP Cron کامل شد", "2025-11-01 18:44:10", "2025-11-01 18:44:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5206", "1754", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5207", "1755", "ایجاد فعالیت", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5208", "1754", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5209", "1729", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5210", "1729", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5211", "1756", "ایجاد فعالیت", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5212", "1730", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5213", "1730", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5214", "1757", "ایجاد فعالیت", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5215", "1731", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:08", "2025-11-01 21:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5216", "1731", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:09", "2025-11-01 21:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5217", "1758", "ایجاد فعالیت", "2025-11-01 21:57:09", "2025-11-01 21:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5218", "1732", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:09", "2025-11-01 21:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5219", "1732", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5220", "1759", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5221", "1733", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5222", "1733", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5223", "1760", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5224", "1734", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5225", "1734", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5226", "1761", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5227", "1737", "عملیات توسط WP Cron شروع شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5229", "1762", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5230", "1763", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5231", "1737", "عملیات توسط WP Cron کامل شد", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5232", "1764", "ایجاد فعالیت", "2025-11-01 21:57:10", "2025-11-01 21:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5233", "1763", "عملیات توسط WP Cron شروع شد", "2025-11-02 02:19:31", "2025-11-02 02:19:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5234", "1763", "عملیات توسط WP Cron کامل شد", "2025-11-02 02:19:31", "2025-11-02 02:19:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5235", "1755", "عملیات توسط WP Cron شروع شد", "2025-11-02 02:19:31", "2025-11-02 02:19:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5236", "1765", "ایجاد فعالیت", "2025-11-02 02:19:31", "2025-11-02 02:19:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5237", "1755", "عملیات توسط WP Cron کامل شد", "2025-11-02 02:19:31", "2025-11-02 02:19:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5238", "1762", "عملیات توسط WP Cron شروع شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5239", "1762", "عملیات توسط WP Cron کامل شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5240", "1766", "ایجاد فعالیت", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5241", "1765", "عملیات توسط WP Cron شروع شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5242", "1767", "ایجاد فعالیت", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5243", "1765", "عملیات توسط WP Cron کامل شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5244", "1751", "عملیات توسط WP Cron شروع شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5245", "1751", "عملیات توسط WP Cron کامل شد", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5246", "1768", "ایجاد فعالیت", "2025-11-02 05:16:08", "2025-11-02 05:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5247", "1767", "عملیات توسط WP Cron شروع شد", "2025-11-02 09:03:05", "2025-11-02 09:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5248", "1769", "ایجاد فعالیت", "2025-11-02 09:03:05", "2025-11-02 09:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5249", "1767", "عملیات توسط WP Cron کامل شد", "2025-11-02 09:03:05", "2025-11-02 09:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5250", "1769", "عملیات توسط Async Request شروع شد", "2025-11-02 10:03:07", "2025-11-02 10:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5251", "1770", "ایجاد فعالیت", "2025-11-02 10:03:07", "2025-11-02 10:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5252", "1769", "عملیات توسط Async Request کامل شد", "2025-11-02 10:03:07", "2025-11-02 10:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5253", "1770", "عملیات توسط WP Cron شروع شد", "2025-11-02 12:06:57", "2025-11-02 12:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5254", "1771", "ایجاد فعالیت", "2025-11-02 12:06:57", "2025-11-02 12:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5255", "1770", "عملیات توسط WP Cron کامل شد", "2025-11-02 12:06:57", "2025-11-02 12:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5256", "1771", "عملیات توسط WP Cron شروع شد", "2025-11-02 15:00:15", "2025-11-02 15:00:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5257", "1772", "ایجاد فعالیت", "2025-11-02 15:00:15", "2025-11-02 15:00:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5258", "1771", "عملیات توسط WP Cron کامل شد", "2025-11-02 15:00:15", "2025-11-02 15:00:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5259", "1772", "عملیات توسط WP Cron شروع شد", "2025-11-02 16:12:09", "2025-11-02 16:12:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5260", "1773", "ایجاد فعالیت", "2025-11-02 16:12:09", "2025-11-02 16:12:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5261", "1772", "عملیات توسط WP Cron کامل شد", "2025-11-02 16:12:09", "2025-11-02 16:12:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5262", "1773", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5263", "1774", "ایجاد فعالیت", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5264", "1773", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5265", "1766", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5266", "1766", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5268", "1768", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5269", "1768", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5270", "1776", "ایجاد فعالیت", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5271", "1756", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5272", "1756", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5273", "1777", "ایجاد فعالیت", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5274", "1757", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5275", "1757", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5276", "1778", "ایجاد فعالیت", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5277", "1758", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:48", "2025-11-02 22:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5278", "1758", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:49", "2025-11-02 22:02:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5279", "1779", "ایجاد فعالیت", "2025-11-02 22:02:49", "2025-11-02 22:02:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5280", "1759", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:49", "2025-11-02 22:02:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5281", "1759", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5282", "1780", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5283", "1760", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5284", "1760", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5285", "1781", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5286", "1761", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5287", "1761", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5288", "1782", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5289", "1764", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5291", "1783", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5292", "1784", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5293", "1764", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5294", "1785", "ایجاد فعالیت", "2025-11-02 22:02:50", "2025-11-02 22:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5295", "1784", "عملیات توسط WP Cron شروع شد", "2025-11-02 22:27:34", "2025-11-02 22:27:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5296", "1784", "عملیات توسط WP Cron کامل شد", "2025-11-02 22:27:34", "2025-11-02 22:27:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5297", "1774", "عملیات توسط WP Cron شروع شد", "2025-11-03 02:19:50", "2025-11-03 02:19:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5298", "1786", "ایجاد فعالیت", "2025-11-03 02:19:50", "2025-11-03 02:19:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5299", "1774", "عملیات توسط WP Cron کامل شد", "2025-11-03 02:19:50", "2025-11-03 02:19:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5300", "1783", "عملیات توسط WP Cron شروع شد", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5301", "1783", "عملیات توسط WP Cron کامل شد", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5302", "1787", "ایجاد فعالیت", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5303", "1786", "عملیات توسط WP Cron شروع شد", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5304", "1788", "ایجاد فعالیت", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5305", "1786", "عملیات توسط WP Cron کامل شد", "2025-11-03 05:37:10", "2025-11-03 05:37:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5306", "1788", "عملیات توسط WP Cron شروع شد", "2025-11-03 06:46:14", "2025-11-03 06:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5307", "1789", "ایجاد فعالیت", "2025-11-03 06:46:14", "2025-11-03 06:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5308", "1788", "عملیات توسط WP Cron کامل شد", "2025-11-03 06:46:14", "2025-11-03 06:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5309", "1789", "عملیات توسط WP Cron شروع شد", "2025-11-03 08:22:47", "2025-11-03 08:22:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5310", "1790", "ایجاد فعالیت", "2025-11-03 08:22:48", "2025-11-03 08:22:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5311", "1789", "عملیات توسط WP Cron کامل شد", "2025-11-03 08:22:48", "2025-11-03 08:22:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5312", "1790", "عملیات توسط WP Cron شروع شد", "2025-11-03 09:55:57", "2025-11-03 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5313", "1791", "ایجاد فعالیت", "2025-11-03 09:55:57", "2025-11-03 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5314", "1790", "عملیات توسط WP Cron کامل شد", "2025-11-03 09:55:57", "2025-11-03 09:55:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5315", "1776", "عملیات توسط WP Cron شروع شد", "2025-11-03 10:10:27", "2025-11-03 10:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5316", "1776", "عملیات توسط WP Cron کامل شد", "2025-11-03 10:10:27", "2025-11-03 10:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5317", "1792", "ایجاد فعالیت", "2025-11-03 10:10:27", "2025-11-03 10:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("5318", "1791", "عملیات توسط WP Cron شروع شد", "2025-11-03 11:00:08", "2025-11-03 11:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5319", "1793", "ایجاد فعالیت", "2025-11-03 11:00:08", "2025-11-03 11:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5320", "1791", "عملیات توسط WP Cron کامل شد", "2025-11-03 11:00:08", "2025-11-03 11:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("5321", "1793", "عملیات توسط WP Cron شروع شد", "2025-11-03 12:43:45", "2025-11-03 12:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5322", "1794", "ایجاد فعالیت", "2025-11-03 12:43:45", "2025-11-03 12:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5323", "1793", "عملیات توسط WP Cron کامل شد", "2025-11-03 12:43:45", "2025-11-03 12:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5324", "1794", "عملیات توسط WP Cron شروع شد", "2025-11-03 14:14:15", "2025-11-03 14:14:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5325", "1795", "ایجاد فعالیت", "2025-11-03 14:14:15", "2025-11-03 14:14:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5326", "1794", "عملیات توسط WP Cron کامل شد", "2025-11-03 14:14:15", "2025-11-03 14:14:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5327", "1795", "عملیات توسط WP Cron شروع شد", "2025-11-03 15:31:45", "2025-11-03 15:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5328", "1796", "ایجاد فعالیت", "2025-11-03 15:31:45", "2025-11-03 15:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5329", "1795", "عملیات توسط WP Cron کامل شد", "2025-11-03 15:31:45", "2025-11-03 15:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5330", "1796", "عملیات توسط WP Cron شروع شد", "2025-11-03 18:51:22", "2025-11-03 18:51:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5331", "1797", "ایجاد فعالیت", "2025-11-03 18:51:23", "2025-11-03 18:51:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5332", "1796", "عملیات توسط WP Cron کامل شد", "2025-11-03 18:51:23", "2025-11-03 18:51:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5333", "1787", "عملیات توسط WP Cron شروع شد", "2025-11-03 18:51:23", "2025-11-03 18:51:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5334", "1787", "عملیات توسط WP Cron کامل شد", "2025-11-03 18:51:23", "2025-11-03 18:51:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5336", "1797", "عملیات توسط WP Cron شروع شد", "2025-11-03 21:15:10", "2025-11-03 21:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5337", "1799", "ایجاد فعالیت", "2025-11-03 21:15:10", "2025-11-03 21:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5338", "1797", "عملیات توسط WP Cron کامل شد", "2025-11-03 21:15:10", "2025-11-03 21:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5339", "1777", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5340", "1777", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5341", "1800", "ایجاد فعالیت", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5342", "1778", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5343", "1778", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5344", "1801", "ایجاد فعالیت", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5345", "1779", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:41", "2025-11-04 01:01:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5346", "1779", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:42", "2025-11-04 01:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("5347", "1802", "ایجاد فعالیت", "2025-11-04 01:01:42", "2025-11-04 01:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("5348", "1780", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:42", "2025-11-04 01:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("5349", "1780", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5350", "1803", "ایجاد فعالیت", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5351", "1781", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5352", "1781", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5353", "1804", "ایجاد فعالیت", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5354", "1782", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5355", "1782", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5356", "1805", "ایجاد فعالیت", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5357", "1792", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5358", "1792", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5359", "1806", "ایجاد فعالیت", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5360", "1799", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5361", "1807", "ایجاد فعالیت", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5362", "1799", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5363", "1785", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:01:43", "2025-11-04 01:01:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5366", "1809", "ایجاد فعالیت", "2025-11-04 01:01:44", "2025-11-04 01:01:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5367", "1785", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:01:44", "2025-11-04 01:01:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5368", "1810", "ایجاد فعالیت", "2025-11-04 01:01:44", "2025-11-04 01:01:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5369", "1809", "عملیات توسط WP Cron شروع شد", "2025-11-04 01:07:43", "2025-11-04 01:07:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5370", "1809", "عملیات توسط WP Cron کامل شد", "2025-11-04 01:07:43", "2025-11-04 01:07:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5371", "1807", "عملیات توسط WP Cron شروع شد", "2025-11-04 02:19:55", "2025-11-04 02:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5372", "1811", "ایجاد فعالیت", "2025-11-04 02:19:55", "2025-11-04 02:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5373", "1807", "عملیات توسط WP Cron کامل شد", "2025-11-04 02:19:55", "2025-11-04 02:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5374", "1811", "عملیات توسط WP Cron شروع شد", "2025-11-04 03:56:07", "2025-11-04 03:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5375", "1812", "ایجاد فعالیت", "2025-11-04 03:56:07", "2025-11-04 03:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5376", "1811", "عملیات توسط WP Cron کامل شد", "2025-11-04 03:56:07", "2025-11-04 03:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5377", "1812", "عملیات توسط WP Cron شروع شد", "2025-11-04 06:54:33", "2025-11-04 06:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("5378", "1813", "ایجاد فعالیت", "2025-11-04 06:54:33", "2025-11-04 06:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("5379", "1812", "عملیات توسط WP Cron کامل شد", "2025-11-04 06:54:33", "2025-11-04 06:54:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("5380", "1813", "عملیات توسط WP Cron شروع شد", "2025-11-04 11:12:25", "2025-11-04 11:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5381", "1814", "ایجاد فعالیت", "2025-11-04 11:12:25", "2025-11-04 11:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5382", "1813", "عملیات توسط WP Cron کامل شد", "2025-11-04 11:12:25", "2025-11-04 11:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5383", "1814", "عملیات توسط WP Cron شروع شد", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5384", "1815", "ایجاد فعالیت", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5385", "1814", "عملیات توسط WP Cron کامل شد", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5386", "1806", "عملیات توسط WP Cron شروع شد", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5387", "1806", "عملیات توسط WP Cron کامل شد", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5388", "1816", "ایجاد فعالیت", "2025-11-04 13:25:59", "2025-11-04 13:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5389", "1815", "عملیات توسط WP Cron شروع شد", "2025-11-04 16:49:46", "2025-11-04 16:49:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5390", "1817", "ایجاد فعالیت", "2025-11-04 16:49:46", "2025-11-04 16:49:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5391", "1815", "عملیات توسط WP Cron کامل شد", "2025-11-04 16:49:46", "2025-11-04 16:49:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5392", "1817", "عملیات توسط WP Cron شروع شد", "2025-11-04 18:19:32", "2025-11-04 18:19:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5393", "1818", "ایجاد فعالیت", "2025-11-04 18:19:32", "2025-11-04 18:19:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5394", "1817", "عملیات توسط WP Cron کامل شد", "2025-11-04 18:19:32", "2025-11-04 18:19:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5395", "1818", "عملیات توسط WP Cron شروع شد", "2025-11-04 19:24:09", "2025-11-04 19:24:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5396", "1819", "ایجاد فعالیت", "2025-11-04 19:24:09", "2025-11-04 19:24:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5397", "1818", "عملیات توسط WP Cron کامل شد", "2025-11-04 19:24:09", "2025-11-04 19:24:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5398", "1819", "عملیات توسط WP Cron شروع شد", "2025-11-04 21:09:35", "2025-11-04 21:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5399", "1820", "ایجاد فعالیت", "2025-11-04 21:09:35", "2025-11-04 21:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5400", "1819", "عملیات توسط WP Cron کامل شد", "2025-11-04 21:09:35", "2025-11-04 21:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5401", "1820", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5402", "1821", "ایجاد فعالیت", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5403", "1820", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5404", "1800", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5405", "1800", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5406", "1822", "ایجاد فعالیت", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5407", "1801", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5408", "1801", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5409", "1823", "ایجاد فعالیت", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5410", "1802", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:04", "2025-11-05 02:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5411", "1802", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:05", "2025-11-05 02:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5412", "1824", "ایجاد فعالیت", "2025-11-05 02:04:05", "2025-11-05 02:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5413", "1803", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:05", "2025-11-05 02:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5414", "1803", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5415", "1825", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5416", "1804", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5417", "1804", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5418", "1826", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5419", "1805", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5420", "1805", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5421", "1827", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5422", "1816", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5423", "1816", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5424", "1828", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5425", "1810", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5428", "1830", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5429", "1810", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5430", "1831", "ایجاد فعالیت", "2025-11-05 02:04:07", "2025-11-05 02:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5431", "1830", "عملیات توسط WP Cron شروع شد", "2025-11-05 02:23:51", "2025-11-05 02:23:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5432", "1830", "عملیات توسط WP Cron کامل شد", "2025-11-05 02:23:51", "2025-11-05 02:23:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5433", "1821", "عملیات توسط WP Cron شروع شد", "2025-11-05 08:04:29", "2025-11-05 08:04:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5434", "1832", "ایجاد فعالیت", "2025-11-05 08:04:30", "2025-11-05 08:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5435", "1821", "عملیات توسط WP Cron کامل شد", "2025-11-05 08:04:30", "2025-11-05 08:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5436", "1832", "عملیات توسط WP Cron شروع شد", "2025-11-05 10:34:49", "2025-11-05 10:34:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5437", "1833", "ایجاد فعالیت", "2025-11-05 10:34:49", "2025-11-05 10:34:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5438", "1832", "عملیات توسط WP Cron کامل شد", "2025-11-05 10:34:49", "2025-11-05 10:34:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5439", "1833", "عملیات توسط WP Cron شروع شد", "2025-11-05 11:56:30", "2025-11-05 11:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5440", "1834", "ایجاد فعالیت", "2025-11-05 11:56:31", "2025-11-05 11:56:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5441", "1833", "عملیات توسط WP Cron کامل شد", "2025-11-05 11:56:31", "2025-11-05 11:56:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5442", "1834", "عملیات توسط WP Cron شروع شد", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5443", "1835", "ایجاد فعالیت", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5444", "1834", "عملیات توسط WP Cron کامل شد", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5445", "1828", "عملیات توسط WP Cron شروع شد", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5446", "1828", "عملیات توسط WP Cron کامل شد", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5447", "1836", "ایجاد فعالیت", "2025-11-05 15:08:25", "2025-11-05 15:08:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5448", "1835", "عملیات توسط WP Cron شروع شد", "2025-11-05 19:29:06", "2025-11-05 19:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("5449", "1837", "ایجاد فعالیت", "2025-11-05 19:29:06", "2025-11-05 19:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("5450", "1835", "عملیات توسط WP Cron کامل شد", "2025-11-05 19:29:06", "2025-11-05 19:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("5451", "1837", "عملیات توسط WP Cron شروع شد", "2025-11-05 21:10:57", "2025-11-05 21:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5452", "1838", "ایجاد فعالیت", "2025-11-05 21:10:57", "2025-11-05 21:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5453", "1837", "عملیات توسط WP Cron کامل شد", "2025-11-05 21:10:57", "2025-11-05 21:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5454", "1838", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5455", "1839", "ایجاد فعالیت", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5456", "1838", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5457", "1822", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5458", "1822", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5459", "1840", "ایجاد فعالیت", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5460", "1823", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5461", "1823", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5462", "1841", "ایجاد فعالیت", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5463", "1824", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:35", "2025-11-06 02:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5464", "1824", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:36", "2025-11-06 02:21:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5465", "1842", "ایجاد فعالیت", "2025-11-06 02:21:36", "2025-11-06 02:21:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5466", "1825", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:36", "2025-11-06 02:21:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5467", "1825", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5468", "1843", "ایجاد فعالیت", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5469", "1826", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5470", "1826", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5471", "1844", "ایجاد فعالیت", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5472", "1827", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5473", "1827", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5474", "1845", "ایجاد فعالیت", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5475", "1831", "عملیات توسط WP Cron شروع شد", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5477", "1846", "ایجاد فعالیت", "2025-11-06 02:21:37", "2025-11-06 02:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5478", "1847", "ایجاد فعالیت", "2025-11-06 02:21:38", "2025-11-06 02:21:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("5479", "1831", "عملیات توسط WP Cron کامل شد", "2025-11-06 02:21:38", "2025-11-06 02:21:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("5480", "1848", "ایجاد فعالیت", "2025-11-06 02:21:38", "2025-11-06 02:21:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("5481", "1847", "عملیات توسط WP Cron شروع شد", "2025-11-06 05:01:36", "2025-11-06 05:01:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5482", "1847", "عملیات توسط WP Cron کامل شد", "2025-11-06 05:01:36", "2025-11-06 05:01:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5483", "1836", "عملیات توسط WP Cron شروع شد", "2025-11-06 05:01:36", "2025-11-06 05:01:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5484", "1836", "عملیات توسط WP Cron کامل شد", "2025-11-06 05:01:37", "2025-11-06 05:01:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5485", "1849", "ایجاد فعالیت", "2025-11-06 05:01:37", "2025-11-06 05:01:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5486", "1839", "عملیات توسط WP Cron شروع شد", "2025-11-06 05:01:37", "2025-11-06 05:01:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5487", "1850", "ایجاد فعالیت", "2025-11-06 05:01:37", "2025-11-06 05:01:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5488", "1839", "عملیات توسط WP Cron کامل شد", "2025-11-06 05:01:37", "2025-11-06 05:01:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5489", "1850", "عملیات توسط WP Cron شروع شد", "2025-11-06 06:04:40", "2025-11-06 06:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5490", "1851", "ایجاد فعالیت", "2025-11-06 06:04:40", "2025-11-06 06:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5491", "1850", "عملیات توسط WP Cron کامل شد", "2025-11-06 06:04:40", "2025-11-06 06:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5492", "1851", "عملیات توسط WP Cron شروع شد", "2025-11-06 07:13:40", "2025-11-06 07:13:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5493", "1852", "ایجاد فعالیت", "2025-11-06 07:13:41", "2025-11-06 07:13:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5494", "1851", "عملیات توسط WP Cron کامل شد", "2025-11-06 07:13:41", "2025-11-06 07:13:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5495", "1852", "عملیات توسط WP Cron شروع شد", "2025-11-06 09:38:31", "2025-11-06 09:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5496", "1853", "ایجاد فعالیت", "2025-11-06 09:38:31", "2025-11-06 09:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5497", "1852", "عملیات توسط WP Cron کامل شد", "2025-11-06 09:38:31", "2025-11-06 09:38:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5498", "1853", "عملیات توسط WP Cron شروع شد", "2025-11-06 11:34:18", "2025-11-06 11:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("5499", "1854", "ایجاد فعالیت", "2025-11-06 11:34:18", "2025-11-06 11:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("5500", "1853", "عملیات توسط WP Cron کامل شد", "2025-11-06 11:34:18", "2025-11-06 11:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("5501", "1854", "عملیات توسط WP Cron شروع شد", "2025-11-06 15:03:07", "2025-11-06 15:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5502", "1855", "ایجاد فعالیت", "2025-11-06 15:03:07", "2025-11-06 15:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5503", "1854", "عملیات توسط WP Cron کامل شد", "2025-11-06 15:03:07", "2025-11-06 15:03:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5504", "1855", "عملیات توسط WP Cron شروع شد", "2025-11-06 16:11:35", "2025-11-06 16:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5505", "1856", "ایجاد فعالیت", "2025-11-06 16:11:35", "2025-11-06 16:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5506", "1855", "عملیات توسط WP Cron کامل شد", "2025-11-06 16:11:35", "2025-11-06 16:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5507", "1849", "عملیات توسط WP Cron شروع شد", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5508", "1849", "عملیات توسط WP Cron کامل شد", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5509", "1857", "ایجاد فعالیت", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5510", "1856", "عملیات توسط WP Cron شروع شد", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5511", "1858", "ایجاد فعالیت", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5512", "1856", "عملیات توسط WP Cron کامل شد", "2025-11-06 17:50:39", "2025-11-06 17:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5513", "1858", "عملیات توسط WP Cron شروع شد", "2025-11-06 19:01:54", "2025-11-06 19:01:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5514", "1859", "ایجاد فعالیت", "2025-11-06 19:01:54", "2025-11-06 19:01:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5515", "1858", "عملیات توسط WP Cron کامل شد", "2025-11-06 19:01:54", "2025-11-06 19:01:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5516", "1859", "عملیات توسط WP Cron شروع شد", "2025-11-06 21:17:17", "2025-11-06 21:17:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5517", "1860", "ایجاد فعالیت", "2025-11-06 21:17:17", "2025-11-06 21:17:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5518", "1859", "عملیات توسط WP Cron کامل شد", "2025-11-06 21:17:17", "2025-11-06 21:17:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5519", "1860", "عملیات توسط WP Cron شروع شد", "2025-11-06 23:41:23", "2025-11-06 23:41:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5520", "1861", "ایجاد فعالیت", "2025-11-06 23:41:23", "2025-11-06 23:41:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5521", "1860", "عملیات توسط WP Cron کامل شد", "2025-11-06 23:41:23", "2025-11-06 23:41:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5522", "1861", "عملیات توسط WP Cron شروع شد", "2025-11-07 02:20:24", "2025-11-07 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5523", "1862", "ایجاد فعالیت", "2025-11-07 02:20:24", "2025-11-07 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5524", "1861", "عملیات توسط WP Cron کامل شد", "2025-11-07 02:20:24", "2025-11-07 02:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("5525", "1840", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5526", "1840", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5527", "1863", "ایجاد فعالیت", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5528", "1841", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5529", "1841", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5530", "1864", "ایجاد فعالیت", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5531", "1842", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:34", "2025-11-07 09:19:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5532", "1842", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:35", "2025-11-07 09:19:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5533", "1865", "ایجاد فعالیت", "2025-11-07 09:19:35", "2025-11-07 09:19:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5534", "1843", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:35", "2025-11-07 09:19:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5535", "1843", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5536", "1866", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5537", "1844", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5538", "1844", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5539", "1867", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5540", "1845", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5541", "1845", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5542", "1868", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5543", "1846", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5544", "1846", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5546", "1862", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5547", "1870", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5548", "1862", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5549", "1857", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5550", "1857", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5551", "1871", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5552", "1848", "عملیات توسط WP Cron شروع شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5554", "1872", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5555", "1873", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5556", "1848", "عملیات توسط WP Cron کامل شد", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5557", "1874", "ایجاد فعالیت", "2025-11-07 09:19:36", "2025-11-07 09:19:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("5558", "1873", "عملیات توسط WP Cron شروع شد", "2025-11-07 10:31:52", "2025-11-07 10:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("5559", "1873", "عملیات توسط WP Cron کامل شد", "2025-11-07 10:31:52", "2025-11-07 10:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("5560", "1870", "عملیات توسط WP Cron شروع شد", "2025-11-07 10:31:52", "2025-11-07 10:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("5561", "1875", "ایجاد فعالیت", "2025-11-07 10:31:52", "2025-11-07 10:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("5562", "1870", "عملیات توسط WP Cron کامل شد", "2025-11-07 10:31:52", "2025-11-07 10:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("5563", "1875", "عملیات توسط WP Cron شروع شد", "2025-11-07 11:33:00", "2025-11-07 11:33:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5564", "1876", "ایجاد فعالیت", "2025-11-07 11:33:00", "2025-11-07 11:33:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5565", "1875", "عملیات توسط WP Cron کامل شد", "2025-11-07 11:33:00", "2025-11-07 11:33:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("5566", "1876", "عملیات توسط WP Cron شروع شد", "2025-11-07 12:41:28", "2025-11-07 12:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5567", "1877", "ایجاد فعالیت", "2025-11-07 12:41:28", "2025-11-07 12:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5568", "1876", "عملیات توسط WP Cron کامل شد", "2025-11-07 12:41:28", "2025-11-07 12:41:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5569", "1877", "عملیات توسط WP Cron شروع شد", "2025-11-07 13:54:02", "2025-11-07 13:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("5570", "1878", "ایجاد فعالیت", "2025-11-07 13:54:02", "2025-11-07 13:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("5571", "1877", "عملیات توسط WP Cron کامل شد", "2025-11-07 13:54:02", "2025-11-07 13:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("5572", "1878", "عملیات توسط WP Cron شروع شد", "2025-11-07 15:04:40", "2025-11-07 15:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5573", "1879", "ایجاد فعالیت", "2025-11-07 15:04:40", "2025-11-07 15:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5574", "1878", "عملیات توسط WP Cron کامل شد", "2025-11-07 15:04:40", "2025-11-07 15:04:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5575", "1879", "عملیات توسط WP Cron شروع شد", "2025-11-07 16:36:16", "2025-11-07 16:36:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("5576", "1880", "ایجاد فعالیت", "2025-11-07 16:36:17", "2025-11-07 16:36:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5577", "1879", "عملیات توسط WP Cron کامل شد", "2025-11-07 16:36:17", "2025-11-07 16:36:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5578", "1880", "عملیات توسط WP Cron شروع شد", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5579", "1881", "ایجاد فعالیت", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5580", "1880", "عملیات توسط WP Cron کامل شد", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5581", "1871", "عملیات توسط WP Cron شروع شد", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5582", "1871", "عملیات توسط WP Cron کامل شد", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5583", "1882", "ایجاد فعالیت", "2025-11-08 00:14:09", "2025-11-08 00:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5584", "1881", "عملیات توسط WP Cron شروع شد", "2025-11-08 01:16:32", "2025-11-08 01:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5585", "1883", "ایجاد فعالیت", "2025-11-08 01:16:32", "2025-11-08 01:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5586", "1881", "عملیات توسط WP Cron کامل شد", "2025-11-08 01:16:32", "2025-11-08 01:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5587", "1883", "عملیات توسط WP Cron شروع شد", "2025-11-08 02:19:54", "2025-11-08 02:19:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5588", "1884", "ایجاد فعالیت", "2025-11-08 02:19:54", "2025-11-08 02:19:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5589", "1883", "عملیات توسط WP Cron کامل شد", "2025-11-08 02:19:54", "2025-11-08 02:19:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5590", "1872", "عملیات توسط WP Cron شروع شد", "2025-11-08 04:59:14", "2025-11-08 04:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5591", "1872", "عملیات توسط WP Cron کامل شد", "2025-11-08 04:59:14", "2025-11-08 04:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5593", "1884", "عملیات توسط WP Cron شروع شد", "2025-11-08 04:59:14", "2025-11-08 04:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5594", "1886", "ایجاد فعالیت", "2025-11-08 04:59:14", "2025-11-08 04:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5595", "1884", "عملیات توسط WP Cron کامل شد", "2025-11-08 04:59:14", "2025-11-08 04:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5596", "1886", "عملیات توسط WP Cron شروع شد", "2025-11-08 06:15:25", "2025-11-08 06:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5597", "1887", "ایجاد فعالیت", "2025-11-08 06:15:25", "2025-11-08 06:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5598", "1886", "عملیات توسط WP Cron کامل شد", "2025-11-08 06:15:25", "2025-11-08 06:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5599", "1887", "عملیات توسط WP Cron شروع شد", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5600", "1888", "ایجاد فعالیت", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5601", "1887", "عملیات توسط WP Cron کامل شد", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5602", "1580", "عملیات توسط WP Cron شروع شد", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5603", "1580", "عملیات توسط WP Cron کامل شد", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5604", "1889", "ایجاد فعالیت", "2025-11-08 08:59:09", "2025-11-08 08:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5605", "1863", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5606", "1863", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5607", "1890", "ایجاد فعالیت", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5608", "1864", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5609", "1864", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5610", "1891", "ایجاد فعالیت", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5611", "1865", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5612", "1865", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5613", "1892", "ایجاد فعالیت", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5614", "1866", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:49", "2025-11-08 09:33:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5615", "1866", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5616", "1893", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5617", "1867", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5618", "1867", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5619", "1894", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5620", "1868", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5621", "1868", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5622", "1895", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5623", "1874", "عملیات توسط WP Cron شروع شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5625", "1896", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5626", "1897", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5627", "1874", "عملیات توسط WP Cron کامل شد", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5628", "1898", "ایجاد فعالیت", "2025-11-08 09:33:51", "2025-11-08 09:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("5629", "1897", "عملیات توسط WP Cron شروع شد", "2025-11-08 10:39:49", "2025-11-08 10:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5630", "1897", "عملیات توسط WP Cron کامل شد", "2025-11-08 10:39:49", "2025-11-08 10:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5631", "1888", "عملیات توسط WP Cron شروع شد", "2025-11-08 10:39:49", "2025-11-08 10:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5632", "1899", "ایجاد فعالیت", "2025-11-08 10:39:49", "2025-11-08 10:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5633", "1888", "عملیات توسط WP Cron کامل شد", "2025-11-08 10:39:49", "2025-11-08 10:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5634", "1899", "عملیات توسط WP Cron شروع شد", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5635", "1900", "ایجاد فعالیت", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5636", "1899", "عملیات توسط WP Cron کامل شد", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5637", "1882", "عملیات توسط WP Cron شروع شد", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5638", "1882", "عملیات توسط WP Cron کامل شد", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5639", "1901", "ایجاد فعالیت", "2025-11-08 14:20:45", "2025-11-08 14:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5640", "1900", "عملیات توسط WP Cron شروع شد", "2025-11-08 18:11:35", "2025-11-08 18:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5641", "1902", "ایجاد فعالیت", "2025-11-08 18:11:35", "2025-11-08 18:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5642", "1900", "عملیات توسط WP Cron کامل شد", "2025-11-08 18:11:35", "2025-11-08 18:11:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5643", "1902", "عملیات توسط WP Cron شروع شد", "2025-11-08 19:11:53", "2025-11-08 19:11:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("5644", "1903", "ایجاد فعالیت", "2025-11-08 19:11:53", "2025-11-08 19:11:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("5645", "1902", "عملیات توسط WP Cron کامل شد", "2025-11-08 19:11:54", "2025-11-08 19:11:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5646", "1903", "عملیات توسط WP Cron شروع شد", "2025-11-08 20:52:55", "2025-11-08 20:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5647", "1904", "ایجاد فعالیت", "2025-11-08 20:52:55", "2025-11-08 20:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5648", "1903", "عملیات توسط WP Cron کامل شد", "2025-11-08 20:52:55", "2025-11-08 20:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5649", "1904", "عملیات توسط WP Cron شروع شد", "2025-11-08 21:53:25", "2025-11-08 21:53:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5650", "1905", "ایجاد فعالیت", "2025-11-08 21:53:25", "2025-11-08 21:53:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("5651", "1904", "عملیات توسط WP Cron کامل شد", "2025-11-08 21:53:25", "2025-11-08 21:53:25");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("3", "4", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("4", "4", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "4", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("6", "5", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("7", "5", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("8", "5", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("9", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("10", "6", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("11", "7", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("12", "7", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("13", "7", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("14", "8", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("15", "8", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("16", "8", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("17", "9", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("18", "9", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("19", "9", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("20", "10", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("21", "10", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("22", "10", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("23", "11", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("24", "11", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("25", "11", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("26", "12", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("27", "12", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("28", "12", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("29", "13", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("30", "13", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("31", "13", "_wxr_import_user", "1");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2024-07-30 03:47:55", "2024-07-30 00:17:55", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://fa.gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "1438", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "::1", "2024-03-13 20:33:47", "2024-03-13 20:33:47", "Nice", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "1438", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "::1", "2024-03-13 20:34:05", "2024-03-13 20:34:05", "Wow", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "1438", "Jikone", "admin@Example.com", "", "::1", "2024-03-15 19:00:58", "2024-03-15 19:00:58", "Awesome", "0", "0", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "1492", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:51:24", "2024-03-16 17:51:24", "Good", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "1494", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:50:25", "2024-03-16 17:50:25", "Nice", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "1496", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "::1", "2024-03-16 09:43:56", "2024-03-16 09:43:56", "Nice", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "1498", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:50:56", "2024-03-16 17:50:56", "Nice", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "1500", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:51:14", "2024-03-16 17:51:14", "Nice", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "1502", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:51:02", "2024-03-16 17:51:02", "WOw", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "1504", "foodking", "admin@foodking.com", "https://modinatheme.com/foodking", "103.49.200.36", "2024-03-16 17:50:45", "2024-03-16 17:50:45", "Wow", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "2214", "ووکامرس", "", "", "", "2024-08-08 03:19:11", "2024-08-07 23:49:11", "وضعیت سفارش از پیش‌نویس به در انتظار پرداخت تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "2214", "ووکامرس", "", "", "", "2024-08-08 03:19:12", "2024-08-07 23:49:12", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "2224", "ووکامرس", "", "", "", "2024-08-08 04:19:51", "2024-08-08 00:49:51", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "2295", "ووکامرس", "", "", "", "2024-08-10 01:48:24", "2024-08-09 22:18:24", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "1890", "foodking", "mahdiwir80@outlook.com", "https://t-theme.com/foodking", "83.121.119.194", "2024-08-14 04:21:24", "2024-08-14 00:51:24", "242444224", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("20", "2533", "ووکامرس", "", "", "", "2024-11-10 01:18:35", "2024-11-09 21:48:35", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "2534", "ووکامرس", "", "", "", "2024-11-10 01:27:48", "2024-11-09 21:57:48", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "2535", "ووکامرس", "", "", "", "2024-11-10 01:30:55", "2024-11-09 22:00:55", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "1", "سلام", "wwwhasanjoon0@gmail.com", "", "5.215.180.99", "2024-12-01 14:51:22", "2024-12-01 11:21:22", "سلام", "0", "0", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("12", "20240820_d982d8a7d984d8a8d981d988d8afda", "348cda641922c07d8434_20251108220914", "21", "2025-11-08 22:09:26", "foodking", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-08 22:09:14\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:12;s:4:\"Name\";s:39:\"20240820_d982d8a7d984d8a8d981d988d8afda\";s:4:\"Hash\";s:35:\"348cda641922c07d8434_20251108220914\";s:8:\"NameHash\";s:75:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914\";s:4:\"Type\";i:0;s:5:\"Notes\";s:231:\"نام کاربری : admin \r\nرمز عبور : 1234\r\nتوجه : حتما پس از اتمام فرایند نصب قالب جهت افزایش امنیت سایت خود حتما پسورد و یوزر تغییر داده شود .\";s:8:\"ScanFile\";s:85:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:8:\"foodking\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/home/tthemeco/public_html/foodking\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2468;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16554;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-08 22:09:14\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20240820_d982d8a7d984d8a8d981d988d8afda\";s:4:\"Hash\";s:35:\"348cda641922c07d8434_20251108220914\";s:8:\"NameHash\";s:75:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914\";s:4:\"Type\";i:0;s:5:\"Notes\";s:231:\"نام کاربری : admin \r\nرمز عبور : 1234\r\nتوجه : حتما پس از اتمام فرایند نصب قالب جهت افزایش امنیت سایت خود حتما پسورد و یوزر تغییر داده شود .\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/home/tthemeco/public_html/foodking/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:156:\"/home/tthemeco/public_html/foodking/wp-content/backups-dup-lite/tmp/20240820_d982d8a7d984d8a8d981d988d8afda_348cda641922c07d8434_20251108220914_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/home/tthemeco/public_html/foodking/wp-admin\";i:1;s:47:\"/home/tthemeco/public_html/foodking/wp-includes\";i:2;s:56:\"/home/tthemeco/public_html/foodking/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/home/tthemeco/public_html/foodking\";i:1;s:35:\"/home/tthemeco/public_html/foodking\";i:2;s:46:\"/home/tthemeco/public_html/foodking/wp-content\";i:3;s:54:\"/home/tthemeco/public_html/foodking/wp-content/uploads\";i:4;s:54:\"/home/tthemeco/public_html/foodking/wp-content/plugins\";i:5;s:57:\"/home/tthemeco/public_html/foodking/wp-content/mu-plugins\";i:6;s:53:\"/home/tthemeco/public_html/foodking/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/home/tthemeco/public_html/foodking/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2024-08-03T03:11:10.098-04:30\"}", "2024-08-03 11:11:10");
INSERT INTO `wp_e_events` VALUES("2", "{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2024-08-03T03:11:13.443-04:30\"}", "2024-08-03 11:11:13");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:23:{i:1762639783;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1762640177;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762640276;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762641151;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762641644;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762641670;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762645109;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762645218;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762645228;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762645244;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762645305;a:1:{s:34:\"yith_wcwl_delete_expired_wishlists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762647476;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762647485;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762647489;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762652874;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762654674;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762741220;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762770600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762863512;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762906676;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763163072;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763163619;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://t-theme.com/foodking", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://t-theme.com/foodking", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "قالب فودکینگ", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "mahdiwir80@outlook.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "password", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "Y-m-d", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:262:{s:8:\"teams/?$\";s:25:\"index.php?post_type=teams\";s:38:\"teams/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=teams&feed=$matches[1]\";s:33:\"teams/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=teams&feed=$matches[1]\";s:25:\"teams/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=teams&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:61:\"((?!wp-json/.*)([^/]+/)*wishlist)(/(.*))?/page/([0-9]{1,})/?$\";s:76:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]&paged=$matches[5]\";s:44:\"((?!wp-json/.*)([^/]+/)*wishlist)(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"teams/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"teams/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"teams/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"teams/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"teams/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"teams/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"teams/([^/]+)/embed/?$\";s:38:\"index.php?teams=$matches[1]&embed=true\";s:26:\"teams/([^/]+)/trackback/?$\";s:32:\"index.php?teams=$matches[1]&tb=1\";s:46:\"teams/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?teams=$matches[1]&feed=$matches[2]\";s:41:\"teams/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?teams=$matches[1]&feed=$matches[2]\";s:34:\"teams/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?teams=$matches[1]&paged=$matches[2]\";s:41:\"teams/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?teams=$matches[1]&cpage=$matches[2]\";s:42:\"teams/([^/]+)/wc/file/transient(/(.*))?/?$\";s:57:\"index.php?teams=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"teams/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?teams=$matches[1]&wc-api=$matches[3]\";s:48:\"teams/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"teams/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"teams/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"teams/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"teams/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?teams=$matches[1]&page=$matches[2]\";s:22:\"teams/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"teams/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"teams/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"teams/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"teams/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"teams/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"foodking_blocks/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"foodking_blocks/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"foodking_blocks/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"foodking_blocks/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"foodking_blocks/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"foodking_blocks/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"foodking_blocks/([^/]+)/embed/?$\";s:48:\"index.php?foodking_blocks=$matches[1]&embed=true\";s:36:\"foodking_blocks/([^/]+)/trackback/?$\";s:42:\"index.php?foodking_blocks=$matches[1]&tb=1\";s:44:\"foodking_blocks/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?foodking_blocks=$matches[1]&paged=$matches[2]\";s:51:\"foodking_blocks/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?foodking_blocks=$matches[1]&cpage=$matches[2]\";s:52:\"foodking_blocks/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?foodking_blocks=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"foodking_blocks/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?foodking_blocks=$matches[1]&wc-api=$matches[3]\";s:58:\"foodking_blocks/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"foodking_blocks/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"foodking_blocks/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"foodking_blocks/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"foodking_blocks/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?foodking_blocks=$matches[1]&page=$matches[2]\";s:32:\"foodking_blocks/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"foodking_blocks/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"foodking_blocks/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"foodking_blocks/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"foodking_blocks/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"foodking_blocks/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=49&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:10:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:37:\"foodking-toolkit/foodking-toolkit.php\";i:6;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:7;s:29:\"persian-date/persian-date.php\";i:8;s:27:\"woocommerce/woocommerce.php\";i:9;s:34:\"yith-woocommerce-wishlist/init.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:72:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/style.css\";i:2;s:70:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/rtl.css\";i:3;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/el-widgets/choose-us.php\";i:4;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/el-widgets/instagram-banner.php\";i:5;s:92:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/foodking-toolkit.php\";}", "off");
INSERT INTO `wp_options` VALUES("41", "template", "foodking", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "foodking", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "gravatar_default", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:26:\"[foodking_block id=\"1652\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "28", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "49", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "1692", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1774951794", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "57155", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:116:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "auto");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "3", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:22:\"custom_search_widget-1\";i:1;s:29:\"custom_popular_posts_widget-1\";i:2;s:34:\"custom_sidebar_categories_widget-1\";i:3;s:32:\"woocommerce_product_categories-1\";i:4;s:24:\"never_miss_news_widget-1\";i:5;s:21:\"popular_tags_widget-1\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:4:\"shop\";a:3:{i:0;s:6:\"text-1\";i:1;s:26:\"woocommerce_price_filter-1\";i:2;s:38:\"woocommerce_recently_viewed_products-1\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.6.1\";s:5:\"files\";a:496:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:29:\"comment-content/style-rtl.css\";i:77;s:33:\"comment-content/style-rtl.min.css\";i:78;s:25:\"comment-content/style.css\";i:79;s:29:\"comment-content/style.min.css\";i:80;s:30:\"comment-template/style-rtl.css\";i:81;s:34:\"comment-template/style-rtl.min.css\";i:82;s:26:\"comment-template/style.css\";i:83;s:30:\"comment-template/style.min.css\";i:84;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:85;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:86;s:38:\"comments-pagination-numbers/editor.css\";i:87;s:42:\"comments-pagination-numbers/editor.min.css\";i:88;s:34:\"comments-pagination/editor-rtl.css\";i:89;s:38:\"comments-pagination/editor-rtl.min.css\";i:90;s:30:\"comments-pagination/editor.css\";i:91;s:34:\"comments-pagination/editor.min.css\";i:92;s:33:\"comments-pagination/style-rtl.css\";i:93;s:37:\"comments-pagination/style-rtl.min.css\";i:94;s:29:\"comments-pagination/style.css\";i:95;s:33:\"comments-pagination/style.min.css\";i:96;s:29:\"comments-title/editor-rtl.css\";i:97;s:33:\"comments-title/editor-rtl.min.css\";i:98;s:25:\"comments-title/editor.css\";i:99;s:29:\"comments-title/editor.min.css\";i:100;s:23:\"comments/editor-rtl.css\";i:101;s:27:\"comments/editor-rtl.min.css\";i:102;s:19:\"comments/editor.css\";i:103;s:23:\"comments/editor.min.css\";i:104;s:22:\"comments/style-rtl.css\";i:105;s:26:\"comments/style-rtl.min.css\";i:106;s:18:\"comments/style.css\";i:107;s:22:\"comments/style.min.css\";i:108;s:20:\"cover/editor-rtl.css\";i:109;s:24:\"cover/editor-rtl.min.css\";i:110;s:16:\"cover/editor.css\";i:111;s:20:\"cover/editor.min.css\";i:112;s:19:\"cover/style-rtl.css\";i:113;s:23:\"cover/style-rtl.min.css\";i:114;s:15:\"cover/style.css\";i:115;s:19:\"cover/style.min.css\";i:116;s:22:\"details/editor-rtl.css\";i:117;s:26:\"details/editor-rtl.min.css\";i:118;s:18:\"details/editor.css\";i:119;s:22:\"details/editor.min.css\";i:120;s:21:\"details/style-rtl.css\";i:121;s:25:\"details/style-rtl.min.css\";i:122;s:17:\"details/style.css\";i:123;s:21:\"details/style.min.css\";i:124;s:20:\"embed/editor-rtl.css\";i:125;s:24:\"embed/editor-rtl.min.css\";i:126;s:16:\"embed/editor.css\";i:127;s:20:\"embed/editor.min.css\";i:128;s:19:\"embed/style-rtl.css\";i:129;s:23:\"embed/style-rtl.min.css\";i:130;s:15:\"embed/style.css\";i:131;s:19:\"embed/style.min.css\";i:132;s:19:\"embed/theme-rtl.css\";i:133;s:23:\"embed/theme-rtl.min.css\";i:134;s:15:\"embed/theme.css\";i:135;s:19:\"embed/theme.min.css\";i:136;s:19:\"file/editor-rtl.css\";i:137;s:23:\"file/editor-rtl.min.css\";i:138;s:15:\"file/editor.css\";i:139;s:19:\"file/editor.min.css\";i:140;s:18:\"file/style-rtl.css\";i:141;s:22:\"file/style-rtl.min.css\";i:142;s:14:\"file/style.css\";i:143;s:18:\"file/style.min.css\";i:144;s:23:\"footnotes/style-rtl.css\";i:145;s:27:\"footnotes/style-rtl.min.css\";i:146;s:19:\"footnotes/style.css\";i:147;s:23:\"footnotes/style.min.css\";i:148;s:23:\"freeform/editor-rtl.css\";i:149;s:27:\"freeform/editor-rtl.min.css\";i:150;s:19:\"freeform/editor.css\";i:151;s:23:\"freeform/editor.min.css\";i:152;s:22:\"gallery/editor-rtl.css\";i:153;s:26:\"gallery/editor-rtl.min.css\";i:154;s:18:\"gallery/editor.css\";i:155;s:22:\"gallery/editor.min.css\";i:156;s:21:\"gallery/style-rtl.css\";i:157;s:25:\"gallery/style-rtl.min.css\";i:158;s:17:\"gallery/style.css\";i:159;s:21:\"gallery/style.min.css\";i:160;s:21:\"gallery/theme-rtl.css\";i:161;s:25:\"gallery/theme-rtl.min.css\";i:162;s:17:\"gallery/theme.css\";i:163;s:21:\"gallery/theme.min.css\";i:164;s:20:\"group/editor-rtl.css\";i:165;s:24:\"group/editor-rtl.min.css\";i:166;s:16:\"group/editor.css\";i:167;s:20:\"group/editor.min.css\";i:168;s:19:\"group/style-rtl.css\";i:169;s:23:\"group/style-rtl.min.css\";i:170;s:15:\"group/style.css\";i:171;s:19:\"group/style.min.css\";i:172;s:19:\"group/theme-rtl.css\";i:173;s:23:\"group/theme-rtl.min.css\";i:174;s:15:\"group/theme.css\";i:175;s:19:\"group/theme.min.css\";i:176;s:21:\"heading/style-rtl.css\";i:177;s:25:\"heading/style-rtl.min.css\";i:178;s:17:\"heading/style.css\";i:179;s:21:\"heading/style.min.css\";i:180;s:19:\"html/editor-rtl.css\";i:181;s:23:\"html/editor-rtl.min.css\";i:182;s:15:\"html/editor.css\";i:183;s:19:\"html/editor.min.css\";i:184;s:20:\"image/editor-rtl.css\";i:185;s:24:\"image/editor-rtl.min.css\";i:186;s:16:\"image/editor.css\";i:187;s:20:\"image/editor.min.css\";i:188;s:19:\"image/style-rtl.css\";i:189;s:23:\"image/style-rtl.min.css\";i:190;s:15:\"image/style.css\";i:191;s:19:\"image/style.min.css\";i:192;s:19:\"image/theme-rtl.css\";i:193;s:23:\"image/theme-rtl.min.css\";i:194;s:15:\"image/theme.css\";i:195;s:19:\"image/theme.min.css\";i:196;s:29:\"latest-comments/style-rtl.css\";i:197;s:33:\"latest-comments/style-rtl.min.css\";i:198;s:25:\"latest-comments/style.css\";i:199;s:29:\"latest-comments/style.min.css\";i:200;s:27:\"latest-posts/editor-rtl.css\";i:201;s:31:\"latest-posts/editor-rtl.min.css\";i:202;s:23:\"latest-posts/editor.css\";i:203;s:27:\"latest-posts/editor.min.css\";i:204;s:26:\"latest-posts/style-rtl.css\";i:205;s:30:\"latest-posts/style-rtl.min.css\";i:206;s:22:\"latest-posts/style.css\";i:207;s:26:\"latest-posts/style.min.css\";i:208;s:18:\"list/style-rtl.css\";i:209;s:22:\"list/style-rtl.min.css\";i:210;s:14:\"list/style.css\";i:211;s:18:\"list/style.min.css\";i:212;s:25:\"media-text/editor-rtl.css\";i:213;s:29:\"media-text/editor-rtl.min.css\";i:214;s:21:\"media-text/editor.css\";i:215;s:25:\"media-text/editor.min.css\";i:216;s:24:\"media-text/style-rtl.css\";i:217;s:28:\"media-text/style-rtl.min.css\";i:218;s:20:\"media-text/style.css\";i:219;s:24:\"media-text/style.min.css\";i:220;s:19:\"more/editor-rtl.css\";i:221;s:23:\"more/editor-rtl.min.css\";i:222;s:15:\"more/editor.css\";i:223;s:19:\"more/editor.min.css\";i:224;s:30:\"navigation-link/editor-rtl.css\";i:225;s:34:\"navigation-link/editor-rtl.min.css\";i:226;s:26:\"navigation-link/editor.css\";i:227;s:30:\"navigation-link/editor.min.css\";i:228;s:29:\"navigation-link/style-rtl.css\";i:229;s:33:\"navigation-link/style-rtl.min.css\";i:230;s:25:\"navigation-link/style.css\";i:231;s:29:\"navigation-link/style.min.css\";i:232;s:33:\"navigation-submenu/editor-rtl.css\";i:233;s:37:\"navigation-submenu/editor-rtl.min.css\";i:234;s:29:\"navigation-submenu/editor.css\";i:235;s:33:\"navigation-submenu/editor.min.css\";i:236;s:25:\"navigation/editor-rtl.css\";i:237;s:29:\"navigation/editor-rtl.min.css\";i:238;s:21:\"navigation/editor.css\";i:239;s:25:\"navigation/editor.min.css\";i:240;s:24:\"navigation/style-rtl.css\";i:241;s:28:\"navigation/style-rtl.min.css\";i:242;s:20:\"navigation/style.css\";i:243;s:24:\"navigation/style.min.css\";i:244;s:23:\"nextpage/editor-rtl.css\";i:245;s:27:\"nextpage/editor-rtl.min.css\";i:246;s:19:\"nextpage/editor.css\";i:247;s:23:\"nextpage/editor.min.css\";i:248;s:24:\"page-list/editor-rtl.css\";i:249;s:28:\"page-list/editor-rtl.min.css\";i:250;s:20:\"page-list/editor.css\";i:251;s:24:\"page-list/editor.min.css\";i:252;s:23:\"page-list/style-rtl.css\";i:253;s:27:\"page-list/style-rtl.min.css\";i:254;s:19:\"page-list/style.css\";i:255;s:23:\"page-list/style.min.css\";i:256;s:24:\"paragraph/editor-rtl.css\";i:257;s:28:\"paragraph/editor-rtl.min.css\";i:258;s:20:\"paragraph/editor.css\";i:259;s:24:\"paragraph/editor.min.css\";i:260;s:23:\"paragraph/style-rtl.css\";i:261;s:27:\"paragraph/style-rtl.min.css\";i:262;s:19:\"paragraph/style.css\";i:263;s:23:\"paragraph/style.min.css\";i:264;s:25:\"post-author/style-rtl.css\";i:265;s:29:\"post-author/style-rtl.min.css\";i:266;s:21:\"post-author/style.css\";i:267;s:25:\"post-author/style.min.css\";i:268;s:33:\"post-comments-form/editor-rtl.css\";i:269;s:37:\"post-comments-form/editor-rtl.min.css\";i:270;s:29:\"post-comments-form/editor.css\";i:271;s:33:\"post-comments-form/editor.min.css\";i:272;s:32:\"post-comments-form/style-rtl.css\";i:273;s:36:\"post-comments-form/style-rtl.min.css\";i:274;s:28:\"post-comments-form/style.css\";i:275;s:32:\"post-comments-form/style.min.css\";i:276;s:27:\"post-content/editor-rtl.css\";i:277;s:31:\"post-content/editor-rtl.min.css\";i:278;s:23:\"post-content/editor.css\";i:279;s:27:\"post-content/editor.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"quote/style-rtl.css\";i:357;s:23:\"quote/style-rtl.min.css\";i:358;s:15:\"quote/style.css\";i:359;s:19:\"quote/style.min.css\";i:360;s:19:\"quote/theme-rtl.css\";i:361;s:23:\"quote/theme-rtl.min.css\";i:362;s:15:\"quote/theme.css\";i:363;s:19:\"quote/theme.min.css\";i:364;s:23:\"read-more/style-rtl.css\";i:365;s:27:\"read-more/style-rtl.min.css\";i:366;s:19:\"read-more/style.css\";i:367;s:23:\"read-more/style.min.css\";i:368;s:18:\"rss/editor-rtl.css\";i:369;s:22:\"rss/editor-rtl.min.css\";i:370;s:14:\"rss/editor.css\";i:371;s:18:\"rss/editor.min.css\";i:372;s:17:\"rss/style-rtl.css\";i:373;s:21:\"rss/style-rtl.min.css\";i:374;s:13:\"rss/style.css\";i:375;s:17:\"rss/style.min.css\";i:376;s:21:\"search/editor-rtl.css\";i:377;s:25:\"search/editor-rtl.min.css\";i:378;s:17:\"search/editor.css\";i:379;s:21:\"search/editor.min.css\";i:380;s:20:\"search/style-rtl.css\";i:381;s:24:\"search/style-rtl.min.css\";i:382;s:16:\"search/style.css\";i:383;s:20:\"search/style.min.css\";i:384;s:20:\"search/theme-rtl.css\";i:385;s:24:\"search/theme-rtl.min.css\";i:386;s:16:\"search/theme.css\";i:387;s:20:\"search/theme.min.css\";i:388;s:24:\"separator/editor-rtl.css\";i:389;s:28:\"separator/editor-rtl.min.css\";i:390;s:20:\"separator/editor.css\";i:391;s:24:\"separator/editor.min.css\";i:392;s:23:\"separator/style-rtl.css\";i:393;s:27:\"separator/style-rtl.min.css\";i:394;s:19:\"separator/style.css\";i:395;s:23:\"separator/style.min.css\";i:396;s:23:\"separator/theme-rtl.css\";i:397;s:27:\"separator/theme-rtl.min.css\";i:398;s:19:\"separator/theme.css\";i:399;s:23:\"separator/theme.min.css\";i:400;s:24:\"shortcode/editor-rtl.css\";i:401;s:28:\"shortcode/editor-rtl.min.css\";i:402;s:20:\"shortcode/editor.css\";i:403;s:24:\"shortcode/editor.min.css\";i:404;s:24:\"site-logo/editor-rtl.css\";i:405;s:28:\"site-logo/editor-rtl.min.css\";i:406;s:20:\"site-logo/editor.css\";i:407;s:24:\"site-logo/editor.min.css\";i:408;s:23:\"site-logo/style-rtl.css\";i:409;s:27:\"site-logo/style-rtl.min.css\";i:410;s:19:\"site-logo/style.css\";i:411;s:23:\"site-logo/style.min.css\";i:412;s:27:\"site-tagline/editor-rtl.css\";i:413;s:31:\"site-tagline/editor-rtl.min.css\";i:414;s:23:\"site-tagline/editor.css\";i:415;s:27:\"site-tagline/editor.min.css\";i:416;s:25:\"site-title/editor-rtl.css\";i:417;s:29:\"site-title/editor-rtl.min.css\";i:418;s:21:\"site-title/editor.css\";i:419;s:25:\"site-title/editor.min.css\";i:420;s:24:\"site-title/style-rtl.css\";i:421;s:28:\"site-title/style-rtl.min.css\";i:422;s:20:\"site-title/style.css\";i:423;s:24:\"site-title/style.min.css\";i:424;s:26:\"social-link/editor-rtl.css\";i:425;s:30:\"social-link/editor-rtl.min.css\";i:426;s:22:\"social-link/editor.css\";i:427;s:26:\"social-link/editor.min.css\";i:428;s:27:\"social-links/editor-rtl.css\";i:429;s:31:\"social-links/editor-rtl.min.css\";i:430;s:23:\"social-links/editor.css\";i:431;s:27:\"social-links/editor.min.css\";i:432;s:26:\"social-links/style-rtl.css\";i:433;s:30:\"social-links/style-rtl.min.css\";i:434;s:22:\"social-links/style.css\";i:435;s:26:\"social-links/style.min.css\";i:436;s:21:\"spacer/editor-rtl.css\";i:437;s:25:\"spacer/editor-rtl.min.css\";i:438;s:17:\"spacer/editor.css\";i:439;s:21:\"spacer/editor.min.css\";i:440;s:20:\"spacer/style-rtl.css\";i:441;s:24:\"spacer/style-rtl.min.css\";i:442;s:16:\"spacer/style.css\";i:443;s:20:\"spacer/style.min.css\";i:444;s:20:\"table/editor-rtl.css\";i:445;s:24:\"table/editor-rtl.min.css\";i:446;s:16:\"table/editor.css\";i:447;s:20:\"table/editor.min.css\";i:448;s:19:\"table/style-rtl.css\";i:449;s:23:\"table/style-rtl.min.css\";i:450;s:15:\"table/style.css\";i:451;s:19:\"table/style.min.css\";i:452;s:19:\"table/theme-rtl.css\";i:453;s:23:\"table/theme-rtl.min.css\";i:454;s:15:\"table/theme.css\";i:455;s:19:\"table/theme.min.css\";i:456;s:23:\"tag-cloud/style-rtl.css\";i:457;s:27:\"tag-cloud/style-rtl.min.css\";i:458;s:19:\"tag-cloud/style.css\";i:459;s:23:\"tag-cloud/style.min.css\";i:460;s:28:\"template-part/editor-rtl.css\";i:461;s:32:\"template-part/editor-rtl.min.css\";i:462;s:24:\"template-part/editor.css\";i:463;s:28:\"template-part/editor.min.css\";i:464;s:27:\"template-part/theme-rtl.css\";i:465;s:31:\"template-part/theme-rtl.min.css\";i:466;s:23:\"template-part/theme.css\";i:467;s:27:\"template-part/theme.min.css\";i:468;s:30:\"term-description/style-rtl.css\";i:469;s:34:\"term-description/style-rtl.min.css\";i:470;s:26:\"term-description/style.css\";i:471;s:30:\"term-description/style.min.css\";i:472;s:27:\"text-columns/editor-rtl.css\";i:473;s:31:\"text-columns/editor-rtl.min.css\";i:474;s:23:\"text-columns/editor.css\";i:475;s:27:\"text-columns/editor.min.css\";i:476;s:26:\"text-columns/style-rtl.css\";i:477;s:30:\"text-columns/style-rtl.min.css\";i:478;s:22:\"text-columns/style.css\";i:479;s:26:\"text-columns/style.min.css\";i:480;s:19:\"verse/style-rtl.css\";i:481;s:23:\"verse/style-rtl.min.css\";i:482;s:15:\"verse/style.css\";i:483;s:19:\"verse/style.min.css\";i:484;s:20:\"video/editor-rtl.css\";i:485;s:24:\"video/editor-rtl.min.css\";i:486;s:16:\"video/editor.css\";i:487;s:20:\"video/editor.min.css\";i:488;s:19:\"video/style-rtl.css\";i:489;s:23:\"video/style-rtl.min.css\";i:490;s:15:\"video/style.css\";i:491;s:19:\"video/style.min.css\";i:492;s:19:\"video/theme-rtl.css\";i:493;s:23:\"video/theme-rtl.min.css\";i:494;s:15:\"video/theme.css\";i:495;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentyfour", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1724195582;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:9:{i:0;s:22:\"custom_search_widget-1\";i:1;s:29:\"custom_popular_posts_widget-1\";i:2;s:34:\"custom_sidebar_categories_widget-1\";i:3;s:32:\"woocommerce_product_categories-1\";i:4;s:24:\"never_miss_news_widget-1\";i:5;s:21:\"popular_tags_widget-1\";i:6;s:6:\"text-1\";i:7;s:26:\"woocommerce_price_filter-1\";i:8;s:38:\"woocommerce_recently_viewed_products-1\";}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("127", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("155", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("175", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":2,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("213", "current_theme", "فودکینگ", "auto");
INSERT INTO `wp_options` VALUES("214", "theme_mods_foodking", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:12:\"primary-menu\";i:48;s:12:\"footer-menu1\";i:46;s:12:\"footer-menu2\";i:47;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1724451623;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:22:\"custom_search_widget-1\";i:1;s:29:\"custom_popular_posts_widget-1\";i:2;s:34:\"custom_sidebar_categories_widget-1\";i:3;s:32:\"woocommerce_product_categories-1\";i:4;s:24:\"never_miss_news_widget-1\";i:5;s:21:\"popular_tags_widget-1\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:4:\"shop\";a:3:{i:0;s:6:\"text-1\";i:1;s:26:\"woocommerce_price_filter-1\";i:2;s:38:\"woocommerce_recently_viewed_products-1\";}}}}", "on");
INSERT INTO `wp_options` VALUES("215", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("218", "_site_transient_wp_plugin_dependencies_plugin_data", "a:1:{s:11:\"woocommerce\";a:35:{s:4:\"name\";s:14:\"ووکامرس\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:6:\"10.0.3\";s:6:\"author\";s:67:\"<a href=\"https://profiles.wordpress.org/automattic/\">Automattic</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:12:\"contributors\";a:50:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73edc627541112a447e978843cf72f516bdbf6350e7cbac10016c71ab1b8c8a1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:11:\"woocommerce\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/woocommerce/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7781a3c13bcc86b57064b9539ec22da52fd5ef1902fbc020d0a4a8595b14ea0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"WooCommerce\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mikejolley/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8295774fc174b6a5b9bd960709949f4de88cd0b8708d711dc5b6676693d41432?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Mike Jolley\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jameskoster/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/94b5473c03a46cb204f0a868dfe65f8199ef483242814ec1bcaf6770ba90d203?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/claudiosanches/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ac91c7d73bb4501567ab3790755bf001d53dac8d1f4311a2480a5fb62dfb180c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rodrigosprimo/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1dc85457417601db220b14e7fa96c842700fbd1cceecd21d65306c26fffb92cc?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/peterfabian1000/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c25372df076206b9fe44dddd7ec6af6ba427d3fe2a457fa301fcb9cf90b23ddd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/vedjain/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/eb19da24784b2f86d310a213b60c903b0a5464a6c725cf5fcabfd274383337c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Vedanshu - a11n\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/jamosova/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73f150b0172cbb319293e372b3b20f4b78f0d5fbe70558318f69aad70908e95a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/obliviousharmony/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/67851e0deeb2c6a7a4c238cf45c0e9694a919e2c5e02706c5852e67c4ad279c9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/konamiman/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ee97f225bf5be24cd3c3b04990b9fc3dfc67a2c9aaea418ec2bdd32e164ed9b1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:23:\"Néstor Soriano Vilchez\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/sadowski/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/cee318a6ec06e747df7f70f274da4e0cf4adba60c59e12d660d0f5a6ba78658a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpmuguru/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23afb25faac780cb6ec9533b2ac9e5daedf7a1faf444b41db471b9529701f87e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/royho/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1beda14f19fa93030ba2c66359dc270286820af6c667cdfeb4e87833c747f3a0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/barryhughes-1/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6ce0f4afb77f8d32da9c43e9a39c84fcfb3ed0e9cac24f440c46a151946cdec8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}s:12:\"claudiulodro\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/claudiulodro/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/34a74527d3859bd9fb0b477cd80c9f78b3610259a251c32a31023ead285ac124?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Claudiu Lodromanean\";}s:12:\"tiagonoronha\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tiagonoronha/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0352cd451932c8a2ab15b8457933e6d90cc919bbf23db63e3bc35ee41d56577e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Tiago Noronha\";}s:6:\"ryelle\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/ryelle/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6d860975d8bd4b166268bba8da8c1ea0e861a7d7f4ef0aee52fa727fc69e12b2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Kelly Choyce-Dwan\";}s:10:\"levinmedia\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/levinmedia/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/657d301b3683f02c75e4b2363681518e94485770056cc51526f19818884ba6aa?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"levinmedia\";}s:7:\"aljullu\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/aljullu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/784f29a6d06799d1d40adc32b115da932cd1ee2b22d91cd8597e9fe6e4ee1420?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:21:\"Albert Juhé Lluveras\";}s:6:\"nerrad\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/nerrad/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1bd692736861bd20949789e4a3d922736480efcacb0e44041616c5a79eaa54c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:22:\"Darren Ethier (nerrad)\";}s:10:\"joshuawold\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/joshuawold/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f98224d78e12fcc0e9686dbf15f8c37b1967835212f25a92fceb6caafdc5b08d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Joshua Wold\";}s:13:\"assassinateur\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/assassinateur/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/00ec8d736cf51890768bcfd3614fc7eea91eec753262bc37cea7c8e988d4d3a3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Nadir Seghir\";}s:7:\"haszari\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/haszari/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/5478c55437f47714a4dae1016cf521e803dfc4633ce5781b2f24d749d1623f69?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Rua Haszard\";}s:10:\"mppfeiffer\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mppfeiffer/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0fe64f1ef1e4abe1825653bcb17113a4a14c755f5b6f77d2f27494fe349d7081?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Michael P. Pfeiffer\";}s:10:\"nielslange\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/nielslange/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0894ec0d7e5d70306a16431b36249b1928cad88a572de9b5211a54d75ad5d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Niels Lange\";}s:9:\"ralucastn\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/ralucastn/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e65d79886499f47ee368495f5016117deef427d5abca9d3ed76c4bfaa42e7c0a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Raluca\";}s:11:\"tjcafferkey\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/tjcafferkey/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23d134901eef453e721759c9d84810f5748a84fc8681ed230c7d78e53583c77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"tjcafferkey\";}s:13:\"danielwrobert\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/danielwrobert/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f1f823ffbe2a6adb7f94c6998079fd6ae6636d3b6272dd8c54385783360e2cf8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"danielwrobert\";}s:19:\"patriciahillebrandt\";a:3:{s:7:\"profile\";s:51:\"https://profiles.wordpress.org/patriciahillebrandt/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/13f5707fad9a68e5cf9c3c0ebb9c7179c862dcb279c761d20c9b40bd2fff9f4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"patriciahillebrandt\";}s:7:\"albarin\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/albarin/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0dd150b60949026a3c34f49d40089e3a8cf97dc331e2f5b27e805ffd34648e22?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"albarin\";}s:10:\"dinhtungdu\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/dinhtungdu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/07e79c32b1abba868f8c5e3ee0c85b9150c74e2c2a946088a268e6be486d9114?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Tung Du\";}s:10:\"imanish003\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/imanish003/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/59ff646ede2dd6475f24762ac21ee2afd7d72fdcade7b9d2915cf1c3c2d984a2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Manish Menaria\";}s:12:\"karolmanijak\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/karolmanijak/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/42305d7047ca11d494b1912d687266a50edd05954fdec22e61ab1fe63cf2df6b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Karol Manijak\";}s:13:\"sunyatasattva\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/sunyatasattva/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73ce316f9775441698b601e6902728a80837f7fd6df0846e3c5a82448dce447c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"sunyatasattva (a11n)\";}s:13:\"alexandrelara\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/alexandrelara/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1c0c71a072f798066e4661395461e73e0fb6692eaddcced2a0e457ef01a458e8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Alexandre Lara\";}s:7:\"gigitux\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/gigitux/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2dcd003f15403180364c56b093b48e6edca9a88c8f1470b965b87fc230c66d7f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Luigi Teschio\";}s:12:\"danieldudzic\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/danieldudzic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b689767c4b308b8f5910cef3a2f44c2acdadcb3b63326b0d5c865d2c208c668e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"danieldudzic\";}s:11:\"samueljseay\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/samueljseay/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/4c4a5e8fd5b99749ed9ac735c31d0370254356e40feea46bcf51b2b607f8ab0e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Sam\";}s:12:\"alexflorisca\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/alexflorisca/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b68615471f527e6224909ce0726dda68b074e6cbcf89e0d4b5ecc483a96557ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Alex Florisca\";}s:5:\"opr18\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/opr18/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e083a0759b8ea01b11c1f154a3087ddfaf65a93011cf97a85fdbfc0cda709538?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"opr18\";}s:12:\"tarunvijwani\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tarunvijwani/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/fa4a4b2688afb8d238bb035f31fda4d07dabd67ccf41576276e5eb084463d617?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"tarunvijwani\";}s:12:\"pauloarromba\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/pauloarromba/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ab6034aa12c0e53f21978df9e470f161f06810d814082cbe3ab74450f0618818?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Paulo Arromba\";}s:9:\"saadtarhi\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/saadtarhi/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f4fd0df69b8c7bf3a3e6526df3b42c3854de544904ef825bfd549afc9829f645?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Saad T.\";}s:4:\"bor0\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/bor0/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/787d8ea71701ced680cd80411d656c20e0e600be5d34f6ce3478143d43dc9fd9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Boro Sitnikovski\";}s:5:\"kloon\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/kloon/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7c708f5b0957714ab48e00220b0f74acccb43b70fa0d4b5ee091d59951ae751?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Gerhard Potgieter\";}s:12:\"coreymckrill\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/coreymckrill/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/9cc64cf0f650f165ac55f1294105259f82f2b72c4c24903a79af6d6cd1ad2a9a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Corey McKrill\";}s:12:\"jorgeatorres\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/jorgeatorres/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/33d6a063c7411775135383c5bae6cd4e45d094b72ec062c96ceafca5e2a4956f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Jorge A. Torres\";}s:10:\"leifsinger\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/leifsinger/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8107603a6bbc5ff73e07e2450f260335af41a5adb2cccd80cba20cdd28b96651?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Leif Singer\";}s:9:\"neosinner\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/neosinner/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/68b52d53a3c6dd39841f697853a1965057c6f3aeb9e89f7d960d1921ffa90d29?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Ján Mikláš\";}}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3762;i:4;i:184;i:3;i:101;i:2;i:109;i:1;i:403;}s:11:\"num_ratings\";i:4559;s:11:\"support_url\";s:49:\"https://wordpress.org/support/plugin/woocommerce/\";s:15:\"support_threads\";i:713;s:24:\"support_threads_resolved\";i:586;s:15:\"active_installs\";i:7000000;s:12:\"last_updated\";s:21:\"2025-07-21 1:18pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:16741:\"<p><a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">ووکامرس</a> پلتفرم تجارت الکترونیک منبع باز برای وردپرس است.</p>\n<p>بستر اصلی ما رایگان، انعطاف پذیر و تقویت شده توسط یک جامعه جهانی است. آزادی منبع آزاد به این معنی است که مالکیت کامل محتوا و داده‌های فروشگاه خود را برای همیشه حفظ کنید.</p>\n<p>خواه در حال راه اندازی تجارت باشید، خرده فروشی یا در حال توسعه سایت هایی برای مشتری، از ووکامرس برای فروشگاهی استفاده کنید که محتوا و تجارت را به شدت با یکدیگر مخلوط می کند.</p>\n<ul>\n<li><strong>ویترین‌های زیبا و جذاب برای فروشگاه‌ها بسازید</strong> با <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">پوسته ها</a> متناسب با برند و صنعت شما</li>\n<li><strong>افزایش درآمد</strong> با بهینه سازی شده <a href=\"https://woocommerce.com/checkout-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">تجربه سبد خرید</a> که تبدیل می‌کند.</li>\n<li><strong>سفارشی سازی صفحات محصول در عرض چند دقیقه</strong> با استفاده از ماژولار <a href=\"https://woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">بلوک‌های محصول</a>.</li>\n<li>کالاهای فیزیکی و دیجیتالی، تغییرات محصول، تنظیمات سفارشی، دانلودهای فوری و موارد وابسته را به نمایش بگذارید.</li>\n<li>با افزونه‌های تأیید شده توسط توسعه‌دهندگان ما، می‌توانید <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">اشتراک‌ها</a>، <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">رزروها</a> یا <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">عضویت‌ها</a> را بفروشید.</li>\n<li>با استفاده از اهرم <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">مزیت بهینه‌سازی موتور جستجو در وردپرس</a> <strong>به صدر نتایج جستجو در موتورهای جستجو بروید.</strong></li>\n<li><strong>روی پلت فرمی بسازید که مقیاس‌پذیر باشد.</strong> تجارت الکترونیک انعطاف پذیر برای <a href=\"https://woocommerce.com/high-volume-stores/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">فروشگاه های با حجم بالا</a>.</li>\n</ul>\n<h4>تمام ابزارهایی که برای فروش نیاز دارید</h4>\n<p>ابزارهای داخلی و یکپارچه‌سازی‌های محبوب به شما کمک می‌کنند تا عملیات تجاری خود را به طور کارآمد مدیریت کنید. بسیاری از خدمات را می‌توان با یک کلیک از طریق <a href=\"https://woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">راه‌اندازی</a> به صورت رایگان اضافه کرد.</p>\n<ul>\n<li><strong>نحوه پرداخت خود را انتخاب کنید</strong>. به راحتی از فروشگاه خود با &#8230; پرداخت‌ها را مدیریت کنید <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooPayments</a> (موجود در ایالات متحده، انگلستان، ایرلند، استرالیا، نیوزیلند، کانادا، اسپانیا، فرانسه، آلمان و ایتالیا). به لطف &#8230;، کارت‌های اعتباری، کیف پول‌های موبایلی، حواله‌های بانکی و پول نقد را با خیال راحت بپذیرید. <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">بیش از ۱۰۰ درگاه پرداخت</a> – از جمله <a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">پی‌پال</a>, و <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مربع</a>.</li>\n<li><strong>گزینه‌های حمل و نقل خود را پیکربندی کنید</strong>. برچسب‌های USPS را مستقیماً از داشبورد خود چاپ کنید و حتی با آنها زمان تحویل گرفتن را تعیین کنید <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">حمل و نقل ووکامرس</a> (U.S.-only). Connect with <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">حامل‌های شناخته شده</a> مانند UPS و FedEx &#8211; به علاوه طیف گسترده‌ای از راه‌حل‌های تحویل، موجودی و تکمیل سفارش برای منطقه شما.</li>\n<li><strong>ساده‌سازی مالیات فروش</strong>. افزودن <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مالیات ووکامرس</a> or <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">خدمات یکپارچه مشابه</a> to محاسبات خودکار را به واقعیت تبدیل کنید.</li>\n</ul>\n<h4>کسب و کار خود را رشد دهید، ویژگی‌ها را اضافه کنید و در عین حال بر فروشگاه خود نظارت کنید</h4>\n<p>ووکامرس یعنی تجارت. با یک داشبورد مرکزی قدرتمند و انعطاف‌پذیر که در ووکامرس تعبیه شده است، بر معیارهای عملکردی که برای شما مهم‌تر هستند، نظارت داشته باشید.</p>\n<p>با استفاده از <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">گوگل ادز</a>، <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">هاب‌اسپات</a>، <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">میل‌چیمپ</a>، و <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">ادغام با فیسبوک</a>. شما همیشه می‌توانید برای ایده‌ها و نکات تازه برای کمک به موفقیت خود، به <a href=\"https://woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مرکز بازاریابی</a> در داشبورد مراجعه کنید.</p>\n<p>با صدها افزونه رایگان و پولی از <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">بازار رسمی ووکامرس</a>، عملکرد فروشگاه را بهبود بخشید. توسعه‌دهندگان ما <a href=\"https://woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">هر افزونه جدید را بررسی می‌کنند</a> و مرتباً افزونه‌های موجود را بررسی می‌کنند تا استانداردهای کیفیت بازار را حفظ کنند. ما به طور فعال <a href=\"https://woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">به دنبال محصولاتی هستیم که به فروشگاه‌سازان در ایجاد فروشگاه‌های موفق کمک کنند</a>.</p>\n<p>فروشگاه خود را از هر مکانی با ووکامرس رایگان مدیریت کنید <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">اپلیکیشن موبایل</a> (اندروید و iOS). هشدار لو رفتن داستان: هر بار که تخفیف جدیدی می‌گذارید، صدای اعلان «چا-چینگ» که کمی اعتیادآور است را بشنوید!</p>\n<h4>داده‌های فروشگاه خود را مالکیت و کنترل کنید &#8211; برای همیشه</h4>\n<p>با <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">ووکامرس</a>، داده‌های شما متعلق به شماست. همیشه.</p>\n<p>اگر تصمیم دارید <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">داده‌های استفاده</a> را با ما به اشتراک بگذارید، می‌توانید با خیال راحت بدانید که این اطلاعات ناشناس و ایمن نگه داشته می‌شوند. در هر زمان می‌توانید بدون اینکه فروشگاه شما تحت تأثیر قرار گیرد، از این گزینه انصراف دهید.</p>\n<p>Unlike hosted ecommerce solutions, WooCommerce store data is future-proof; you’re free to export all your content and take your site to any platform you choose. No restrictions.</p>\n<h4>چرا توسعه‌دهندگان ووکامرس را انتخاب میکنند و آن را دوست دارند</h4>\n<p>توسعه‌دهندگان می‌توانند از <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">ووکامرس</a> برای ایجاد، سفارشی‌سازی و مقیاس‌بندی فروشگاهی برای مطابقت با مشخصات دقیق مشتری، ایجاد پیشرفت‌ها از طریق برنامه‌های افزودنی یا راه‌حل‌های سفارشی استفاده کنند.</p>\n<ul>\n<li>اهرمی <a href=\"https://woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">قلاب‌ها و فیلترها</a> برای تغییر یا ایجاد قابلیت.</li>\n<li>تقریباً هر سرویسی را با استفاده از یک سیستم قوی ادغام کنید <a href=\"https://developer.woocommerce.com/docs/getting-started-with-the-woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">REST API</a> و وب هوک‌ها.</li>\n<li>با React بلوک‌های محتوای سفارشی را طراحی کنید و بسازید.</li>\n<li><a href=\"https://developer.woocommerce.com/docs/category/extension-development/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">بازرسی و اصلاح کنید</a> هر جنبه ای از کد افزونه اصلی.</li>\n<li>سرعت توسعه را با رعد و برق سریع افزایش دهید <a href=\"https://developer.woocommerce.com/docs/category/wc-cli/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a>.</li>\n</ul>\n<p>بستر اصلی به طور دقیق و غالباً مورد آزمایش قرار می گیرد و توسط یک تیم توسعه‌دهنده اختصاصی که در مناطق مختلف کار می کنند پشتیبانی می شود. اسناد جامع با هر نسخه به‌روز میشوند و به شما امکان می دهند دقیقاً فروشگاه مورد نیاز خود را بسازید.</p>\n<h4>جزئی از جامعه بین‌المللی در حال رشد ما باشید</h4>\n<p>ووکامرس دارای یک انجمن بزرگ و پرشور است که به تجار کمک می کند تا موفق شوند – و به سرعت در حال رشد است.</p>\n<p><a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">اجلاس‌های ووکامرس</a> در مکان‌هایی در سراسر جهان وجود دارد که می‌توانید به صورت رایگان در آنها شرکت کنید و حتی در آن شرکت کنید. این رویدادها راهی عالی برای یادگیری از دیگران، به اشتراک گذاشتن تخصص خود و ارتباط با افراد همفکر هستند.</p>\n<p>ووکامرس همچنین به طور منظم در وردکمپ‌ها در سراسر جهان حضور دارد &#8211; ما دوست داریم شما را ملاقات کنیم.</p>\n<h4>مشارکت و ترجمه</h4>\n<p>ووکامرس توسط اتوماتیک، سازندگان WordPress.com و جت پک ایجاد شده و پشتیبانی می شود. ما همچنین صدها مشارکت کننده مستقل داریم و همیشه جای بیشتری وجود دارد. به <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مخزن گیتهاب ووکامرس</a> بروید تا بفهمید چگونه می توانید در سایت خود قرار دهید .</p>\n<p>ووکامرس به چندین زبان از جمله دانمارکی، اوکراینی و فارسی ترجمه شده است. با افزودن زبان، به بومی‌سازی ووکامرس کمک کنید &#8211; به  <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">ترجمه wordpress.org</a>  مراجعه کنید.</p>\n<h4>اتصال به WooCommerce.com</h4>\n<p>می‌توانید فروشگاه خود را به <a href=\"https://woocommerce.com/\" rel=\"nofollow ugc\">WooCommerce.com</a> متصل کنید تا اشتراک‌های خود را در WooCommerce Marketplace مدیریت کنید و به‌روزرسانی‌های محصول را بدون ترک مدیر وردپرس دریافت کنید. اتصال همچنین نصب محصولات خریداری شده را مستقیما از WooCommerce.com امکان پذیر می‌کند و دسترسی به پشتیبانی فنی را ساده می‌کند. اگر می‌خواهید اطلاعاتی درباره داده‌هایی که جمع‌آوری می‌شوند و نحوه استفاده از آن‌ها را بدانید، لطفا به <a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">خط‌مشی رازداری</a> ما مراجعه کنید.</p>\n\";s:12:\"installation\";s:3491:\"<h4>حداقل نیازمندی ها</h4>\n<ul>\n<li>نیازمند PHP 7.4 یا بالاتر است (PHP 8.0 یا بالاتر پیشنهاد می‌شود)</li>\n<li>نیازمند MySQL 5.6 یا بالاتر، یا MariaDB نسخۀ 10.1یا بالاتر است</li>\n</ul>\n<p>برای مشاهده لیست کاملی از نیازمندی‌های سرور، به <a href=\"https://woocommerce.com/document/server-requirements/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">مستندات نیازمندی‌های سرور ووکامرس</a> مراجعه کنید.</p>\n<h4>نصب خودکار</h4>\n<p>نصب خودکار ساده ترین گزینه است &#8212; وردپرس انتقال فایل را انجام می دهد و شما نیازی به ترک مرورگر وب خود ندارید. برای نصب خودکار ووکامرس، وارد پیشخوان وردپرس خود شوید، به فهرست افزونه‌ها بروید و روی «افزودن جدید» کلیک کنید.</p>\n<p>در قسمت جستجو، «WooCommerce» را تایپ کنید، سپس «جستجوی افزونه‌ها» را کلیک کنید. وقتی ما را پیدا کردید، می توانید جزئیات مربوط به آن مانند انتشار نقطه، رتبه‌بندی و توضیحات را مشاهده کنید. البته از همه مهمتر، میتوانید آن را نصب کنید! روی «اکنون نصب شود» کلیک کنید و وردپرس آن را نصب میکند.</p>\n<h4>نصب دستی</h4>\n<p>روش نصب دستی مستلزم دانلود افزونه ووکامرس و آپلود آن در وب سرور خود از طریق برنامه FTP مورد علاقه خود است. کدکس وردپرس حاوی <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\" rel=\"ugc\">دستورالعمل‌هایی درباره نحوه انجام این کار در اینجا</a> است.</p>\n<h4>به روز کردن</h4>\n<p>به‌روزرسانی‌های خودکار باید بدون مشکل کار کنند، اما ما همچنان توصیه می کنیم از سایت خود پشتیبان تهیه کنید.</p>\n<p>اگر پس از به‌روزرسانی در صفحات فروشگاه /دسته با مشکلی روبرو شدید، با رفتن به پنل مدیریت &gt; تنظیمات &gt;  پیوند های یکتا، سپس ذخیره را بفشرید. و پس از آن تمام لینک های سایت به درستی نمایش داده می شوند.</p>\n<h4>داده نمونه</h4>\n<p>ووکامرس با برخی داده‌های نمونه ارائه می‌شود که می‌توانید از آنها برای مشاهده ظاهر محصولات استفاده کنید؛ sample_products.xml را از طریق &#8230; وارد کنید. <a href=\"https://wordpress.org/plugins/wordpress-importer/\" rel=\"ugc\">واردکننده وردپرس</a>. از هسته هم میشه استفاده کرد <a href=\"https://woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">واردکننده CSV</a> یا ما <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">برنامه افزودنی CSV واردات Suite</a> برای واردات sample_products.csv</p>\n\";s:3:\"faq\";s:10033:\"\n<dt id=\'where%20can%20i%20find%20woocommerce%20documentation%20and%20user%20guides%3F\'>\nکجا می توانم مستندات ووکامرس و راهنمای کاربر را پیدا کنم؟\n</h4>\n<p>\n<p>برای راهنمایی در راه اندازی و پیکربندی ووکامرس، لطفاً به <a href=\"https://woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">شروع به کار</a> and the <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">راهنمای مالک فروشگاه جدید ووکامرس</a>.</p>\n<p>برای گسترش یا قالب بندی ووکامرس، به ما مراجعه کنید <a href=\"https://github.com/woocommerce/woocommerce/tree/trunk/docs\" rel=\"nofollow ugc\">مستندات</a>, به همان خوبی <a href=\"https://github.com/woocommerce/woocommerce/blob/trunk/docs/extension-development/extension-development-best-practices.md\" rel=\"nofollow ugc\">بهترین روش های توسعه دهنده افزونه</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20or%20talk%20to%20other%20users%20about%20woocommerce%20core%3F\'>\nاز کجا می توانم در مورد هسته ووکامرس کمک بگیرم یا با کاربران دیگر صحبت کنم؟\n</h4>\n<p>\n<p>اگر گیر کردید، می‌توانید در [بخش] درخواست کمک کنید <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">انجمن پشتیبانی ووکامرس</a> با دنبال کردن <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">این دستورالعمل‌ها</a>, از طریق <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">انجمن ووکامرس اسلک</a>, یا پست بگذارید <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">گروه انجمن ووکامرس</a> on فیسبوک.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20for%20extensions%20i%20have%20purchased%20from%20the%20woocommerce%20marketplace%3F\'>\nاز کجا می‌توانم برای افزونه‌هایی که از WooCommerce Marketplace خریداری کرده‌ام کمک بگیرم؟\n</h4>\n<p>\n<p>برای کمک در مورد افزونه‌های پولی از بازار ووکامرس: ابتدا، موارد ما را بررسی کنید <a href=\"https://woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">self-service troubleshooting guide</a>. اگر مشکل همچنان ادامه داشت، لطفاً از طریق تیکت پشتیبانی ثبت نام کنید <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">میز کمک ما</a>. مهندسان شادی اختصاصی ما قصد دارند ظرف 24 ساعت پاسخ دهند.</p>\n</p>\n<dt id=\'i%E2%80%99m%20having%20trouble%20logging%20in%20to%20woocommerce.com%20%E2%80%93%20what%20now%3F\'>\nبرای ورود به WooCommerce.com مشکل دارم &#8211; حالا چه کار کنم؟\n</h4>\n<p>\n<p>ابتدا، مشکلات رایج ورود به سیستم را با استفاده از این راهنمای مفید عیب‌یابی کنید <a href=\"https://woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">راهنمای گام به گام</a>. هنوز کار نمی‌کند؟ <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">با ما در تماس باشید</a>.</p>\n</p>\n<dt id=\'will%20woocommerce%20work%20with%20my%20theme%3F\'>\nآیا ووکامرس با قالب من کار می کند؟\n</h4>\n<p>\n<p>بله! ووکامرس با هر قالبی کار می‌کند اما ممکن است به استایل‌بندی اضافی نیاز داشته باشد. اگر به دنبال قالبی هستید که به طور کامل با ووکامرس یکپارچه باشد، <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a> را توصیه می‌کنیم.</p>\n</p>\n<dt id=\'how%20do%20i%20update%20woocommerce%3F\'>\nچگونه میتوانم ووکامرس را بروز کنم؟\n</h4>\n<p>\n<p>ما یک راهنمای مفصل در مورد <a href=\"https://woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">نحوه به‌روزرسانی ووکامرس</a> داریم.</p>\n</p>\n<dt id=\'my%20site%20broke%20%E2%80%93%20what%20do%20i%20do%3F\'>\nسایت من خراب شد &#8211; چه کاری انجام دهم؟\n</h4>\n<p>\n<p>با تشخیص مشکل با استفاده از ابزارهای مفید ما شروع کنید <a href=\"https://woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">راهنمای عیب‌یابی</a>.</p>\n<p>اگر پس از به‌روزرسانی یک پوسته یا افزونه متوجه خطا شدید، ممکن است مشکلات سازگاری بین آن و ووکامرس وجود داشته باشد. اگر این مسئله پس از به روزرسانی ووکامرس ظاهر شود، ممکن است بین ووکامرس و یک پوسته یا افزونه قدیمی تداخلی وجود داشته باشد.</p>\n<p>در هر دو مورد، توصیه می‌کنیم با استفاده از <a href=\"https://woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">بررسی سلامت</a> (که به شما امکان می‌دهد قالب‌ها و افزونه‌ها را بدون تأثیر بر بازدیدکنندگان خود غیرفعال کنید) یا با استفاده از <a href=\"https://woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">سایت آزمایشی</a>، یک تست تداخل اجرا کنید.</p>\n</p>\n<dt id=\'where%20can%20i%20report%20bugs%3F\'>\nاز کجا می توان مشکلات را گزارش داد؟\n</h4>\n<p>\n<p>خطاها را در <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مخزن گیتهاب ووکامرس</a> گزارش کنید. همچنین می توانید از طریق انجمن پشتیبانی ما، به ما اطلاع دهید &#8211; حتماً در انجمن ها جستجو کنید تا مطمئن شوید که خطا قبلاً گزارش نشده است.</p>\n</p>\n<dt id=\'where%20can%20i%20request%20new%20features%2C%20themes%2C%20and%20extensions%3F\'>\nاز کجا می توانم ویژگی‌ها ، پوسته‌ها و برنامه‌های افزودنی جدید را درخواست کنم؟\n</h4>\n<p>\n<p>درخواست ویژگی‌ها و افزونه‌های جدید را بدهید و به پیشنهادات موجود در <a href=\"https://woocommerce.com/feature-requests/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">تابلوی درخواست ویژگی</a> رسمی ما رأی دهید. تیم‌های محصول ما مرتباً درخواست‌ها را بررسی می‌کنند و آنها را برای برنامه‌ریزی محصول ارزشمند می‌دانند.</p>\n</p>\n<dt id=\'woocommerce%20is%20awesome%21%20can%20i%20contribute%3F\'>\nووکامرس فوق العاده ست! چطوری می تونم مشارکت کنم؟\n</h4>\n<p>\n<p>بله، میتوانید! به <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">مخزن گیتهاب</a> ما بپیوندید و <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">وب‌نوشت توسعه</a> را دنبال کنید تا در مورد هر آنچه در این پروژه به‌روز میشود مطلع باشید.</p>\n</p>\n<dt id=\'where%20can%20i%20find%20rest%20api%20documentation%3F\'>\nکجا می توانم مستندات Rest API را پیدا کنم؟\n</h4>\n<p>\n<p>مستندات گسترده REST API<a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\"> ووکامرس</a> در گیتهاب در دسترس است.</p>\n</p>\n<dt id=\'my%20question%20is%20not%20listed%20here.%20where%20can%20i%20find%20more%20answers%3F\'>\nسوال من در اینجا ذکر نشده است. از کجا می‌توانم پاسخ‌های بیشتری پیدا کنم؟\n</h4>\n<p>\n<p>برای اطلاعات بیشتر به <a href=\"https://woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">سوالات متداول</a> مراجعه کنید.</p>\n</p>\n\n\";s:9:\"changelog\";s:681:\"<h4>10.0.3 2025-07-21</h4>\n<p><strong>ووکامرس</strong></p>\n<ul>\n<li>Fix &#8211; Product Details: prevent the default template to be auto applied for existing blocks. <a href=\"https://github.com/woocommerce/woocommerce/pull/59698\" rel=\"nofollow ugc\">#59698</a></li>\n<li>Tweak &#8211; Filter tooltip content in jQuery tipTip tooltips <a href=\"https://github.com/woocommerce/woocommerce/pull/59830\" rel=\"nofollow ugc\">#59830</a></li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">برای مشاهده‌ی تغییرات همه نسخه‌ها به فهرست تغییرات مراجعه کنید</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:15435:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good Base, Needs Some Improvements</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/williedgarcia/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0fa87555931fffbebf02902d2eff36fc0bd098081f6303fbb039cabdb99af724?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0fa87555931fffbebf02902d2eff36fc0bd098081f6303fbb039cabdb99af724?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/williedgarcia/\" class=\"reviewer-name\">williedgarcia</a> در <span class=\"review-date\">جولای 21, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>WooCommerce is quite powerful for setting up an online store without coding. It works well for basic needs, but some advanced features require too many extensions. Still, it’s a solid choice if you’re okay with a bit of tweaking.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great plugin and support team</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/psychonet/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/89c0eb1b47baa6bb5c1f3aa0ff11d951924ccad0bf3c51c5680de9f834a57a60?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/89c0eb1b47baa6bb5c1f3aa0ff11d951924ccad0bf3c51c5680de9f834a57a60?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/psychonet/\" class=\"reviewer-name\">psychonet</a> در <span class=\"review-date\">جولای 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>It\'s a great plugin, and the support team responds quickly and effectively.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent Plugin, Excellent Support!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/edyplat/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d6ddd833fcbb3de9481d90b36694d4a6cc9a9de73d1e38a69ac8afab5a42363a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d6ddd833fcbb3de9481d90b36694d4a6cc9a9de73d1e38a69ac8afab5a42363a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/edyplat/\" class=\"reviewer-name\">edyplat</a> در <span class=\"review-date\">جولای 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The plugin and support really make the difference. <br />Thanks to the people behind Woocommerce!!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/whuchumeen/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0188245c1ef5824af7a42feee415aef8d068403eb2883e84b8eba9c16c56100b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0188245c1ef5824af7a42feee415aef8d068403eb2883e84b8eba9c16c56100b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/whuchumeen/\" class=\"reviewer-name\">whuchumeen</a> در <span class=\"review-date\">جولای 17, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Excellent support! Fast, professional, and courteous. Thank you</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Silly questions but very clever answers</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/jaana20/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a07ad30ebdb384a7559ed1ec784933009b2d6d2b8efa536bf48695486dd7a219?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a07ad30ebdb384a7559ed1ec784933009b2d6d2b8efa536bf48695486dd7a219?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/jaana20/\" class=\"reviewer-name\">jaana20</a> در <span class=\"review-date\">جولای 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Just when I thought I had screwed up so badly that I was going to lose all my efforts for my online store - and in the worst case, my entire website - I found very professional help here. I received very clear guidance and none of my questions seemed too stupid or ridiculous. I am not very good at these things, but I learn by doing. You are doing a good job and I will certainly contact you again when I need help. Special thanks to Moses M, LovingBro and shahzeen! Another special thanks to Bruno Kos at WooCommerce Multilingual!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Helpful for Small Business Owners</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/khushbu91/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/67b16f92184f7858115ca4f0aa7dc28d355c5f8207458a3d05844de94c93ce97?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/67b16f92184f7858115ca4f0aa7dc28d355c5f8207458a3d05844de94c93ce97?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/khushbu91/\" class=\"reviewer-name\">khushbu91</a> در <span class=\"review-date\">جولای 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Its the best plugin for a small business owner, community is helpful too :)</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/fscha/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/62f736586b661e1077f2c6f0f5e3eeafa4b156e5f20ade9a81e81b6a410e93b5?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/62f736586b661e1077f2c6f0f5e3eeafa4b156e5f20ade9a81e81b6a410e93b5?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/fscha/\" class=\"reviewer-name\">fscha</a> در <span class=\"review-date\">جولای 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Quick response and I was well guided, thank you again</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excelente</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/samuelibon/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f104feb102606cd24cdc08035580f5cb06d57c19f6ac20bb2ac6bf3688e99818?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f104feb102606cd24cdc08035580f5cb06d57c19f6ac20bb2ac6bf3688e99818?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/samuelibon/\" class=\"reviewer-name\">samuelibon</a> در <span class=\"review-date\">جولای 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Gran plugin  y un gran equipo de soporte detrás. Eficaz y muy rápido.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Code snippet support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/laetabi/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/33a535ef0ec7a866eecda2b86dc060b30c2bee3d5c5cb8366f1c26f273d7718d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/33a535ef0ec7a866eecda2b86dc060b30c2bee3d5c5cb8366f1c26f273d7718d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/laetabi/\" class=\"reviewer-name\">laetabi</a> در <span class=\"review-date\">جولای 12, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Fantastic support today from the WooCommerce board, providing a code snippet to support a minor amend to emails that was really bugging me, and all within an hour on a Saturday. Thank you @LovingBro</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Super</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/falafelina/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/4598616f3fdef6bb52169f418feea4043bd39f37c43fab3f7c7d68c2846343fa?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/4598616f3fdef6bb52169f418feea4043bd39f37c43fab3f7c7d68c2846343fa?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/falafelina/\" class=\"reviewer-name\">falafelina</a> در <span class=\"review-date\">جولای 12, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Easy to install and configure :) </p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:294:\"همه چیزهایی که برای راه اندازی یک فروشگاه آنلاین در عرض چند روز و درحال رشد نگه‌داشتن آن برای سال‌ها نیاز دارید. از اولین فروش تا درآمد میلیونی، ووکامرس با شماست.\";s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.3.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.png?rev=3235205\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.png?rev=3234504\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:498:{s:6:\"10.0.0\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0.zip\";s:11:\"10.0.0-rc.1\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.1.zip\";s:11:\"10.0.0-rc.2\";s:66:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.0-rc.2.zip\";s:6:\"10.0.1\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.1.zip\";s:6:\"10.0.2\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.2.zip\";s:6:\"10.0.3\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.0.3.zip\";s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.3.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"7.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.1.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.4.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"8.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.2.zip\";s:5:\"8.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0.zip\";s:12:\"8.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-beta.1.zip\";s:10:\"8.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.1.zip\";s:10:\"8.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.2.zip\";s:5:\"8.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.1.zip\";s:5:\"8.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.2.zip\";s:5:\"8.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.3.zip\";s:5:\"8.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0.zip\";s:12:\"8.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-beta.1.zip\";s:10:\"8.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.1.zip\";s:10:\"8.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.2.zip\";s:5:\"8.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"8.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.2.zip\";s:5:\"8.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0.zip\";s:12:\"8.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-beta.1.zip\";s:10:\"8.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-rc.1.zip\";s:5:\"8.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.1.zip\";s:5:\"8.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0.zip\";s:12:\"8.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-beta.1.zip\";s:10:\"8.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-rc.1.zip\";s:5:\"8.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.1.zip\";s:5:\"8.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.2.zip\";s:5:\"8.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.3.zip\";s:5:\"8.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0.zip\";s:12:\"8.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-beta.1.zip\";s:10:\"8.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-rc.1.zip\";s:5:\"8.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.1.zip\";s:5:\"8.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.2.zip\";s:5:\"8.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0.zip\";s:12:\"8.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.1.zip\";s:12:\"8.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.2.zip\";s:10:\"8.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-rc.1.zip\";s:5:\"8.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.1.zip\";s:5:\"8.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0.zip\";s:12:\"8.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-beta.1.zip\";s:10:\"8.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-rc.1.zip\";s:5:\"8.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.1.zip\";s:5:\"8.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.2.zip\";s:5:\"8.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.3.zip\";s:5:\"8.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.4.zip\";s:5:\"8.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.5.zip\";s:5:\"8.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0.zip\";s:12:\"8.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-beta.1.zip\";s:10:\"8.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-rc.1.zip\";s:5:\"8.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.1.zip\";s:5:\"8.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.2.zip\";s:5:\"8.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.3.zip\";s:5:\"9.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0.zip\";s:12:\"9.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.1.zip\";s:12:\"9.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.2.zip\";s:10:\"9.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-rc.1.zip\";s:5:\"9.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.1.zip\";s:5:\"9.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.2.zip\";s:5:\"9.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0.zip\";s:12:\"9.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-beta.1.zip\";s:10:\"9.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-rc.1.zip\";s:5:\"9.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.1.zip\";s:5:\"9.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.2.zip\";s:5:\"9.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.3.zip\";s:5:\"9.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.4.zip\";s:5:\"9.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0.zip\";s:12:\"9.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-beta.1.zip\";s:10:\"9.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-rc.1.zip\";s:5:\"9.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.1.zip\";s:5:\"9.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.2.zip\";s:5:\"9.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.3.zip\";s:5:\"9.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0.zip\";s:12:\"9.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-beta.1.zip\";s:10:\"9.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-rc.1.zip\";s:5:\"9.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.1.zip\";s:5:\"9.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.2.zip\";s:5:\"9.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.3.zip\";s:5:\"9.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.4.zip\";s:5:\"9.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0.zip\";s:12:\"9.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.1.zip\";s:12:\"9.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.2.zip\";s:10:\"9.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.1.zip\";s:10:\"9.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.2.zip\";s:10:\"9.4.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.3.zip\";s:10:\"9.4.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.4.zip\";s:5:\"9.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.1.zip\";s:5:\"9.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.2.zip\";s:5:\"9.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.3.zip\";s:5:\"9.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0.zip\";s:12:\"9.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.1.zip\";s:12:\"9.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.2.zip\";s:10:\"9.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-rc.1.zip\";s:5:\"9.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:5:\"9.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.2.zip\";s:5:\"9.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0.zip\";s:12:\"9.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.1.zip\";s:12:\"9.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.2.zip\";s:10:\"9.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-rc.1.zip\";s:5:\"9.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.1.zip\";s:5:\"9.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.2.zip\";s:5:\"9.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0.zip\";s:12:\"9.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-beta.1.zip\";s:10:\"9.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.0-rc.1.zip\";s:5:\"9.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.7.1.zip\";s:5:\"9.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0.zip\";s:12:\"9.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-beta.1.zip\";s:10:\"9.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.0-rc.1.zip\";s:5:\"9.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.1.zip\";s:5:\"9.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.2.zip\";s:5:\"9.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.3.zip\";s:5:\"9.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.4.zip\";s:5:\"9.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.8.5.zip\";s:5:\"9.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0.zip\";s:12:\"9.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-beta.1.zip\";s:10:\"9.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.0-rc.1.zip\";s:5:\"9.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.1.zip\";s:5:\"9.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.2.zip\";s:5:\"9.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.3.zip\";s:5:\"9.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.4.zip\";s:5:\"9.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.5.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:14:\"ووکامرس\";}}", "off");
INSERT INTO `wp_options` VALUES("253", "wpp_adminpanel_font_main", "Vazir", "auto");
INSERT INTO `wp_options` VALUES("254", "wpp_adminpanel_font_h", "Vazir", "auto");
INSERT INTO `wp_options` VALUES("255", "wpp_adminpanel_font_nav", "Vazir", "auto");
INSERT INTO `wp_options` VALUES("256", "wpp_adminpanel_datepicker", "1", "auto");
INSERT INTO `wp_options` VALUES("258", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("264", "rtl_rsm_settings", "a:6:{s:21:\"checkUpdateListNumber\";a:2:{s:9:\"lastCheck\";i:1;s:6:\"number\";i:1;}s:8:\"settings\";a:3:{s:25:\"notificationUpdateInEmail\";i:1;s:26:\"notificationLicenseInEmail\";i:1;s:25:\"notificationMarketInEmail\";i:1;}s:6:\"server\";a:3:{s:6:\"setNew\";i:1;s:7:\"setNew1\";i:1;s:6:\"manual\";s:1:\"0\";}s:22:\"checkUpdateProductList\";a:1:{s:9:\"lastCheck\";i:1730230148;}s:9:\"delayTime\";a:1:{s:8:\"wpLoaded\";i:1730168871;}s:5:\"clean\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("265", "auto_update_plugins", "a:10:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:37:\"foodking-toolkit/foodking-toolkit.php\";i:2;s:29:\"persian-date/persian-date.php\";i:3;s:34:\"yith-woocommerce-wishlist/init.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:8;s:36:\"contact-form-7/wp-contact-form-7.php\";i:9;s:30:\"advanced-custom-fields/acf.php\";i:10;s:27:\"woocommerce/woocommerce.php\";}", "off");
INSERT INTO `wp_options` VALUES("267", "auto_update_themes", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("272", "rtl_rsm_autoUpdate", "a:2:{s:7:\"plugins\";a:0:{}s:6:\"themes\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("276", "rtl_rsm_pluginsUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1762680827;}", "off");
INSERT INTO `wp_options` VALUES("277", "rtl_rsm_themesUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1762680827;}", "off");
INSERT INTO `wp_options` VALUES("278", "rtl_rsm_sendProductUpdateEmail", "1724139369", "auto");
INSERT INTO `wp_options` VALUES("283", "rtl_rsm_localProducts", "bY87C4MwFIX_imRuoyZqEqF069QupXTKYkOCob7QOIn_vXkIFdrlcM_Hua8FEFVR8cI5pbhAL0FBuYCLbuRTjpPuO1CCFCaQgQO46e4u5j0nMLH8oU0jredzUmTIKSK-znxNI2-oU5x6pJwS-SUYh9BmfKjaodCN1DYq2neG8M-OcELxZ4jTijkVIoQ8UfaVq-7e9pPamGEqeczj0TRHU8tWQtG3PD4PJ0RYjhlY1w8", "on");
INSERT INTO `wp_options` VALUES("284", "rtl_rsm_lastSync", "1722641868", "auto");
INSERT INTO `wp_options` VALUES("286", "rtl_rsm_transient", "a:1:{s:13:\"updatePlugins\";a:2:{s:9:\"transient\";O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1736648593;s:8:\"response\";a:1:{s:29:\"RTL-CareUnit/RTL-CareUnit.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:12:\"RTL-CareUnit\";s:6:\"plugin\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:11:\"new_version\";s:5:\"2.4.1\";s:6:\"tested\";s:3:\"6.7\";s:7:\"package\";s:53:\"https://files.rtl-theme.com/plugins/rtlRsm/rtlRsm.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:8:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:6:\"6.3.11\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.3.11.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";s:3:\"svg\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=3207824\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=3207824\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.0.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.26.4\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";}s:47:\"one-click-demo-import/one-click-demo-import.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:35:\"w.org/plugins/one-click-demo-import\";s:4:\"slug\";s:21:\"one-click-demo-import\";s:6:\"plugin\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:11:\"new_version\";s:5:\"3.3.0\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/one-click-demo-import/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/one-click-demo-import.3.3.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-256x256.png?rev=2506685\";s:2:\"1x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-128x128.png?rev=2506685\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/one-click-demo-import/assets/banner-1544x500.png?rev=2506685\";s:2:\"1x\";s:76:\"https://ps.w.org/one-click-demo-import/assets/banner-772x250.png?rev=2506685\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}s:29:\"persian-date/persian-date.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/persian-date\";s:4:\"slug\";s:12:\"persian-date\";s:6:\"plugin\";s:29:\"persian-date/persian-date.php\";s:11:\"new_version\";s:5:\"0.1.3\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/persian-date/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/persian-date.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/persian-date/assets/icon-128x128.png?rev=2201684\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/persian-date/assets/banner-772x250.png?rev=2263169\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:5:\"9.5.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-256x256.gif?rev=2869506\";s:2:\"1x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-128x128.gif?rev=2869506\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3000842\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3000842\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:34:\"yith-woocommerce-wishlist/init.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"w.org/plugins/yith-woocommerce-wishlist\";s:4:\"slug\";s:25:\"yith-woocommerce-wishlist\";s:6:\"plugin\";s:34:\"yith-woocommerce-wishlist/init.php\";s:11:\"new_version\";s:5:\"4.1.0\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/yith-woocommerce-wishlist/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/yith-woocommerce-wishlist.4.1.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:78:\"https://ps.w.org/yith-woocommerce-wishlist/assets/icon-128x128.gif?rev=3129302\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/yith-woocommerce-wishlist/assets/banner-1544x500.gif?rev=3129931\";s:2:\"1x\";s:80:\"https://ps.w.org/yith-woocommerce-wishlist/assets/banner-772x250.gif?rev=3129931\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}}s:7:\"checked\";a:10:{s:30:\"advanced-custom-fields/acf.php\";s:6:\"6.3.11\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.0.2\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.2\";s:23:\"elementor/elementor.php\";s:6:\"3.26.4\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:5:\"3.3.0\";s:29:\"persian-date/persian-date.php\";s:5:\"0.1.3\";s:27:\"woocommerce/woocommerce.php\";s:5:\"9.5.2\";s:34:\"yith-woocommerce-wishlist/init.php\";s:5:\"4.1.0\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:5:\"2.4.0\";s:37:\"foodking-toolkit/foodking-toolkit.php\";s:5:\"1.1.1\";}}s:9:\"lastCheck\";i:1736734994;}}", "off");
INSERT INTO `wp_options` VALUES("348", "elementor_active_kit", "7", "auto");
INSERT INTO `wp_options` VALUES("349", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("352", "yit_recently_activated", "a:2:{i:0;s:34:\"yith-woocommerce-wishlist/init.php\";i:1;s:34:\"yith-woocommerce-wishlist/init.php\";}", "auto");
INSERT INTO `wp_options` VALUES("353", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1722642018;s:7:\"version\";s:5:\"5.9.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("354", "acf_first_activated_version", "6.3.5", "on");
INSERT INTO `wp_options` VALUES("355", "acf_site_health", "{\"version\":\"6.6.2\",\"plugin_type\":\"Free\",\"update_source\":\"wordpress.org\",\"wp_version\":\"6.8.3\",\"mysql_version\":\"8.0.43-cll-lve\",\"is_multisite\":false,\"active_theme\":{\"name\":\"\\u0641\\u0648\\u062f\\u06a9\\u06cc\\u0646\\u06af\",\"version\":\"1.2.1.3\",\"theme_uri\":\"https:\\/\\/www.rtl-theme.com\\/foodking-wordpress-theme\\/\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields\\/acf.php\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.6.2\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"contact-form-7\\/wp-contact-form-7.php\":{\"name\":\"Contact Form 7\",\"version\":\"6.1.3\",\"plugin_uri\":\"https:\\/\\/contactform7.com\\/\"},\"duplicator\\/duplicator.php\":{\"name\":\"Duplicator\",\"version\":\"1.5.14\",\"plugin_uri\":\"https:\\/\\/duplicator.com\\/\"},\"elementor\\/elementor.php\":{\"name\":\"Elementor\",\"version\":\"3.32.5\",\"plugin_uri\":\"https:\\/\\/elementor.com\\/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\"},\"one-click-demo-import\\/one-click-demo-import.php\":{\"name\":\"One Click Demo Import\",\"version\":\"3.4.0\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/one-click-demo-import\\/\"},\"persian-date\\/persian-date.php\":{\"name\":\"Persian Date\",\"version\":\"0.1.3\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/persian-date\\/\"},\"woocommerce\\/woocommerce.php\":{\"name\":\"WooCommerce\",\"version\":\"10.3.4\",\"plugin_uri\":\"https:\\/\\/woocommerce.com\\/\"},\"yith-woocommerce-wishlist\\/init.php\":{\"name\":\"YITH WooCommerce Wishlist\",\"version\":\"4.10.0\",\"plugin_uri\":\"https:\\/\\/yithemes.com\\/themes\\/plugins\\/yith-woocommerce-wishlist\\/\"},\"RTL-CareUnit\\/RTL-CareUnit.php\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0647\\u0648\\u0634\\u0645\\u0646\\u062f \\u0631\\u0627\\u0633\\u062a \\u0686\\u06cc\\u0646\",\"version\":\"2.5.2\",\"plugin_uri\":\"https:\\/\\/www.rtl-theme.com\\/\"},\"foodking-toolkit\\/foodking-toolkit.php\":{\"name\":\"\\u062c\\u0639\\u0628\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631 \\u0641\\u0648\\u062f\\u06a9\\u06cc\\u0646\\u06af\",\"version\":\"1.1.2\",\"plugin_uri\":\"\"}},\"ui_field_groups\":\"3\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"all_location_rules\":[\"post_type==teams\",\"post_type==page\",\"post_type==post\"],\"number_of_fields_by_type\":{\"text\":10,\"url\":4,\"true_false\":1,\"image\":1,\"select\":1},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"14\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"11\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":false,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_activated\":1722642019,\"last_updated\":1762560850}", "off");
INSERT INTO `wp_options` VALUES("356", "action_scheduler_hybrid_store_demarkation", "9", "auto");
INSERT INTO `wp_options` VALUES("357", "schema-ActionScheduler_StoreSchema", "8.0.1755051731", "auto");
INSERT INTO `wp_options` VALUES("358", "schema-ActionScheduler_LoggerSchema", "3.0.1722642019", "auto");
INSERT INTO `wp_options` VALUES("361", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("362", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("363", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("364", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("365", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("366", "woocommerce_default_country", "IR:THR", "on");
INSERT INTO `wp_options` VALUES("367", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("368", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("369", "woocommerce_all_except_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("370", "woocommerce_specific_allowed_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("371", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("372", "woocommerce_specific_ship_to_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("373", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("374", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("375", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("376", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("377", "woocommerce_currency", "IRT", "on");
INSERT INTO `wp_options` VALUES("378", "woocommerce_currency_pos", "right_space", "on");
INSERT INTO `wp_options` VALUES("379", "woocommerce_price_thousand_sep", ",", "on");
INSERT INTO `wp_options` VALUES("380", "woocommerce_price_decimal_sep", ".", "on");
INSERT INTO `wp_options` VALUES("381", "woocommerce_price_num_decimals", "0", "on");
INSERT INTO `wp_options` VALUES("382", "woocommerce_shop_page_id", "2212", "on");
INSERT INTO `wp_options` VALUES("383", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("384", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("385", "woocommerce_placeholder_image", "9", "on");
INSERT INTO `wp_options` VALUES("386", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("387", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("388", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("389", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("390", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("391", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("392", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("393", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("394", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("395", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("396", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("397", "woocommerce_stock_email_recipient", "mahdiwir80@outlook.com", "off");
INSERT INTO `wp_options` VALUES("398", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("399", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("400", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("401", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("402", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("403", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("404", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("405", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("406", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("407", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("409", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("410", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("411", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("412", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("413", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("414", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("415", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("416", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("417", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("418", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("419", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("420", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("421", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("422", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("423", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("424", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("425", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("426", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("427", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("428", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("429", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("430", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("431", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("432", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("433", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("434", "woocommerce_registration_privacy_policy_text", "Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("435", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت، و برای اهداف دیگری که در [privacy_policy] ما توضیح داده شده است، استفاده خواهد شد.\n\n", "on");
INSERT INTO `wp_options` VALUES("436", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("437", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("438", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("439", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("440", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("441", "woocommerce_email_from_name", "قالب فودکینگ", "off");
INSERT INTO `wp_options` VALUES("442", "woocommerce_email_from_address", "mahdiwir80@outlook.com", "off");
INSERT INTO `wp_options` VALUES("443", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("444", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("445", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("446", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("447", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("448", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("449", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("450", "woocommerce_cart_page_id", "2213", "off");
INSERT INTO `wp_options` VALUES("451", "woocommerce_checkout_page_id", "2220", "off");
INSERT INTO `wp_options` VALUES("452", "woocommerce_myaccount_page_id", "13", "off");
INSERT INTO `wp_options` VALUES("453", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("454", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("455", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("456", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("457", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("458", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("459", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("460", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("461", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("462", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("463", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("464", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("465", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("466", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("467", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("468", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("469", "woocommerce_show_marketplace_suggestions", "no", "off");
INSERT INTO `wp_options` VALUES("470", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("471", "woocommerce_analytics_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("472", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("473", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("474", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("475", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("476", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("477", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("478", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("479", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("480", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("481", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("482", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("485", "default_product_cat", "15", "auto");
INSERT INTO `wp_options` VALUES("487", "woocommerce_refund_returns_page_id", "14", "auto");
INSERT INTO `wp_options` VALUES("490", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:22:\"mahdiwir80@outlook.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:22:\"mahdiwir80@outlook.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("491", "woocommerce_version", "10.3.4", "auto");
INSERT INTO `wp_options` VALUES("492", "woocommerce_db_version", "10.3.4", "auto");
INSERT INTO `wp_options` VALUES("493", "woocommerce_store_id", "817cfbef-62fc-43b6-b501-4bbcae229d17", "auto");
INSERT INTO `wp_options` VALUES("494", "woocommerce_admin_install_timestamp", "1722642032", "auto");
INSERT INTO `wp_options` VALUES("495", "woocommerce_inbox_variant_assignment", "8", "auto");
INSERT INTO `wp_options` VALUES("496", "woocommerce_remote_variant_assignment", "38", "auto");
INSERT INTO `wp_options` VALUES("501", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("502", "action_scheduler_lock_async-request-runner", "690fbf8a1e8133.44280786|1762639814", "no");
INSERT INTO `wp_options` VALUES("503", "woocommerce_admin_notices", "a:1:{i:0;s:20:\"no_secure_connection\";}", "auto");
INSERT INTO `wp_options` VALUES("507", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("508", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("509", "elementor_version", "3.32.5", "auto");
INSERT INTO `wp_options` VALUES("510", "elementor_install_history", "a:16:{s:6:\"3.23.3\";i:1722642044;s:6:\"3.23.4\";i:1722985822;s:6:\"3.25.2\";i:1730242399;s:6:\"3.25.3\";i:1730500836;s:6:\"3.25.4\";i:1730630948;s:7:\"3.25.10\";i:1732963446;s:6:\"3.26.3\";i:1735165401;s:6:\"3.26.4\";i:1736303285;s:6:\"3.26.5\";i:1736994605;s:6:\"3.27.0\";i:1737426752;s:6:\"3.28.1\";i:1743197875;s:6:\"3.28.2\";i:1743387968;s:6:\"3.29.2\";i:1751227995;s:6:\"3.30.0\";i:1751423187;s:6:\"3.31.4\";i:1757393212;s:6:\"3.32.5\";i:1762638075;}", "auto");
INSERT INTO `wp_options` VALUES("511", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("512", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"Zv7y6gprwmwbi13onySoe6LR8UFY8TxP\";}", "on");
INSERT INTO `wp_options` VALUES("513", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("514", "widget_custom_search_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("515", "widget_custom_popular_posts_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("516", "widget_custom_sidebar_categories_widget", "a:2:{i:1;a:1:{s:5:\"title\";s:22:\"دسته بندی ها\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("517", "widget_never_miss_news_widget", "a:2:{i:1;a:5:{s:8:\"facebook\";s:23:\"http://www.facebook.com\";s:7:\"twitter\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("518", "widget_popular_tags_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("519", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("520", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("521", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("522", "widget_woocommerce_price_filter", "a:2:{i:1;a:1:{s:5:\"title\";s:32:\"فیلتر براساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("523", "widget_woocommerce_product_categories", "a:2:{i:1;a:8:{s:5:\"title\";s:32:\"دسته بندی محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("524", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("525", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("526", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("527", "widget_woocommerce_recently_viewed_products", "a:2:{i:1;a:2:{s:5:\"title\";s:43:\"محصولات مشاهده شده اخیر\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("528", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("529", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("530", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("535", "yith_wcwl_wishlist_page_id", "15", "auto");
INSERT INTO `wp_options` VALUES("537", "yith_wcwl_db_version", "4.0.0", "auto");
INSERT INTO `wp_options` VALUES("549", "_transient_woocommerce_shipping_task_zone_count_transient", "0", "on");
INSERT INTO `wp_options` VALUES("552", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("557", "acf_version", "6.6.2", "auto");
INSERT INTO `wp_options` VALUES("558", "wc_admin_show_legacy_coupon_menu", "0", "auto");
INSERT INTO `wp_options` VALUES("559", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("570", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("576", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1762560851;}", "auto");
INSERT INTO `wp_options` VALUES("578", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("579", "foodking_opt", "a:112:{s:8:\"last_tab\";s:0:\"\";s:9:\"main_logo\";a:5:{s:3:\"url\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_14-transformed.png\";s:2:\"id\";s:4:\"2286\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"137\";s:9:\"thumbnail\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_14-transformed.png\";}s:20:\"main_logo_dimensions\";a:3:{s:5:\"width\";s:2:\"px\";s:6:\"height\";s:0:\"\";s:5:\"units\";s:2:\"px\";}s:10:\"main_logo2\";a:5:{s:3:\"url\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_18-transformed.png\";s:2:\"id\";s:4:\"2297\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"137\";s:9:\"thumbnail\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_18-transformed.png\";}s:12:\"sidebar_logo\";a:5:{s:3:\"url\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_14-transformed.png\";s:2:\"id\";s:4:\"2286\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"137\";s:9:\"thumbnail\";s:92:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/U_U_O¯U©U_U_U¯_14-transformed.png\";}s:15:\"side_menu_icon1\";a:5:{s:3:\"url\";s:63:\"https://t-theme.com/foodking/wp-content/uploads/2024/03/bar.svg\";s:2:\"id\";s:4:\"1649\";s:6:\"height\";s:2:\"25\";s:5:\"width\";s:2:\"25\";s:9:\"thumbnail\";s:63:\"https://t-theme.com/foodking/wp-content/uploads/2024/03/bar.svg\";}s:15:\"side_menu_icon2\";a:5:{s:3:\"url\";s:65:\"https://t-theme.com/foodking/wp-content/uploads/2024/03/bar-2.svg\";s:2:\"id\";s:4:\"1650\";s:6:\"height\";s:2:\"25\";s:5:\"width\";s:2:\"25\";s:9:\"thumbnail\";s:65:\"https://t-theme.com/foodking/wp-content/uploads/2024/03/bar-2.svg\";}s:23:\"sidebar_logo_dimensions\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"units\";s:2:\"px\";}s:11:\"footer_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:22:\"footer_logo_dimensions\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"units\";s:2:\"px\";}s:16:\"enable_preloader\";s:1:\"1\";s:12:\"loading_text\";s:14:\"فودکینگ\";s:13:\"loading_text2\";s:26:\"اندکی صبر کنید\";s:14:\"top_bar_number\";s:4:\"100%\";s:12:\"info_field_1\";s:51:\"تحویل مطمئن بدون تماس با پیک\";s:10:\"icon_field\";s:12:\"fas fa-truck\";s:12:\"info_field_2\";s:43:\"سفارشتان را پیگیری کنید\";s:17:\"enable_search_bar\";s:1:\"1\";s:23:\"search_placeholder_text\";s:10:\"جستجو\";s:18:\"enable_back_to_top\";s:1:\"1\";s:20:\"enable_sticky_header\";s:1:\"1\";s:10:\"header_btn\";s:31:\"با ما تماس بگیرید\";s:15:\"header_btn_link\";s:1:\"#\";s:19:\"header_sidebar_desc\";s:248:\"این شامل تعاملات بین یک کسب و کار و مشتریان آن است. این در مورد رفع نیازهای مشتریان و حل مشکلات آنها است. خدمات موثر به مشتری بسیار مهم است.\";s:13:\"gallery_img_1\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/01.jpg\";s:2:\"id\";s:2:\"84\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/01.jpg\";}s:13:\"gallery_img_2\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/02.jpg\";s:2:\"id\";s:2:\"85\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/02.jpg\";}s:13:\"gallery_img_3\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/03.jpg\";s:2:\"id\";s:2:\"86\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/03.jpg\";}s:13:\"gallery_img_4\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/04.jpg\";s:2:\"id\";s:2:\"87\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/04.jpg\";}s:13:\"gallery_img_5\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/05.jpg\";s:2:\"id\";s:2:\"88\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/05.jpg\";}s:13:\"gallery_img_6\";a:5:{s:3:\"url\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/06.jpg\";s:2:\"id\";s:2:\"89\";s:6:\"height\";s:3:\"120\";s:5:\"width\";s:3:\"120\";s:9:\"thumbnail\";s:62:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/06.jpg\";}s:13:\"sidebar_title\";s:23:\"اطلاعات تماس\";s:20:\"contact_icon_field_1\";s:21:\"fas fa-map-marker-alt\";s:15:\"contact_field_1\";s:55:\"خیابان اصلی، ملبورن، استرالیا\";s:20:\"contact_field_1_link\";s:1:\"#\";s:20:\"contact_icon_field_2\";s:15:\"far fa-envelope\";s:15:\"contact_field_2\";s:17:\"INFO@FOODKING.COM\";s:25:\"header_sidebar_email_link\";s:24:\"mailto:info@foodking.com\";s:20:\"contact_icon_field_3\";s:12:\"far fa-clock\";s:15:\"contact_field_3\";s:58:\"یکشنبه-جمعه، 9 صبح تا 5 بعد از ظهر\";s:20:\"contact_field_3_link\";s:16:\"tel:+11002345909\";s:20:\"contact_icon_field_4\";s:12:\"fas fa-phone\";s:15:\"contact_field_4\";s:12:\"+11002345909\";s:25:\"header_sidebar_phone_link\";s:16:\"tel:+11002345909\";s:9:\"order_btn\";s:30:\"اکنون سفارش دهید\";s:14:\"order_btn_link\";s:1:\"#\";s:23:\"foodking_footer_content\";s:25:\"[foodking_block id=\"134\"]\";s:13:\"cta_banner_bg\";a:5:{s:3:\"url\";s:73:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/main-cta-bg-2.jpg\";s:2:\"id\";s:3:\"129\";s:6:\"height\";s:3:\"377\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:81:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/main-cta-bg-2-150x150.jpg\";}s:11:\"cta_sec_img\";a:5:{s:3:\"url\";s:74:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/delivery-man-2.png\";s:2:\"id\";s:3:\"128\";s:6:\"height\";s:3:\"347\";s:5:\"width\";s:3:\"412\";s:9:\"thumbnail\";s:82:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/delivery-man-2-150x150.png\";}s:15:\"cta_shape_img_1\";a:5:{s:3:\"url\";s:68:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/image-11.png\";s:2:\"id\";s:4:\"2142\";s:6:\"height\";s:3:\"198\";s:5:\"width\";s:3:\"108\";s:9:\"thumbnail\";s:76:\"https://t-theme.com/foodking/wp-content/uploads/2024/08/image-11-108x150.png\";}s:15:\"cta_shape_img_2\";a:5:{s:3:\"url\";s:66:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/chilli.png\";s:2:\"id\";s:3:\"126\";s:6:\"height\";s:2:\"83\";s:5:\"width\";s:2:\"90\";s:9:\"thumbnail\";s:66:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/chilli.png\";}s:12:\"cta_subtitle\";s:27:\"ترد، هر لقمه ای\";s:11:\"cta_title_1\";s:22:\"30 دقیقه سریع\";s:11:\"cta_title_2\";s:10:\"تحویل\";s:11:\"cta_title_3\";s:8:\"چالش\";s:7:\"cta_btn\";s:30:\"اکنون سفارش دهید\";s:12:\"cta_btn_link\";s:1:\"#\";s:20:\"foodking_blog_layout\";s:9:\"container\";s:18:\"foodking_blog_grid\";s:19:\"col-lg-12 col-md-12\";s:21:\"foodking_blog_sidebar\";s:21:\"foodking_with_sidebar\";s:30:\"foodking_blog_sidebar_position\";s:5:\"right\";s:18:\"blog_header_banner\";a:5:{s:3:\"url\";s:70:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/breadcrumb.jpg\";s:2:\"id\";s:2:\"99\";s:6:\"height\";s:3:\"390\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:78:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/breadcrumb-150x150.jpg\";}s:15:\"blog_page_title\";s:19:\"صفحه وبلاگ\";s:9:\"read_more\";s:23:\"مشاهده بیشتر\";s:27:\"foodking_single_blog_layout\";s:9:\"container\";s:28:\"foodking_single_blog_sidebar\";s:28:\"foodking_with_single_sidebar\";s:37:\"foodking_single_blog_sidebar_position\";s:5:\"right\";s:25:\"single_blog_header_banner\";a:5:{s:3:\"url\";s:70:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/breadcrumb.jpg\";s:2:\"id\";s:2:\"99\";s:6:\"height\";s:3:\"390\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:78:\"https://t-theme.com/foodking/wp-content/uploads/2024/02/breadcrumb-150x150.jpg\";}s:22:\"single_blog_page_title\";s:24:\"صفحه بلاگ تکی\";s:16:\"error_page_title\";s:3:\"404\";s:15:\"error_page_desc\";s:39:\"متأسفیم صفحه یافت نشد\";s:21:\"error_page_action_url\";s:36:\"بازگشت به صفحه اصلی \";s:19:\"products_page_count\";s:1:\"8\";s:19:\"hide_product_banner\";s:1:\"0\";s:23:\"hide_product_breadcrumb\";s:1:\"0\";s:14:\"shop_banner_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"product_sidebar\";s:27:\"foodking_product_no_sidebar\";s:19:\"enable_product_meta\";s:1:\"1\";s:13:\"des_tab_title\";s:14:\"توضیحات\";s:16:\"review_tab_title\";s:15:\"بررسی ها\";s:22:\"foodking_social_target\";s:6:\"_blank\";s:12:\"facebook_url\";s:1:\"#\";s:11:\"twitter_url\";s:1:\"#\";s:9:\"vimeo_url\";s:1:\"#\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:13:\"pinterest_url\";s:1:\"#\";s:12:\"dribbble_url\";s:0:\"\";s:10:\"tumblr_url\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:10:\"flickr_url\";s:0:\"\";s:11:\"behance_url\";s:0:\"\";s:10:\"github_url\";s:0:\"\";s:9:\"skype_url\";s:0:\"\";s:7:\"rss_url\";s:0:\"\";s:10:\"tiktok_url\";s:0:\"\";s:10:\"gogole_url\";s:0:\"\";s:10:\"medium_url\";s:0:\"\";s:12:\"snapchat_url\";s:0:\"\";s:10:\"wechat_url\";s:0:\"\";s:12:\"whatsapp_url\";s:0:\"\";s:12:\"telegram_url\";s:0:\"\";s:13:\"primary_color\";s:7:\"#00813D\";s:15:\"secondary_color\";s:7:\"#D12525\";s:10:\"main_color\";s:7:\"#FFB936\";s:10:\"text_color\";s:7:\"#5C5C5B\";s:11:\"white_color\";s:7:\"#FFFFFF\";s:11:\"black_color\";s:7:\"#212121\";s:8:\"bg_color\";s:7:\"#F4F1EA\";s:19:\"top_header_bg_color\";s:7:\"#F4F1EA\";s:18:\"primary_typography\";a:2:{s:11:\"font-family\";s:7:\"Kalameh\";s:12:\"font-options\";s:0:\"\";}s:8:\"css_code\";s:0:\"\";s:7:\"js_code\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("580", "foodking_opt-transients", "a:5:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1724124245;s:13:\"last_compiler\";i:1724124245;s:11:\"last_import\";i:1724124245;s:7:\"notices\";a:2:{s:6:\"errors\";a:0:{}s:8:\"sanitize\";a:0:{}}}", "auto");
INSERT INTO `wp_options` VALUES("588", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("607", "yith_wcwl_ajax_enable", "yes", "on");
INSERT INTO `wp_options` VALUES("608", "yith_wcwl_after_add_to_wishlist_behaviour", "add", "on");
INSERT INTO `wp_options` VALUES("609", "yith_wcwl_show_on_loop", "no", "on");
INSERT INTO `wp_options` VALUES("610", "yith_wcwl_loop_position", "after_add_to_cart", "auto");
INSERT INTO `wp_options` VALUES("611", "yith_wcwl_button_position", "add-to-cart", "on");
INSERT INTO `wp_options` VALUES("612", "yith_wcwl_add_to_wishlist_text", "افزودن به لیست علاقه مندی", "on");
INSERT INTO `wp_options` VALUES("613", "yith_wcwl_product_added_text", "اضافه شد!", "auto");
INSERT INTO `wp_options` VALUES("614", "yith_wcwl_browse_wishlist_text", "", "on");
INSERT INTO `wp_options` VALUES("615", "yith_wcwl_already_in_wishlist_text", "محصول از قبل در لیست علاقه مندی های شما موجود است!", "on");
INSERT INTO `wp_options` VALUES("616", "yith_wcwl_add_to_wishlist_style", "link", "on");
INSERT INTO `wp_options` VALUES("617", "yith_wcwl_rounded_corners_radius", "16", "auto");
INSERT INTO `wp_options` VALUES("618", "yith_wcwl_add_to_wishlist_icon", "heart-outline", "auto");
INSERT INTO `wp_options` VALUES("619", "yith_wcwl_add_to_wishlist_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("620", "yith_wcwl_added_to_wishlist_icon", "heart", "auto");
INSERT INTO `wp_options` VALUES("621", "yith_wcwl_added_to_wishlist_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("622", "yith_wcwl_custom_css", "", "auto");
INSERT INTO `wp_options` VALUES("623", "yith_wcwl_variation_show", "no", "on");
INSERT INTO `wp_options` VALUES("624", "yith_wcwl_price_show", "yes", "auto");
INSERT INTO `wp_options` VALUES("625", "yith_wcwl_stock_show", "yes", "auto");
INSERT INTO `wp_options` VALUES("626", "yith_wcwl_show_dateadded", "no", "on");
INSERT INTO `wp_options` VALUES("627", "yith_wcwl_add_to_cart_show", "yes", "auto");
INSERT INTO `wp_options` VALUES("628", "yith_wcwl_show_remove", "yes", "auto");
INSERT INTO `wp_options` VALUES("629", "yith_wcwl_repeat_remove_button", "no", "on");
INSERT INTO `wp_options` VALUES("630", "yith_wcwl_redirect_cart", "no", "auto");
INSERT INTO `wp_options` VALUES("631", "yith_wcwl_remove_after_add_to_cart", "yes", "auto");
INSERT INTO `wp_options` VALUES("632", "yith_wcwl_enable_share", "yes", "auto");
INSERT INTO `wp_options` VALUES("633", "yith_wcwl_share_fb", "yes", "auto");
INSERT INTO `wp_options` VALUES("634", "yith_wcwl_share_twitter", "yes", "auto");
INSERT INTO `wp_options` VALUES("635", "yith_wcwl_share_pinterest", "yes", "auto");
INSERT INTO `wp_options` VALUES("636", "yith_wcwl_share_email", "yes", "auto");
INSERT INTO `wp_options` VALUES("637", "yith_wcwl_share_whatsapp", "yes", "auto");
INSERT INTO `wp_options` VALUES("638", "yith_wcwl_share_url", "no", "auto");
INSERT INTO `wp_options` VALUES("639", "yith_wcwl_socials_title", "لیست علاقه مندی های من در قالب فودکینگ", "auto");
INSERT INTO `wp_options` VALUES("640", "yith_wcwl_socials_text", "", "auto");
INSERT INTO `wp_options` VALUES("641", "yith_wcwl_socials_image_url", "", "auto");
INSERT INTO `wp_options` VALUES("642", "yith_wcwl_wishlist_title", "لیست علاقه مندی من", "on");
INSERT INTO `wp_options` VALUES("643", "yith_wcwl_add_to_cart_text", "افزودن به سبد خرید", "on");
INSERT INTO `wp_options` VALUES("645", "yith_wcwl_add_to_cart_style", "link", "auto");
INSERT INTO `wp_options` VALUES("646", "yith_wcwl_add_to_cart_rounded_corners_radius", "16", "auto");
INSERT INTO `wp_options` VALUES("647", "yith_wcwl_add_to_cart_icon", "shopping-cart", "auto");
INSERT INTO `wp_options` VALUES("648", "yith_wcwl_add_to_cart_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("649", "yith_wcwl_color_headers_background", "#F4F4F4", "auto");
INSERT INTO `wp_options` VALUES("650", "yith_wcwl_fb_button_icon", "default", "auto");
INSERT INTO `wp_options` VALUES("651", "yith_wcwl_fb_button_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("652", "yith_wcwl_tw_button_icon", "default", "auto");
INSERT INTO `wp_options` VALUES("653", "yith_wcwl_tw_button_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("654", "yith_wcwl_pr_button_icon", "default", "auto");
INSERT INTO `wp_options` VALUES("655", "yith_wcwl_pr_button_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("656", "yith_wcwl_em_button_icon", "default", "auto");
INSERT INTO `wp_options` VALUES("657", "yith_wcwl_em_button_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("658", "yith_wcwl_wa_button_icon", "default", "auto");
INSERT INTO `wp_options` VALUES("659", "yith_wcwl_wa_button_custom_icon", "", "auto");
INSERT INTO `wp_options` VALUES("660", "yit_plugin_fw_panel_wc_default_options_set", "a:1:{s:15:\"yith_wcwl_panel\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("663", "_elementor_installed_time", "1722642084", "auto");
INSERT INTO `wp_options` VALUES("664", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("665", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("721", "_transient_woocommerce_reports-transient-version", "1744462356", "on");
INSERT INTO `wp_options` VALUES("801", "rtl_rsm_dashboard", "a:2:{s:13:\"slideshowList\";a:1:{i:0;a:4:{s:4:\"type\";s:6:\"Slider\";s:5:\"title\";s:52:\"پروهاست وردپرس راست چین کلود\";s:8:\"imageUrl\";s:91:\"https://content-marketing.rtlcdn.com/image/2024/07/c811647c-7e1c-4843-af7d-06711183b9a6.jpg\";s:7:\"ctaLink\";s:23:\"http://rtlt.ir/cloudrtl\";}}s:17:\"dashboardSyncTime\";i:1730504472;}", "off");
INSERT INTO `wp_options` VALUES("802", "rtl_rsm_announcements", "a:3:{s:12:\"lastSyncTime\";i:1730504472;s:4:\"List\";a:1:{i:280702;a:10:{s:2:\"id\";i:4;s:15:\"announcement_id\";i:280702;s:5:\"title\";s:67:\"🔴 اطلاعیه مهم: نحوه اشکال زدایی دستی\";s:7:\"excerpt\";s:935:\"<p>🚩در صورتی که پس از نصب و یا بروز رسانی افزونه لایسنس محصولات غیر فعال و یا وبسایت دچار اختلال شد با انجام مراحل زیر بصورت دستی اقدام به اشکال زدایی دستی نموده در غیر اینصورت منتظر بمانید تا افزونه بصورت خودکار اشکال زدایی را انجام و لایسنس محصولات را فعال نماید. 📌 در ابتدا از بروز بودن افزونه به آخرین نسخه موجود اطمینان حاصل کنید&#8221;از طریق صفحه محصول در وبسایت راست چین&#8221;👇 صفحه محصول افزونه 📌در قسمت مدیریت لایسنس و بخش انتخاب سرور ، سرور را از حالت خودکار به یکی از سرور های پیشنهاد شده تغییر داده و [&hellip;]</p>\n\";s:7:\"content\";s:2366:\"<p><a href=\"https://www.rtl-theme.com/rtl-smart-management\"><img decoding=\"async\" loading=\"lazy\" class=\"aligncenter size-full \" src=\"https://media.rtlcdn.com/2024/08/251b12419aea5720a810d54464fc3eb343e8211c61d796.jpg\" alt=\"\" width=\"1203\" height=\"294\" /></a><br />\n🚩در صورتی که پس از نصب و یا بروز رسانی افزونه لایسنس محصولات غیر فعال و یا وبسایت دچار اختلال شد با انجام مراحل زیر بصورت دستی اقدام به اشکال زدایی دستی نموده در غیر اینصورت منتظر بمانید تا افزونه بصورت خودکار اشکال زدایی را انجام و لایسنس محصولات را فعال نماید.<br />\n📌 در ابتدا از بروز بودن افزونه به آخرین نسخه موجود اطمینان حاصل کنید&#8221;از طریق صفحه محصول در وبسایت راست چین&#8221;👇<br />\n<strong><a href=\"https://www.rtl-theme.com/rtl-smart-management\">صفحه محصول افزونه</a></strong><br />\n📌در قسمت مدیریت لایسنس و بخش انتخاب سرور ، سرور را از حالت خودکار به یکی از سرور های پیشنهاد شده تغییر داده و ثبت و ذخیره سازی سرور را انجام دهید.<br />\n📌دکمه اشکال زدایی را زده و منتظر انجام فرآیند باشید، چنانچه با خطای تست ازتباط با سرور و یا سایر خطاها مواجه شدید با صرف نطر کردن از این خطاها اقدام به چک کردن فعال بودن محصولات خود نمایید.<br />\n📌در صورتی که با انجام مراحل بالا لایسنس محصولات فعال نبوده این فرایند را با انتخاب سرور دیگر انجام دهید.<br />\n📌در نهایت چنانچه با امتحان تمامی سرور ها همچنان با اشکال زدایی دستی و فعال کردن لایسنس محصولات به مشکل برخوردید از قسمت راهنما و دکمه پشتیبانی و با ارسال اطلاعات مورد نیاز &#8220;لینک ورود به سایت ،یوزرنیم ، پسورد&#8221; منتظربررسی و حل مشکل توسط همکاران ما باشید.</p>\n\";s:5:\"image\";s:100:\"https://www.rtl-theme.com/wp-content/themes/rtl-theme/assets/images/defaults/product-cover-large.png\";s:8:\"category\";N;s:6:\"sticky\";N;s:10:\"created_at\";s:27:\"2024-08-12T05:51:54.000000Z\";s:10:\"updated_at\";s:27:\"2024-08-12T05:53:14.000000Z\";}}s:7:\"visited\";a:1:{i:0;s:6:\"280702\";}}", "off");
INSERT INTO `wp_options` VALUES("1388", "elementor_log", "a:43:{s:32:\"581ae739215cf04c51991a8b31445d84\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-08 05:58:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-08 05:58:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"deef832e4f86844d388995e87320f685\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-08 05:58:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.26.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-08 05:58:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.26.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"44f04428a60d846fddd4c3d66e128482\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-16 06:00:04\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.4\";s:2:\"to\";s:6:\"3.26.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-16 06:00:04\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.4\";s:2:\"to\";s:6:\"3.26.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"45fbe643d118e78a9bee9e07c97d8f13\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-16 06:00:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-16 06:00:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"78016f026c700276c0a7d26a9408d166\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-16 06:00:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-16 06:00:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"61a75f8986e4898eef042b26fcb9962c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-16 06:00:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-16 06:00:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5af439d3414da2996a18b3c410ab38fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-16 06:00:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.4\";s:2:\"to\";s:6:\"3.26.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-16 06:00:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.4\";s:2:\"to\";s:6:\"3.26.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4574cdb42093b31ce0b9548a3fa025c9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:31\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fa5a03815fba8f0296e2f9450ce98904\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:32\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"9a8a0f1c0a82f128688c8a9d03c92d0e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:32\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"cca609e3d0ddb856e32da2b959a907e3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:32\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"457e0f4fe63e8e8c839b85f804297113\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:32\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"edb92b8e1613f0a46522146cc60eb4f0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-01-21 06:02:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-21 06:02:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.26.5\";s:2:\"to\";s:6:\"3.27.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ed308d01009a02c99494b0e7931fed88\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-29 01:07:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-29 01:07:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f48057266720f19cb6d5e6c46527a3a7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-29 01:07:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-29 01:07:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"40b91570fb39be58ecfdd863ec06bd5f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-29 01:07:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-29 01:07:55\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"66b7e895be5f313130fda75e5c690a94\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-29 01:07:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.0\";s:2:\"to\";s:6:\"3.28.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-29 01:07:55\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.0\";s:2:\"to\";s:6:\"3.28.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"3b509c468a9dbc04867f78ec6ff669fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:08\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0eb03b1e8e2753df0682430d7799e55f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f73a4d578d3f8a03105d258ffaf58018\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"23f83b2b0de65f9867367fb01cf187be\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"721811aecf6865ab6b750a3bf76e209e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:08\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e156c363b858561874d158819625088a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-31 05:56:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-31 05:56:10\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"db7433cfc28a14da2c4533ec375f8263\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-29 23:43:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-29 23:43:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7835794f8d172402df73756d4af1d0a2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-29 23:43:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-29 23:43:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ae7b8cae1815cf826d24a908ef2a8493\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-29 23:43:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-29 23:43:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"70753aca69e9d05fb30ca01a8d0e9477\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-29 23:43:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-29 23:43:15\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1f29a5c95a0cae01f10229a674f0973c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1131b66c8f7bf64070b24b66befce82c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c8b8b1964be2209f083abe8f2669d018\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"bbddae7efadf6ad7f32d2168b713ecce\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"6ac5459111cb92ca3585eb4da47e2521\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"7d196b0320a061a677ac1dc3100b0872\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-02 05:56:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-02 05:56:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"7ae604c4d3fda98e0d146075d94832ce\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-09 08:16:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-09 08:16:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d6684b9469a2369fe77683fc9fd36a33\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-09 08:16:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-09 08:16:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"bf4d8ff52aaccedf0260637c69d00661\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-09 08:16:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-09 08:16:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"bae471e20eb57dff9a1273eacbb4abaf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-09 08:16:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.31.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-09 08:16:52\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.31.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"12f36e3120227b641ff596ba5d0f374b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-09 08:16:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.31.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-09 08:16:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.31.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d385f7d58f1310a29902839448a84eb5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-09 01:11:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-09 01:11:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"00f9b7551185f15dd1f75602386e690d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-09 01:11:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-09 01:11:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"bdad66a427b72858d46639926a932ee0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-09 01:11:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-09 01:11:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"663e701cdcbffd6e562053b2a7eb7e2d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-09 01:11:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-09 01:11:15\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"55776bf6ee568d0b33235f5009b51ed1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-09 01:11:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-09 01:11:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.31.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("1415", "_transient_product_query-transient-version", "1762638067", "on");
INSERT INTO `wp_options` VALUES("1426", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("1446", "_transient_product-transient-version", "1722812695", "on");
INSERT INTO `wp_options` VALUES("1450", "woocommerce_demo_store_notice", "This is a demo store for testing purposes &mdash; no orders shall be fulfilled.", "on");
INSERT INTO `wp_options` VALUES("1451", "woocommerce_shop_page_display", "", "on");
INSERT INTO `wp_options` VALUES("1452", "woocommerce_category_archive_display", "", "on");
INSERT INTO `wp_options` VALUES("1453", "woocommerce_default_catalog_orderby", "date", "on");
INSERT INTO `wp_options` VALUES("1454", "woocommerce_thumbnail_cropping", "1:1", "on");
INSERT INTO `wp_options` VALUES("1455", "woocommerce_thumbnail_cropping_custom_width", "4", "on");
INSERT INTO `wp_options` VALUES("1456", "woocommerce_thumbnail_cropping_custom_height", "3", "on");
INSERT INTO `wp_options` VALUES("1457", "woocommerce_checkout_company_field", "optional", "on");
INSERT INTO `wp_options` VALUES("1458", "woocommerce_checkout_address_2_field", "optional", "on");
INSERT INTO `wp_options` VALUES("1459", "woocommerce_checkout_phone_field", "required", "on");
INSERT INTO `wp_options` VALUES("1460", "woocommerce_checkout_terms_and_conditions_checkbox_text", "I have read and agree to the website [terms]", "on");
INSERT INTO `wp_options` VALUES("1461", "nav_menus_created_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("1677", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1753893414;s:5:\"value\";s:15287:\"[{\"id\":\"send-cart-widget\",\"title\":\"Introducing: Cart Widget\",\"description\":\"Show customers exactly what they left behind\\u2014visually. The new Cart Widget adds product images to your emails for smarter, higher-converting cart recovery.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cart-widget-send.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Explore Cart Widget\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/WN_CartW\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"tools-3.30\",\"title\":\"Essential Editor tools\",\"description\":\"V4 now includes a long list of essential V3 capabilities, re-engineered to fit the new framework - IDs, custom unit, anchor offset, display none, object fit, clear icons and more!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tools-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"send-notification-june\",\"title\":\"A whole new onboarding experience\",\"description\":\"Try the new onboarding now: Launch abandoned cart recovery, welcome flows & more in minutes. No setup stress\\u2014just smarter automation from day one.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-june.png\",\"chipTags\":[\"New Features\"],\"cta\":\"Check Out\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/New_June\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("1689", "_elementor_settings_update_time", "1723419660", "auto");
INSERT INTO `wp_options` VALUES("1690", "elementor_cpt_support", "a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:5:\"teams\";i:4;s:7:\"product\";i:5;s:15:\"foodking_blocks\";}", "auto");
INSERT INTO `wp_options` VALUES("1691", "elementor_disable_color_schemes", "yes", "auto");
INSERT INTO `wp_options` VALUES("1692", "elementor_disable_typography_schemes", "yes", "auto");
INSERT INTO `wp_options` VALUES("1693", "elementor_allow_tracking", "no", "auto");
INSERT INTO `wp_options` VALUES("1694", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("1695", "elementor_editor_break_lines", "", "auto");
INSERT INTO `wp_options` VALUES("1696", "elementor_unfiltered_files_upload", "", "auto");
INSERT INTO `wp_options` VALUES("1697", "elementor_google_font", "1", "auto");
INSERT INTO `wp_options` VALUES("1698", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `wp_options` VALUES("1699", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `wp_options` VALUES("1700", "elementor_css_print_method", "external", "auto");
INSERT INTO `wp_options` VALUES("1701", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("1702", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("1703", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `wp_options` VALUES("1704", "elementor_experiment-e_optimized_control_loading", "default", "auto");
INSERT INTO `wp_options` VALUES("1705", "elementor_experiment-editor_v2", "default", "auto");
INSERT INTO `wp_options` VALUES("1706", "elementor_experiment-landing-pages", "default", "auto");
INSERT INTO `wp_options` VALUES("1707", "elementor_experiment-container", "default", "auto");
INSERT INTO `wp_options` VALUES("1708", "elementor_experiment-nested-elements", "default", "auto");
INSERT INTO `wp_options` VALUES("1709", "elementor_experiment-e_element_cache", "default", "auto");
INSERT INTO `wp_options` VALUES("1710", "elementor_experiment-link-in-bio", "default", "auto");
INSERT INTO `wp_options` VALUES("1711", "elementor_experiment-floating-buttons", "default", "auto");
INSERT INTO `wp_options` VALUES("1712", "elementor_experiment-e_optimized_css_loading", "default", "auto");
INSERT INTO `wp_options` VALUES("1713", "elementor_experiment-e_font_icon_svg", "default", "auto");
INSERT INTO `wp_options` VALUES("1714", "elementor_experiment-additional_custom_breakpoints", "default", "auto");
INSERT INTO `wp_options` VALUES("1715", "elementor_experiment-container_grid", "default", "auto");
INSERT INTO `wp_options` VALUES("1716", "elementor_experiment-e_swiper_latest", "default", "auto");
INSERT INTO `wp_options` VALUES("1717", "elementor_experiment-ai-layout", "default", "auto");
INSERT INTO `wp_options` VALUES("1718", "elementor_experiment-e_lazyload", "default", "auto");
INSERT INTO `wp_options` VALUES("1789", "woocommerce_share_key", "JjP0j2uiu8ofKKngg4lji1pbCurqVQno", "auto");
INSERT INTO `wp_options` VALUES("1800", "woocommerce_task_list_tracked_completed_tasks", "a:3:{i:0;s:8:\"products\";i:1;s:17:\"launch-your-store\";i:2;s:8:\"payments\";}", "auto");
INSERT INTO `wp_options` VALUES("1892", "woocommerce_custom_orders_table_data_sync_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("4794", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("5352", "_transient_shipping-transient-version", "1722727265", "on");
INSERT INTO `wp_options` VALUES("7203", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("7204", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("7205", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("17447", "yith_wcwl_color_add_to_wishlist", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#333333\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#333333\";}", "on");
INSERT INTO `wp_options` VALUES("17487", "yith_system_info", "a:3:{s:11:\"system_info\";a:13:{s:14:\"min_wp_version\";a:1:{s:5:\"value\";s:5:\"6.6.1\";}s:14:\"min_wc_version\";a:1:{s:5:\"value\";s:5:\"9.1.4\";}s:15:\"wp_memory_limit\";a:1:{s:5:\"value\";i:1073741824;}s:15:\"min_php_version\";a:1:{s:5:\"value\";s:6:\"7.4.33\";}s:15:\"min_tls_version\";a:1:{s:5:\"value\";s:3:\"1.3\";}s:15:\"imagick_version\";a:1:{s:5:\"value\";s:5:\"7.1.1\";}s:15:\"wp_cron_enabled\";a:1:{s:5:\"value\";b:1;}s:16:\"mbstring_enabled\";a:1:{s:5:\"value\";b:1;}s:17:\"simplexml_enabled\";a:1:{s:5:\"value\";b:1;}s:10:\"gd_enabled\";a:1:{s:5:\"value\";b:1;}s:13:\"iconv_enabled\";a:1:{s:5:\"value\";b:1;}s:15:\"opcache_enabled\";a:1:{s:5:\"value\";b:0;}s:17:\"url_fopen_enabled\";a:1:{s:5:\"value\";s:1:\"1\";}}s:6:\"errors\";b:0;s:6:\"tables\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("21618", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:42:\"پرداخت نقدی پس از تحویل\";s:12:\"instructions\";s:42:\"پرداخت نقدی پس از تحویل\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:3:\"yes\";}", "on");
INSERT INTO `wp_options` VALUES("21632", "woocommerce_gateway_order", "a:4:{s:33:\"_wc_offline_payment_methods_group\";i:0;s:4:\"bacs\";i:1;s:6:\"cheque\";i:2;s:3:\"cod\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("22384", "loco_recent", "a:4:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:3:{s:14:\"theme.foodking\";i:1722983358;s:41:\"plugin.yith-woocommerce-wishlist/init.php\";i:1722985325;s:43:\"plugin.contact-form-7/wp-contact-form-7.php\";i:1723337158;}}s:1:\"t\";i:1723337158;}", "off");
INSERT INTO `wp_options` VALUES("22817", "woocommerce_maybe_regenerate_images_hash", "f0a016bb3bb0cf5611a64489dc3e3934", "auto");
INSERT INTO `wp_options` VALUES("25115", "yith_wcwl_color_add_to_cart", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "on");
INSERT INTO `wp_options` VALUES("25116", "yith_wcwl_color_button_style_1", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "on");
INSERT INTO `wp_options` VALUES("25117", "yith_wcwl_color_button_style_2", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#4F4F4F\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#4F4F4F\";}", "on");
INSERT INTO `wp_options` VALUES("25118", "yith_wcwl_color_wishlist_table", "a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:4:\"text\";s:7:\"#6d6c6c\";s:6:\"border\";s:7:\"#FFFFFF\";}", "on");
INSERT INTO `wp_options` VALUES("25119", "yith_wcwl_color_share_button", "a:2:{s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"color_hover\";s:7:\"#FFFFFF\";}", "on");
INSERT INTO `wp_options` VALUES("25120", "yith_wcwl_color_fb_button", "a:2:{s:10:\"background\";s:7:\"#39599E\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "on");
INSERT INTO `wp_options` VALUES("25121", "yith_wcwl_color_tw_button", "a:2:{s:10:\"background\";s:7:\"#45AFE2\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "on");
INSERT INTO `wp_options` VALUES("25122", "yith_wcwl_color_pr_button", "a:2:{s:10:\"background\";s:7:\"#AB2E31\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "on");
INSERT INTO `wp_options` VALUES("25123", "yith_wcwl_color_em_button", "a:2:{s:10:\"background\";s:7:\"#FBB102\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "on");
INSERT INTO `wp_options` VALUES("25124", "yith_wcwl_color_wa_button", "a:2:{s:10:\"background\";s:7:\"#00A901\";s:16:\"background_hover\";s:7:\"#595A5A\";}", "on");
INSERT INTO `wp_options` VALUES("26016", "_transient_orders-transient-version", "1731189655", "on");
INSERT INTO `wp_options` VALUES("26123", "woocommerce_admin_last_orders_milestone", "1", "auto");
INSERT INTO `wp_options` VALUES("26306", "woocommerce_sales_record_date", "2024-11-10", "auto");
INSERT INTO `wp_options` VALUES("26307", "woocommerce_sales_record_amount", "429", "auto");
INSERT INTO `wp_options` VALUES("26689", "new_admin_email", "mahdiwir80@outlook.com", "auto");
INSERT INTO `wp_options` VALUES("26919", "secret_key", "Nl>,&*7~E;>!3C<jz?^6n(Z3,,NTMER$)FHs[H}XMNS,v+wf 8OAc@<j[b8<b+T_", "off");
INSERT INTO `wp_options` VALUES("28444", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1723608250;s:5:\"value\";s:8379:\"{\"top\":{\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("28464", "_transient_timeout_dirsize_cache", "2038952593", "off");
INSERT INTO `wp_options` VALUES("28465", "_transient_dirsize_cache", "a:1964:{s:51:\"/home/tthemeco/public_html/foodking/wp-admin/images\";i:426821;s:50:\"/home/tthemeco/public_html/foodking/wp-admin/maint\";i:7592;s:55:\"/home/tthemeco/public_html/foodking/wp-admin/js/widgets\";i:139432;s:47:\"/home/tthemeco/public_html/foodking/wp-admin/js\";i:1971224;s:49:\"/home/tthemeco/public_html/foodking/wp-admin/user\";i:3685;s:52:\"/home/tthemeco/public_html/foodking/wp-admin/network\";i:125999;s:60:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/blue\";i:77778;s:61:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/ocean\";i:75229;s:61:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/light\";i:78474;s:63:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/sunrise\";i:78407;s:62:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/modern\";i:77989;s:62:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/coffee\";i:75892;s:65:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/ectoplasm\";i:77742;s:64:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors/midnight\";i:78486;s:55:\"/home/tthemeco/public_html/foodking/wp-admin/css/colors\";i:643556;s:48:\"/home/tthemeco/public_html/foodking/wp-admin/css\";i:2542173;s:53:\"/home/tthemeco/public_html/foodking/wp-admin/includes\";i:3068919;s:44:\"/home/tthemeco/public_html/foodking/wp-admin\";i:9109869;s:51:\"/home/tthemeco/public_html/foodking/wp-includes/ID3\";i:1160011;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Decode/HTML\";i:17241;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Decode\";i:17241;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Content/Type\";i:8015;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Content\";i:8015;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/HTTP\";i:11487;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Parse\";i:20551;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/XML/Declaration\";i:7098;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/XML\";i:7098;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Cache\";i:39607;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie/Net\";i:7493;s:57:\"/home/tthemeco/public_html/foodking/wp-includes/SimplePie\";i:458625;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/images/media\";i:5263;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/images/crystal\";i:15541;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/images/smilies\";i:10082;s:54:\"/home/tthemeco/public_html/foodking/wp-includes/images\";i:102178;s:54:\"/home/tthemeco/public_html/foodking/wp-includes/assets\";i:24990;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/interactivity-api\";i:55221;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/certificates\";i:233231;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/library\";i:261;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Proxy\";i:4217;s:68:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Utility\";i:7176;s:75:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Exception/Http\";i:16715;s:80:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Exception/Transport\";i:1397;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Exception\";i:22464;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Cookie\";i:4363;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Auth\";i:2541;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Transport\";i:35470;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src/Response\";i:3101;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/Requests/src\";i:214849;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/Requests\";i:215110;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/block-supports\";i:130165;s:57:\"/home/tthemeco/public_html/foodking/wp-includes/PHPMailer\";i:233227;s:52:\"/home/tthemeco/public_html/foodking/wp-includes/l10n\";i:30499;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/html-api\";i:330488;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/site-tagline\";i:1625;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/latest-posts\";i:11776;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/group\";i:9055;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/list\";i:2173;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-author-biography\";i:971;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/social-link\";i:3474;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/block\";i:587;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-terms\";i:1715;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/social-links\";i:58808;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-featured-image\";i:29684;s:58:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/rss\";i:4491;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/footnotes\";i:2642;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/page-list-item\";i:1109;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/pattern\";i:411;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-title\";i:1392;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/video\";i:11619;s:83:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments-pagination-previous\";i:1023;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-author-name\";i:1118;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-template\";i:2910;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/columns\";i:9193;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/table\";i:27351;s:68:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/legacy-widget\";i:556;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments\";i:28882;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-comments-form\";i:9737;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-date\";i:1112;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-no-results\";i:899;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-excerpt\";i:2925;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-pagination\";i:9403;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/more\";i:3770;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-author-name\";i:1192;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/gallery\";i:80571;s:80:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-pagination-previous\";i:1051;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query\";i:14007;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/column\";i:1597;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/spacer\";i:4737;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/read-more\";i:2526;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/avatar\";i:2296;s:75:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-navigation-link\";i:4010;s:68:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-template\";i:8072;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-content\";i:1369;s:82:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments-pagination-numbers\";i:1833;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments-pagination\";i:8628;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-author\";i:2895;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/calendar\";i:3804;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/freeform\";i:41824;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments-pagination-next\";i:1011;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-edit-link\";i:1213;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/search\";i:19592;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/term-description\";i:1751;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/button\";i:14416;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/navigation-submenu\";i:5842;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/tag-cloud\";i:3616;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/details\";i:2030;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/nextpage\";i:3039;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/site-logo\";i:17033;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/quote\";i:6526;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/media-text\";i:14445;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/buttons\";i:11183;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/home-link\";i:1130;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-content\";i:1389;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/widget-group\";i:400;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/embed\";i:11232;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/shortcode\";i:2918;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/audio\";i:3660;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/separator\";i:5038;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/html\";i:3770;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/archives\";i:1725;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-title\";i:1823;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comments-title\";i:1701;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/comment-reply-link\";i:1001;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/site-title\";i:2289;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-pagination-next\";i:1039;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/preformatted\";i:1696;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/categories\";i:2825;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/image\";i:64157;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/paragraph\";i:6904;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/query-pagination-numbers\";i:1942;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/text-columns\";i:3034;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/loginout\";i:1026;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/page-list\";i:7663;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/pullquote\";i:8267;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/verse\";i:1860;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/missing\";i:617;s:68:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/template-part\";i:7986;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/latest-comments\";i:6657;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/navigation\";i:132149;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/navigation-link\";i:11752;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/post-date\";i:1377;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/cover\";i:83346;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/file\";i:11514;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/code\";i:2638;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/heading\";i:5731;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/blocks/list-item\";i:1137;s:54:\"/home/tthemeco/public_html/foodking/wp-includes/blocks\";i:1503913;s:51:\"/home/tthemeco/public_html/foodking/wp-includes/IXR\";i:33915;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/block-bindings\";i:3610;s:52:\"/home/tthemeco/public_html/foodking/wp-includes/pomo\";i:57146;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/js/imgareaselect\";i:49553;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/js/thickbox\";i:31323;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/js/mediaelement/renderers\";i:18880;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/js/mediaelement\";i:721307;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/js/jcrop\";i:24976;s:59:\"/home/tthemeco/public_html/foodking/wp-includes/js/plupload\";i:490468;s:55:\"/home/tthemeco/public_html/foodking/wp-includes/js/crop\";i:20004;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/js/jquery/ui\";i:787634;s:57:\"/home/tthemeco/public_html/foodking/wp-includes/js/jquery\";i:1305370;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/js/dist/development\";i:179848;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/js/dist/vendor\";i:2753435;s:55:\"/home/tthemeco/public_html/foodking/wp-includes/js/dist\";i:21234878;s:75:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:78:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpeditimage\";i:37711;s:77:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/link\";i:32949;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/media\";i:57914;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:81:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:75:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/paste\";i:113193;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wplink\";i:26816;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:80:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/lists\";i:97383;s:78:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/hr\";i:1347;s:73:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/image\";i:55874;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wordpress\";i:50628;s:76:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/plugins\";i:607301;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/themes/inlite\";i:452642;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/themes/modern\";i:446221;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/themes\";i:898863;s:78:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:80:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:81:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins/wordpress/images\";i:14207;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins/wordpress\";i:22831;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/skins\";i:233085;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/langs\";i:15529;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce/utils\";i:18826;s:58:\"/home/tthemeco/public_html/foodking/wp-includes/js/tinymce\";i:2854127;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/js/codemirror\";i:1287141;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/js/swfupload\";i:8715;s:50:\"/home/tthemeco/public_html/foodking/wp-includes/js\";i:30443441;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/sitemaps/providers\";i:17593;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/sitemaps\";i:47491;s:86:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:91:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:88:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:86:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:77:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/namespaced\";i:2698;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/lib\";i:87360;s:85:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:81:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:86:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:83:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:81:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core32\";i:437041;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/PHP52\";i:4116;s:77:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/Base64\";i:22135;s:83:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:84:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:7881;s:81:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/Curve25519\";i:121645;s:79:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src/Core\";i:452743;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat/src\";i:1207254;s:61:\"/home/tthemeco/public_html/foodking/wp-includes/sodium_compat\";i:1303525;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/commands\";i:13442;s:71:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/format-library\";i:5556;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/editor\";i:249100;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/edit-widgets\";i:95440;s:68:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/preferences\";i:8474;s:70:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/block-library\";i:805380;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/block-directory\";i:15116;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/edit-post\";i:52240;s:67:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/components\";i:357993;s:77:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/list-reusable-blocks\";i:17928;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/nux\";i:11624;s:74:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/customize-widgets\";i:23886;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/edit-site\";i:337302;s:69:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/block-editor\";i:617115;s:65:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/patterns\";i:7442;s:72:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/reusable-blocks\";i:2290;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist/widgets\";i:23740;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/css/dist\";i:2644068;s:51:\"/home/tthemeco/public_html/foodking/wp-includes/css\";i:3289825;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/Text/Diff/Renderer\";i:5528;s:64:\"/home/tthemeco/public_html/foodking/wp-includes/Text/Diff/Engine\";i:31802;s:57:\"/home/tthemeco/public_html/foodking/wp-includes/Text/Diff\";i:44136;s:52:\"/home/tthemeco/public_html/foodking/wp-includes/Text\";i:57049;s:57:\"/home/tthemeco/public_html/foodking/wp-includes/customize\";i:177349;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/theme-compat\";i:15656;s:60:\"/home/tthemeco/public_html/foodking/wp-includes/style-engine\";i:47528;s:53:\"/home/tthemeco/public_html/foodking/wp-includes/fonts\";i:326266;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/rest-api/fields\";i:22510;s:66:\"/home/tthemeco/public_html/foodking/wp-includes/rest-api/endpoints\";i:848388;s:63:\"/home/tthemeco/public_html/foodking/wp-includes/rest-api/search\";i:16749;s:56:\"/home/tthemeco/public_html/foodking/wp-includes/rest-api\";i:977234;s:62:\"/home/tthemeco/public_html/foodking/wp-includes/block-patterns\";i:8843;s:55:\"/home/tthemeco/public_html/foodking/wp-includes/widgets\";i:158524;s:58:\"/home/tthemeco/public_html/foodking/wp-includes/php-compat\";i:1253;s:47:\"/home/tthemeco/public_html/foodking/wp-includes\";i:48794197;s:54:\"/home/tthemeco/public_html/foodking/wp-content/upgrade\";i:0;s:64:\"/home/tthemeco/public_html/foodking/wp-content/languages/plugins\";i:7745870;s:63:\"/home/tthemeco/public_html/foodking/wp-content/languages/themes\";i:251365;s:56:\"/home/tthemeco/public_html/foodking/wp-content/languages\";i:12724312;s:67:\"/home/tthemeco/public_html/foodking/wp-content/backups-dup-lite/tmp\";i:17;s:63:\"/home/tthemeco/public_html/foodking/wp-content/backups-dup-lite\";i:173198673;s:74:\"/home/tthemeco/public_html/foodking/wp-content/upgrade-temp-backup/plugins\";i:0;s:66:\"/home/tthemeco/public_html/foodking/wp-content/upgrade-temp-backup\";i:0;s:46:\"/home/tthemeco/public_html/foodking/wp-content\";i:185923013;s:49:\"/home/tthemeco/public_html/foodking/.wp-cli/cache\";i:0;s:43:\"/home/tthemeco/public_html/foodking/.wp-cli\";i:0;s:35:\"/home/tthemeco/public_html/foodking\";i:244024353;s:98:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets/fonts/ibm-plex-mono\";i:148118;s:101:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets/fonts/source-serif-pro\";i:1409152;s:92:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets/fonts/dm-sans\";i:128429;s:90:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets/fonts/inter\";i:807760;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets/fonts\";i:2493459;s:78:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/assets\";i:2493459;s:77:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/parts\";i:878;s:81:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/templates\";i:10482;s:78:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/styles\";i:52636;s:80:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree/patterns\";i:9341;s:71:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentythree\";i:2667552;s:83:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/images\";i:1503139;s:83:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/videos\";i:468755;s:91:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/fonts/ibm-plex\";i:423403;s:99:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/fonts/source-serif-pro\";i:1409152;s:90:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/fonts/dm-sans\";i:301601;s:88:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/fonts/inter\";i:809786;s:82:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets/fonts\";i:4348514;s:76:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/assets\";i:6320408;s:75:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/parts\";i:2864;s:82:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/inc/patterns\";i:158253;s:73:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/inc\";i:162261;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/templates\";i:13966;s:76:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo/styles\";i:11351;s:69:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentytwo\";i:6693745;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/images\";i:1152100;s:81:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/css\";i:357;s:99:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/fonts/instrument-sans\";i:187522;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/fonts/inter\";i:331004;s:88:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/fonts/jost\";i:116852;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/fonts/cardo\";i:388180;s:83:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets/fonts\";i:1023558;s:77:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/assets\";i:2176015;s:76:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/parts\";i:1473;s:80:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/templates\";i:12953;s:77:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/styles\";i:33892;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour/patterns\";i:158957;s:70:\"/home/tthemeco/public_html/foodking/wp-content/themes/twentytwentyfour\";i:3137090;s:78:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/webfonts\";i:930052;s:72:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/js\";i:449172;s:73:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/css\";i:1049895;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/img/about\";i:16314;s:80:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/img/client\";i:247437;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/img/shape\";i:32081;s:78:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/img/icon\";i:88403;s:73:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/img\";i:654462;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iranyekan/ttf\";i:485244;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iranyekan/eot\";i:487756;s:90:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iranyekan/woff\";i:270144;s:85:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iranyekan\";i:1249335;s:85:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/dana/woff\";i:146236;s:86:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/dana/woff2\";i:109736;s:80:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/dana\";i:257127;s:88:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iransans/ttf\";i:247292;s:88:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iransans/eot\";i:248452;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iransans/woff\";i:151072;s:90:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iransans/woff2\";i:118932;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/iransans\";i:770208;s:88:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/kalemeh/woff\";i:260084;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/kalemeh/woff2\";i:200656;s:83:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts/kalemeh\";i:461858;s:75:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets/fonts\";i:5600512;s:69:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/assets\";i:8684093;s:72:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/languages\";i:171187;s:74:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/lib/plugins\";i:7924099;s:76:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/lib/demo-data\";i:2536585;s:66:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/lib\";i:10603796;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/template-parts/header\";i:27343;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/template-parts/footer\";i:942;s:77:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/template-parts\";i:32326;s:66:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/inc\";i:110463;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/cart\";i:15375;s:83:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/checkout\";i:11479;s:79:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/loop\";i:5859;s:81:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/global\";i:2232;s:84:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/myaccount\";i:15715;s:94:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/single-product/tabs\";i:3833;s:101:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/single-product/add-to-cart\";i:3534;s:89:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce/single-product\";i:13944;s:74:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/woocommerce\";i:112493;s:68:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking/.idea\";i:5401;s:62:\"/home/tthemeco/public_html/foodking/wp-content/themes/foodking\";i:20154257;s:53:\"/home/tthemeco/public_html/foodking/wp-content/themes\";i:32652672;s:72:\"/home/tthemeco/public_html/foodking/wp-content/plugins/classic-editor/js\";i:624;s:69:\"/home/tthemeco/public_html/foodking/wp-content/plugins/classic-editor\";i:63801;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/languages\";i:1326193;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/blue\";i:10213;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/ocean\";i:10252;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/light\";i:10156;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/sunrise\";i:10264;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/coffee\";i:10225;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/ectoplasm\";i:10225;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/fresh\";i:10259;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/classic\";i:68558;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors/midnight\";i:10225;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/colors\";i:161380;s:123:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/elusive-icons/scss\";i:85049;s:118:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/elusive-icons\";i:144991;s:119:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/select2/mixins\";i:1127;s:126:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/select2/theme/default\";i:16604;s:126:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/select2/theme/classic\";i:16325;s:118:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/select2/theme\";i:33008;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor/select2\";i:84784;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss/vendor\";i:648482;s:97:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/scss\";i:915519;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/font-awesome/webfonts\";i:1010680;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/font-awesome/css\";i:312606;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/font-awesome\";i:1323286;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/redux\";i:58429;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/media\";i:9813;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/spectrum\";i:85407;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/block-ui\";i:29460;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/qtip\";i:152997;s:119:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/select2-sortable\";i:28925;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/wp-color-picker-alpha\";i:23642;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/nouislider\";i:49226;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor/select2\";i:226419;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js/vendor\";i:655466;s:95:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/js\";i:894241;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/blue\";i:41638;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/ocean\";i:41656;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/light\";i:41503;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/sunrise\";i:41674;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/coffee\";i:41656;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/ectoplasm\";i:41656;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/fresh\";i:41691;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/classic\";i:199660;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors/midnight\";i:41656;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/colors\";i:532869;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css/vendor\";i:666753;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/css\";i:2309972;s:120:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/img/raw/jquery-ui-bootstrap\";i:36134;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/img/raw\";i:58952;s:116:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/img/jquery-ui-bootstrap\";i:44505;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/img\";i:110176;s:98:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets/fonts\";i:337251;s:92:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/assets\";i:5890524;s:95:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/languages\";i:510143;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/welcome/views\";i:5960;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/welcome/js\";i:1725;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/welcome/css\";i:33403;s:97:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/welcome\";i:47644;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/comma_numeric\";i:1301;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/unique_slug\";i:2910;s:106:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/color\";i:1907;s:106:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/email\";i:972;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/url\";i:1021;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/no_html\";i:974;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/numeric\";i:986;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/not_empty\";i:922;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/js\";i:906;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/date\";i:1433;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/preg_replace\";i:878;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/css\";i:1048;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/str_replace\";i:831;s:117:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/no_special_chars\";i:1163;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation/html_custom\";i:1047;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/validation\";i:18378;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/lib/gradient-filters\";i:18635;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/lib/image-filters\";i:13148;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/lib\";i:160563;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/switch\";i:9182;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/color\";i:11432;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/radio\";i:2479;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/background\";i:38551;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/typography\";i:561640;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/multi_text\";i:11087;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/info\";i:11501;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/media\";i:13400;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/select\";i:14311;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/editor\";i:6490;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/text\";i:6400;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/password\";i:3915;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/sorter\";i:17588;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/gallery\";i:8189;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/color_palette\";i:7103;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/sortable\";i:14356;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/palette\";i:7146;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/image_select\";i:16787;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/slider\";i:26912;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/ace_editor\";i:6787;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/textarea\";i:2055;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/link_color\";i:17070;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/date\";i:4620;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/section\";i:5167;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/raw\";i:43697;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/color_gradient\";i:15758;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/border\";i:22369;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/box_shadow\";i:28024;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/spinner/vendor\";i:26464;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/spinner\";i:42395;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/color_rgba\";i:23787;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/select_image\";i:8929;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/divide\";i:4437;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/button_set\";i:7397;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/checkbox\";i:7228;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/spacing\";i:20223;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/slides\";i:27397;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields/dimensions\";i:17262;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/fields\";i:1093071;s:118:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/repeater/repeater\";i:46318;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/repeater\";i:47445;s:126:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/custom_fonts/custom_fonts\";i:23536;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/custom_fonts\";i:48247;s:130:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/options_object/options_object\";i:6061;s:115:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/options_object\";i:8140;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/multi_media/multi_media\";i:31576;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/multi_media\";i:33299;s:125:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/datetime/datetime/vendor\";i:127649;s:118:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/datetime/datetime\";i:158194;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/datetime\";i:159132;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/metaboxes\";i:95231;s:136:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/social_profiles/social_profiles/inc\";i:40153;s:136:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/social_profiles/social_profiles/css\";i:951;s:132:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/social_profiles/social_profiles\";i:83928;s:116:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/social_profiles\";i:94970;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/search\";i:10605;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/taxonomy\";i:71616;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/widget_areas/assets/img\";i:557;s:120:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/widget_areas/assets\";i:557;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/widget_areas\";i:21220;s:128:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/import_export/import_export\";i:16708;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/import_export\";i:21750;s:115:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/customizer/inc\";i:15695;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/customizer\";i:56947;s:120:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/js_button/js_button\";i:6979;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/js_button\";i:8039;s:120:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/accordion/accordion\";i:12200;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/accordion\";i:13290;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/icon_select/icon_select\";i:37312;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/icon_select\";i:95441;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/tabbed/tabbed\";i:20016;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/tabbed\";i:20969;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/google_maps/google_maps\";i:52712;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/google_maps\";i:53662;s:106:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/users\";i:69798;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions/shortcodes\";i:10946;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/extensions\";i:940826;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/themecheck/checks\";i:5333;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/themecheck/js\";i:911;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/themecheck/css\";i:219;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/themecheck/lang\";i:997;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/themecheck\";i:13312;s:97:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc/classes\";i:412072;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/inc\";i:2685945;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/templates/panel\";i:12717;s:95:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/templates\";i:12796;s:90:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore/core\";i:1806;s:85:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/ReduxCore\";i:9189508;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/reusablec-block/includes/js\";i:522;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/reusablec-block/includes/css\";i:387;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/reusablec-block/includes\";i:15834;s:91:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/reusablec-block\";i:21180;s:86:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc/el-widgets\";i:941583;s:75:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/inc\";i:10373347;s:77:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit/.idea\";i:4615;s:71:\"/home/tthemeco/public_html/foodking/wp-content/plugins/foodking-toolkit\";i:11766551;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media/home\";i:5064;s:90:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media/other\";i:23299;s:92:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media/product\";i:47778;s:92:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media/sidebar\";i:187064;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media/icon\";i:46997;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/media\";i:310202;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/js\";i:190561;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/css\";i:82771;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts/IRANSansWeb/ttf\";i:362004;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts/IRANSansWeb/eot\";i:363924;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts/IRANSansWeb/woff\";i:216418;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts/IRANSansWeb/woff2\";i:170296;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts/IRANSansWeb\";i:1112642;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets/fonts\";i:1112642;s:78:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/assets\";i:1696176;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/languages\";i:62937;s:94:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views/layout\";i:67530;s:101:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views/debug/layouts\";i:66150;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views/debug\";i:216058;s:94:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views/errors\";i:9386;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views/pages\";i:955087;s:87:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front/Views\";i:1248061;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Front\";i:1284238;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Products\";i:369488;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Template\";i:59224;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Settings\";i:22341;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Showcase\";i:21332;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Router\";i:56845;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Update\";i:84298;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Backup\";i:100966;s:83:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/License\";i:213365;s:110:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/App/Controllers/ProductsController\";i:42944;s:91:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/App/Controllers\";i:185497;s:90:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/App/Middleware\";i:8364;s:79:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/App\";i:423400;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Config\";i:152596;s:88:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Core/Utility\";i:187525;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Core/RtlInterface\";i:7581;s:91:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Core/HttpClient\";i:18527;s:87:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Core/Helper\";i:162136;s:80:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Core\";i:597757;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL/Debug\";i:29223;s:75:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/RTL\";i:3457412;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/paragonie/random_compat/other\";i:25681;s:106:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/paragonie/random_compat/lib\";i:2876;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/paragonie/random_compat/dist\";i:719;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/paragonie/random_compat\";i:35495;s:88:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/paragonie\";i:35495;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse/php-encryption/dist\";i:13410;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse/php-encryption/src/Exception\";i:24803;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse/php-encryption/src\";i:287131;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse/php-encryption/bin\";i:312;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse/php-encryption\";i:300853;s:85:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/defuse\";i:300853;s:117:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/php-curl-class/php-curl-class/src/Curl\";i:471177;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/php-curl-class/php-curl-class/src\";i:471177;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/php-curl-class/php-curl-class\";i:502277;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/php-curl-class\";i:502277;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/bin\";i:3512;s:87:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor/composer\";i:225535;s:78:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin/vendor\";i:1080883;s:71:\"/home/tthemeco/public_html/foodking/wp-content/plugins/rtl-smart-plugin\";i:6303245;s:71:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/ctrls\";i:40519;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/webfonts\";i:357688;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/lib/lity\";i:8371;s:76:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/lib\";i:8371;s:87:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js/jquery.qtip\";i:119252;s:86:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js/duplicator\";i:4477;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js/notifications\";i:7171;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js/popper\";i:94019;s:81:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js/tippy\";i:115445;s:75:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/js\";i:716909;s:83:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/css/images\";i:23901;s:98:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/css/font-awesome/webfonts\";i:946772;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/css/font-awesome/css\";i:102233;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/css/font-awesome\";i:1049021;s:76:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/css\";i:1164169;s:84:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/img/welcome\";i:141893;s:82:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/img/about\";i:493930;s:76:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets/img\";i:759019;s:72:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/assets\";i:3006156;s:75:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/languages\";i:316740;s:79:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/lib/forceutf8\";i:16177;s:69:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/lib\";i:16206;s:88:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/packages/details\";i:33088;s:85:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/packages/main\";i:232736;s:80:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/packages\";i:268652;s:77:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/parts\";i:8832;s:89:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/tools/diagnostics\";i:35046;s:77:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/tools\";i:36711;s:80:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views/settings\";i:48497;s:71:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/views\";i:362885;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/ctrls/classes\";i:203281;s:95:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/ctrls\";i:210754;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/images\";i:32513;s:118:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/font-awesome/webfonts\";i:357688;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/font-awesome/css\";i:53800;s:109:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/font-awesome\";i:411504;s:117:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/js/password-strength\";i:62218;s:99:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/js\";i:62218;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/fonts/dots\";i:49100;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets/fonts\";i:49100;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/assets\";i:1053034;s:97:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/favicon\";i:125506;s:126:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/secure\";i:2877;s:130:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/boot-error\";i:951;s:129:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/exception\";i:1814;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/head\";i:5919;s:138:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step2/options-tabs\";i:1484;s:125:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step2\";i:3264;s:142:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/help/steps/step1-parts\";i:38418;s:130:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/help/steps\";i:69536;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/help\";i:71824;s:139:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1/database-tabs\";i:6202;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1/actions\";i:3492;s:138:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1/options-tabs\";i:4435;s:145:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1/info-tabs/overviews\";i:4215;s:135:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1/info-tabs\";i:7460;s:125:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step1\";i:35108;s:138:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step3/options-tabs\";i:6741;s:136:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step3/usersParts\";i:1441;s:125:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step3\";i:11040;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step4/actions\";i:1285;s:125:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/step4\";i:7560;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts/body\";i:252;s:119:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/pages-parts\";i:142011;s:140:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/validation/tests/wordfence\";i:1525;s:130:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/validation/tests\";i:38067;s:139:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/validation/database-tests\";i:49382;s:124:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/validation\";i:91393;s:123:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/education\";i:2424;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/params/inline_helps\";i:1098;s:120:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/params\";i:5800;s:121:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts/reports\";i:985;s:113:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/parts\";i:105662;s:123:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/scripts/modules\";i:57828;s:115:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default/scripts\";i:80089;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/default\";i:333405;s:130:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base/pages-parts/step1/actions\";i:679;s:122:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base/pages-parts/step1\";i:2147;s:122:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base/pages-parts/step4\";i:231;s:116:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base/pages-parts\";i:2378;s:112:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base/scripts\";i:507;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/base\";i:2885;s:137:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/pages-parts/step1/actions\";i:747;s:129:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/pages-parts/step1\";i:1763;s:129:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/pages-parts/step4\";i:346;s:123:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/pages-parts\";i:2109;s:144:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/parts/validation/tests/wordfence\";i:1322;s:134:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/parts/validation/tests\";i:1322;s:128:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/parts/validation\";i:1322;s:117:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/parts\";i:1425;s:119:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base/scripts\";i:507;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-base\";i:4041;s:132:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/head\";i:3906;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step2\";i:444;s:141:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step1/actions\";i:1912;s:143:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step1/info-tabs\";i:606;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step1\";i:2934;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step3\";i:469;s:141:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step4/actions\";i:995;s:133:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/step4\";i:1799;s:132:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts/body\";i:194;s:127:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/pages-parts\";i:9746;s:148:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/parts/validation/tests/wordfence\";i:1322;s:138:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/parts/validation/tests\";i:1322;s:132:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/parts/validation\";i:1322;s:121:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced/parts\";i:1425;s:115:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates/import-advanced\";i:11171;s:99:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/templates\";i:351631;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Deploy/Files\";i:23782;s:116:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Deploy/DupArchive\";i:13330;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Deploy/Database\";i:60709;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Deploy\";i:97821;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Addons\";i:11544;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Hooks\";i:36226;s:117:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Params/Descriptors\";i:153604;s:111:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Params/Items\";i:100293;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core/Params\";i:287002;s:98:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Core\";i:452987;s:100:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Models\";i:5379;s:103:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Utils/Log\";i:19562;s:108:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Utils/Tests/WP\";i:17438;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Utils/Tests\";i:26901;s:99:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src/Utils\";i:55834;s:93:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/src\";i:514329;s:96:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/addons\";i:146;s:116:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/utilities/template\";i:6295;s:107:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/utilities\";i:133188;s:105:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/plugins\";i:41401;s:106:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/database\";i:65256;s:104:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/config\";i:75559;s:102:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/host\";i:23079;s:114:\"/home/tthemeco/public_html/foodking/wp-content/plugins/duplicator/installer/dup-installer/classes/validation/tests\";i:49044;s:123:\"/home/tthemeco/public_html/foodking/wp-content/plugi